/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.model.filefolder.loader.AbstractLoaderThread;
import org.alfresco.repo.model.filefolder.loader.LoaderCOCIThread;
import org.alfresco.repo.model.filefolder.loader.LoaderClientException;
import org.alfresco.repo.model.filefolder.loader.LoaderDeleteThread;
import org.alfresco.repo.model.filefolder.loader.LoaderListFoldersThread;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.repo.model.filefolder.loader.LoaderTotalsThread;
import org.alfresco.repo.model.filefolder.loader.LoaderUpdateThread;
import org.alfresco.repo.model.filefolder.loader.LoaderUploadThread;
import org.alfresco.service.cmr.repository.StoreRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderRemoteLoader {
    private static final String STORE_PROTOCOL = "FileFolderRemoteLoader";
    private Properties properties;
    private String username;
    private String password;
    private LoaderSession session;
    private AbstractLoaderThread[] threads;
    private static final String COLUMNS_VERBOSE = String.format("%40s\t%15s\t%15s\t%15s\t%15s\t%15s", "NAME", "COUNT", "TIME", "AVERAGE TIME", "PER SECOND", "DESCRIPTION");
    private static final String COLUMNS_SUMMARY = String.format("%40s\t%15s\t%15s\t%15s\t%15s\t%15s", "NAME", "COUNT", "TOTAL TIME", "AVERAGE TIME", "PER SECOND", "DESCRIPTION");
    public static final String PROP_SESSION_NAME = "session.name";
    public static final String PROP_SESSION_SOURCE_DIR = "session.sourceDir";
    public static final String PROP_SESSION_STORE_IDENTIFIERS = "session.storeIdentifiers";
    public static final String PROP_SESSION_RMI_URLS = "session.rmiUrls";
    public static final String PROP_SESSION_FOLDER_PROFILE = "session.folderProfile";

    public FileFolderRemoteLoader(Properties properties, String username, String password) {
        this.properties = properties;
        this.username = username;
        this.password = password;
    }

    public synchronized void initialize() throws Exception {
        if (this.session != null || this.threads != null) {
            throw new AlfrescoRuntimeException("Application already initialized");
        }
        this.session = FileFolderRemoteLoader.makeSession(this.username, this.password, this.properties);
        this.threads = FileFolderRemoteLoader.makeThreads(this.session, this.properties);
        String summary = this.session.getSummary();
        this.session.logVerbose(summary, true);
        this.session.logSummary(summary);
        this.session.logError(summary);
        this.session.logVerbose(LoaderSession.getLineEnding(), true);
        this.session.logVerbose(COLUMNS_VERBOSE, true);
        this.session.logSummary(LoaderSession.getLineEnding());
        this.session.logSummary(COLUMNS_SUMMARY);
    }

    public synchronized void start() {
        if (this.session == null || this.threads == null) {
            throw new AlfrescoRuntimeException("Application not initialized");
        }
        for (AbstractLoaderThread thread : this.threads) {
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        for (AbstractLoaderThread thread : this.threads) {
            thread.setStop();
        }
        AbstractLoaderThread[] arr$ = this.threads;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            AbstractLoaderThread thread;
            AbstractLoaderThread abstractLoaderThread = thread = arr$[i$];
            synchronized (abstractLoaderThread) {
                thread.notifyAll();
            }
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        for (AbstractLoaderThread thread : this.threads) {
            String summary = thread.getSummary();
            this.session.logSummary(summary);
        }
    }

    public void dumpThreadSummaries() {
        System.out.println("");
        System.out.println(COLUMNS_SUMMARY);
        for (AbstractLoaderThread thread : this.threads) {
            String summary = thread.getSummary();
            System.out.println(summary);
        }
    }

    private static LoaderSession makeSession(String username, String password, Properties properties) throws Exception {
        String name = properties.getProperty(PROP_SESSION_NAME);
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_STORE_IDENTIFIERS, name);
        String sourceDirStr = properties.getProperty(PROP_SESSION_SOURCE_DIR);
        File sourceDir = new File(sourceDirStr);
        String storeIdentifiersStr = properties.getProperty(PROP_SESSION_STORE_IDENTIFIERS);
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_STORE_IDENTIFIERS, storeIdentifiersStr);
        StringTokenizer tokenizer = new StringTokenizer(storeIdentifiersStr, ",");
        HashSet<StoreRef> storeRefs = new HashSet<StoreRef>();
        while (tokenizer.hasMoreTokens()) {
            String storeIdentifier = tokenizer.nextToken().trim();
            storeRefs.add(new StoreRef(STORE_PROTOCOL, storeIdentifier));
        }
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_STORE_IDENTIFIERS, storeRefs);
        String rmiUrlsStr = properties.getProperty(PROP_SESSION_RMI_URLS);
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_RMI_URLS, rmiUrlsStr);
        tokenizer = new StringTokenizer(rmiUrlsStr, ",");
        HashSet<String> rmiUrls = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String rmiUrl = tokenizer.nextToken().trim();
            rmiUrls.add(rmiUrl);
        }
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_STORE_IDENTIFIERS, rmiUrls);
        String folderProfilesStr = properties.getProperty(PROP_SESSION_FOLDER_PROFILE);
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_FOLDER_PROFILE, folderProfilesStr);
        tokenizer = new StringTokenizer(folderProfilesStr, ",");
        ArrayList<Integer> folderProfilesList = new ArrayList<Integer>(5);
        while (tokenizer.hasMoreTokens()) {
            String folderProfileStr = tokenizer.nextToken().trim();
            Integer folderProfile = Integer.valueOf(folderProfileStr);
            folderProfilesList.add(folderProfile);
        }
        FileFolderRemoteLoader.checkProperty(PROP_SESSION_FOLDER_PROFILE, folderProfilesList);
        int[] folderProfiles = new int[folderProfilesList.size()];
        for (int i = 0; i < folderProfiles.length; ++i) {
            folderProfiles[i] = (Integer)folderProfilesList.get(i);
        }
        if (folderProfiles.length == 0 || folderProfiles[0] != 1) {
            throw new LoaderClientException("'session.folderProfile' must always start with '1', which represents the root of the hierarchy, and have at least one other value.  E.g. '1, 3'");
        }
        LoaderSession session = new LoaderSession(username, password, name, rmiUrls, storeRefs, sourceDir, folderProfiles);
        session.initialize();
        return session;
    }

    private static AbstractLoaderThread[] makeThreads(LoaderSession session, Properties properties) throws Exception {
        ArrayList<LoaderUploadThread> threads = new ArrayList<LoaderUploadThread>(3);
        for (Object o : properties.keySet()) {
            String propertyName = (String)o;
            if (!propertyName.startsWith("test.load.")) continue;
            String name = propertyName;
            int lastIndex = propertyName.indexOf(".", 10);
            if (lastIndex < 0) {
                throw new LoaderClientException("Invalid test loader property.  It should be of the form 'test.load.upload.xyz=...': " + propertyName);
            }
            String type = propertyName.substring(10, lastIndex);
            String valuesStr = properties.getProperty(propertyName);
            FileFolderRemoteLoader.checkProperty(propertyName, valuesStr);
            String[] strValues = new String[]{"1", "0", "0", "1", "false", "1"};
            int index = 0;
            StringTokenizer tokenizer = new StringTokenizer(valuesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken().trim();
                if (value.length() > 0) {
                    strValues[index] = value;
                }
                if (++index < strValues.length) continue;
                break;
            }
            long testCount = 1L;
            long testPeriod = 0L;
            long testTotal = 0L;
            long testDepth = 1L;
            boolean testVerbose = false;
            long filesPerIteration = 1L;
            try {
                testCount = Long.parseLong(strValues[0]);
                testPeriod = Long.parseLong(strValues[1]);
                testTotal = Long.parseLong(strValues[2]);
                testDepth = Long.parseLong(strValues[3]);
                testVerbose = Boolean.parseBoolean(strValues[4]);
                filesPerIteration = Long.parseLong(strValues[5]);
            }
            catch (Throwable e) {
                throw new LoaderClientException("Unable to parse the loader configuration for '" + name + "'. " + LoaderSession.getLineEnding() + "The correct format is [threadCount], [period(ms)], [total], [folder depth], [verbose]<, [filesPerIteration]>");
            }
            int i = 0;
            while ((long)i < testCount) {
                AbstractLoaderThread thread = null;
                if (type.equals("upload")) {
                    thread = new LoaderUploadThread(session, name, testPeriod, testTotal, testDepth, testVerbose, filesPerIteration);
                } else if (type.equals("totals")) {
                    thread = new LoaderTotalsThread(session, name, testPeriod, testTotal, testDepth, testVerbose);
                } else if (type.equals("listFolders")) {
                    thread = new LoaderListFoldersThread(session, name, testPeriod, testTotal, testDepth, testVerbose);
                } else if (type.equals("delete")) {
                    thread = new LoaderDeleteThread(session, name, testPeriod, testTotal, testDepth, testVerbose, filesPerIteration);
                } else if (type.equals("update")) {
                    thread = new LoaderUpdateThread(session, name, testPeriod, testTotal, testDepth, testVerbose, filesPerIteration);
                } else if (type.equals("coci")) {
                    thread = new LoaderCOCIThread(session, name, testPeriod, testTotal, testDepth, testVerbose, filesPerIteration);
                } else {
                    throw new LoaderClientException("Unknown test type: " + name);
                }
                threads.add((LoaderUploadThread)thread);
                ++i;
            }
        }
        AbstractLoaderThread[] ret = new AbstractLoaderThread[threads.size()];
        return threads.toArray(ret);
    }

    private static void checkProperty(String propertyName, Object propertyValue) throws LoaderClientException {
        Collection propertyCollection;
        int size;
        if (propertyValue == null) {
            throw new LoaderClientException("'" + propertyName + "' must be provided.");
        }
        if (propertyValue instanceof Collection && (size = (propertyCollection = (Collection)propertyValue).size()) == 0) {
            throw new LoaderClientException("'" + propertyName + "' does not have any values.");
        }
    }

    public static void main(String ... args) {
        Map<String, String> argMap = FileFolderRemoteLoader.ripArgs(args);
        String username = argMap.get("username");
        String password = argMap.get("password");
        String config = argMap.get("config");
        if (username == null || password == null || config == null) {
            FileFolderRemoteLoader.printUsage();
            System.exit(1);
        }
        try {
            int keyPress;
            File propertiesFile = new File(config);
            if (!propertiesFile.exists()) {
                System.err.println("Unable to find config file: " + config);
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(propertiesFile));
            FileFolderRemoteLoader app = new FileFolderRemoteLoader(properties, username, password);
            app.initialize();
            app.start();
            Thread.currentThread().setPriority(1);
            System.out.println("Running test " + app.session.getName() + ".");
            System.out.println("   Enter 'q' to quit.");
            System.out.println("   Enter 's' to dump a thread summary.");
            while ((keyPress = System.in.read()) != 81 && keyPress != 113) {
                if (keyPress == 83 || keyPress == 115) {
                    app.dumpThreadSummaries();
                } else if (System.in.available() > 0) continue;
                Thread.yield();
            }
            app.stop();
            System.out.println("The test is complete.");
        }
        catch (LoaderClientException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println("A failure prevented proper execution.");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static Map<String, String> ripArgs(String ... args) {
        HashMap<String, String> argsMap = new HashMap<String, String>(5);
        for (String arg : args) {
            int index = arg.indexOf(61);
            if (!arg.startsWith("--") || index < 0 || index == arg.length() - 1) continue;
            String name = arg.substring(2, index);
            String value = arg.substring(index + 1, arg.length());
            argsMap.put(name, value);
        }
        return argsMap;
    }

    private static void printUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("Usage\n").append("   java -jar ...  --username=<username> --password=<password> --config=<config file> \n");
        System.out.println(sb.toString());
    }
}

