/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.repo.module.ModuleComponent;
import org.alfresco.repo.module.ModuleComponentHelper;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.BaseAlfrescoTestCase;
import org.alfresco.util.VersionNumber;

public class ModuleComponentHelperTest
extends BaseAlfrescoTestCase {
    private final String CURRENT_TIME = "" + System.currentTimeMillis() + "-" + System.nanoTime();
    private final String[] MODULE_IDS = new String[]{"M0 @ " + this.CURRENT_TIME, "M1 @ " + this.CURRENT_TIME, "M2 @ " + this.CURRENT_TIME};
    private final String[] COMPONENT_NAMES = new String[]{"C0 @ " + this.CURRENT_TIME, "C1 @ " + this.CURRENT_TIME, "C2 @ " + this.CURRENT_TIME};
    private final VersionNumber[] VERSIONS = new VersionNumber[]{new VersionNumber("0"), new VersionNumber("1"), new VersionNumber("2"), new VersionNumber("3")};
    private static final Map<VersionNumber, Integer> EXECUTION_COUNT_BY_VERSION = new HashMap<VersionNumber, Integer>(13);
    private RegistryService registryService;
    private TenantAdminService tenantDeployerService;
    private DescriptorService descriptorService;
    private DummyModuleService moduleService;
    private ModuleComponentHelper helper;
    private DummyModuleComponent[][] components;
    static int executed;

    public void setUp() throws Exception {
        super.setUp();
        this.registryService = (RegistryService)this.ctx.getBean("RegistryService");
        this.tenantDeployerService = (TenantAdminService)this.ctx.getBean("tenantAdminService");
        this.descriptorService = this.serviceRegistry.getDescriptorService();
        this.moduleService = new DummyModuleService();
        this.helper = new ModuleComponentHelper();
        this.helper.setModuleService(this.moduleService);
        this.helper.setRegistryService(this.registryService);
        this.helper.setServiceRegistry(this.serviceRegistry);
        this.helper.setDescriptorService(this.descriptorService);
        this.helper.setTenantAdminService(this.tenantDeployerService);
        this.components = new DummyModuleComponent[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                DummyModuleComponent component = new DummyModuleComponent(this.MODULE_IDS[i], this.COMPONENT_NAMES[j], this.VERSIONS[j], this.VERSIONS[j + 1]);
                component.setServiceRegistry(this.serviceRegistry);
                component.setAuthenticationComponent(this.authenticationComponent);
                component.setModuleService(this.moduleService);
                component.setTenantAdminService(this.tenantDeployerService);
                this.helper.registerComponent(component);
                this.components[i][j] = component;
            }
        }
        this.components[1][1].setDependsOn(Collections.singletonList(this.components[0][1]));
    }

    public void testSetup() throws Exception {
    }

    private void startComponents(VersionNumber moduleVersion) {
        int expectedCount = EXECUTION_COUNT_BY_VERSION.get(moduleVersion);
        this.moduleService.setCurrentVersion(moduleVersion);
        this.helper.startModules();
        int tenantCount = 0;
        if (this.tenantDeployerService.isEnabled()) {
            tenantCount = this.tenantDeployerService.getAllTenants().size();
        }
        ModuleComponentHelperTest.assertEquals((String)("Incorrent number of executions (version " + moduleVersion + ")"), (int)(expectedCount + expectedCount * tenantCount), (int)executed);
    }

    public void testStartComponentsV00() {
        VersionNumber moduleVersion = new VersionNumber("0.0");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV05() {
        VersionNumber moduleVersion = new VersionNumber("0.5");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV10() {
        VersionNumber moduleVersion = new VersionNumber("1.0");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV15() {
        VersionNumber moduleVersion = new VersionNumber("1.5");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV30() {
        VersionNumber moduleVersion = new VersionNumber("3.0");
        this.startComponents(moduleVersion);
    }

    public void testStartComponentsV35() {
        VersionNumber moduleVersion = new VersionNumber("3.5");
        this.startComponents(moduleVersion);
    }

    static {
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("0.0"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("0.5"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("1.0"), 6);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("1.5"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("2.0"), 6);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("2.5"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("3.0"), 3);
        EXECUTION_COUNT_BY_VERSION.put(new VersionNumber("3.5"), 0);
        executed = 0;
    }

    public static class NoopModuleComponent
    extends AbstractModuleComponent {
        protected void executeInternal() throws Throwable {
        }
    }

    private class DummyModuleComponent
    extends AbstractModuleComponent {
        private DummyModuleComponent(String moduleId, String name, VersionNumber from, VersionNumber to) {
            super.setServiceRegistry(this.serviceRegistry);
            super.setAuthenticationComponent(this.authenticationComponent);
            super.setModuleService(this.moduleService);
            super.setTenantAdminService(ModuleComponentHelperTest.this.tenantDeployerService);
            super.setModuleId(moduleId);
            super.setName(name);
            super.setAppliesFromVersion(from.toString());
            super.setAppliesToVersion(to.toString());
            super.setSinceVersion("10.1.2");
            super.setDescription("A dummy module component");
        }

        protected void executeInternal() throws Throwable {
            ++executed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DummyModuleService
    implements ModuleService {
        private VersionNumber currentVersion;

        private DummyModuleService() {
        }

        public void setCurrentVersion(VersionNumber currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public void registerComponent(ModuleComponent component) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ModuleDetails> getAllModules() {
            executed = 0;
            ArrayList<ModuleDetails> details = new ArrayList<ModuleDetails>(3);
            for (int i = 0; i < 3; ++i) {
                ModuleDetailsImpl moduleDetails = new ModuleDetailsImpl(ModuleComponentHelperTest.this.MODULE_IDS[i], this.currentVersion, "Module-" + i, "Description-" + i);
                details.add(moduleDetails);
            }
            return details;
        }

        @Override
        public ModuleDetails getModule(String moduleId) {
            for (int i = 0; i < ModuleComponentHelperTest.this.MODULE_IDS.length; ++i) {
                if (!ModuleComponentHelperTest.this.MODULE_IDS[i].equals(moduleId)) continue;
                new ModuleDetailsImpl(ModuleComponentHelperTest.this.MODULE_IDS[i], this.currentVersion, "Module-" + i, "Description-" + i);
            }
            return null;
        }

        @Override
        public void startModules() {
            throw new UnsupportedOperationException();
        }
    }
}

