/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class NodeAuditor
implements InitializingBean,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static Log logger = LogFactory.getLog(NodeAuditor.class);
    private static final String ROOT_PATH = "/alfresco-node";
    private static final String BEFORE_DELETE_NODE_PATH = "/alfresco-node/beforeDeleteNode";
    private static final String NODE_PATH_COMPONENT = "node";
    private PolicyComponent policyComponent;
    private AuditComponent auditComponent;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"auditComponent", (Object)this.auditComponent);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        if (!this.auditComponent.areAuditValuesRequired()) {
            return;
        }
        Map<String, Serializable> auditMap = new HashMap<String, Serializable>(13);
        auditMap.put(NODE_PATH_COMPONENT, (Serializable)nodeRef);
        auditMap = this.auditComponent.recordAuditValues(BEFORE_DELETE_NODE_PATH, auditMap);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NodeAuditor: Audited node deletion: \n" + auditMap));
        }
    }
}

