/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeArchiveServiceImpl
implements NodeArchiveService {
    private static Log logger = LogFactory.getLog(NodeArchiveServiceImpl.class);
    private NodeService nodeService;
    private SearchService searchService;
    private TransactionService transactionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public NodeRef getStoreArchiveNode(StoreRef originalStoreRef) {
        return this.nodeService.getStoreArchiveNode(originalStoreRef);
    }

    @Override
    public NodeRef getArchivedNode(NodeRef originalNodeRef) {
        StoreRef orginalStoreRef = originalNodeRef.getStoreRef();
        NodeRef archiveRootNodeRef = this.nodeService.getStoreArchiveNode(orginalStoreRef);
        NodeRef archivedNodeRef = new NodeRef(archiveRootNodeRef.getStoreRef(), originalNodeRef.getId());
        return archivedNodeRef;
    }

    private ResultSet getArchivedNodes(StoreRef originalStoreRef) {
        NodeRef archiveParentNodeRef = this.nodeService.getStoreArchiveNode(originalStoreRef);
        StoreRef archiveStoreRef = archiveParentNodeRef.getStoreRef();
        String query = String.format("PARENT:\"%s\" AND ASPECT:\"%s\"", archiveParentNodeRef, ContentModel.ASPECT_ARCHIVED);
        SearchParameters params = new SearchParameters();
        params.addStore(archiveStoreRef);
        params.setLanguage("lucene");
        params.setQuery(query);
        ResultSet rs = this.searchService.query(params);
        return rs;
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(final NodeRef archivedNodeRef, final NodeRef destinationNodeRef, final QName assocTypeQName, final QName assocQName) {
        RestoreNodeReport report = new RestoreNodeReport(archivedNodeRef);
        report.setTargetParentNodeRef(destinationNodeRef);
        try {
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> restoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    return NodeArchiveServiceImpl.this.nodeService.restoreNode(archivedNodeRef, destinationNodeRef, assocTypeQName, assocQName);
                }
            };
            NodeRef newNodeRef = txnHelper.doInTransaction(restoreCallback, false, true);
            report.setRestoredNodeRef(newNodeRef);
            report.setStatus(RestoreNodeReport.RestoreStatus.SUCCESS);
        }
        catch (InvalidNodeRefException e) {
            report.setCause(e);
            NodeRef invalidNodeRef = e.getNodeRef();
            if (archivedNodeRef.equals((Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE);
            } else if (EqualsHelper.nullSafeEquals((Object)destinationNodeRef, (Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
            } else if (destinationNodeRef == null) {
                ChildAssociationRef originalParentAssocRef = (ChildAssociationRef)this.nodeService.getProperty(archivedNodeRef, ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
                NodeRef originalParentNodeRef = originalParentAssocRef.getParentRef();
                if (EqualsHelper.nullSafeEquals((Object)originalParentNodeRef, (Object)invalidNodeRef)) {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
                } else {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
                }
            } else {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            }
        }
        catch (AccessDeniedException e) {
            report.setCause((Throwable)((Object)e));
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION);
        }
        catch (Throwable e) {
            report.setCause(e);
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            logger.error((Object)"An unhandled exception stopped the restore", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempted node restore: " + report));
        }
        return report;
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(NodeRef archivedNodeRef) {
        return this.restoreArchivedNode(archivedNodeRef, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs) {
        return this.restoreArchivedNodes(archivedNodeRefs, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs, NodeRef destinationNodeRef, QName assocTypeQName, QName assocQName) {
        ArrayList<RestoreNodeReport> results = new ArrayList<RestoreNodeReport>(archivedNodeRefs.size());
        for (NodeRef nodeRef : archivedNodeRefs) {
            RestoreNodeReport result = this.restoreArchivedNode(nodeRef, destinationNodeRef, assocTypeQName, assocQName);
            results.add(result);
        }
        return results;
    }

    @Override
    public List<RestoreNodeReport> restoreAllArchivedNodes(StoreRef originalStoreRef) {
        return this.restoreAllArchivedNodes(originalStoreRef, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RestoreNodeReport> restoreAllArchivedNodes(StoreRef originalStoreRef, NodeRef destinationNodeRef, QName assocTypeQName, QName assocQName) {
        ArrayList<RestoreNodeReport> arrayList;
        ResultSet rs = this.getArchivedNodes(originalStoreRef);
        try {
            ArrayList<RestoreNodeReport> results = new ArrayList<RestoreNodeReport>(1000);
            for (ResultSetRow row : rs) {
                NodeRef archivedNodeRef = row.getNodeRef();
                RestoreNodeReport result = this.restoreArchivedNode(archivedNodeRef, destinationNodeRef, assocTypeQName, assocQName);
                results.add(result);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Restored " + results.size() + " nodes into store " + originalStoreRef));
            }
            arrayList = results;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
        return arrayList;
    }

    @Override
    public void purgeArchivedNode(final NodeRef archivedNodeRef) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    NodeArchiveServiceImpl.this.nodeService.deleteNode(archivedNodeRef);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    // empty catch block
                }
                return null;
            }
        };
        txnHelper.doInTransaction(deleteCallback, false, true);
    }

    @Override
    public void purgeArchivedNodes(List<NodeRef> archivedNodes) {
        for (NodeRef archivedNodeRef : archivedNodes) {
            this.purgeArchivedNode(archivedNodeRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeAllArchivedNodes(StoreRef originalStoreRef) {
        ResultSet rs = this.getArchivedNodes(originalStoreRef);
        try {
            ArrayList results = new ArrayList(1000);
            for (ResultSetRow row : rs) {
                NodeRef archivedNodeRef = row.getNodeRef();
                this.purgeArchivedNode(archivedNodeRef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted " + results.size() + " nodes originally in store " + originalStoreRef));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
    }
}

