/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.node.AbstractNodeServiceImpl;
import org.alfresco.repo.node.StoreArchiveMap;
import org.alfresco.repo.node.index.NodeIndexer;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbNodeServiceImpl
extends AbstractNodeServiceImpl {
    private static Log logger = LogFactory.getLog(DbNodeServiceImpl.class);
    private QNameDAO qnameDAO;
    private NodeDAO nodeDAO;
    private StoreArchiveMap storeArchiveMap = new StoreArchiveMap();
    private NodeService avmNodeService;
    private NodeIndexer nodeIndexer;
    private static final String KEY_PRE_COMMIT_ADD_NODE = "DbNodeServiceImpl.PreCommitAddNode";
    private static final String KEY_DELETED_NODES = "DbNodeServiceImpl.DeletedNodes";
    private static List<QName> getChildAssocsByPropertyValueBannedProps = new ArrayList<QName>();

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setStoreArchiveMap(StoreArchiveMap storeArchiveMap) {
        this.storeArchiveMap = storeArchiveMap;
    }

    public void setAvmNodeService(NodeService avmNodeService) {
        this.avmNodeService = avmNodeService;
    }

    public void setNodeIndexer(NodeIndexer nodeIndexer) {
        this.nodeIndexer = nodeIndexer;
    }

    private Pair<Long, NodeRef> getNodePairNotNull(NodeRef nodeRef) throws InvalidNodeRefException {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Pair<Long, NodeRef> unchecked = this.nodeDAO.getNodePair(nodeRef);
        if (unchecked == null) {
            throw new InvalidNodeRefException("Node does not exist: " + nodeRef, nodeRef);
        }
        return unchecked;
    }

    public boolean exists(StoreRef storeRef) {
        return this.nodeDAO.exists(storeRef);
    }

    public boolean exists(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.nodeDAO.exists(nodeRef);
    }

    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        NodeRef.Status status = this.nodeDAO.getNodeRefStatus(nodeRef);
        return status;
    }

    public List<StoreRef> getStores() {
        List<Pair<Long, StoreRef>> stores = this.nodeDAO.getStores();
        ArrayList<StoreRef> storeRefs = new ArrayList<StoreRef>(50);
        for (Pair<Long, StoreRef> pair : stores) {
            StoreRef storeRef = (StoreRef)pair.getSecond();
            if (storeRef.getProtocol().equals("deleted")) continue;
            storeRefs.add(storeRef);
        }
        List avmStores = this.avmNodeService.getStores();
        storeRefs.addAll(avmStores);
        return storeRefs;
    }

    public StoreRef createStore(String protocol, String identifier) {
        StoreRef storeRef = new StoreRef(protocol, identifier);
        this.invokeBeforeCreateStore(ContentModel.TYPE_STOREROOT, storeRef);
        Pair<Long, NodeRef> rootNodePair = this.nodeDAO.newStore(storeRef);
        NodeRef rootNodeRef = (NodeRef)rootNodePair.getSecond();
        this.invokeOnCreateStore(rootNodeRef);
        ChildAssociationRef assocRef = new ChildAssociationRef(null, null, null, rootNodeRef);
        this.nodeIndexer.indexCreateNode(assocRef);
        return storeRef;
    }

    public void deleteStore(StoreRef storeRef) throws InvalidStoreRefException {
        this.nodeIndexer.indexDeleteStore(storeRef);
        StoreRef deletedStoreRef = new StoreRef("deleted", GUID.generate());
        this.nodeDAO.moveStore(storeRef, deletedStoreRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Marked store for deletion: " + storeRef + " --> " + deletedStoreRef));
        }
    }

    public NodeRef getRootNode(StoreRef storeRef) throws InvalidStoreRefException {
        Pair<Long, NodeRef> rootNodePair = this.nodeDAO.getRootNode(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException("Store does not exist: " + storeRef, storeRef);
        }
        return (NodeRef)rootNodePair.getSecond();
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        return this.createNode(parentRef, assocTypeQName, assocQName, nodeTypeQName, null);
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"parentRef", (Object)parentRef);
        ParameterCheck.mandatory((String)"assocTypeQName", (Object)assocTypeQName);
        ParameterCheck.mandatory((String)"assocQName", (Object)assocQName);
        ParameterCheck.mandatory((String)"nodeTypeQName", (Object)nodeTypeQName);
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(parentRef);
        StoreRef parentStoreRef = parentRef.getStoreRef();
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        String newUuid = this.generateGuid(properties);
        if (this.isDeletedNodeRef(parentRef)) {
            throw new InvalidNodeRefException("The parent node has been deleted", parentRef);
        }
        this.invokeBeforeCreateNode(parentRef, assocTypeQName, assocQName, nodeTypeQName);
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(nodeTypeQName);
        if (nodeTypeDef == null) {
            throw new InvalidTypeException(nodeTypeQName);
        }
        String newName = this.extractNameProperty(properties);
        ChildAssocEntity assoc = this.nodeDAO.newNode((Long)parentNodePair.getFirst(), assocTypeQName, assocQName, parentStoreRef, newUuid, nodeTypeQName, newName, properties);
        ChildAssociationRef childAssocRef = assoc.getRef(this.qnameDAO);
        Pair<Long, NodeRef> childNodePair = assoc.getChildNode().getNodePair();
        this.addAspectsAndProperties(childNodePair, nodeTypeQName, Collections.<QName>emptySet(), Collections.<QName, Serializable>emptyMap(), Collections.<QName>emptySet(), properties, true, false);
        Map<QName, Serializable> propertiesAfter = this.nodeDAO.getNodeProperties((Long)childNodePair.getFirst());
        this.invokeBeforeCreateChildAssociation(parentRef, (NodeRef)childNodePair.getSecond(), assocTypeQName, assocQName, true);
        this.invokeOnCreateNode(childAssocRef);
        this.invokeOnCreateChildAssociation(childAssocRef, true);
        Map<QName, Serializable> propertiesBefore = PropertyMap.EMPTY_MAP;
        this.invokeOnUpdateProperties(childAssocRef.getChildRef(), propertiesBefore, propertiesAfter);
        this.untrackDeletedNodeRef(childAssocRef.getChildRef());
        this.nodeIndexer.indexCreateNode(childAssocRef);
        this.addAspectsAndProperties(parentNodePair, assocTypeQName, null, null, null, null, false);
        return childAssocRef;
    }

    private boolean trackDeletedNodeRef(NodeRef deletedNodeRef) {
        Set deletedNodes = TransactionalResourceHelper.getSet(KEY_DELETED_NODES);
        return deletedNodes.add(deletedNodeRef);
    }

    private void untrackDeletedNodeRef(NodeRef deletedNodeRef) {
        Set deletedNodes = TransactionalResourceHelper.getSet(KEY_DELETED_NODES);
        if (deletedNodes.size() > 0) {
            deletedNodes.remove(deletedNodeRef);
        }
    }

    private boolean isDeletedNodeRef(NodeRef deletedNodeRef) {
        Set deletedNodes = TransactionalResourceHelper.getSet(KEY_DELETED_NODES);
        return deletedNodes.contains(deletedNodeRef);
    }

    private void untrackNewNodeRef(NodeRef nodeRef) {
        Set newNodes = TransactionalResourceHelper.getSet(KEY_PRE_COMMIT_ADD_NODE);
        if (newNodes.size() > 0) {
            newNodes.remove(nodeRef);
        }
    }

    private boolean addAspectsAndProperties(Pair<Long, NodeRef> nodePair, QName classQName, Set<QName> existingAspects, Map<QName, Serializable> existingProperties, Set<QName> extraAspects, Map<QName, Serializable> extraProperties, boolean overwriteExistingProperties) {
        return this.addAspectsAndProperties(nodePair, classQName, existingAspects, existingProperties, extraAspects, extraProperties, overwriteExistingProperties, true);
    }

    private boolean addAspectsAndProperties(Pair<Long, NodeRef> nodePair, QName classQName, Set<QName> existingAspects, Map<QName, Serializable> existingProperties, Set<QName> extraAspects, Map<QName, Serializable> extraProperties, boolean overwriteExistingProperties, boolean invokeOnUpdateProperties) {
        boolean changedAspects;
        ParameterCheck.mandatory((String)"nodePair", nodePair);
        Long nodeId = (Long)nodePair.getFirst();
        NodeRef nodeRef = (NodeRef)nodePair.getSecond();
        if (classQName == null) {
            classQName = ContentModel.TYPE_BASE;
        }
        if (extraAspects == null) {
            extraAspects = Collections.emptySet();
        }
        if (extraProperties == null) {
            extraProperties = Collections.emptyMap();
        }
        if (existingAspects == null) {
            existingAspects = this.nodeDAO.getNodeAspects(nodeId);
        }
        if (existingProperties == null) {
            existingProperties = this.nodeDAO.getNodeProperties(nodeId);
        }
        HashMap<QName, Serializable> allProperties = new HashMap<QName, Serializable>(37);
        allProperties.putAll(existingProperties);
        allProperties.putAll(extraProperties);
        existingAspects = new HashSet<QName>(existingAspects);
        Set<QName> missingAspects = this.getMissingAspects(existingAspects, allProperties, classQName);
        missingAspects.addAll(extraAspects);
        for (QName missingAspect : missingAspects) {
            this.invokeBeforeAddAspect(nodeRef, missingAspect);
        }
        HashSet<QName> allClassQNames = new HashSet<QName>(13);
        allClassQNames.add(classQName);
        allClassQNames.addAll(missingAspects);
        Map<QName, Serializable> missingProperties = this.getMissingProperties(existingProperties, allClassQNames);
        missingProperties.putAll(extraProperties);
        boolean changedProperties = false;
        changedProperties = overwriteExistingProperties ? this.nodeDAO.setNodeProperties(nodeId, missingProperties) : this.nodeDAO.addNodeProperties(nodeId, missingProperties);
        if (changedProperties && invokeOnUpdateProperties) {
            Map<QName, Serializable> propertiesAfter = this.nodeDAO.getNodeProperties(nodeId);
            this.invokeOnUpdateProperties(nodeRef, existingProperties, propertiesAfter);
        }
        if (changedAspects = this.nodeDAO.addNodeAspects(nodeId, missingAspects)) {
            for (QName missingAspect : missingAspects) {
                this.invokeOnAddAspect(nodeRef, missingAspect);
            }
        }
        return changedAspects || changedProperties;
    }

    private Set<QName> getMissingAspects(Set<QName> existingAspects, Map<QName, Serializable> existingProperties, QName classQName) {
        existingAspects = new HashSet<QName>(existingAspects);
        ClassDefinition classDefinition = this.dictionaryService.getClass(classQName);
        if (classDefinition == null) {
            AssociationDefinition assocDef = this.dictionaryService.getAssociation(classQName);
            if (assocDef == null) {
                return Collections.emptySet();
            }
            classDefinition = assocDef.getSourceClass();
            classQName = classDefinition.getName();
        }
        HashSet<QName> missingAspects = new HashSet<QName>(7);
        if (classDefinition.isAspect() && !existingAspects.contains(classQName)) {
            missingAspects.add(classQName);
        }
        List defaultAspectDefs = classDefinition.getDefaultAspects();
        for (AspectDefinition defaultAspectDef : defaultAspectDefs) {
            QName defaultAspect = defaultAspectDef.getName();
            if (existingAspects.contains(defaultAspect)) continue;
            missingAspects.add(defaultAspect);
        }
        for (QName existingPropQName : existingProperties.keySet()) {
            QName existingPropDefiningType;
            PropertyDefinition existingPropDef = this.dictionaryService.getProperty(existingPropQName);
            if (existingPropDef == null || !existingPropDef.getContainerClass().isAspect() || existingAspects.contains(existingPropDefiningType = existingPropDef.getContainerClass().getName())) continue;
            missingAspects.add(existingPropDefiningType);
        }
        HashSet<QName> allTypesAndAspects = new HashSet<QName>(13);
        allTypesAndAspects.add(classQName);
        allTypesAndAspects.addAll(existingAspects);
        allTypesAndAspects.addAll(missingAspects);
        HashSet missingAspectsCopy = new HashSet(missingAspects);
        for (QName missingAspect : missingAspectsCopy) {
            Set<QName> furtherMissingAspects = this.getMissingAspects(allTypesAndAspects, Collections.<QName, Serializable>emptyMap(), missingAspect);
            missingAspects.addAll(furtherMissingAspects);
            allTypesAndAspects.addAll(furtherMissingAspects);
        }
        return missingAspects;
    }

    private Map<QName, Serializable> getMissingProperties(Map<QName, Serializable> existingProperties, Set<QName> classQNames) {
        HashMap<QName, Serializable> allDefaultProperties = new HashMap<QName, Serializable>(17);
        for (QName classQName : classQNames) {
            Map<QName, Serializable> defaultProperties;
            ClassDefinition classDefinition = this.dictionaryService.getClass(classQName);
            if (classDefinition == null || (defaultProperties = this.getDefaultProperties(classQName)).size() <= 0) continue;
            allDefaultProperties.putAll(defaultProperties);
        }
        HashMap<QName, Serializable> missingProperties = new HashMap<QName, Serializable>(allDefaultProperties);
        missingProperties.entrySet().removeAll(existingProperties.entrySet());
        return missingProperties;
    }

    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) {
        QName assocQName;
        QName assocTypeQName;
        Long childNodeId;
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(childAssocRef.getParentRef());
        Pair<Long, NodeRef> childNodePair = this.getNodePairNotNull(childAssocRef.getChildRef());
        Long parentNodeId = (Long)parentNodePair.getFirst();
        int updated = this.nodeDAO.setChildAssocIndex(parentNodeId, childNodeId = (Long)childNodePair.getFirst(), assocTypeQName = childAssocRef.getTypeQName(), assocQName = childAssocRef.getQName(), index);
        if (updated < 1) {
            throw new InvalidChildAssociationRefException("Unable to set child association index: \n   assoc: " + childAssocRef + "\n" + "   index: " + index, childAssocRef);
        }
    }

    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.getNodeType((Long)nodePair.getFirst());
    }

    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(typeQName);
        if (nodeTypeDef == null) {
            throw new InvalidTypeException(typeQName);
        }
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.nodeDAO.updateNode((Long)nodePair.getFirst(), null, null, typeQName);
        this.addAspectsAndProperties(nodePair, typeQName, null, null, null, null, false);
        this.nodeIndexer.indexUpdateNode(nodeRef);
        this.invokeOnUpdateNode(nodeRef);
    }

    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        if (aspectDef == null) {
            throw new InvalidAspectException("The aspect is invalid: " + aspectTypeQName, aspectTypeQName);
        }
        if (aspectProperties == null) {
            aspectProperties = Collections.emptyMap();
        }
        aspectProperties = Collections.unmodifiableMap(aspectProperties);
        this.invokeBeforeUpdateNode(nodeRef);
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        boolean modified = this.addAspectsAndProperties(nodePair, aspectTypeQName, null, null, Collections.singleton(aspectTypeQName), aspectProperties, false);
        if (modified) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void removeAspect(NodeRef nodeRef, QName aspectTypeQName) throws InvalidNodeRefException, InvalidAspectException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        boolean hadAspect = this.nodeDAO.hasNodeAspect(nodeId, aspectTypeQName);
        this.invokeBeforeUpdateNode(nodeRef);
        if (hadAspect) {
            this.invokeBeforeRemoveAspect(nodeRef, aspectTypeQName);
            this.nodeDAO.removeNodeAspects(nodeId, Collections.singleton(aspectTypeQName));
        }
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        boolean updated = false;
        if (aspectDef != null) {
            Map propertyDefs = aspectDef.getProperties();
            Set<QName> propertyToRemoveQNames = propertyDefs.keySet();
            this.nodeDAO.removeNodeProperties(nodeId, propertyToRemoveQNames);
            final ArrayList assocsToDelete = new ArrayList(5);
            final ArrayList nodesToDelete = new ArrayList(5);
            NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

                @Override
                public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                    if (((ChildAssociationRef)childAssocPair.getSecond()).isPrimary()) {
                        nodesToDelete.add(childNodePair);
                    } else {
                        assocsToDelete.add(childAssocPair);
                    }
                    return true;
                }

                @Override
                public boolean preLoadNodes() {
                    return true;
                }

                @Override
                public void done() {
                }
            };
            HashSet<QName> assocTypeQNamesToRemove = new HashSet<QName>(aspectDef.getChildAssociations().keySet());
            this.nodeDAO.getChildAssocs(nodeId, assocTypeQNamesToRemove, callback);
            for (Pair assocPair : assocsToDelete) {
                updated = true;
                Long assocId = (Long)assocPair.getFirst();
                ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
                this.invokeBeforeDeleteChildAssociation(assocRef);
                this.nodeDAO.deleteChildAssoc(assocId);
                this.invokeOnDeleteChildAssociation(assocRef);
            }
            for (Pair childNodePair : nodesToDelete) {
                NodeRef childNodeRef = (NodeRef)childNodePair.getSecond();
                this.deleteNode(childNodeRef);
            }
            Map nodeAssocDefs = aspectDef.getAssociations();
            HashSet<QName> nodeAssocTypeQNamesToRemove = new HashSet<QName>(13);
            for (Map.Entry entry : nodeAssocDefs.entrySet()) {
                if (((AssociationDefinition)entry.getValue()).isChild()) continue;
                nodeAssocTypeQNamesToRemove.add((QName)entry.getKey());
            }
            int assocsDeleted = this.nodeDAO.removeNodeAssocsToAndFrom(nodeId, nodeAssocTypeQNamesToRemove);
            boolean bl = updated = updated || assocsDeleted > 0;
        }
        if (updated) {
            this.invokeOnUpdateNode(nodeRef);
        }
        if (hadAspect) {
            this.invokeOnRemoveAspect(nodeRef, aspectTypeQName);
        }
        this.nodeIndexer.indexUpdateNode(nodeRef);
    }

    public boolean hasAspect(NodeRef nodeRef, QName aspectQName) throws InvalidNodeRefException, InvalidAspectException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.hasNodeAspect((Long)nodePair.getFirst(), aspectQName);
    }

    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.getNodeAspects((Long)nodePair.getFirst());
    }

    public void deleteNode(NodeRef nodeRef) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Boolean requiresDelete = null;
        Pair<Long, ChildAssociationRef> childAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
        ChildAssociationRef childAssocRef = (ChildAssociationRef)childAssocPair.getSecond();
        QName nodeTypeQName = this.nodeDAO.getNodeType(nodeId);
        Set<QName> nodeAspectQNames = this.nodeDAO.getNodeAspects(nodeId);
        StoreRef storeRef = nodeRef.getStoreRef();
        StoreRef archiveStoreRef = this.storeArchiveMap.get(storeRef);
        if (archiveStoreRef == null) {
            requiresDelete = true;
        } else {
            Boolean requiresArchive;
            TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
            if (typeDef != null && (requiresArchive = typeDef.getArchive()) != null) {
                requiresDelete = requiresArchive == false;
            }
            Iterator<QName> i = nodeAspectQNames.iterator();
            while ((requiresDelete == null || !requiresDelete.booleanValue()) && i.hasNext()) {
                Boolean requiresArchive2;
                QName nodeAspectQName = i.next();
                AspectDefinition aspectDef = this.dictionaryService.getAspect(nodeAspectQName);
                if (aspectDef == null || (requiresArchive2 = aspectDef.getArchive()) == null) continue;
                requiresDelete = requiresArchive2 == false;
            }
        }
        if (requiresDelete == null || requiresDelete.booleanValue()) {
            this.untrackNewNodeRef(nodeRef);
            this.trackDeletedNodeRef(nodeRef);
            this.invokeBeforeDeleteNode(nodeRef);
            this.deletePrimaryChildrenNotArchived(nodePair);
            this.nodeDAO.deleteNode(nodeId);
            this.invokeOnDeleteNode(childAssocRef, nodeTypeQName, nodeAspectQNames, false);
            this.nodeIndexer.indexDeleteNode(childAssocRef);
        } else {
            this.archiveNode(nodeRef, archiveStoreRef);
        }
    }

    private void deletePrimaryChildrenNotArchived(Pair<Long, NodeRef> nodePair) {
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList childNodePairs = new ArrayList(5);
        final HashMap childAssocRefsByChildId = new HashMap(5);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                childNodePairs.add(childNodePair);
                childAssocRefsByChildId.put(childNodePair.getFirst(), childAssocPair.getSecond());
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(nodeId, null, null, null, Boolean.TRUE, null, callback);
        for (Pair childNodePair : childNodePairs) {
            Long childNodeId = (Long)childNodePair.getFirst();
            NodeRef childNodeRef = (NodeRef)childNodePair.getSecond();
            QName childNodeType = this.nodeDAO.getNodeType(childNodeId);
            Set<QName> childNodeQNames = this.nodeDAO.getNodeAspects(childNodeId);
            ChildAssociationRef childParentAssocRef = (ChildAssociationRef)childAssocRefsByChildId.get(childNodeId);
            this.untrackNewNodeRef(childNodeRef);
            this.trackDeletedNodeRef(childNodeRef);
            this.invokeBeforeDeleteNode(childNodeRef);
            this.deletePrimaryChildrenNotArchived((Pair<Long, NodeRef>)childNodePair);
            this.nodeDAO.deleteNode(childNodeId);
            this.invokeOnDeleteNode(childParentAssocRef, childNodeType, childNodeQNames, false);
            this.untrackNewNodeRef(childNodeRef);
        }
    }

    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName assocQName) {
        return this.addChild(Collections.singletonList(parentRef), childRef, assocTypeQName, assocQName).get(0);
    }

    public List<ChildAssociationRef> addChild(Collection<NodeRef> parentRefs, NodeRef childRef, QName assocTypeQName, QName assocQName) {
        Pair<Long, NodeRef> childNodePair = this.getNodePairNotNull(childRef);
        Long childNodeId = (Long)childNodePair.getFirst();
        Map<QName, Serializable> childNodeProperties = this.nodeDAO.getNodeProperties((Long)childNodePair.getFirst());
        String childNodeName = this.extractNameProperty(childNodeProperties);
        if (childNodeName == null) {
            childNodeName = childRef.getId();
        }
        ArrayList<ChildAssociationRef> childAssociationRefs = new ArrayList<ChildAssociationRef>(parentRefs.size());
        ArrayList<Pair<Long, NodeRef>> parentNodePairs = new ArrayList<Pair<Long, NodeRef>>(parentRefs.size());
        for (NodeRef nodeRef : parentRefs) {
            if (this.isDeletedNodeRef(nodeRef)) {
                throw new InvalidNodeRefException("The parent node has been deleted", nodeRef);
            }
            Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(nodeRef);
            Long parentNodeId = (Long)parentNodePair.getFirst();
            parentNodePairs.add(parentNodePair);
            this.invokeBeforeCreateChildAssociation(nodeRef, childRef, assocTypeQName, assocQName, false);
            Pair<Long, ChildAssociationRef> childAssocPair = this.nodeDAO.newChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName, childNodeName);
            childAssociationRefs.add((ChildAssociationRef)childAssocPair.getSecond());
        }
        this.getPaths(childRef, false);
        for (ChildAssociationRef childAssociationRef : childAssociationRefs) {
            this.invokeOnCreateChildAssociation(childAssociationRef, false);
        }
        for (Pair pair : parentNodePairs) {
            this.addAspectsAndProperties((Pair<Long, NodeRef>)pair, assocTypeQName, null, null, null, null, false);
        }
        for (ChildAssociationRef childAssociationRef : childAssociationRefs) {
            this.nodeIndexer.indexCreateChildAssociation(childAssociationRef);
        }
        return childAssociationRefs;
    }

    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        NodeRef primaryParentNodeRef;
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(parentRef);
        Long parentNodeId = (Long)parentNodePair.getFirst();
        Pair<Long, NodeRef> childNodePair = this.getNodePairNotNull(childRef);
        final Long childNodeId = (Long)childNodePair.getFirst();
        Pair<Long, ChildAssociationRef> primaryChildAssocPair = this.nodeDAO.getPrimaryParentAssoc(childNodeId);
        if (primaryChildAssocPair != null && (primaryParentNodeRef = ((ChildAssociationRef)primaryChildAssocPair.getSecond()).getParentRef()).equals((Object)parentRef)) {
            this.deleteNode(childRef);
            return;
        }
        final ArrayList assocsToDelete = new ArrayList(5);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (!((Long)childNodePair.getFirst()).equals(childNodeId)) {
                    return false;
                }
                assocsToDelete.add(childAssocPair);
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(parentNodeId, childNodeId, null, null, null, null, callback);
        for (Pair assocPair : assocsToDelete) {
            Long assocId = (Long)assocPair.getFirst();
            ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
            this.invokeBeforeDeleteChildAssociation(assocRef);
            this.nodeDAO.deleteChildAssoc(assocId);
            this.invokeOnDeleteChildAssociation(assocRef);
            this.nodeIndexer.indexDeleteChildAssociation(assocRef);
        }
    }

    public boolean removeChildAssociation(ChildAssociationRef childAssocRef) {
        QName assocQName;
        QName assocTypeQName;
        Long childNodeId;
        Long parentNodeId = (Long)this.getNodePairNotNull(childAssocRef.getParentRef()).getFirst();
        Pair<Long, ChildAssociationRef> assocPair = this.nodeDAO.getChildAssoc(parentNodeId, childNodeId = (Long)this.getNodePairNotNull(childAssocRef.getChildRef()).getFirst(), assocTypeQName = childAssocRef.getTypeQName(), assocQName = childAssocRef.getQName());
        if (assocPair == null) {
            return false;
        }
        Long assocId = (Long)assocPair.getFirst();
        ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
        if (assocRef.isPrimary()) {
            NodeRef childNodeRef = assocRef.getChildRef();
            this.deleteNode(childNodeRef);
            return true;
        }
        this.invokeBeforeDeleteChildAssociation(childAssocRef);
        this.nodeDAO.deleteChildAssoc(assocId);
        this.invokeOnDeleteChildAssociation(childAssocRef);
        this.nodeIndexer.indexDeleteChildAssociation(childAssocRef);
        return true;
    }

    public boolean removeSeconaryChildAssociation(ChildAssociationRef childAssocRef) {
        QName assocQName;
        QName assocTypeQName;
        Long childNodeId;
        Long parentNodeId = (Long)this.getNodePairNotNull(childAssocRef.getParentRef()).getFirst();
        Pair<Long, ChildAssociationRef> assocPair = this.nodeDAO.getChildAssoc(parentNodeId, childNodeId = (Long)this.getNodePairNotNull(childAssocRef.getChildRef()).getFirst(), assocTypeQName = childAssocRef.getTypeQName(), assocQName = childAssocRef.getQName());
        if (assocPair == null) {
            return false;
        }
        Long assocId = (Long)assocPair.getFirst();
        ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
        if (assocRef.isPrimary()) {
            throw new IllegalArgumentException("removeSeconaryChildAssociation can not be applied to a primary association: \n   Child Assoc: " + assocRef);
        }
        this.nodeDAO.deleteChildAssoc(assocId);
        this.invokeOnDeleteChildAssociation(childAssocRef);
        this.nodeIndexer.indexDeleteChildAssociation(childAssocRef);
        return true;
    }

    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Long nodeId = (Long)this.getNodePairNotNull(nodeRef).getFirst();
        if (qname.equals((Object)ContentModel.PROP_STORE_PROTOCOL)) {
            return nodeRef.getStoreRef().getProtocol();
        }
        if (qname.equals((Object)ContentModel.PROP_STORE_IDENTIFIER)) {
            return nodeRef.getStoreRef().getIdentifier();
        }
        if (qname.equals((Object)ContentModel.PROP_NODE_UUID)) {
            return nodeRef.getId();
        }
        if (qname.equals((Object)ContentModel.PROP_NODE_DBID)) {
            return nodeId;
        }
        Serializable property = this.nodeDAO.getNodeProperty(nodeId, qname);
        if (property == null && qname.equals((Object)ContentModel.PROP_NAME)) {
            return nodeRef.getId();
        }
        return property;
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.getPropertiesImpl(nodePair);
    }

    private Map<QName, Serializable> getPropertiesImpl(Pair<Long, NodeRef> nodePair) throws InvalidNodeRefException {
        Long nodeId = (Long)nodePair.getFirst();
        Map<QName, Serializable> nodeProperties = this.nodeDAO.getNodeProperties(nodeId);
        return nodeProperties;
    }

    public Long getNodeAclId(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.getAclIDImpl(nodePair);
    }

    private Long getAclIDImpl(Pair<Long, NodeRef> nodePair) throws InvalidNodeRefException {
        Long nodeId = (Long)nodePair.getFirst();
        Long aclID = this.nodeDAO.getNodeAclId(nodeId);
        return aclID;
    }

    private boolean setPropertiesCommonWork(Pair<Long, NodeRef> nodePair, Map<QName, Serializable> properties) {
        Long nodeId = (Long)nodePair.getFirst();
        boolean changed = false;
        if (properties.containsKey(ContentModel.PROP_NAME)) {
            String name = this.extractNameProperty(properties);
            Pair<Long, ChildAssociationRef> primaryParentAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
            if (primaryParentAssocPair != null) {
                String oldName = this.extractNameProperty(this.nodeDAO.getNodeProperties(nodeId));
                String newName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)name);
                changed = this.setChildNameUnique(nodePair, newName, oldName);
            }
        }
        return changed;
    }

    public void setProperty(NodeRef nodeRef, QName qname, Serializable value) throws InvalidNodeRefException {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"qname", (Object)qname);
        if (qname.equals((Object)ContentModel.PROP_NODE_UUID)) {
            throw new IllegalArgumentException("The node UUID cannot be changed.");
        }
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.setPropertiesCommonWork(nodePair, Collections.singletonMap(qname, value));
        boolean changed = this.addAspectsAndProperties(nodePair, null, null, null, null, Collections.singletonMap(qname, value), false);
        if (changed) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.setPropertiesCommonWork(nodePair, properties);
        boolean changed = this.addAspectsAndProperties(nodePair, null, null, null, null, properties, true);
        if (changed) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void addProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.setPropertiesCommonWork(nodePair, properties);
        boolean changed = this.addAspectsAndProperties(nodePair, null, null, null, null, properties, false);
        if (changed) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void removeProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        this.invokeBeforeUpdateNode(nodeRef);
        Map<QName, Serializable> propertiesBefore = this.getPropertiesImpl(nodePair);
        if (qname.equals((Object)ContentModel.PROP_NAME)) {
            String oldName = this.extractNameProperty(this.nodeDAO.getNodeProperties(nodeId));
            String newName = null;
            this.setChildNameUnique(nodePair, newName, oldName);
        }
        this.nodeDAO.removeNodeProperties(nodeId, Collections.singleton(qname));
        Map<QName, Serializable> propertiesAfter = this.getPropertiesImpl(nodePair);
        this.invokeOnUpdateNode(nodeRef);
        this.invokeOnUpdateProperties(nodeRef, propertiesBefore, propertiesAfter);
        this.nodeIndexer.indexUpdateNode(nodeRef);
    }

    public Collection<NodeRef> getParents(NodeRef nodeRef) throws InvalidNodeRefException {
        List<ChildAssociationRef> parentAssocs = this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
        HashSet<NodeRef> parentNodeRefs = new HashSet<NodeRef>(parentAssocs.size());
        for (ChildAssociationRef parentAssoc : parentAssocs) {
            NodeRef parentNodeRef = parentAssoc.getParentRef();
            parentNodeRefs.add(parentNodeRef);
        }
        return new ArrayList<NodeRef>(parentNodeRefs);
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, final QNamePattern typeQNamePattern, final QNamePattern qnamePattern) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(10);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (!typeQNamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getTypeQName())) {
                    return true;
                }
                if (!qnamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getQName())) {
                    return true;
                }
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        QName typeQName = typeQNamePattern instanceof QName ? (QName)typeQNamePattern : null;
        QName qname = qnamePattern instanceof QName ? (QName)qnamePattern : null;
        this.nodeDAO.getParentAssocs(nodeId, typeQName, qname, null, callback);
        return results;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        return this.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern, true);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, final QNamePattern typeQNamePattern, final QNamePattern qnamePattern, final boolean preload) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(10);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return preload;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (!typeQNamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getTypeQName())) {
                    return true;
                }
                if (!qnamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getQName())) {
                    return true;
                }
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        QName typeQName = typeQNamePattern instanceof QName ? (QName)typeQNamePattern : null;
        QName qname = qnamePattern instanceof QName ? (QName)qnamePattern : null;
        this.nodeDAO.getChildAssocs(nodeId, null, typeQName, qname, null, null, callback);
        List<ChildAssociationRef> orderedList = this.reorderChildAssocs(results);
        return orderedList;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, Set<QName> childNodeTypeQNames) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocsByChildTypes(nodeId, childNodeTypeQNames, callback);
        List<ChildAssociationRef> orderedList = this.reorderChildAssocs(results);
        return orderedList;
    }

    private List<ChildAssociationRef> reorderChildAssocs(Collection<ChildAssociationRef> childAssocRefs) {
        if (childAssocRefs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ChildAssociationRef> orderedList = new ArrayList<ChildAssociationRef>(childAssocRefs);
        Collections.sort(orderedList);
        int nthSibling = 0;
        for (ChildAssociationRef childAssocRef : orderedList) {
            childAssocRef.setNthSibling(nthSibling);
            ++nthSibling;
        }
        return orderedList;
    }

    public NodeRef getChildByName(NodeRef nodeRef, QName assocTypeQName, String childName) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Pair<Long, ChildAssociationRef> childAssocPair = this.nodeDAO.getChildAssoc(nodeId, assocTypeQName, childName);
        if (childAssocPair != null) {
            return ((ChildAssociationRef)childAssocPair.getSecond()).getChildRef();
        }
        return null;
    }

    public List<ChildAssociationRef> getChildrenByName(NodeRef nodeRef, QName assocTypeQName, Collection<String> childNames) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(nodeId, assocTypeQName, childNames, callback);
        List<ChildAssociationRef> orderedList = this.reorderChildAssocs(results);
        return orderedList;
    }

    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Pair<Long, ChildAssociationRef> assocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
        ChildAssociationRef assocRef = null;
        assocRef = assocPair == null ? new ChildAssociationRef(null, null, null, nodeRef) : (ChildAssociationRef)assocPair.getSecond();
        return assocRef;
    }

    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException, AssociationExistsException {
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        long sourceNodeId = (Long)sourceNodePair.getFirst();
        Pair<Long, NodeRef> targetNodePair = this.getNodePairNotNull(targetRef);
        long targetNodeId = (Long)targetNodePair.getFirst();
        Long assocId = this.nodeDAO.newNodeAssoc(sourceNodeId, targetNodeId, assocTypeQName);
        AssociationRef assocRef = new AssociationRef(assocId, sourceRef, assocTypeQName, targetRef);
        this.invokeOnCreateAssociation(assocRef);
        this.addAspectsAndProperties(sourceNodePair, assocTypeQName, null, null, null, null, false);
        return assocRef;
    }

    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(NodeRef parent, QName assocTypeQName) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(parent);
        Long parentNodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocsWithoutParentAssocsOfType(parentNodeId, assocTypeQName, callback);
        return results;
    }

    public List<ChildAssociationRef> getChildAssocsByPropertyValue(NodeRef nodeRef, QName propertyQName, Serializable value) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        if (getChildAssocsByPropertyValueBannedProps.contains(propertyQName)) {
            throw new IllegalArgumentException("getChildAssocsByPropertyValue does not allow search of system maintaied properties: " + propertyQName);
        }
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(10);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocsByPropertyValue(nodeId, propertyQName, value, callback);
        List<ChildAssociationRef> orderedList = this.reorderChildAssocs(results);
        return orderedList;
    }

    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException {
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        long sourceNodeId = (Long)sourceNodePair.getFirst();
        Pair<Long, NodeRef> targetNodePair = this.getNodePairNotNull(targetRef);
        long targetNodeId = (Long)targetNodePair.getFirst();
        int assocsDeleted = this.nodeDAO.removeNodeAssoc(sourceNodeId, targetNodeId, assocTypeQName);
        if (assocsDeleted > 0) {
            AssociationRef assocRef = new AssociationRef(sourceRef, assocTypeQName, targetRef);
            this.invokeOnDeleteAssociation(assocRef);
        }
    }

    public AssociationRef getAssoc(Long id) {
        return (AssociationRef)this.nodeDAO.getNodeAssoc(id).getSecond();
    }

    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        long sourceNodeId = (Long)sourceNodePair.getFirst();
        Collection<Pair<Long, AssociationRef>> assocPairs = this.nodeDAO.getTargetNodeAssocs(sourceNodeId);
        ArrayList<AssociationRef> nodeAssocRefs = new ArrayList<AssociationRef>(assocPairs.size());
        for (Pair<Long, AssociationRef> assocPair : assocPairs) {
            AssociationRef assocRef = (AssociationRef)assocPair.getSecond();
            if (!qnamePattern.isMatch(assocRef.getTypeQName())) continue;
            nodeAssocRefs.add(assocRef);
        }
        return nodeAssocRefs;
    }

    public List<AssociationRef> getSourceAssocs(NodeRef targetRef, QNamePattern qnamePattern) {
        Pair<Long, NodeRef> targetNodePair = this.getNodePairNotNull(targetRef);
        long targetNodeId = (Long)targetNodePair.getFirst();
        Collection<Pair<Long, AssociationRef>> assocPairs = this.nodeDAO.getSourceNodeAssocs(targetNodeId);
        ArrayList<AssociationRef> nodeAssocRefs = new ArrayList<AssociationRef>(assocPairs.size());
        for (Pair<Long, AssociationRef> assocPair : assocPairs) {
            AssociationRef assocRef = (AssociationRef)assocPair.getSecond();
            if (!qnamePattern.isMatch(assocRef.getTypeQName())) continue;
            nodeAssocRefs.add(assocRef);
        }
        return nodeAssocRefs;
    }

    public Path getPath(NodeRef nodeRef) throws InvalidNodeRefException {
        List<Path> paths = this.getPaths(nodeRef, true);
        if (paths.size() == 1) {
            return paths.get(0);
        }
        throw new RuntimeException("Primary path count not checked");
    }

    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.getPaths(nodePair, primaryOnly);
    }

    private void archiveNode(NodeRef nodeRef, StoreRef archiveStoreRef) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Pair<Long, ChildAssociationRef> primaryParentAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
        HashSet<QName> newAspects = new HashSet<QName>(5);
        Map<QName, Serializable> existingProperties = this.nodeDAO.getNodeProperties(nodeId);
        HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(11);
        newAspects.add(ContentModel.ASPECT_ARCHIVED);
        newProperties.put(ContentModel.PROP_ARCHIVED_BY, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        newProperties.put(ContentModel.PROP_ARCHIVED_DATE, new Date());
        newProperties.put(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC, (Serializable)primaryParentAssocPair.getSecond());
        Serializable originalOwner = existingProperties.get(ContentModel.PROP_OWNER);
        Serializable originalCreator = existingProperties.get(ContentModel.PROP_CREATOR);
        if (originalOwner != null || originalCreator != null) {
            newProperties.put(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER, originalOwner != null ? originalOwner : originalCreator);
        }
        newAspects.add(ContentModel.ASPECT_OWNABLE);
        newProperties.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        this.nodeDAO.addNodeProperties(nodeId, newProperties);
        this.nodeDAO.addNodeAspects(nodeId, newAspects);
        Pair<Long, NodeRef> archiveStoreRootNodePair = this.nodeDAO.getRootNode(archiveStoreRef);
        this.moveNode(nodeRef, (NodeRef)archiveStoreRootNodePair.getSecond(), ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"archivedItem"));
    }

    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef destinationParentNodeRef, QName assocTypeQName, QName assocQName) {
        Pair<Long, NodeRef> archivedNodePair = this.getNodePairNotNull(archivedNodeRef);
        Long archivedNodeId = (Long)archivedNodePair.getFirst();
        Set<QName> existingAspects = this.nodeDAO.getNodeAspects(archivedNodeId);
        HashSet<QName> newAspects = new HashSet<QName>(5);
        Map<QName, Serializable> existingProperties = this.nodeDAO.getNodeProperties(archivedNodeId);
        HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(11);
        if (!existingAspects.contains(ContentModel.ASPECT_ARCHIVED)) {
            throw new AlfrescoRuntimeException("The node to restore is not an archive node");
        }
        ChildAssociationRef originalPrimaryParentAssocRef = (ChildAssociationRef)existingProperties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        Serializable originalOwner = existingProperties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER);
        HashSet<QName> removePropertyQNames = new HashSet<QName>(11);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_BY);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_DATE);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER);
        this.nodeDAO.removeNodeProperties(archivedNodeId, removePropertyQNames);
        this.nodeDAO.removeNodeAspects(archivedNodeId, Collections.singleton(ContentModel.ASPECT_ARCHIVED));
        if (originalOwner != null) {
            newAspects.add(ContentModel.ASPECT_OWNABLE);
            newProperties.put(ContentModel.PROP_OWNER, originalOwner);
        }
        if (destinationParentNodeRef == null) {
            destinationParentNodeRef = originalPrimaryParentAssocRef.getParentRef();
        }
        if (assocTypeQName == null) {
            assocTypeQName = originalPrimaryParentAssocRef.getTypeQName();
        }
        if (assocQName == null) {
            assocQName = originalPrimaryParentAssocRef.getQName();
        }
        ChildAssociationRef newChildAssocRef = this.moveNode(archivedNodeRef, destinationParentNodeRef, assocTypeQName, assocQName);
        NodeRef restoredNodeRef = newChildAssocRef.getChildRef();
        this.invokeOnRestoreNode(newChildAssocRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Restored node: \n   original noderef: " + archivedNodeRef + "\n" + "   restored noderef: " + restoredNodeRef + "\n" + "   new parent: " + destinationParentNodeRef));
        }
        return restoredNodeRef;
    }

    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) {
        boolean movingStore;
        if (this.isDeletedNodeRef(newParentRef)) {
            throw new InvalidNodeRefException("The parent node has been deleted", newParentRef);
        }
        Pair<Long, NodeRef> nodeToMovePair = this.getNodePairNotNull(nodeToMoveRef);
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(newParentRef);
        Long nodeToMoveId = (Long)nodeToMovePair.getFirst();
        QName nodeToMoveTypeQName = this.nodeDAO.getNodeType(nodeToMoveId);
        NodeRef oldNodeToMoveRef = (NodeRef)nodeToMovePair.getSecond();
        Long parentNodeId = (Long)parentNodePair.getFirst();
        NodeRef parentNodeRef = (NodeRef)parentNodePair.getSecond();
        StoreRef oldStoreRef = oldNodeToMoveRef.getStoreRef();
        StoreRef newStoreRef = parentNodeRef.getStoreRef();
        NodeRef newNodeToMoveRef = new NodeRef(newStoreRef, oldNodeToMoveRef.getId());
        Pair newNodeToMovePair = new Pair((Object)nodeToMoveId, (Object)newNodeToMoveRef);
        Pair<Long, ChildAssociationRef> oldParentAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeToMoveId);
        if (oldParentAssocPair == null) {
            throw new IllegalArgumentException("Node " + nodeToMoveId + " doesn't have a parent.  Use 'addChild' instead of move.");
        }
        ChildAssociationRef oldParentAssocRef = (ChildAssociationRef)oldParentAssocPair.getSecond();
        if (EqualsHelper.nullSafeEquals((Object)oldParentAssocRef.getParentRef(), (Object)newParentRef) && EqualsHelper.nullSafeEquals((Object)oldParentAssocRef.getTypeQName(), (Object)assocTypeQName) && EqualsHelper.nullSafeEquals((Object)oldParentAssocRef.getQName(), (Object)assocQName)) {
            return oldParentAssocRef;
        }
        boolean bl = movingStore = !oldStoreRef.equals((Object)newStoreRef);
        if (movingStore) {
            this.untrackNewNodeRef(nodeToMoveRef);
            this.trackDeletedNodeRef(nodeToMoveRef);
            this.invokeBeforeDeleteNode(nodeToMoveRef);
            this.invokeBeforeCreateNode(newParentRef, assocTypeQName, assocQName, nodeToMoveTypeQName);
        } else {
            this.invokeBeforeDeleteChildAssociation(oldParentAssocRef);
            this.invokeBeforeCreateChildAssociation(newParentRef, nodeToMoveRef, assocTypeQName, assocQName, false);
        }
        Pair<Long, ChildAssociationRef> newParentAssocPair = this.nodeDAO.moveNode(nodeToMoveId, parentNodeId, assocTypeQName, assocQName);
        ChildAssociationRef newParentAssocRef = (ChildAssociationRef)newParentAssocPair.getSecond();
        if (movingStore) {
            this.nodeIndexer.indexDeleteNode(oldParentAssocRef);
            this.nodeIndexer.indexCreateNode(newParentAssocRef);
        } else {
            this.nodeIndexer.indexUpdateChildAssociation(oldParentAssocRef, newParentAssocRef);
        }
        if (movingStore) {
            Set<QName> nodeToMoveAspectQNames = this.nodeDAO.getNodeAspects(nodeToMoveId);
            this.invokeOnDeleteNode(oldParentAssocRef, nodeToMoveTypeQName, nodeToMoveAspectQNames, true);
            this.invokeOnCreateNode(newParentAssocRef);
            this.pullNodeChildrenToSameStore((Pair<Long, NodeRef>)newNodeToMovePair);
        } else {
            this.invokeOnCreateChildAssociation(newParentAssocRef, false);
            this.invokeOnDeleteChildAssociation(oldParentAssocRef);
            this.invokeOnMoveNode(oldParentAssocRef, newParentAssocRef);
        }
        return newParentAssocRef;
    }

    private void pullNodeChildrenToSameStore(Pair<Long, NodeRef> nodePair) {
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList childNodePairs = new ArrayList(5);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                childNodePairs.add(childNodePair);
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(nodeId, null, null, null, Boolean.TRUE, Boolean.FALSE, callback);
        for (Pair oldChildNodePair : childNodePairs) {
            Long childNodeId = (Long)oldChildNodePair.getFirst();
            NodeRef childNodeRef = (NodeRef)oldChildNodePair.getSecond();
            if (this.nodeDAO.getNodeRefStatus(childNodeRef).isDeleted()) continue;
            QName childNodeTypeQName = this.nodeDAO.getNodeType(childNodeId);
            Set<QName> childNodeAspectQNames = this.nodeDAO.getNodeAspects(childNodeId);
            Pair<Long, ChildAssociationRef> oldParentAssocPair = this.nodeDAO.getPrimaryParentAssoc(childNodeId);
            Pair newChildNodePair = oldChildNodePair;
            Pair<Long, ChildAssociationRef> newParentAssocPair = oldParentAssocPair;
            ChildAssociationRef newParentAssocRef = (ChildAssociationRef)newParentAssocPair.getSecond();
            this.untrackNewNodeRef(childNodeRef);
            this.trackDeletedNodeRef(childNodeRef);
            this.invokeBeforeDeleteNode(childNodeRef);
            this.invokeBeforeCreateNode(newParentAssocRef.getParentRef(), newParentAssocRef.getTypeQName(), newParentAssocRef.getQName(), childNodeTypeQName);
            newParentAssocPair = this.nodeDAO.moveNode(childNodeId, nodeId, null, null);
            this.nodeIndexer.indexCreateNode((ChildAssociationRef)newParentAssocPair.getSecond());
            this.invokeOnDeleteNode((ChildAssociationRef)oldParentAssocPair.getSecond(), childNodeTypeQName, childNodeAspectQNames, true);
            this.invokeOnCreateNode((ChildAssociationRef)newParentAssocPair.getSecond());
            this.pullNodeChildrenToSameStore((Pair<Long, NodeRef>)newChildNodePair);
        }
    }

    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        StoreRef archiveStoreRef = this.storeArchiveMap.get(storeRef);
        if (archiveStoreRef == null) {
            return null;
        }
        return this.getRootNode(archiveStoreRef);
    }

    private String extractNameProperty(Map<QName, Serializable> properties) {
        Serializable nameValue = properties.get(ContentModel.PROP_NAME);
        String name = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)nameValue);
        return name;
    }

    private boolean setChildNameUnique(Pair<Long, NodeRef> childNodePair, String newName, String oldName) {
        if (newName == null) {
            newName = ((NodeRef)childNodePair.getSecond()).getId();
        }
        Long childNodeId = (Long)childNodePair.getFirst();
        if (EqualsHelper.nullSafeEquals((Object)newName, (Object)oldName)) {
            return false;
        }
        this.nodeDAO.setChildAssocsUniqueName(childNodeId, newName);
        return true;
    }

    static {
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_NODE_DBID);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_NODE_UUID);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_NAME);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_MODIFIED);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_MODIFIER);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_CREATED);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_CREATOR);
    }
}

