/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.cleanup.NodeCleanupRegistry;
import org.alfresco.repo.node.db.DbNodeServiceImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbNodeServiceImplTest
extends BaseNodeServiceTest {
    private TransactionService txnService;
    private NodeDAO nodeDAO;
    private DictionaryService dictionaryService;

    @Override
    protected NodeService getNodeService() {
        DbNodeServiceImpl dbNodeServiceImpl = (DbNodeServiceImpl)this.applicationContext.getBean("dbNodeServiceImpl");
        return (NodeService)this.applicationContext.getBean("dbNodeService");
    }

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.txnService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.nodeDAO = (NodeDAO)this.applicationContext.getBean("nodeDAO");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
    }

    public void testNodeCleanupRegistry() throws Exception {
        this.setComplete();
        this.endTransaction();
        NodeCleanupRegistry cleanupRegistry = (NodeCleanupRegistry)this.applicationContext.getBean("nodeCleanupRegistry");
        cleanupRegistry.doClean();
    }

    public void testLazyLoadIssue() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        this.setComplete();
        this.endTransaction();
        UserTransaction userTransaction = this.txnService.getUserTransaction();
        try {
            userTransaction.begin();
            ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n6_p_n8"));
            NodeRef n6Ref = n6pn8Ref.getParentRef();
            NodeRef n8Ref = n6pn8Ref.getChildRef();
            this.nodeService.deleteNode(n8Ref);
            List assocs = this.nodeService.getChildAssocs(n6Ref);
            for (ChildAssociationRef assoc : assocs) {
            }
            userTransaction.commit();
        }
        catch (Exception e) {
            try {
                userTransaction.rollback();
            }
            catch (IllegalStateException ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public void testNodeStatus() throws Throwable {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef n6pn8Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"n6_p_n8"));
        final NodeRef n6Ref = n6pn8Ref.getParentRef();
        final NodeRef n8Ref = n6pn8Ref.getChildRef();
        final Map properties = this.nodeService.getProperties(n6Ref);
        this.setComplete();
        this.endTransaction();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> changePropertiesWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.setProperty(n6Ref, ContentModel.PROP_CREATED, (Serializable)new Date());
                return null;
            }
        };
        this.executeAndCheck(n6Ref, changePropertiesWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> addAspectWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.addAspect(n6Ref, BaseNodeServiceTest.ASPECT_QNAME_TEST_MARKER, null);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, addAspectWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> removeAspectWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.removeAspect(n6Ref, BaseNodeServiceTest.ASPECT_QNAME_TEST_MARKER);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, removeAspectWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> moveNodeWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.moveNode(n6Ref, DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"moved"));
                return null;
            }
        };
        this.executeAndCheck(n6Ref, moveNodeWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteNodeWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                DbNodeServiceImplTest.this.nodeService.deleteNode(n6Ref);
                return null;
            }
        };
        this.executeAndCheck(n6Ref, deleteNodeWork);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkCascadeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                NodeRef.Status n6Status = DbNodeServiceImplTest.this.nodeDAO.getNodeRefStatus(n6Ref);
                if (!n6Status.isDeleted()) {
                    throw new RuntimeException("Deleted node does not have deleted status");
                }
                NodeRef.Status n8Status = DbNodeServiceImplTest.this.nodeDAO.getNodeRefStatus(n8Ref);
                if (!n8Status.isDeleted()) {
                    throw new RuntimeException("Cascade-deleted node does not have deleted status");
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(checkCascadeCallback);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkRecreateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                properties.put(ContentModel.PROP_STORE_PROTOCOL, n6Ref.getStoreRef().getProtocol());
                properties.put(ContentModel.PROP_STORE_IDENTIFIER, n6Ref.getStoreRef().getIdentifier());
                properties.put(ContentModel.PROP_NODE_UUID, n6Ref.getId());
                DbNodeServiceImplTest.this.nodeService.createNode(DbNodeServiceImplTest.this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"recreated-n6"), ContentModel.TYPE_CONTAINER, properties);
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(checkRecreateCallback);
    }

    private void executeAndCheck(NodeRef nodeRef, RetryingTransactionHelper.RetryingTransactionCallback<Object> callback) throws Throwable {
        UserTransaction txn = this.txnService.getUserTransaction();
        txn.begin();
        NodeRef.Status currentStatus = this.nodeService.getNodeStatus(nodeRef);
        DbNodeServiceImplTest.assertNotNull((Object)currentStatus);
        String currentTxnId = AlfrescoTransactionSupport.getTransactionId();
        DbNodeServiceImplTest.assertNotNull((Object)currentTxnId);
        DbNodeServiceImplTest.assertNotSame((Object)currentTxnId, (Object)currentStatus.getChangeTxnId());
        try {
            callback.execute();
            NodeRef.Status newStatus = this.nodeService.getNodeStatus(nodeRef);
            DbNodeServiceImplTest.assertNotNull((Object)newStatus);
            DbNodeServiceImplTest.assertEquals((String)"Change didn't update status", (String)currentTxnId, (String)newStatus.getChangeTxnId());
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public void testMLTextValues() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.ENGLISH, "Very good!");
        mlTextProperty.addValue(Locale.FRENCH, "Tr\u00e8s bon!");
        mlTextProperty.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
        Serializable textValueDirect = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertEquals((String)"MLText type not returned direct", (Object)mlTextProperty, (Object)textValueDirect);
        Map propertiesDirect = this.nodeService.getProperties(this.rootNodeRef);
        DbNodeServiceImplTest.assertEquals((String)"MLText type not returned direct in Map", (Object)mlTextProperty, propertiesDirect.get(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    public void testStringIntoMLTextProperty() throws Exception {
        String text = "Hello";
        this.nodeService.setProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)text));
        Serializable mlTextCheck = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertTrue((String)"Plain string insertion should be returned as MLText", (boolean)(mlTextCheck instanceof MLText));
        Locale defaultLocale = I18NUtil.getLocale();
        MLText mlTextCheck2 = (MLText)mlTextCheck;
        String mlTextDefaultCheck = mlTextCheck2.getDefaultValue();
        DbNodeServiceImplTest.assertEquals((String)"Default MLText value was not set correctly", (String)text, (String)mlTextDefaultCheck);
        this.nodeService.setProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE, null);
        Serializable nullValueCheck = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE);
        this.nodeService.setProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)text));
        MLText mlText = new MLText();
        mlText.addValue(Locale.ENGLISH, "Very good!");
        mlText.addValue(Locale.FRENCH, "Tr\u00e8s bon!");
        mlText.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
        mlTextCheck = this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertEquals((String)"Setting of MLText over String failed.", (Object)mlText, (Object)mlTextCheck);
    }

    public void testSingleStringMLTextProperty() throws Exception {
        MLText mlText = new MLText();
        mlText.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
        MLText mlTextCheck = (MLText)this.nodeService.getProperty(this.rootNodeRef, PROP_QNAME_ML_TEXT_VALUE);
        DbNodeServiceImplTest.assertEquals((String)"Setting of MLText over String failed.", (Object)mlText, (Object)mlTextCheck);
    }

    public void testInTransactionCreateAndDelete() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)this.getName()), TYPE_QNAME_TEST_CONTENT).getChildRef();
        this.nodeService.deleteNode(nodeRef);
    }

    public void testAspectRemovalWithCommit() throws Throwable {
        NodeRef sourceNodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"testAspectRemoval-source"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef targetNodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"testAspectRemoval-target"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS, null);
        this.nodeService.addChild(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_CHILD_ASSOC, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"aspect-child"));
        this.nodeService.createAssociation(sourceNodeRef, targetNodeRef, ASSOC_ASPECT_NORMAL_ASSOC);
        DbNodeServiceImplTest.assertEquals((String)"Expected exactly one child", (int)1, (int)this.nodeService.getChildAssocs(sourceNodeRef).size());
        DbNodeServiceImplTest.assertEquals((String)"Expected exactly one target", (int)1, (int)this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL).size());
        this.setComplete();
        this.endTransaction();
        UserTransaction txn = this.txnService.getUserTransaction();
        txn.begin();
        try {
            Set aspects = this.nodeService.getAspects(sourceNodeRef);
            int noAspectsBefore = aspects.size();
            this.nodeService.removeAspect(sourceNodeRef, ASPECT_WITH_ASSOCIATIONS);
            DbNodeServiceImplTest.assertEquals((String)"Expected exactly zero child", (int)0, (int)this.nodeService.getChildAssocs(sourceNodeRef).size());
            DbNodeServiceImplTest.assertEquals((String)"Expected exactly zero target", (int)0, (int)this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL).size());
            aspects = this.nodeService.getAspects(sourceNodeRef);
            DbNodeServiceImplTest.assertEquals((String)"Expected exactly one less aspect", (int)(noAspectsBefore - 1), (int)aspects.size());
            txn.commit();
        }
        catch (Throwable e) {
            try {
                txn.rollback();
            }
            catch (Throwable ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public void testGetChildAssocsByPropertyValue() throws Exception {
        Map<QName, ChildAssociationRef> assocRefs = this.buildNodeGraph();
        ChildAssociationRef rootRef = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root"));
        ChildAssociationRef n1Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n1"));
        ChildAssociationRef n2Ref = assocRefs.get(QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"root_p_n2"));
        NodeRef parentNodeRef = n1Ref.getParentRef();
        NodeRef childNodeRef = n1Ref.getChildRef();
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(parentNodeRef));
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(childNodeRef));
        String subject = "Hello World";
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        List refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        this.nodeService.setProperty(n2Ref.getChildRef(), ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_SUBJECT, (Serializable)((Object)subject));
        DbNodeServiceImplTest.assertTrue((String)"failed to read two assocs", (refs.size() == 2 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n2Ref));
        parentNodeRef = n1Ref.getParentRef();
        childNodeRef = n1Ref.getChildRef();
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(parentNodeRef));
        DbNodeServiceImplTest.assertTrue((boolean)this.nodeService.exists(childNodeRef));
        int count = 123;
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_COUNTER, (Serializable)Integer.valueOf(count));
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_COUNTER, (Serializable)Integer.valueOf(count));
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        Double alfLat = new Double(51.5216666);
        Double alfLon = new Double(0.43);
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_LATITUDE, (Serializable)alfLat);
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_LATITUDE, (Serializable)alfLat);
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        Boolean beauty = Boolean.TRUE;
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED)));
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        DbNodeServiceImplTest.assertTrue((String)"content not correct", (boolean)refs.contains(n1Ref));
        beauty = Boolean.FALSE;
        this.nodeService.setProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue(((Boolean)this.nodeService.getProperty(n1Ref.getChildRef(), ContentModel.PROP_ENABLED) == false ? 1 : 0) != 0);
        refs = this.nodeService.getChildAssocsByPropertyValue(parentNodeRef, ContentModel.PROP_ENABLED, (Serializable)beauty);
        DbNodeServiceImplTest.assertTrue((String)"failed to read one assoc", (refs.size() == 1 ? 1 : 0) != 0);
        try {
            List refs2 = this.nodeService.getChildAssocsByPropertyValue(n1Ref.getParentRef(), ContentModel.PROP_NODE_DBID, (Serializable)((Object)"Fail"));
            DbNodeServiceImplTest.fail((String)"sys:node-dbid not rejected");
        }
        catch (IllegalArgumentException ie) {
            // empty catch block
        }
        try {
            String title = (String)((Object)this.nodeService.getProperty(n1Ref.getChildRef(), ContentModel.PROP_TITLE));
            List refs3 = this.nodeService.getChildAssocsByPropertyValue(n1Ref.getParentRef(), ContentModel.PROP_NAME, (Serializable)((Object)title));
            DbNodeServiceImplTest.fail((String)"MLText type not rejected");
        }
        catch (IllegalArgumentException ie) {
            // empty catch block
        }
    }
}

