/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.concurrent.ThreadPoolExecutor;
import javax.transaction.UserTransaction;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.index.AVMRemoteSnapshotTracker;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;

public class AVMRemoteSnapshotTrackerTest
extends BaseSpringTest {
    private AuthenticationComponent authenticationComponent;
    private AVMService avmService;
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;
    private TransactionService transactionService;
    private UserTransaction testTX;
    private SearchService searchService;
    private NodeService nodeService;
    private FullTextSearchIndexer ftsIndexer;
    private Indexer indexer;
    private NodeDAO nodeDAO;
    private ThreadPoolExecutor threadPoolExecutor;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.avmService = (AVMService)this.applicationContext.getBean("AVMService");
        this.avmSnapShotTriggeredIndexingMethodInterceptor = (AVMSnapShotTriggeredIndexingMethodInterceptor)this.applicationContext.getBean("avmSnapShotTriggeredIndexingMethodInterceptor");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.searchService = serviceRegistry.getSearchService();
        this.nodeService = serviceRegistry.getNodeService();
        this.ftsIndexer = (FullTextSearchIndexer)this.applicationContext.getBean("LuceneFullTextSearchIndexer");
        this.indexer = (Indexer)this.applicationContext.getBean("indexerComponent");
        this.nodeDAO = (NodeDAO)this.applicationContext.getBean("nodeDAO");
        this.threadPoolExecutor = (ThreadPoolExecutor)this.applicationContext.getBean("indexTrackerThreadPoolExecutor");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void onTearDownInTransaction() throws Exception {
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onTearDownInTransaction();
    }

    public void testCatchUp() {
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("one"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("two"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("three"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("four"));
        this.avmService.createStore("one");
        this.avmService.createDirectory("one:/", "a");
        this.avmService.createSnapshot("one", null, null);
        this.avmService.createStore("two");
        this.avmService.createDirectory("two:/", "a");
        this.avmService.createStore("three");
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("one"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("one"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("two"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("two"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("three"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("three"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("four"));
        this.avmSnapShotTriggeredIndexingMethodInterceptor.setEnableIndexing(false);
        this.avmService.createSnapshot("two", null, null);
        this.avmService.createDirectory("three:/", "a");
        this.avmService.createSnapshot("three", null, null);
        this.avmService.createStore("four");
        this.avmService.createDirectory("four:/", "a");
        this.avmService.createSnapshot("four", null, null);
        this.avmService.createDirectory("four:/", "b");
        this.avmService.createSnapshot("four", null, null);
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("one"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("one"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("two"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("two"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("three"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("three"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("four"));
        AVMRemoteSnapshotTrackerTest.assertFalse((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("four"));
        this.avmSnapShotTriggeredIndexingMethodInterceptor.setEnableIndexing(true);
        AVMRemoteSnapshotTracker tracker = new AVMRemoteSnapshotTracker();
        tracker.setAuthenticationComponent(this.authenticationComponent);
        tracker.setAvmService(this.avmService);
        tracker.setAvmSnapShotTriggeredIndexingMethodInterceptor(this.avmSnapShotTriggeredIndexingMethodInterceptor);
        tracker.setTransactionService((TransactionServiceImpl)this.transactionService);
        tracker.setFtsIndexer(this.ftsIndexer);
        tracker.setIndexer(this.indexer);
        tracker.setNodeDAO(this.nodeDAO);
        tracker.setNodeService(this.nodeService);
        tracker.setSearcher(this.searchService);
        tracker.setThreadPoolExecutor(this.threadPoolExecutor);
        tracker.reindex();
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("one"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("one"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("two"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("two"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("three"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("three"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.hasIndexBeenCreated("four"));
        AVMRemoteSnapshotTrackerTest.assertTrue((boolean)this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexUpToDate("four"));
    }
}

