/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.processor;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptProcessor;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptServiceImpl
implements ScriptService {
    private static final Log logger = LogFactory.getLog(ScriptServiceImpl.class);
    private String defaultScriptProcessor;
    private Map<String, ScriptProcessor> scriptProcessors = new HashMap<String, ScriptProcessor>(8);
    private Map<String, String> scriptProcessorNamesByExtension = new HashMap<String, String>(8);
    private NodeService nodeService;

    public void setDefaultScriptProcessor(String defaultScriptProcessor) {
        this.defaultScriptProcessor = defaultScriptProcessor;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void registerScriptProcessor(ScriptProcessor scriptProcessor) {
        this.scriptProcessors.put(scriptProcessor.getName(), scriptProcessor);
        this.scriptProcessorNamesByExtension.put(scriptProcessor.getExtension(), scriptProcessor.getName());
    }

    @Override
    public void resetScriptProcessors() {
        for (ScriptProcessor p : this.scriptProcessors.values()) {
            p.reset();
        }
    }

    @Override
    public Object executeScript(String scriptClasspath, Map<String, Object> model) throws ScriptException {
        if (scriptClasspath == null) {
            throw new IllegalArgumentException("Script ClassPath is mandatory.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script: " + scriptClasspath));
        }
        try {
            ScriptProcessor scriptProcessor = this.getScriptProcessor(scriptClasspath);
            return scriptProcessor.execute(scriptClasspath, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + scriptClasspath + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeScript(String engine, String scriptClasspath, Map<String, Object> model) throws ScriptException {
        if (scriptClasspath == null) {
            throw new IllegalArgumentException("Script ClassPath is mandatory.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script: " + scriptClasspath));
        }
        try {
            ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
            return scriptProcessor.execute(scriptClasspath, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + scriptClasspath + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeScript(NodeRef scriptRef, QName contentProp, Map<String, Object> model) throws ScriptException {
        if (scriptRef == null) {
            throw new IllegalArgumentException("Script NodeRef is mandatory.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script: " + scriptRef.toString()));
        }
        try {
            ScriptProcessor scriptProcessor = this.getScriptProcessor(scriptRef);
            return scriptProcessor.execute(scriptRef, contentProp, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + scriptRef.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeScript(String engine, NodeRef scriptRef, QName contentProp, Map<String, Object> model) throws ScriptException {
        if (scriptRef == null) {
            throw new IllegalArgumentException("Script NodeRef is mandatory.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script: " + scriptRef.toString()));
        }
        try {
            ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
            return scriptProcessor.execute(scriptRef, contentProp, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + scriptRef.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeScript(ScriptLocation location, Map<String, Object> model) throws ScriptException {
        ParameterCheck.mandatory((String)"Location", (Object)location);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script: " + location.toString()));
        }
        try {
            ScriptProcessor scriptProcessor = this.getScriptProcessor(location.toString());
            return scriptProcessor.execute(location, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + location.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeScript(String engine, ScriptLocation location, Map<String, Object> model) throws ScriptException {
        ParameterCheck.mandatory((String)"Location", (Object)location);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script: " + location.toString()));
        }
        try {
            ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
            return scriptProcessor.execute(location, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + location.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object executeScriptString(String script, Map<String, Object> model) throws ScriptException {
        return this.executeScriptString(this.defaultScriptProcessor, script, model);
    }

    @Override
    public Object executeScriptString(String engine, String script, Map<String, Object> model) throws ScriptException {
        if (script == null || script.length() == 0) {
            throw new IllegalArgumentException("Script argument is mandatory.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script:\n" + script));
        }
        try {
            ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
            return scriptProcessor.executeString(script, model);
        }
        catch (ScriptException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute supplied script: " + err.getMessage(), err);
        }
    }

    protected ScriptProcessor lookupScriptProcessor(String name) {
        ScriptProcessor scriptProcessor = this.scriptProcessors.get(name);
        if (scriptProcessor == null) {
            scriptProcessor = this.scriptProcessors.get(this.defaultScriptProcessor);
        }
        return scriptProcessor;
    }

    protected ScriptProcessor getScriptProcessor(NodeRef scriptNode) {
        String scriptName = (String)((Object)this.nodeService.getProperty(scriptNode, ContentModel.PROP_NAME));
        return this.getScriptProcessorImpl(scriptName);
    }

    protected ScriptProcessor getScriptProcessor(String scriptLocation) {
        if (scriptLocation.indexOf("://") != -1) {
            NodeRef nodeRef = new NodeRef(scriptLocation);
            scriptLocation = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        }
        return this.getScriptProcessorImpl(scriptLocation);
    }

    protected ScriptProcessor getScriptProcessorImpl(String scriptFileName) {
        String extension;
        String engine = null;
        if (scriptFileName != null && (extension = this.getFileExtension(scriptFileName)) != null) {
            engine = this.scriptProcessorNamesByExtension.get(extension);
        }
        return this.lookupScriptProcessor(engine);
    }

    private String getFileExtension(String fileName) {
        String extension = null;
        int index = fileName.lastIndexOf(46);
        if (index > -1 && index < fileName.length() - 1) {
            extension = fileName.substring(index + 1);
        }
        return extension;
    }

    @Override
    public Map<String, Object> buildDefaultModel(NodeRef person, NodeRef companyHome, NodeRef userHome, NodeRef script, NodeRef document, NodeRef space) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("companyhome", companyHome);
        model.put("userhome", userHome);
        model.put("person", person);
        if (script != null) {
            model.put("script", script);
        }
        if (document != null) {
            model.put("document", document);
        }
        if (space != null) {
            model.put("space", space);
        }
        return model;
    }
}

