/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.IOException;
import java.io.InputStream;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.service.cmr.remote.AVMRemoteTransport;

public class AVMRemoteInputStream
extends InputStream {
    private AVMRemoteTransport fAVMRemote;
    private ClientTicketHolder fTicketHolder;
    private String fHandle;

    public AVMRemoteInputStream(String handle, AVMRemoteTransport remote, ClientTicketHolder ticketHolder) {
        this.fHandle = handle;
        this.fAVMRemote = remote;
        this.fTicketHolder = ticketHolder;
    }

    public int read() throws IOException {
        try {
            byte[] buff = this.fAVMRemote.readInput(this.fTicketHolder.getTicket(), this.fHandle, 1);
            if (buff.length == 0) {
                return -1;
            }
            return buff[0] & 0xFF;
        }
        catch (Exception e) {
            throw new IOException("Remote I/O Error.");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            byte[] buff = this.fAVMRemote.readInput(this.fTicketHolder.getTicket(), this.fHandle, len);
            if (buff.length == 0) {
                return -1;
            }
            System.arraycopy(buff, 0, b, off, buff.length);
            return buff.length;
        }
        catch (Exception e) {
            throw new IOException("Remote I/O Error.");
        }
    }

    public void close() throws IOException {
        try {
            this.fAVMRemote.closeInputHandle(this.fTicketHolder.getTicket(), this.fHandle);
        }
        catch (Exception e) {
            throw new IOException("Remote Error closing input stream.");
        }
    }
}

