/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class RenditionNodeManager {
    private final NodeRef sourceNode;
    private final NodeRef oldRendition;
    private final RenditionDefinition renditionDefinition;
    private final RenditionLocation location;
    private final NodeService nodeService;

    public RenditionNodeManager(NodeRef sourceNode, NodeRef oldRendition, RenditionLocation location, RenditionDefinition renditionDefinition, NodeService nodeService) {
        this.sourceNode = sourceNode;
        this.oldRendition = oldRendition;
        this.location = location;
        this.renditionDefinition = renditionDefinition;
        this.nodeService = nodeService;
    }

    public ChildAssociationRef findOrCreateRenditionNode() {
        QName renditionName = this.renditionDefinition.getRenditionName();
        if (this.oldRendition == null) {
            return this.getSpecifiedRenditionOrCreateNewRendition(renditionName);
        }
        if (this.renditionLocationMatches()) {
            return this.nodeService.getPrimaryParent(this.oldRendition);
        }
        if (this.orphanExistingRendition()) {
            this.orphanRendition((QNamePattern)renditionName);
            return this.getSpecifiedRenditionOrCreateNewRendition(renditionName);
        }
        return this.moveRendition(renditionName);
    }

    private ChildAssociationRef moveRendition(QName associationName) {
        NodeRef parent = this.location.getParentRef();
        QName assocType = this.sourceNode.equals((Object)parent) ? RenditionModel.ASSOC_RENDITION : ContentModel.ASSOC_CONTAINS;
        return this.nodeService.moveNode(this.oldRendition, parent, assocType, associationName);
    }

    private void orphanRendition(QNamePattern renditionName) {
        ChildAssociationRef parentAssoc;
        List parents = this.nodeService.getParentAssocs(this.oldRendition, (QNamePattern)RenditionModel.ASSOC_RENDITION, renditionName);
        if (parents.size() == 1 && (parentAssoc = (ChildAssociationRef)parents.get(0)).getParentRef().equals((Object)this.sourceNode)) {
            this.nodeService.removeAspect(this.oldRendition, RenditionModel.ASPECT_HIDDEN_RENDITION);
            this.nodeService.removeAspect(this.oldRendition, RenditionModel.ASPECT_VISIBLE_RENDITION);
            this.nodeService.removeChildAssociation(parentAssoc);
            return;
        }
        String msg = "Node: " + this.oldRendition + " is not a rendition of type: " + renditionName + " for source node: " + this.sourceNode;
        throw new RenditionServiceException(msg);
    }

    private boolean orphanExistingRendition() {
        if (this.location.getChildRef() != null) {
            return true;
        }
        return AbstractRenderingEngine.getParamWithDefault("orphan-existing-rendition", Boolean.FALSE, this.renditionDefinition);
    }

    private boolean renditionLocationMatches() {
        NodeRef destination = this.location.getChildRef();
        if (destination != null) {
            return destination.equals((Object)this.oldRendition);
        }
        ChildAssociationRef oldParentAssoc = this.nodeService.getPrimaryParent(this.oldRendition);
        NodeRef oldParent = oldParentAssoc.getParentRef();
        if (oldParent.equals((Object)this.location.getParentRef())) {
            String childName = this.location.getChildName();
            if (childName == null) {
                return true;
            }
            Serializable oldName = this.nodeService.getProperty(this.oldRendition, ContentModel.PROP_NAME);
            return childName.equals(oldName);
        }
        return false;
    }

    private ChildAssociationRef getSpecifiedRenditionOrCreateNewRendition(QName renditionName) {
        NodeRef destination = this.location.getChildRef();
        if (destination != null) {
            return this.nodeService.getPrimaryParent(destination);
        }
        return this.createNewRendition(renditionName);
    }

    private ChildAssociationRef createNewRendition(QName renditionName) {
        NodeRef parentRef = this.location.getParentRef();
        boolean parentIsSource = parentRef.equals((Object)this.sourceNode);
        QName renditionType = RenditionModel.ASSOC_RENDITION;
        QName assocTypeQName = parentIsSource ? renditionType : ContentModel.ASSOC_CONTAINS;
        QName nodeTypeQName = ContentModel.TYPE_CONTENT;
        ChildAssociationRef primaryAssoc = this.nodeService.createNode(parentRef, assocTypeQName, renditionName, nodeTypeQName);
        if (!parentIsSource) {
            NodeRef rendition = primaryAssoc.getChildRef();
            this.nodeService.addChild(this.sourceNode, rendition, renditionType, renditionName);
        }
        return primaryAssoc;
    }
}

