/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.StandardRenditionLocationResolverImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;

public class StandardRenditionLocationResolverTest
extends BaseAlfrescoSpringTest {
    private ServiceRegistry serviceRegistry;
    private NodeRef companyHome;
    private StandardRenditionLocationResolverImpl locationResolver;
    private RenditionService renditionService;
    private SearchService searchService;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.searchService = this.serviceRegistry.getSearchService();
        this.renditionService = (RenditionService)this.getApplicationContext().getBean("RenditionService");
        ResultSet rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", "/app:company_home");
        if (rs.length() != 1) {
            StandardRenditionLocationResolverTest.fail((String)"Could not find company home");
        }
        this.companyHome = rs.getNodeRef(0);
        this.locationResolver = new StandardRenditionLocationResolverImpl();
        this.locationResolver.setServiceRegistry(this.serviceRegistry);
    }

    public void testChildAssociationFinder() {
        QName renditionKind = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"test");
        NodeRef sourceNode = this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        NodeRef tempRenditionNode = this.makeNode(sourceNode, ContentModel.TYPE_CONTENT);
        RenditionDefinition renditionDef = this.renditionService.createRenditionDefinition(renditionKind, "brians_test_engine");
        RenditionLocation location = this.locationResolver.getRenditionLocation(sourceNode, renditionDef, tempRenditionNode);
        StandardRenditionLocationResolverTest.assertEquals((Object)sourceNode, (Object)location.getParentRef());
        StandardRenditionLocationResolverTest.assertNull((Object)location.getChildName());
        StandardRenditionLocationResolverTest.assertNull((Object)location.getChildRef());
        NodeRef targetFolder = this.makeNode(this.companyHome, ContentModel.TYPE_FOLDER);
        String companyHomeName = (String)((Object)this.nodeService.getProperty(this.companyHome, ContentModel.PROP_NAME));
        String targetFolderName = (String)((Object)this.nodeService.getProperty(targetFolder, ContentModel.PROP_NAME));
        String template = "/" + companyHomeName + "/" + targetFolderName + "/brian.xml";
        renditionDef.setParameterValue("destination-path-template", (Serializable)((Object)template));
        location = this.locationResolver.getRenditionLocation(sourceNode, renditionDef, tempRenditionNode);
        StandardRenditionLocationResolverTest.assertEquals((Object)targetFolder, (Object)location.getParentRef());
        StandardRenditionLocationResolverTest.assertEquals((String)"brian.xml", (String)location.getChildName());
        StandardRenditionLocationResolverTest.assertNull((Object)location.getChildRef());
        template = targetFolderName + "/test-${sourceContentType}.xml";
        renditionDef.setParameterValue("destination-path-template", (Serializable)((Object)template));
        location = this.locationResolver.getRenditionLocation(sourceNode, renditionDef, tempRenditionNode);
        StandardRenditionLocationResolverTest.assertEquals((Object)targetFolder, (Object)location.getParentRef());
        StandardRenditionLocationResolverTest.assertEquals((String)("test-" + ContentModel.PROP_CONTENT.getLocalName() + ".xml"), (String)location.getChildName());
        StandardRenditionLocationResolverTest.assertNull((Object)location.getChildRef());
        NodeRef destinationNode = this.makeNode(targetFolder, ContentModel.TYPE_CONTENT);
        String destinationName = (String)((Object)this.nodeService.getProperty(destinationNode, ContentModel.PROP_NAME));
        template = targetFolderName + "/" + destinationName;
        renditionDef.setParameterValue("destination-path-template", (Serializable)((Object)template));
        location = this.locationResolver.getRenditionLocation(sourceNode, renditionDef, tempRenditionNode);
        StandardRenditionLocationResolverTest.assertEquals((Object)targetFolder, (Object)location.getParentRef());
        StandardRenditionLocationResolverTest.assertEquals((String)destinationName, (String)location.getChildName());
        StandardRenditionLocationResolverTest.assertEquals((Object)destinationNode, (Object)location.getChildRef());
        template = "/" + targetFolderName + "/brian.xml";
        renditionDef.setParameterValue("destination-path-template", (Serializable)((Object)template));
        renditionDef.setParameterValue("rendition-destination-node", (Serializable)destinationNode);
        location = this.locationResolver.getRenditionLocation(sourceNode, renditionDef, tempRenditionNode);
        StandardRenditionLocationResolverTest.assertEquals((Object)targetFolder, (Object)location.getParentRef());
        StandardRenditionLocationResolverTest.assertEquals((String)destinationName, (String)location.getChildName());
        StandardRenditionLocationResolverTest.assertEquals((Object)destinationNode, (Object)location.getChildRef());
    }

    public void testCreatesFoldersForTemplatedLocation() throws Exception {
        QName fooName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFooFolder");
        QName barName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testBarFolder");
        String fooPath = "/testFooFolder";
        String barPath = fooPath + "/testBarFolder";
        List childAssocs = this.nodeService.getChildAssocs(this.companyHome, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)fooName);
        StandardRenditionLocationResolverTest.assertTrue((String)("Folder " + fooPath + " should not exist!"), (boolean)childAssocs.isEmpty());
        QName renditionKind = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"test");
        NodeRef sourceFolder = this.makeNode(this.companyHome, ContentModel.TYPE_FOLDER);
        NodeRef sourceNode = this.makeNode(sourceFolder, ContentModel.TYPE_CONTENT);
        NodeRef tempRenditionNode = this.makeNode(this.companyHome, ContentModel.TYPE_CONTENT);
        RenditionDefinition renditionDef = this.renditionService.createRenditionDefinition(renditionKind, "nicks_test_engine");
        String pathTemplate = barPath + "${cwd}nick.xml";
        renditionDef.setParameterValue("destination-path-template", (Serializable)((Object)pathTemplate));
        RenditionLocation location = this.locationResolver.getRenditionLocation(sourceNode, renditionDef, tempRenditionNode);
        NodeRef fooNode = this.checkFolder(fooName, this.companyHome, "Foo");
        NodeRef barNode = this.checkFolder(barName, fooNode, "Bar");
        NodeRef finalFolderNode = this.checkFolder(this.nodeService.getPrimaryParent(sourceFolder).getQName(), barNode, "Final Folder");
        StandardRenditionLocationResolverTest.assertEquals((String)"Final folder is not the rendition parent!", (Object)finalFolderNode, (Object)location.getParentRef());
        StandardRenditionLocationResolverTest.assertEquals((String)"nick.xml", (String)location.getChildName());
    }

    private NodeRef checkFolder(QName folderName, NodeRef parentName, String folderMessageName) {
        List folderAssocs = this.nodeService.getChildAssocs(parentName, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)folderName);
        StandardRenditionLocationResolverTest.assertEquals((String)("Folder " + folderMessageName + " should exist!"), (int)1, (int)folderAssocs.size());
        NodeRef folderNode = ((ChildAssociationRef)folderAssocs.get(0)).getChildRef();
        StandardRenditionLocationResolverTest.assertEquals((String)(folderMessageName + " node is wrong type!"), (Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folderNode));
        StandardRenditionLocationResolverTest.assertEquals((String)(folderMessageName + " node has wrong name!"), (Object)folderName.getLocalName(), (Object)this.nodeService.getProperty(folderNode, ContentModel.PROP_NAME));
        return folderNode;
    }

    private NodeRef makeNode(NodeRef parent, QName nodeType) {
        String uuid = GUID.generate();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, uuid);
        ChildAssociationRef assoc = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)uuid), nodeType, props);
        return assoc.getChildRef();
    }
}

