/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLRenderingEngine
extends AbstractRenderingEngine {
    private static Log logger = LogFactory.getLog(HTMLRenderingEngine.class);
    public static final String PARAM_BODY_CONTENTS_ONLY = "bodyContentsOnly";
    public static final String NAME = "htmlRenderingEngine";
    protected static final QName PRIMARY_IMAGE = QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"primaryImage");
    protected static final QName SECONDARY_IMAGE = QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)"secondaryImage");
    private DictionaryService dictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        paramList.add(new ParameterDefinitionImpl(PARAM_BODY_CONTENTS_ONLY, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_BODY_CONTENTS_ONLY)));
        return paramList;
    }

    @Override
    protected void render(AbstractRenderingEngine.RenderingContext context) {
        ContentReader contentReader = context.makeContentReader();
        String sourceMimeType = contentReader.getMimetype();
        AutoDetectParser p = new AutoDetectParser();
        MediaType sourceMediaType = MediaType.parse((String)sourceMimeType);
        if (!p.getParsers().containsKey(sourceMediaType)) {
            throw new RenditionServiceException("Source mime type of " + sourceMimeType + " is not supported by Tika for HTML conversions");
        }
        this.generateHTML((Parser)p, context);
    }

    private String getImagesDirectoryName(AbstractRenderingEngine.RenderingContext context) {
        String folderName = this.nodeService.getProperty(context.getSourceNode(), ContentModel.PROP_NAME).toString();
        if (folderName.lastIndexOf(46) > -1) {
            folderName = folderName.substring(0, folderName.lastIndexOf(46));
        }
        folderName = folderName + "_files";
        return folderName;
    }

    private NodeRef createImagesDirectory(AbstractRenderingEngine.RenderingContext context) {
        String folderName;
        RenditionLocation location = this.resolveRenditionLocation(context.getSourceNode(), context.getDefinition(), context.getDestinationNode());
        NodeRef parent = location.getParentRef();
        NodeRef imgFolder = this.nodeService.getChildByName(parent, ContentModel.ASSOC_CONTAINS, folderName = this.getImagesDirectoryName(context));
        if (imgFolder != null) {
            return imgFolder;
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, folderName);
        imgFolder = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)folderName), ContentModel.TYPE_FOLDER, properties).getChildRef();
        return imgFolder;
    }

    private NodeRef createEmbeddedImage(NodeRef imgFolder, boolean primary, String filename, String contentType, InputStream imageSource, AbstractRenderingEngine.RenderingContext context) {
        NodeRef img = this.nodeService.getChildByName(imgFolder, ContentModel.ASSOC_CONTAINS, filename);
        if (img == null) {
            HashMap<QName, String> properties = new HashMap<QName, String>();
            properties.put(ContentModel.PROP_NAME, filename);
            img = this.nodeService.createNode(imgFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)filename), ContentModel.TYPE_CONTENT, properties).getChildRef();
        }
        QName assocType = SECONDARY_IMAGE;
        if (primary) {
            assocType = PRIMARY_IMAGE;
        }
        if (this.dictionaryService.getAssociation(assocType) != null) {
            this.nodeService.createAssociation(context.getDestinationNode(), img, assocType);
        }
        ContentWriter writer = this.contentService.getWriter(img, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(contentType);
        writer.putContent(imageSource);
        return img;
    }

    private ContentHandler buildContentHandler(Writer output, AbstractRenderingEngine.RenderingContext context) {
        TransformerHandler handler;
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RenditionServiceException("SAX Processing isn't available - " + e);
        }
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(output));
        handler.getTransformer().setOutputProperty("method", "xml");
        TikaImageRewritingContentHandler contentHandler = new TikaImageRewritingContentHandler(handler, this.getImagesDirectoryName(context));
        boolean bodyOnly = context.getParamWithDefault(PARAM_BODY_CONTENTS_ONLY, false);
        if (bodyOnly) {
            contentHandler = new BodyContentHandler((ContentHandler)((Object)contentHandler));
        }
        return contentHandler;
    }

    private void generateHTML(Parser p, AbstractRenderingEngine.RenderingContext context) {
        ContentReader contentReader = context.makeContentReader();
        StringWriter sw = new StringWriter();
        ContentHandler handler = this.buildContentHandler(sw, context);
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", contentReader.getMimetype());
        metadata.set("resourceName", this.nodeService.getProperty(context.getSourceNode(), ContentModel.PROP_NAME).toString());
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, (Object)new TikaImageExtractingParser(context));
        try {
            p.parse(contentReader.getContentInputStream(), handler, metadata, parseContext);
        }
        catch (Exception e) {
            throw new RenditionServiceException("Tika HTML Conversion Failed", e);
        }
        String html = sw.toString();
        boolean bodyOnly = context.getParamWithDefault(PARAM_BODY_CONTENTS_ONLY, false);
        if (bodyOnly) {
            html = html.replaceAll("<p xmlns=\"http://www.w3.org/1999/xhtml\"", "<p");
            html = html.replaceAll("<h(\\d) xmlns=\"http://www.w3.org/1999/xhtml\"", "<h\\1");
            html = html.replaceAll("<div xmlns=\"http://www.w3.org/1999/xhtml\"", "<div");
            html = html.replaceAll("<table xmlns=\"http://www.w3.org/1999/xhtml\"", "<table");
            html = html.replaceAll("&#13;", "");
        }
        ContentWriter contentWriter = context.makeContentWriter();
        contentWriter.setMimetype("text/html");
        contentWriter.putContent(html);
    }

    private class TikaImageRewritingContentHandler
    extends ContentHandlerDecorator {
        private String imageFolder;

        private TikaImageRewritingContentHandler(ContentHandler handler, String imageFolder) {
            super(handler);
            this.imageFolder = imageFolder;
        }

        public void startElement(String uri, String localName, String qName, Attributes origAttrs) throws SAXException {
            if ("img".equals(localName)) {
                AttributesImpl attrs = origAttrs instanceof AttributesImpl ? (AttributesImpl)origAttrs : new AttributesImpl(origAttrs);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String src;
                    if (!"src".equals(attrs.getLocalName(i)) || !(src = attrs.getValue(i)).startsWith("embedded:")) continue;
                    src = this.imageFolder + "/" + src.substring(src.indexOf(58) + 1);
                    attrs.setValue(i, src);
                }
                super.startElement(uri, localName, qName, (Attributes)attrs);
            } else {
                super.startElement(uri, localName, qName, origAttrs);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TikaImageExtractingParser
    implements Parser {
        private Set<MediaType> types;
        private AbstractRenderingEngine.RenderingContext renderingContext;
        private NodeRef imgFolder = null;
        private int count = 0;

        private TikaImageExtractingParser(AbstractRenderingEngine.RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            this.types = new HashSet<MediaType>();
            this.types.add(MediaType.image((String)"bmp"));
            this.types.add(MediaType.image((String)"gif"));
            this.types.add(MediaType.image((String)"jpg"));
            this.types.add(MediaType.image((String)"jpeg"));
            this.types.add(MediaType.image((String)"png"));
            this.types.add(MediaType.image((String)"tiff"));
        }

        public Set<MediaType> getSupportedTypes(ParseContext context) {
            return this.types;
        }

        public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            String filename = metadata.get("resourceName");
            String type = metadata.get("Content-Type");
            boolean accept = false;
            if (type != null) {
                for (MediaType mt : this.types) {
                    if (!mt.toString().equals(type)) continue;
                    accept = true;
                }
            }
            if (filename != null) {
                for (MediaType mt : this.types) {
                    String ext = "." + mt.getSubtype();
                    if (!filename.endsWith(ext)) continue;
                    accept = true;
                }
            }
            if (!accept) {
                return;
            }
            this.handleImage(stream, filename, type);
        }

        public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
            this.parse(stream, handler, metadata, new ParseContext());
        }

        private void handleImage(InputStream stream, String filename, String type) {
            ++this.count;
            if (this.imgFolder == null) {
                this.imgFolder = HTMLRenderingEngine.this.createImagesDirectory(this.renderingContext);
            }
            if (filename == null) {
                filename = "image-" + this.count + ".";
                filename = filename + type.substring(type.indexOf(47) + 1);
            }
            HTMLRenderingEngine.this.createEmbeddedImage(this.imgFolder, this.count == 1, filename, type, stream, this.renderingContext);
        }
    }
}

