/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.util.Collection;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.rendition.executer.AbstractTransformationRenderingEngine;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReformatRenderingEngine
extends AbstractTransformationRenderingEngine {
    private static Log logger = LogFactory.getLog(ReformatRenderingEngine.class);
    public static final String PARAM_FLASH_VERSION = "flashVersion";
    public static final String NAME = "reformat";

    @Override
    protected String getTargetMimeType(AbstractRenderingEngine.RenderingContext context) {
        String targetMimeType = context.getCheckedParam("mime-type", String.class);
        if (targetMimeType == null) {
            String msg = "The parameter: mime-type must be explicitly set for this rendering engine!";
            logger.warn((Object)msg);
            throw new RenditionServiceException(msg);
        }
        return targetMimeType;
    }

    @Override
    protected TransformationOptions getTransformOptions(AbstractRenderingEngine.RenderingContext context) {
        NodeRef sourceNode = context.getSourceNode();
        NodeRef destinationNode = context.getDestinationNode();
        return new TransformationOptions(sourceNode, null, destinationNode, null);
    }

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        paramList.add(new ParameterDefinitionImpl("mime-type", DataTypeDefinition.TEXT, true, this.getParamDisplayLabel("mime-type")));
        paramList.add(new ParameterDefinitionImpl(PARAM_FLASH_VERSION, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_FLASH_VERSION)));
        return paramList;
    }
}

