/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.script;

import org.alfresco.repo.jscript.ScriptAction;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Scriptable;

public final class ScriptRenditionDefinition
extends ScriptAction {
    private static final long serialVersionUID = 8132935577891455490L;

    public ScriptRenditionDefinition(ServiceRegistry serviceRegistry, Scriptable scope, RenderingEngineDefinition engineDefinition, RenditionDefinition renditionDefinition) {
        super(serviceRegistry, renditionDefinition, engineDefinition);
    }

    public String getRenditionName() {
        QName qname = this.getRenditionDefinition().getRenditionName();
        return qname.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    public String getRenderingEngineName() {
        return this.getRenderingEngineDefinition().getName();
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getClass().getSimpleName()).append("[").append(this.getRenditionName()).append("]");
        return msg.toString();
    }

    RenditionDefinition getRenditionDefinition() {
        this.performParamConversionForRepo();
        return (RenditionDefinition)this.action;
    }

    RenderingEngineDefinition getRenderingEngineDefinition() {
        return (RenderingEngineDefinition)this.actionDef;
    }

    protected void executeImpl(ScriptNode node) {
        RenditionDefinition renditionDefinition = this.getRenditionDefinition();
        this.services.getRenditionService().render(node.getNodeRef(), renditionDefinition);
    }
}

