/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionCancelledException;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.replication.ReplicationDefinitionImpl;
import org.alfresco.repo.replication.ReplicationDefinitionPersisterImpl;
import org.alfresco.repo.replication.ReplicationParams;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.ChildAssociatedNodeFinder;
import org.alfresco.repo.transfer.ContentClassFilter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.NodeCrawler;
import org.alfresco.service.cmr.transfer.NodeCrawlerFactory;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEndEvent;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferEventBegin;
import org.alfresco.service.cmr.transfer.TransferEventCancelled;
import org.alfresco.service.cmr.transfer.TransferEventEnterState;
import org.alfresco.service.cmr.transfer.TransferEventError;
import org.alfresco.service.cmr.transfer.TransferFailureException;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationActionExecutor
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(ReplicationActionExecutor.class);
    private JobLockService jobLockService;
    private TransferService2 transferService;
    private NodeCrawlerFactory nodeCrawlerFactory;
    private ActionTrackingService actionTrackingService;
    private TransactionService transactionService;
    private ReplicationDefinitionPersisterImpl replicationDefinitionPersister;
    private ReplicationParams replicationParams;
    private long replicationActionLockDuration = 1800000L;

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransferService(TransferService2 transferService) {
        this.transferService = transferService;
    }

    public void setNodeCrawlerFactory(NodeCrawlerFactory nodeCrawlerFactory) {
        this.nodeCrawlerFactory = nodeCrawlerFactory;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setReplicationDefinitionPersister(ReplicationDefinitionPersisterImpl replicationDefinitionPersister) {
        this.replicationDefinitionPersister = replicationDefinitionPersister;
    }

    public void setReplicationParams(ReplicationParams replicationParams) {
        this.replicationParams = replicationParams;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }

    protected Set<NodeRef> expandPayload(ReplicationDefinition replicationDef) {
        HashSet<NodeRef> toTransfer = new HashSet<NodeRef>(89);
        NodeCrawler crawler = this.nodeCrawlerFactory.getNodeCrawler();
        crawler.setNodeFinders(new ChildAssociatedNodeFinder(ContentModel.ASSOC_CONTAINS));
        crawler.setNodeFilters(new ContentClassFilter(ContentModel.TYPE_FOLDER, ContentModel.TYPE_CONTENT));
        for (NodeRef payload : replicationDef.getPayload()) {
            Set<NodeRef> crawledNodes = crawler.crawl(payload);
            toTransfer.addAll(crawledNodes);
        }
        return toTransfer;
    }

    protected TransferDefinition buildTransferDefinition(ReplicationDefinition replicationDef, Set<NodeRef> toTransfer) {
        TransferDefinition transferDefinition = new TransferDefinition();
        transferDefinition.setNodes(toTransfer);
        transferDefinition.setSync(true);
        transferDefinition.setReadOnly(this.replicationParams.getTransferReadOnly());
        transferDefinition.setExcludedAspects(RuleModel.ASPECT_RULES);
        return transferDefinition;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Set<NodeRef> toTransfer;
        ReplicationDefinition replicationDef;
        if (!(action instanceof ReplicationDefinition) && action.getActionDefinitionName().equals("replicationActionExecutor")) {
            action = new ReplicationDefinitionImpl(action);
        }
        if ((replicationDef = (ReplicationDefinition)action).getTargetName() == null || replicationDef.getTargetName().equals("")) {
            throw new ReplicationServiceException("The target is required but wasn't given");
        }
        if (replicationDef.getPayload().size() == 0) {
            throw new ReplicationServiceException("No payloads were specified");
        }
        if (!replicationDef.isEnabled()) {
            throw new ReplicationServiceException("Unable to execute a disabled replication definition");
        }
        ReplicationDefinitionLockExtender lock = new ReplicationDefinitionLockExtender(replicationDef);
        try {
            toTransfer = this.expandPayload(replicationDef);
        }
        catch (Exception e) {
            lock.close();
            throw new ReplicationServiceException("Error processing payload list - " + e.getMessage(), e);
        }
        TransferEndEvent endEvent = null;
        try {
            try {
                TransferDefinition transferDefinition = this.buildTransferDefinition(replicationDef, toTransfer);
                endEvent = this.transferService.transfer(replicationDef.getTargetName(), transferDefinition, lock);
                if (endEvent instanceof TransferEventCancelled) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Cancelling replication job");
                    }
                    throw new ActionCancelledException(replicationDef);
                }
                replicationDef.setLocalTransferReport(endEvent.getSourceReport());
                replicationDef.setRemoteTransferReport(endEvent.getDestinationReport());
            }
            catch (Exception e) {
                if (e instanceof ActionCancelledException) {
                    this.writeDefinitionReports(replicationDef, endEvent.getSourceReport(), endEvent.getDestinationReport());
                    throw (ActionCancelledException)((Object)e);
                }
                if (e instanceof TransferFailureException) {
                    TransferEventError failureEndEvent = ((TransferFailureException)((Object)e)).getErrorEvent();
                    this.writeDefinitionReports(replicationDef, failureEndEvent.getSourceReport(), failureEndEvent.getDestinationReport());
                    Throwable cause = e.getCause() == null ? e : e.getCause();
                    throw new ReplicationServiceException("Error executing transfer - " + cause.getMessage(), cause);
                }
                this.writeDefinitionReports(replicationDef, null, null);
                throw new ReplicationServiceException("Error executing transfer - " + e.getMessage(), e);
            }
            Object var11_10 = null;
            lock.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.close();
            throw throwable;
        }
    }

    private void writeDefinitionReports(final ReplicationDefinition replicationDef, NodeRef sourceReport, NodeRef destinationReport) {
        replicationDef.setLocalTransferReport(sourceReport);
        replicationDef.setRemoteTransferReport(destinationReport);
        if (replicationDef.getNodeRef() != null) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Exception - writing replication def reports");
                    }
                    ReplicationActionExecutor.this.replicationDefinitionPersister.saveReplicationDefinition(replicationDef);
                    return null;
                }
            }, false, true);
        }
    }

    protected class ReplicationDefinitionLockExtender
    implements TransferCallback {
        private ReplicationDefinition replicationDef;
        private String transferId;
        private String lockToken;

        protected ReplicationDefinitionLockExtender(ReplicationDefinition replicationDef) {
            this.replicationDef = replicationDef;
            this.acquireLock();
        }

        public void processEvent(TransferEvent event) {
            this.refreshLock();
            if (event instanceof TransferEventEnterState) {
                return;
            }
            if (event instanceof TransferEventBegin) {
                this.transferId = ((TransferEventBegin)event).getTransferId();
            }
            if (ReplicationActionExecutor.this.actionTrackingService.isCancellationRequested(this.replicationDef)) {
                if (this.transferId != null) {
                    ReplicationActionExecutor.this.transferService.cancelAsync(this.transferId);
                    logger.debug((Object)("Replication cancel was requested for " + this.replicationDef.getReplicationQName()));
                } else {
                    logger.warn((Object)"Unable to cancel replication as requested, as transfer has yet to reach a cancellable state");
                }
            }
        }

        public void close() {
            this.releaseLock();
        }

        private void acquireLock() {
            long retryTime = 30000L;
            int retries = (int)(ReplicationActionExecutor.this.replicationActionLockDuration * 3L / retryTime);
            try {
                this.lockToken = ReplicationActionExecutor.this.jobLockService.getLock(this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration, 5000L, 6);
            }
            catch (LockAcquisitionException e) {
                logger.debug((Object)("Unable to get the replication job lock on " + this.replicationDef.getReplicationQName() + ", retrying every " + (int)(retryTime / 1000L) + " seconds"));
                this.lockToken = ReplicationActionExecutor.this.jobLockService.getLock(this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration, retryTime, retries);
            }
        }

        private void refreshLock() {
            ReplicationActionExecutor.this.jobLockService.refreshLock(this.lockToken, this.replicationDef.getReplicationQName(), ReplicationActionExecutor.this.replicationActionLockDuration);
        }

        private void releaseLock() {
            ReplicationActionExecutor.this.jobLockService.releaseLock(this.lockToken, this.replicationDef.getReplicationQName());
        }
    }
}

