/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.List;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.namespace.QName;

public class SingleNodeRefPolicyRuleTrigger
extends RuleTriggerAbstractBase {
    private static final String ERR_POLICY_NAME_NOT_SET = "Unable to register rule trigger since policy name has not been set.";
    private String policyNamespace = "http://www.alfresco.org";
    private String policyName;
    private boolean triggerParentRules = true;

    public void setPolicyNamespace(String policyNamespace) {
        this.policyNamespace = policyNamespace;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    public void registerRuleTrigger() {
        if (this.policyName == null) {
            throw new RuleServiceException(ERR_POLICY_NAME_NOT_SET);
        }
        this.policyComponent.bindClassBehaviour(QName.createQName((String)this.policyNamespace, (String)this.policyName), this, (Behaviour)new JavaBehaviour(this, "policyBehaviour"));
    }

    public void policyBehaviour(NodeRef nodeRef) {
        if (this.triggerParentRules) {
            List parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
            for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
            }
        } else {
            this.triggerRules(nodeRef, nodeRef);
        }
    }
}

