/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

import com.werken.saxpath.XPathReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.FilterIndexReaderByStringId;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneXPathHandler;
import org.alfresco.repo.search.impl.lucene.analysis.AlfrescoStandardAnalyser;
import org.alfresco.repo.search.impl.lucene.index.IndexEntry;
import org.alfresco.repo.search.impl.lucene.index.IndexEvent;
import org.alfresco.repo.search.impl.lucene.index.IndexMonitor;
import org.alfresco.repo.search.impl.lucene.index.IndexType;
import org.alfresco.repo.search.impl.lucene.index.ReferenceCounting;
import org.alfresco.repo.search.impl.lucene.index.ReferenceCountingReadOnlyIndexReaderFactory;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TraceableThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;
import org.safehaus.uuid.UUID;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfo
implements IndexMonitor {
    public static final String MAIN_READER = "MainReader";
    private static Timer timer = new Timer(true);
    private static Log s_logger = LogFactory.getLog(IndexInfo.class);
    private static boolean useNIOMemoryMapping = true;
    private static String INDEX_INFO = "IndexInfo";
    private static String INDEX_INFO_BACKUP = "IndexInfoBackup";
    private static String INDEX_INFO_DELETIONS = "IndexInfoDeletions";
    private static String OLD_INDEX = "index";
    private boolean indexIsShared = false;
    private File indexDirectory;
    private String relativePath;
    private RandomAccessFile indexInfoRAF;
    private FileChannel indexInfoChannel;
    private RandomAccessFile indexInfoBackupRAF;
    private FileChannel indexInfoBackupChannel;
    private long version = -1L;
    private LinkedHashMap<String, IndexEntry> indexEntries = new LinkedHashMap();
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private HashMap<String, IndexReader> referenceCountingReadOnlyIndexReaders = new HashMap();
    private IndexReader mainIndexReader;
    private Map<String, IndexWriter> indexWriters = new ConcurrentHashMap<String, IndexWriter>(51);
    private Map<String, IndexReader> indexReaders = new ConcurrentHashMap<String, IndexReader>(51);
    private EnumMap<TransactionStatus, Transition> transitions = new EnumMap(TransactionStatus.class);
    private ConcurrentLinkedQueue<String> deleteQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IndexReader> deletableReaders = new ConcurrentLinkedQueue();
    private Cleaner cleaner = new Cleaner();
    private Merger merger = new Merger();
    private Directory emptyIndex = new RAMDirectory();
    private static HashMap<File, IndexInfo> indexInfos = new HashMap();
    private int maxDocsForInMemoryMerge = 10000;
    private int maxDocsForInMemoryIndex = 10000;
    private double maxRamInMbForInMemoryMerge = 16.0;
    private double maxRamInMbForInMemoryIndex = 16.0;
    private int writerMaxBufferedDocs = -1;
    private double writerRamBufferSizeMb = 16.0;
    private int writerMergeFactor = 5;
    private int writerMaxMergeDocs = 1000000;
    private boolean writerUseCompoundFile = true;
    private int mergerMaxBufferedDocs = -1;
    private double mergerRamBufferSizeMb = 16.0;
    private int mergerMergeFactor = 5;
    private int mergerMergeBlockingFactor = 1;
    private int mergerMaxMergeDocs = 1000000;
    private boolean mergerUseCompoundFile = true;
    private int mergerTargetOverlays = 5;
    private int mergerTargetOverlaysBlockingFactor = 1;
    private long writeLockTimeout = IndexWriter.WRITE_LOCK_TIMEOUT;
    private int maxFieldLength = 10000;
    private int termIndexInterval = 128;
    private ThreadPoolExecutor threadPoolExecutor;
    private LuceneConfig config;
    private List<ApplicationListener> applicationListeners = new LinkedList<ApplicationListener>();
    private static final int CHANNEL_OPEN_RETRIES = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(final String deltaId) {
        this.getWriteLock();
        try {
            this.doWithFileLock(new LockWork<Object>(){

                @Override
                public Object doWork() throws Exception {
                    IndexInfo.this.setStatusFromFile();
                    if (!IndexInfo.this.indexIsShared) {
                        HashSet<String> deletable = new HashSet<String>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getName().equals(deltaId)) continue;
                            entry.setStatus(TransactionStatus.DELETABLE);
                            deletable.add(entry.getName());
                        }
                        for (String id : deletable) {
                            IndexInfo.this.indexEntries.remove(id);
                        }
                        IndexInfo.this.clearOldReaders();
                        IndexInfo.this.cleaner.schedule();
                        IndexInfo.this.merger.schedule();
                        IndexInfo.this.writeStatus();
                        if (IndexInfo.this.mainIndexReader != null) {
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)"... invalidating main index reader");
                            }
                            ((ReferenceCounting)IndexInfo.this.mainIndexReader).setInvalidForReuse();
                            IndexInfo.this.mainIndexReader = null;
                        }
                    }
                    return null;
                }

                @Override
                public boolean canRetry() {
                    return false;
                }
            });
        }
        finally {
            this.releaseWriteLock();
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Index " + this.indexDirectory + " deleted"));
        }
    }

    public static synchronized IndexInfo getIndexInfo(File file, LuceneConfig config) throws IndexerException {
        try {
            File canonicalFile = file.getCanonicalFile();
            IndexInfo indexInfo = indexInfos.get(canonicalFile);
            if (indexInfo == null) {
                indexInfo = new IndexInfo(canonicalFile, config);
                indexInfos.put(canonicalFile, indexInfo);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Made " + indexInfo + " for " + file.getAbsolutePath()));
                }
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Got " + indexInfo + " for " + file.getAbsolutePath()));
            }
            return indexInfo;
        }
        catch (IOException e) {
            throw new IndexerException("Failed to transform a file into is canonical form", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexInfo(File indexDirectory, LuceneConfig config) {
        this.initialiseTransitions();
        this.config = config;
        if (config != null) {
            this.maxFieldLength = config.getIndexerMaxFieldLength();
            this.threadPoolExecutor = config.getThreadPoolExecutor();
            useNIOMemoryMapping = config.getUseNioMemoryMapping();
            this.maxDocsForInMemoryMerge = config.getMaxDocsForInMemoryMerge();
            this.maxRamInMbForInMemoryMerge = config.getMaxRamInMbForInMemoryMerge();
            this.maxDocsForInMemoryIndex = config.getMaxDocsForInMemoryIndex();
            this.maxRamInMbForInMemoryIndex = config.getMaxRamInMbForInMemoryIndex();
            this.writerMaxBufferedDocs = config.getWriterMaxBufferedDocs();
            this.writerRamBufferSizeMb = config.getWriterRamBufferSizeMb();
            this.writerMergeFactor = config.getWriterMergeFactor();
            this.writerMaxMergeDocs = config.getWriterMaxMergeDocs();
            this.mergerMaxBufferedDocs = config.getMergerMaxBufferedDocs();
            this.mergerRamBufferSizeMb = config.getMergerRamBufferSizeMb();
            this.mergerMergeFactor = config.getMergerMergeFactor();
            this.mergerMergeBlockingFactor = config.getMergerMergeBlockingFactor();
            this.mergerMaxMergeDocs = config.getMergerMaxMergeDocs();
            this.termIndexInterval = config.getTermIndexInterval();
            this.mergerTargetOverlays = config.getMergerTargetOverlayCount();
            this.mergerTargetOverlaysBlockingFactor = config.getMergerTargetOverlaysBlockingFactor();
            try {
                String indexRoot = new File(config.getIndexRootLocation()).getCanonicalPath();
                this.relativePath = indexDirectory.getCanonicalPath().substring(indexRoot.length() + 1);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to determine index relative path", (Throwable)e);
            }
        }
        TraceableThreadFactory threadFactory = new TraceableThreadFactory();
        threadFactory.setThreadDaemon(true);
        threadFactory.setThreadPriority(5);
        this.threadPoolExecutor = new ThreadPoolExecutor(10, 10, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        try {
            this.relativePath = indexDirectory.getCanonicalPath();
            int sepIndex = this.relativePath.indexOf(File.separator);
            if (sepIndex != -1) {
                this.relativePath = this.relativePath.length() > sepIndex + 1 ? this.relativePath.substring(sepIndex + 1) : "";
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to determine index relative path", (Throwable)e);
        }
        try {
            IndexWriter writer = new IndexWriter(this.emptyIndex, (Analyzer)new AlfrescoStandardAnalyser(), true, IndexWriter.MaxFieldLength.LIMITED);
            writer.setUseCompoundFile(this.writerUseCompoundFile);
            writer.setMaxBufferedDocs(this.writerMaxBufferedDocs);
            writer.setRAMBufferSizeMB(this.writerRamBufferSizeMb);
            writer.setMergeFactor(this.writerMergeFactor);
            writer.setMaxMergeDocs(this.writerMaxMergeDocs);
            writer.setWriteLockTimeout(this.writeLockTimeout);
            writer.setMaxFieldLength(this.maxFieldLength);
            writer.setTermIndexInterval(this.termIndexInterval);
            writer.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
            writer.setMergePolicy((MergePolicy)new LogDocMergePolicy());
            writer.close();
        }
        catch (IOException e) {
            throw new IndexerException("Failed to create an empty in memory index!");
        }
        this.indexDirectory = indexDirectory;
        if (!this.indexDirectory.exists() && !this.indexDirectory.mkdirs()) {
            throw new AlfrescoRuntimeException("Failed to create index directory");
        }
        if (!this.indexDirectory.isDirectory()) {
            throw new AlfrescoRuntimeException("The index must be held in a directory");
        }
        File indexInfoFile = new File(this.indexDirectory, INDEX_INFO);
        File indexInfoBackupFile = new File(this.indexDirectory, INDEX_INFO_BACKUP);
        if (IndexInfo.createFile(indexInfoFile) && IndexInfo.createFile(indexInfoBackupFile)) {
            this.version = 0L;
        }
        this.indexInfoRAF = IndexInfo.openFile(indexInfoFile);
        this.indexInfoChannel = this.indexInfoRAF.getChannel();
        this.indexInfoBackupRAF = IndexInfo.openFile(indexInfoBackupFile);
        this.indexInfoBackupChannel = this.indexInfoBackupRAF.getChannel();
        if (this.version == 0L) {
            final File oldIndex = new File(this.indexDirectory, OLD_INDEX);
            if (IndexReader.indexExists((File)oldIndex)) {
                this.getWriteLock();
                try {
                    this.doWithFileLock(new LockWork<Object>(){

                        @Override
                        public Object doWork() throws Exception {
                            try {
                                IndexWriter writer = new IndexWriter(oldIndex, (Analyzer)new AlfrescoStandardAnalyser(), false, IndexWriter.MaxFieldLength.LIMITED);
                                writer.setUseCompoundFile(IndexInfo.this.writerUseCompoundFile);
                                writer.setMaxBufferedDocs(IndexInfo.this.writerMaxBufferedDocs);
                                writer.setRAMBufferSizeMB(IndexInfo.this.writerRamBufferSizeMb);
                                writer.setMergeFactor(IndexInfo.this.writerMergeFactor);
                                writer.setMaxMergeDocs(IndexInfo.this.writerMaxMergeDocs);
                                writer.setWriteLockTimeout(IndexInfo.this.writeLockTimeout);
                                writer.setMaxFieldLength(IndexInfo.this.maxFieldLength);
                                writer.setTermIndexInterval(IndexInfo.this.termIndexInterval);
                                writer.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                                writer.setMergePolicy((MergePolicy)new LogDocMergePolicy());
                                writer.optimize();
                                long docs = writer.numDocs();
                                writer.close();
                                IndexEntry entry = new IndexEntry(IndexType.INDEX, OLD_INDEX, "", TransactionStatus.COMMITTED, "", docs, 0L, false);
                                IndexInfo.this.indexEntries.put(OLD_INDEX, entry);
                                IndexInfo.this.writeStatus();
                                IndexInfo.this.registerReferenceCountingIndexReader(entry.getName(), IndexInfo.this.buildReferenceCountingIndexReader(entry.getName(), entry.getDocumentCount()));
                            }
                            catch (IOException e) {
                                throw new IndexerException("Failed to optimise old index");
                            }
                            return null;
                        }

                        @Override
                        public boolean canRetry() {
                            return false;
                        }
                    });
                }
                finally {
                    this.releaseWriteLock();
                }
            }
        } else if (this.version == -1L) {
            this.getWriteLock();
            try {
                this.doWithFileLock(new LockWork<Object>(){

                    @Override
                    public Object doWork() throws Exception {
                        IndexInfo.this.setStatusFromFile();
                        if (!IndexInfo.this.indexIsShared) {
                            HashSet<String> deletable = new HashSet<String>();
                            for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                                switch (entry.getStatus()) {
                                    case ACTIVE: 
                                    case MARKED_ROLLBACK: 
                                    case NO_TRANSACTION: 
                                    case PREPARING: 
                                    case ROLLEDBACK: 
                                    case ROLLINGBACK: 
                                    case MERGE_TARGET: 
                                    case UNKNOWN: 
                                    case PREPARED: 
                                    case DELETABLE: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Deleting index entry " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.DELETABLE);
                                        deletable.add(entry.getName());
                                        break;
                                    }
                                    case COMMITTED_DELETING: 
                                    case MERGE: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Resetting merge to committed " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.COMMITTED);
                                        IndexInfo.this.registerReferenceCountingIndexReader(entry.getName(), IndexInfo.this.buildReferenceCountingIndexReader(entry.getName(), entry.getDocumentCount()));
                                        break;
                                    }
                                    case COMMITTING: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Committing " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.COMMITTED);
                                        IndexInfo.this.registerReferenceCountingIndexReader(entry.getName(), IndexInfo.this.buildReferenceCountingIndexReader(entry.getName(), entry.getDocumentCount()));
                                        IndexInfo.this.mainIndexReader = null;
                                        break;
                                    }
                                    case COMMITTED: {
                                        IndexInfo.this.registerReferenceCountingIndexReader(entry.getName(), IndexInfo.this.buildReferenceCountingIndexReader(entry.getName(), entry.getDocumentCount()));
                                        break;
                                    }
                                }
                            }
                            for (String id : deletable) {
                                IndexInfo.this.indexEntries.remove(id);
                            }
                            IndexInfo.this.clearOldReaders();
                            IndexInfo.this.cleaner.schedule();
                            IndexInfo.this.merger.schedule();
                            IndexInfo.this.writeStatus();
                        }
                        return null;
                    }

                    @Override
                    public boolean canRetry() {
                        return false;
                    }
                });
            }
            finally {
                this.releaseWriteLock();
            }
        }
        this.getWriteLock();
        try {
            DeleteUnknownGuidDirectories work = new DeleteUnknownGuidDirectories();
            this.doWithFileLock(work);
        }
        finally {
            this.releaseWriteLock();
        }
        timer.schedule(new TimerTask(){

            public void run() {
                IndexInfo.this.cleaner.schedule();
            }
        }, 0L, 20000L);
        this.publishDiscoveryEvent();
    }

    public IndexReader getDeltaIndexReader(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexReader reader = this.indexReaders.get(id);
        if (reader == null) {
            this.closeDeltaIndexWriter(id);
            reader = this.buildAndRegisterDeltaReader(id);
            this.indexReaders.put(id, reader);
        }
        return reader;
    }

    private IndexReader buildAndRegisterDeltaReader(String id) throws IOException {
        File location = this.ensureDeltaIsRegistered(id);
        IndexReader reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)this.emptyIndex);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File ensureDeltaIsRegistered(String id) throws IOException {
        File location;
        block8: {
            if (id == null) {
                throw new IndexerException("\"null\" is not a valid identifier for a transaction");
            }
            location = new File(this.indexDirectory, id).getCanonicalFile();
            this.getReadLock();
            try {
                if (this.indexEntries.containsKey(id)) break block8;
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    if (!this.indexEntries.containsKey(id)) {
                        this.indexEntries.put(id, new IndexEntry(IndexType.DELTA, id, "", TransactionStatus.ACTIVE, "", 0L, 0L, false));
                    }
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            finally {
                this.releaseReadLock();
            }
        }
        return location;
    }

    private IndexWriter makeDeltaIndexWriter(File location, Analyzer analyzer) throws IOException {
        IndexWriter writer = !IndexReader.indexExists((File)location) ? new IndexWriter(location, analyzer, true, IndexWriter.MaxFieldLength.LIMITED) : new IndexWriter(location, analyzer, false, IndexWriter.MaxFieldLength.LIMITED);
        writer.setUseCompoundFile(this.writerUseCompoundFile);
        writer.setMaxBufferedDocs(this.writerMaxBufferedDocs);
        writer.setRAMBufferSizeMB(this.writerRamBufferSizeMb);
        writer.setMergeFactor(this.writerMergeFactor);
        writer.setMaxMergeDocs(this.writerMaxMergeDocs);
        writer.setWriteLockTimeout(this.writeLockTimeout);
        writer.setMaxFieldLength(this.maxFieldLength);
        writer.setTermIndexInterval(this.termIndexInterval);
        writer.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        writer.setMergePolicy((MergePolicy)new LogDocMergePolicy());
        return writer;
    }

    public IndexWriter getDeltaIndexWriter(String id, Analyzer analyzer) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexWriter writer = this.indexWriters.get(id);
        if (writer == null) {
            this.closeDeltaIndexReader(id);
            File location = this.ensureDeltaIsRegistered(id);
            writer = this.makeDeltaIndexWriter(location, analyzer);
            this.indexWriters.put(id, writer);
        }
        return writer;
    }

    public void closeDeltaIndexReader(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexReader reader = this.indexReaders.remove(id);
        if (reader != null) {
            reader.close();
        }
    }

    public void closeDeltaIndexWriter(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexWriter writer = this.indexWriters.remove(id);
        if (writer != null) {
            writer.close();
        }
    }

    public void closeDelta(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        this.closeDeltaIndexReader(id);
        this.closeDeltaIndexWriter(id);
    }

    public Set<String> getDeletions(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        HashSet<String> deletions = new HashSet<String>();
        File location = new File(this.indexDirectory, id).getCanonicalFile();
        File file = new File(location, INDEX_INFO_DELETIONS).getCanonicalFile();
        if (!file.exists()) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("No deletions for " + id));
            }
            return Collections.emptySet();
        }
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            String ref = is.readUTF();
            deletions.add(ref);
        }
        is.close();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("There are " + deletions.size() + " deletions for " + id));
        }
        return deletions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreparedState(String id, Set<String> toDelete, long documents, boolean deleteNodesOnly) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        if (toDelete.size() > 0) {
            File location = new File(this.indexDirectory, id).getCanonicalFile();
            if (!location.exists() && !location.mkdirs()) {
                throw new IndexerException("Failed to make index directory " + location);
            }
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(location, INDEX_INFO_DELETIONS).getCanonicalFile())));
            os.writeInt(toDelete.size());
            for (String ref : toDelete) {
                os.writeUTF(ref);
            }
            os.flush();
            os.close();
        }
        this.getWriteLock();
        try {
            IndexEntry entry = this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Invalid index delta id " + id);
            }
            if (entry.getStatus() != TransactionStatus.PREPARING && entry.getStatus() != TransactionStatus.COMMITTING) {
                throw new IndexerException("Deletes and doc count can only be set on a preparing index");
            }
            entry.setDocumentCount(documents);
            entry.setDeletions(toDelete.size());
            entry.setDeletOnlyNodes(deleteNodesOnly);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getMainIndexReferenceCountingReadOnlyIndexReader() throws IOException {
        this.getReadLock();
        try {
            if (this.indexIsShared && !this.checkVersion()) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    this.mainIndexReader = null;
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            if (this.mainIndexReader == null) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    if (this.mainIndexReader == null) {
                        this.doWithFileLock(new LockWork<Object>(){

                            @Override
                            public Object doWork() throws Exception {
                                return null;
                            }

                            @Override
                            public boolean canRetry() {
                                return true;
                            }
                        });
                        this.mainIndexReader = this.createMainIndexReader();
                    }
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            this.mainIndexReader.incRef();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Main index reader references = " + ((ReferenceCounting)this.mainIndexReader).getReferenceCount()));
            }
            FilterIndexReader filterIndexReader = new FilterIndexReader(this.mainIndexReader){

                protected void doClose() throws IOException {
                    this.in.decRef();
                }
            };
            return filterIndexReader;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getMainIndexReferenceCountingReadOnlyIndexReader(String id, Set<String> deletions, boolean deleteOnlyNodes) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        this.getReadLock();
        try {
            if (this.indexIsShared && !this.checkVersion()) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    this.mainIndexReader = null;
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            if (this.mainIndexReader == null) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    if (this.mainIndexReader == null) {
                        this.doWithFileLock(new LockWork<Object>(){

                            @Override
                            public Object doWork() throws Exception {
                                return null;
                            }

                            @Override
                            public boolean canRetry() {
                                return true;
                            }
                        });
                        this.mainIndexReader = this.createMainIndexReader();
                    }
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            IndexReader deltaReader = this.buildAndRegisterDeltaReader(id);
            MultiReader reader = null;
            if (deletions == null || deletions.size() == 0) {
                reader = new MultiReader(new IndexReader[]{this.mainIndexReader, deltaReader}, false);
            } else {
                FilterIndexReaderByStringId filterReader = new FilterIndexReaderByStringId("main+id", this.mainIndexReader, deletions, deleteOnlyNodes);
                reader = new MultiReader(new IndexReader[]{filterReader, deltaReader}, false);
                filterReader.decRef();
            }
            deltaReader.decRef();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Main index reader references = " + ((ReferenceCounting)this.mainIndexReader).getReferenceCount()));
            }
            reader = ReferenceCountingReadOnlyIndexReaderFactory.createReader(MAIN_READER + id, (IndexReader)reader, false, this.config);
            ReferenceCounting refCounting = (ReferenceCounting)reader;
            reader.incRef();
            refCounting.setInvalidForReuse();
            MultiReader multiReader = reader;
            return multiReader;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(final String id, final TransactionStatus state, final Set<Term> toDelete, final Set<Term> read) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        final Transition transition = this.getTransition(state);
        this.getReadLock();
        try {
            while (!transition.beforeWithReadLock(id, toDelete, read)) {
                Merger merger = this.merger;
                synchronized (merger) {
                    int count = this.merger.getScheduledCount();
                    if (count <= 0) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("CAN'T THROTTLE: " + this.indexEntries.size()));
                        }
                        break;
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("THROTTLING: " + this.indexEntries.size()));
                    }
                    this.releaseReadLock();
                    try {
                        this.merger.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.getReadLock();
            }
            this.releaseReadLock();
            this.getWriteLock();
            try {
                if (transition.requiresFileLock()) {
                    this.doWithFileLock(new LockWork<Object>(){

                        @Override
                        public Object doWork() throws Exception {
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)("Start Index " + id + " state = " + (Object)((Object)state)));
                            }
                            IndexInfo.this.dumpInfo();
                            transition.transition(id, toDelete, read);
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)("End Index " + id + " state = " + (Object)((Object)state)));
                            }
                            IndexInfo.this.dumpInfo();
                            return null;
                        }

                        @Override
                        public boolean canRetry() {
                            return true;
                        }
                    });
                } else {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Start Index " + id + " state = " + (Object)((Object)state)));
                    }
                    this.dumpInfo();
                    transition.transition(id, toDelete, read);
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("End Index " + id + " state = " + (Object)((Object)state)));
                    }
                    this.dumpInfo();
                }
            }
            finally {
                this.getReadLock();
                this.releaseWriteLock();
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    private Transition getTransition(TransactionStatus state) {
        Transition transition = this.transitions.get((Object)state);
        if (transition != null) {
            return transition;
        }
        throw new IndexerException("Invalid state " + (Object)((Object)state));
    }

    private void initialiseTransitions() {
        this.transitions.put(TransactionStatus.PREPARING, new PreparingTransition());
        this.transitions.put(TransactionStatus.PREPARED, new PreparedTransition());
        this.transitions.put(TransactionStatus.COMMITTING, new CommittingTransition());
        this.transitions.put(TransactionStatus.COMMITTED, new CommittedTransition());
        this.transitions.put(TransactionStatus.ROLLINGBACK, new RollingBackTransition());
        this.transitions.put(TransactionStatus.ROLLEDBACK, new RolledBackTransition());
        this.transitions.put(TransactionStatus.DELETABLE, new DeletableTransition());
        this.transitions.put(TransactionStatus.ACTIVE, new ActiveTransition());
    }

    private static boolean createFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
                return true;
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to create info file", (Throwable)e);
            }
        }
        return false;
    }

    private static RandomAccessFile openFile(File file) {
        try {
            if (useNIOMemoryMapping) {
                return new RandomAccessFile(file, "rw");
            }
            return new RandomAccessFile(file, "rws");
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Failed to open index info file", (Throwable)e);
        }
    }

    private void setStatusFromFile() throws IOException {
        try {
            this.setStatusFromFile(this.indexInfoChannel);
        }
        catch (IOException e) {
            this.setStatusFromFile(this.indexInfoBackupChannel);
        }
        this.clearOldReaders();
    }

    private void clearOldReaders() throws IOException {
        HashSet<String> inValid = new HashSet<String>();
        for (String id : this.referenceCountingReadOnlyIndexReaders.keySet()) {
            if (!this.indexEntries.containsKey(id)) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)(id + " is now INVALID "));
                }
                inValid.add(id);
                continue;
            }
            if (!s_logger.isDebugEnabled()) continue;
            s_logger.debug((Object)(id + " is still part of the index "));
        }
        this.clearInvalid(inValid);
    }

    private void clearInvalid(HashSet<String> inValid) throws IOException {
        boolean hasInvalid = false;
        for (String id : inValid) {
            IndexReader reader = this.referenceCountingReadOnlyIndexReaders.remove(id);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("... invalidating sub reader " + id));
            }
            ReferenceCounting referenceCounting = (ReferenceCounting)reader;
            referenceCounting.setInvalidForReuse();
            this.deletableReaders.add(reader);
            hasInvalid = true;
        }
        if (hasInvalid) {
            if (this.mainIndexReader != null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"... invalidating main index reader");
                }
                ((ReferenceCounting)this.mainIndexReader).setInvalidForReuse();
            }
            this.mainIndexReader = null;
        }
    }

    private IndexReader createMainIndexReader() throws IOException {
        IndexReader reader = null;
        for (String id : this.indexEntries.keySet()) {
            IndexReader oldReader;
            IndexEntry entry = this.indexEntries.get(id);
            if (!entry.getStatus().isCommitted()) continue;
            IndexReader subReader = this.getReferenceCountingIndexReader(id);
            if (reader == null) {
                reader = subReader;
                reader.incRef();
                continue;
            }
            if (entry.getType() == IndexType.INDEX) {
                oldReader = reader;
                reader = new MultiReader(new IndexReader[]{oldReader, subReader}, false);
                oldReader.decRef();
                continue;
            }
            if (entry.getType() != IndexType.DELTA) continue;
            try {
                oldReader = reader;
                FilterIndexReaderByStringId filterReader = new FilterIndexReaderByStringId(id, oldReader, this.getDeletions(entry.getName()), entry.isDeletOnlyNodes());
                reader = new MultiReader(new IndexReader[]{filterReader, subReader}, false);
                oldReader.decRef();
                filterReader.decRef();
            }
            catch (IOException ioe) {
                s_logger.error((Object)("Failed building filter reader beneath " + entry.getName()), (Throwable)ioe);
                throw ioe;
            }
        }
        if (reader == null) {
            reader = IndexReader.open((Directory)this.emptyIndex);
        }
        reader = ReferenceCountingReadOnlyIndexReaderFactory.createReader(MAIN_READER, reader, false, this.config);
        return reader;
    }

    private IndexReader getReferenceCountingIndexReader(String id) throws IOException {
        IndexReader reader = this.referenceCountingReadOnlyIndexReaders.get(id);
        if (reader == null) {
            throw new IllegalStateException("Indexer should have been pre-built for " + id);
        }
        return reader;
    }

    private void registerReferenceCountingIndexReader(String id, IndexReader reader) {
        ReferenceCounting referenceCounting = (ReferenceCounting)reader;
        if (!referenceCounting.getId().equals(id)) {
            throw new IllegalStateException("Registering " + referenceCounting.getId() + " as " + id);
        }
        this.referenceCountingReadOnlyIndexReaders.put(id, reader);
    }

    private double getSizeInMb(File file) {
        long size = this.getSize(file);
        return (double)size / 1024.0 / 1024.0;
    }

    private long getSize(File file) {
        long size = 0L;
        if (file == null) {
            return size;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] files = file.listFiles();
        if (files == null) {
            return size;
        }
        for (File current : files) {
            if (current.isDirectory()) {
                size += this.getSize(current);
                continue;
            }
            size += current.length();
        }
        return size;
    }

    private IndexReader buildReferenceCountingIndexReader(String id, long size) throws IOException {
        IndexReader reader;
        File location = new File(this.indexDirectory, id).getCanonicalFile();
        double folderSize = this.getSizeInMb(location);
        if (IndexReader.indexExists((File)location)) {
            if (size < (long)this.maxDocsForInMemoryIndex && folderSize < this.maxRamInMbForInMemoryIndex) {
                RAMDirectory rd = new RAMDirectory(location);
                reader = IndexReader.open((Directory)rd);
            } else {
                reader = IndexReader.open((File)location);
            }
        } else {
            reader = IndexReader.open((Directory)this.emptyIndex);
        }
        reader = ReferenceCountingReadOnlyIndexReaderFactory.createReader(id, reader, true, this.config);
        return reader;
    }

    private boolean checkVersion() throws IOException {
        try {
            return this.checkVersion(this.indexInfoChannel);
        }
        catch (IOException e) {
            try {
                return this.checkVersion(this.indexInfoBackupChannel);
            }
            catch (IOException ee) {
                return false;
            }
        }
    }

    private boolean checkVersion(FileChannel channel) throws IOException {
        if (channel.size() > 0L) {
            ByteBuffer buffer;
            channel.position(0L);
            if (useNIOMemoryMapping) {
                MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 8L);
                mbb.load();
                buffer = mbb;
            } else {
                buffer = ByteBuffer.wrap(new byte[8]);
                channel.read(buffer);
                buffer.position(0);
            }
            buffer.position(0);
            long onDiskVersion = buffer.getLong();
            return this.version == onDiskVersion;
        }
        return this.version == 0L;
    }

    private void setStatusFromFile(FileChannel channel) throws IOException {
        if (channel.size() > 0L) {
            ByteBuffer buffer;
            channel.position(0L);
            if (useNIOMemoryMapping) {
                MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                mbb.load();
                buffer = mbb;
            } else {
                buffer = ByteBuffer.wrap(new byte[(int)channel.size()]);
                channel.read(buffer);
                buffer.position(0);
            }
            buffer.position(0);
            long onDiskVersion = buffer.getLong();
            if (this.version != onDiskVersion) {
                CRC32 crc32 = new CRC32();
                crc32.update((int)(onDiskVersion >>> 32) & 0xFFFFFFFF);
                crc32.update((int)(onDiskVersion >>> 0) & 0xFFFFFFFF);
                int size = buffer.getInt();
                crc32.update(size);
                LinkedHashMap<String, IndexEntry> newIndexEntries = new LinkedHashMap<String, IndexEntry>();
                for (int i = 0; i < size; ++i) {
                    boolean isDeletOnlyNodes;
                    TransactionStatus status;
                    IndexType indexType;
                    String indexTypeString = this.readString(buffer, crc32);
                    try {
                        indexType = IndexType.valueOf(indexTypeString);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Invalid type " + indexTypeString);
                    }
                    String name = this.readString(buffer, crc32);
                    String parentName = this.readString(buffer, crc32);
                    String txStatus = this.readString(buffer, crc32);
                    try {
                        status = TransactionStatus.valueOf(txStatus);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Invalid status " + txStatus);
                    }
                    String mergeId = this.readString(buffer, crc32);
                    long documentCount = buffer.getLong();
                    crc32.update((int)(documentCount >>> 32) & 0xFFFFFFFF);
                    crc32.update((int)(documentCount >>> 0) & 0xFFFFFFFF);
                    long deletions = buffer.getLong();
                    crc32.update((int)(deletions >>> 32) & 0xFFFFFFFF);
                    crc32.update((int)(deletions >>> 0) & 0xFFFFFFFF);
                    byte deleteOnlyNodesFlag = buffer.get();
                    crc32.update(deleteOnlyNodesFlag);
                    boolean bl = isDeletOnlyNodes = deleteOnlyNodesFlag == 1;
                    if (status.isTransient()) continue;
                    newIndexEntries.put(name, new IndexEntry(indexType, name, parentName, status, mergeId, documentCount, deletions, isDeletOnlyNodes));
                }
                long onDiskCRC32 = buffer.getLong();
                if (crc32.getValue() == onDiskCRC32) {
                    for (IndexEntry entry : this.indexEntries.values()) {
                        if (!entry.getStatus().isTransient()) continue;
                        newIndexEntries.put(entry.getName(), entry);
                    }
                    this.version = onDiskVersion;
                    this.indexEntries = newIndexEntries;
                } else {
                    throw new IOException("Invalid file check sum");
                }
            }
        }
    }

    private String readString(ByteBuffer buffer, CRC32 crc32) throws UnsupportedEncodingException {
        int size = buffer.getInt();
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)bytes[i];
        }
        crc32.update(bytes);
        return new String(chars);
    }

    private void writeString(ByteBuffer buffer, CRC32 crc32, String string) throws UnsupportedEncodingException {
        char[] chars = string.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u00ff') {
                throw new UnsupportedEncodingException();
            }
            bytes[i] = (byte)chars[i];
        }
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        crc32.update(bytes);
    }

    private void writeStatus() throws IOException {
        ++this.version;
        this.writeStatusToFile(this.indexInfoChannel);
        this.writeStatusToFile(this.indexInfoBackupChannel);
    }

    private void writeStatusToFile(FileChannel channel) throws IOException {
        ByteBuffer buffer;
        long size = this.getBufferSize();
        if (useNIOMemoryMapping) {
            MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
            mbb.load();
            buffer = mbb;
        } else {
            channel.truncate(size);
            buffer = ByteBuffer.wrap(new byte[(int)size]);
        }
        buffer.position(0);
        buffer.putLong(this.version);
        CRC32 crc32 = new CRC32();
        crc32.update((int)(this.version >>> 32) & 0xFFFFFFFF);
        crc32.update((int)(this.version >>> 0) & 0xFFFFFFFF);
        buffer.putInt(this.indexEntries.size());
        crc32.update(this.indexEntries.size());
        for (IndexEntry entry : this.indexEntries.values()) {
            byte[] byArray;
            String entryType = entry.getType().toString();
            this.writeString(buffer, crc32, entryType);
            this.writeString(buffer, crc32, entry.getName());
            this.writeString(buffer, crc32, entry.getParentName());
            String entryStatus = entry.getStatus().toString();
            this.writeString(buffer, crc32, entryStatus);
            this.writeString(buffer, crc32, entry.getMergeId());
            buffer.putLong(entry.getDocumentCount());
            crc32.update((int)(entry.getDocumentCount() >>> 32) & 0xFFFFFFFF);
            crc32.update((int)(entry.getDocumentCount() >>> 0) & 0xFFFFFFFF);
            buffer.putLong(entry.getDeletions());
            crc32.update((int)(entry.getDeletions() >>> 32) & 0xFFFFFFFF);
            crc32.update((int)(entry.getDeletions() >>> 0) & 0xFFFFFFFF);
            buffer.put(entry.isDeletOnlyNodes() ? (byte)1 : 0);
            if (entry.isDeletOnlyNodes()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            crc32.update(byArray);
        }
        buffer.putLong(crc32.getValue());
        if (useNIOMemoryMapping) {
            ((MappedByteBuffer)buffer).force();
        } else {
            buffer.rewind();
            channel.position(0L);
            channel.write(buffer);
        }
    }

    private long getBufferSize() throws IOException {
        long size = 0L;
        size += 8L;
        size += 4L;
        for (IndexEntry entry : this.indexEntries.values()) {
            String entryType = entry.getType().toString();
            size += (long)(entryType.length() + 4);
            size += (long)(entry.getName().length() + 4);
            size += (long)(entry.getParentName().length() + 4);
            String entryStatus = entry.getStatus().toString();
            size += (long)(entryStatus.length() + 4);
            size += (long)(entry.getMergeId().length() + 4);
            size += 8L;
            size += 8L;
            ++size;
        }
        return size += 8L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doWithWriteLock(LockWork<R> lockWork) {
        this.getWriteLock();
        try {
            R r = this.doWithFileLock(lockWork);
            return r;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private <R> R doWithFileLock(LockWork<R> lockWork) {
        try {
            return this.doWithFileLock(lockWork, 5);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error during run with lock.", e);
        }
    }

    private <R> R doWithFileLock(LockWork<R> lockWork, int retriesRemaining) throws Throwable {
        FileLock fileLock = null;
        R result = null;
        long start = 0L;
        try {
            if (!this.indexInfoChannel.isOpen()) {
                if (lockWork.canRetry()) {
                    throw new IndexInfoChannelException("Channel is closed.  Manually triggering reopen attempts");
                }
                this.reopenChannels();
            }
            if (this.indexIsShared) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)" ... waiting for file lock");
                    start = System.nanoTime();
                }
                fileLock = this.indexInfoChannel.lock();
                if (s_logger.isDebugEnabled()) {
                    long end = System.nanoTime();
                    s_logger.debug((Object)(" ... got file lock in " + (float)(end - start) / 1.0E7f + " ms"));
                }
                if (!this.checkVersion()) {
                    this.setStatusFromFile();
                }
            }
            R end = result = (R)lockWork.doWork();
            return end;
        }
        catch (IOException e) {
            R e2;
            if (!lockWork.canRetry()) {
                s_logger.warn((Object)"This operation can not retry upon an IOException - it has to roll back to its previous state");
                throw e;
            }
            if (retriesRemaining == 0) {
                s_logger.warn((Object)"No more channel open retries remaining");
                throw e;
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("\nChannel is closed.  Will attempt to open it. \n   Retries remaining: " + retriesRemaining));
            }
            try {
                this.reopenChannels();
                e2 = this.doWithFileLock(lockWork, --retriesRemaining);
            }
            catch (Throwable ee) {
                s_logger.error((Object)("Channel reopen failed on index info files in: " + this.indexDirectory), ee);
                throw e;
            }
            return e2;
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                    long end = System.nanoTime();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)(" ... released file lock after " + (float)(end - start) / 1.0E7f + " ms"));
                    }
                }
                catch (IOException e) {
                    s_logger.warn((Object)("Failed to release file lock: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private synchronized void reopenChannels() throws Throwable {
        try {
            this.indexInfoRAF.close();
        }
        catch (IOException e) {
            s_logger.warn((Object)"Failed to close indexInfoRAF", (Throwable)e);
        }
        try {
            this.indexInfoBackupRAF.close();
        }
        catch (IOException e) {
            s_logger.warn((Object)"Failed to close indexInfoRAF", (Throwable)e);
        }
        File indexInfoFile = new File(this.indexDirectory, INDEX_INFO);
        File indexInfoBackupFile = new File(this.indexDirectory, INDEX_INFO_BACKUP);
        this.indexInfoRAF = IndexInfo.openFile(indexInfoFile);
        this.indexInfoChannel = this.indexInfoRAF.getChannel();
        this.indexInfoBackupRAF = IndexInfo.openFile(indexInfoBackupFile);
        this.indexInfoBackupChannel = this.indexInfoBackupRAF.getChannel();
    }

    public static void main(String[] args) throws Throwable {
        for (int i = 0; i < args.length; ++i) {
            File indexLocation = new File(args[i]);
            if (!indexLocation.exists()) {
                System.err.println("Index directory doesn't exist: " + indexLocation);
                continue;
            }
            IndexInfo.readIndexInfo(indexLocation);
        }
    }

    static Query getPathQuery(String path) throws SAXPathException {
        ApplicationContext ac = ApplicationContextHelper.getApplicationContext();
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver((NamespacePrefixResolver)((NamespaceService)ac.getBean("namespaceService")));
        handler.setDictionaryService((DictionaryService)ac.getBean("dictionaryService"));
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(path);
        PathQuery pathQuery = handler.getQuery();
        pathQuery.setRepeats(false);
        return pathQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readIndexInfo(File indexLocation) throws Throwable {
        IndexInfo ii = new IndexInfo(indexLocation, null);
        ii.readWriteLock.writeLock().lock();
        try {
            System.out.println("Entry List for " + indexLocation);
            System.out.println("   Size = " + ii.indexEntries.size());
            int i = 0;
            for (IndexEntry entry : ii.indexEntries.values()) {
                System.out.println("\t" + i++ + "\t" + entry.toString());
            }
        }
        finally {
            ii.releaseWriteLock();
        }
        IndexReader reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
        System.out.println(reader.getFieldNames(IndexReader.FieldOption.ALL));
        TermEnum te = reader.terms();
        while (te.next()) {
            if (!te.term().field().contains("FTS")) continue;
            System.out.println(te.term());
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        TermQuery query = new TermQuery(new Term("@{http://www.alfresco.org/model/content/1.0}name", "product363_ocmwbeersel"));
        long start = System.nanoTime();
        Hits hits = searcher.search((Query)query);
        long end = System.nanoTime();
        System.out.println("@{http://www.alfresco.org/model/content/1.0}name:product363_ocmwbeersel = " + hits.length() + " in " + (double)(end - start) / 1.0E9);
        searcher.close();
        searcher = new IndexSearcher(reader);
        query = new WildcardQuery(new Term("@{http://www.alfresco.org/model/content/1.0}name", "b*"));
        start = System.nanoTime();
        hits = searcher.search((Query)query);
        end = System.nanoTime();
        System.out.println("@{http://www.alfresco.org/model/content/1.0}name:b* = " + hits.length() + " in " + (double)(end - start) / 1.0E9);
        searcher.close();
        searcher = new IndexSearcher(reader);
        query = new TermQuery(new Term("@{http://www.alfresco.org/model/content/1.0}name", "be"));
        start = System.nanoTime();
        hits = searcher.search((Query)query);
        end = System.nanoTime();
        System.out.println("@{http://www.alfresco.org/model/content/1.0}name:be = " + hits.length() + " in " + (double)(end - start) / 1.0E9);
        searcher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInfo() {
        if (s_logger.isDebugEnabled()) {
            int count = 0;
            StringBuilder builder = new StringBuilder();
            this.readWriteLock.writeLock().lock();
            try {
                builder.append("\n");
                builder.append("Entry List\n");
                for (IndexEntry entry : this.indexEntries.values()) {
                    builder.append(++count + "        " + entry.toString()).append("\n");
                }
                s_logger.debug((Object)builder.toString());
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    private void getWriteLock() {
        String threadName = null;
        long start = 0L;
        if (s_logger.isDebugEnabled()) {
            threadName = Thread.currentThread().getName();
            s_logger.debug((Object)("Waiting for WRITE lock  - " + threadName));
            start = System.nanoTime();
        }
        this.readWriteLock.writeLock().lock();
        if (s_logger.isDebugEnabled()) {
            long end = System.nanoTime();
            s_logger.debug((Object)("...GOT WRITE LOCK  - " + threadName + " -  in " + (float)(end - start) / 1.0E7f + " ms"));
        }
    }

    private void releaseWriteLock() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("RELEASED WRITE LOCK  - " + Thread.currentThread().getName()));
        }
        this.readWriteLock.writeLock().unlock();
    }

    private void getReadLock() {
        String threadName = null;
        long start = 0L;
        if (s_logger.isDebugEnabled()) {
            threadName = Thread.currentThread().getName();
            s_logger.debug((Object)("Waiting for READ lock  - " + threadName));
            start = System.nanoTime();
        }
        this.readWriteLock.readLock().lock();
        if (s_logger.isDebugEnabled()) {
            long end = System.nanoTime();
            s_logger.debug((Object)("...GOT READ LOCK  - " + threadName + " -  in " + (float)(end - start) / 1.0E7f + " ms"));
        }
    }

    private void releaseReadLock() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("RELEASED READ LOCK  - " + Thread.currentThread().getName()));
        }
        this.readWriteLock.readLock().unlock();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.indexDirectory.toString());
        builder.append(" ");
        builder.append(super.toString());
        return builder.toString();
    }

    private boolean isGUID(String guid) {
        try {
            UUID id = new UUID(guid);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getStatusSnapshot() {
        TreeMap<String, Integer> snapShot = new TreeMap<String, Integer>();
        this.readWriteLock.writeLock().lock();
        try {
            for (IndexEntry entry : this.indexEntries.values()) {
                String stateKey;
                Integer count = (Integer)snapShot.get(stateKey = (Object)((Object)entry.getType()) + "-" + (Object)((Object)entry.getStatus()));
                snapShot.put(stateKey, count == null ? 1 : count + 1);
            }
            TreeMap<String, Integer> treeMap = snapShot;
            return treeMap;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActualSize() throws IOException {
        this.getReadLock();
        try {
            int size = 0;
            for (IndexEntry entry : this.indexEntries.values()) {
                File[] contents;
                File location = new File(this.indexDirectory, entry.getName()).getCanonicalFile();
                for (File file : contents = location.listFiles()) {
                    if (!file.isFile()) continue;
                    size = (int)((long)size + file.length());
                }
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsedSize() throws IOException {
        this.getReadLock();
        try {
            long l = this.sizeRecurse(this.indexDirectory);
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfDocuments() throws IOException {
        IndexReader reader = this.getMainIndexReferenceCountingReadOnlyIndexReader();
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfFields() throws IOException {
        IndexReader reader = this.getMainIndexReferenceCountingReadOnlyIndexReader();
        try {
            int n = reader.getFieldNames(IndexReader.FieldOption.ALL).size();
            return n;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfIndexedFields() throws IOException {
        IndexReader reader = this.getMainIndexReferenceCountingReadOnlyIndexReader();
        try {
            int n = reader.getFieldNames(IndexReader.FieldOption.INDEXED).size();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void addApplicationListener(ApplicationListener listener) {
        this.applicationListeners.add(listener);
    }

    private long sizeRecurse(File fileOrDir) {
        long size = 0L;
        if (fileOrDir.isDirectory()) {
            File[] files;
            for (File file : files = fileOrDir.listFiles()) {
                size += this.sizeRecurse(file);
            }
        } else {
            size = fileOrDir.length();
        }
        return size;
    }

    private void publishDiscoveryEvent() {
        if (this.config == null) {
            return;
        }
        final IndexEvent discoveryEvent = new IndexEvent(this, "Discovery", 1);
        final ConfigurableApplicationContext applicationContext = this.config.getApplicationContext();
        try {
            applicationContext.publishEvent((ApplicationEvent)discoveryEvent);
        }
        catch (IllegalStateException e) {
            applicationContext.addApplicationListener(new ApplicationListener(){

                public void onApplicationEvent(ApplicationEvent event) {
                    if (event instanceof ContextRefreshedEvent) {
                        applicationContext.publishEvent((ApplicationEvent)discoveryEvent);
                    }
                }
            });
        }
    }

    private void notifyListeners(String description, int count) {
        if (!this.applicationListeners.isEmpty()) {
            IndexEvent event = new IndexEvent(this, description, count);
            for (ApplicationListener listener : this.applicationListeners) {
                listener.onApplicationEvent((ApplicationEvent)event);
            }
        }
    }

    static {
        FSDirectory.setDisableLocks(true);
    }

    static interface Schedulable {
        public void schedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Merger
    extends AbstractSchedulable {
        private Merger() {
        }

        @Override
        String getLogName() {
            return "Index merger";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ExitState runImpl() throws IOException {
            MergeAction action = MergeAction.NONE;
            IndexInfo.this.getReadLock();
            try {
                if (IndexInfo.this.indexIsShared && !IndexInfo.this.checkVersion()) {
                    IndexInfo.this.releaseReadLock();
                    IndexInfo.this.getWriteLock();
                    try {
                        IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                            @Override
                            public Object doWork() throws Exception {
                                return null;
                            }

                            @Override
                            public boolean canRetry() {
                                return true;
                            }
                        });
                    }
                    finally {
                        IndexInfo.this.getReadLock();
                        IndexInfo.this.releaseWriteLock();
                    }
                }
                int indexes = 0;
                boolean mergingIndexes = false;
                int deltas = 0;
                boolean applyingDeletions = false;
                for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                    if (entry.getType() == IndexType.INDEX) {
                        ++indexes;
                        if (entry.getStatus() != TransactionStatus.MERGE && entry.getStatus() != TransactionStatus.MERGE_TARGET) continue;
                        mergingIndexes = true;
                        continue;
                    }
                    if (entry.getType() != IndexType.DELTA) continue;
                    if (entry.getStatus() == TransactionStatus.COMMITTED) {
                        ++deltas;
                    }
                    if (entry.getStatus() != TransactionStatus.COMMITTED_DELETING) continue;
                    applyingDeletions = true;
                    ++deltas;
                }
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Indexes = " + indexes));
                    s_logger.debug((Object)("Merging = " + mergingIndexes));
                    s_logger.debug((Object)("Deltas = " + deltas));
                    s_logger.debug((Object)("Deleting = " + applyingDeletions));
                }
                if (!mergingIndexes && !applyingDeletions) {
                    if (indexes > IndexInfo.this.mergerMergeFactor) {
                        action = MergeAction.MERGE_INDEX;
                    } else if (deltas > IndexInfo.this.mergerTargetOverlays) {
                        action = MergeAction.APPLY_DELTA_DELETION;
                    }
                }
            }
            catch (IOException e) {
                s_logger.error((Object)"Error reading index file", (Throwable)e);
                ExitState exitState = ExitState.DONE;
                return exitState;
            }
            finally {
                IndexInfo.this.releaseReadLock();
            }
            if (action == MergeAction.APPLY_DELTA_DELETION) {
                action = this.mergeDeletions();
            } else if (action == MergeAction.MERGE_INDEX) {
                action = this.mergeIndexes();
            }
            if (action == MergeAction.NONE) {
                return ExitState.DONE;
            }
            return ExitState.RESCHEDULE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ExitState recoverImpl() {
            IndexInfo.this.getWriteLock();
            try {
                IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                    @Override
                    public Object doWork() throws Exception {
                        IndexInfo.this.setStatusFromFile();
                        if (!IndexInfo.this.indexIsShared) {
                            ReferenceCounting rcMain;
                            HashSet<String> deletable = new HashSet<String>();
                            for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                                switch (entry.getStatus()) {
                                    default: {
                                        if (!s_logger.isInfoEnabled()) break;
                                        s_logger.info((Object)("Roll back merge: leaving index entry " + entry));
                                        break;
                                    }
                                    case COMMITTED_DELETING: 
                                    case MERGE: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Roll back merge: Resetting merge and committed_deleting to committed " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.COMMITTED);
                                        break;
                                    }
                                    case MERGE_TARGET: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Roll back merge: Deleting merge target " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.DELETABLE);
                                        deletable.add(entry.getName());
                                    }
                                }
                                if (IndexInfo.this.referenceCountingReadOnlyIndexReaders.get(entry.getName()) != null) continue;
                                IndexInfo.this.registerReferenceCountingIndexReader(entry.getName(), IndexInfo.this.buildReferenceCountingIndexReader(entry.getName(), entry.getDocumentCount()));
                            }
                            if (IndexInfo.this.mainIndexReader != null && (rcMain = (ReferenceCounting)IndexInfo.this.mainIndexReader).isInvalidForReuse()) {
                                IndexInfo.this.mainIndexReader = null;
                            }
                            for (String id : deletable) {
                                IndexInfo.this.indexEntries.remove(id);
                            }
                            IndexInfo.this.clearOldReaders();
                            IndexInfo.this.cleaner.schedule();
                            IndexInfo.this.writeStatus();
                        }
                        return null;
                    }

                    @Override
                    public boolean canRetry() {
                        return false;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            return ExitState.DONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MergeAction mergeDeletions() throws IOException {
            IndexReader reader;
            LinkedHashMap<String, IndexEntry> indexes;
            LinkedHashMap toDelete;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Deleting ...");
            }
            IndexInfo.this.getWriteLock();
            try {
                toDelete = (LinkedHashMap)IndexInfo.this.doWithFileLock(new LockWork<LinkedHashMap<String, IndexEntry>>(){

                    @Override
                    public LinkedHashMap<String, IndexEntry> doWork() throws Exception {
                        LinkedHashMap<String, IndexEntry> set = new LinkedHashMap<String, IndexEntry>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() == IndexType.INDEX && entry.getStatus() == TransactionStatus.MERGE) {
                                return set;
                            }
                            if (entry.getType() == IndexType.INDEX && entry.getStatus() == TransactionStatus.MERGE_TARGET) {
                                return set;
                            }
                            if (entry.getType() != IndexType.DELTA || entry.getStatus() != TransactionStatus.COMMITTED_DELETING) continue;
                            return set;
                        }
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() != IndexType.DELTA) continue;
                            if (entry.getStatus() != TransactionStatus.COMMITTED) break;
                            entry.setStatus(TransactionStatus.COMMITTED_DELETING);
                            set.put(entry.getName(), entry);
                        }
                        if (set.size() > 0) {
                            IndexInfo.this.writeStatus();
                        }
                        return set;
                    }

                    @Override
                    public boolean canRetry() {
                        return false;
                    }
                });
            }
            finally {
                IndexInfo.this.getReadLock();
                IndexInfo.this.releaseWriteLock();
            }
            try {
                indexes = new LinkedHashMap<String, IndexEntry>();
                for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                    if (entry.getStatus() == TransactionStatus.COMMITTED_DELETING) {
                        break;
                    }
                    indexes.put(entry.getName(), entry);
                }
            }
            finally {
                IndexInfo.this.releaseReadLock();
            }
            if (toDelete.size() == 0) {
                return MergeAction.NONE;
            }
            final HashSet<String> invalidIndexes = new HashSet<String>();
            final HashMap<String, Long> newIndexCounts = new HashMap<String, Long>();
            LinkedHashMap<String, IndexReader> readers = new LinkedHashMap<String, IndexReader>();
            for (IndexEntry entry : indexes.values()) {
                File location = new File(IndexInfo.this.indexDirectory, entry.getName()).getCanonicalFile();
                reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)IndexInfo.this.emptyIndex);
                readers.put(entry.getName(), reader);
            }
            for (IndexEntry currentDelete : toDelete.values()) {
                Set<String> deletions = IndexInfo.this.getDeletions(currentDelete.getName());
                for (String key : readers.keySet()) {
                    IndexReader reader2 = (IndexReader)readers.get(key);
                    for (String stringRef : deletions) {
                        int deletedCount;
                        block30: {
                            if (currentDelete.isDeletOnlyNodes()) {
                                IndexSearcher searcher = new IndexSearcher(reader2);
                                TermQuery query = new TermQuery(new Term("ID", stringRef));
                                Hits hits = searcher.search((Query)query);
                                if (hits.length() > 0) {
                                    for (int i = 0; i < hits.length(); ++i) {
                                        Document doc = hits.doc(i);
                                        if (doc.getField("ISCONTAINER") != null) continue;
                                        reader2.deleteDocument(hits.id(i));
                                        invalidIndexes.add(key);
                                    }
                                }
                                searcher.close();
                                continue;
                            }
                            deletedCount = 0;
                            try {
                                deletedCount = reader2.deleteDocuments(new Term("ID", stringRef));
                            }
                            catch (IOException ioe) {
                                if (!s_logger.isDebugEnabled()) break block30;
                                s_logger.debug((Object)("IO Error for " + key));
                                throw ioe;
                            }
                        }
                        if (deletedCount <= 0) continue;
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("Deleted " + deletedCount + " from " + key + " for id " + stringRef + " remaining docs " + reader2.numDocs()));
                        }
                        invalidIndexes.add(key);
                    }
                }
                File location = new File(IndexInfo.this.indexDirectory, currentDelete.getName()).getCanonicalFile();
                IndexReader reader3 = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)IndexInfo.this.emptyIndex);
                readers.put(currentDelete.getName(), reader3);
            }
            IndexInfo.this.getWriteLock();
            try {
                for (String key : readers.keySet()) {
                    IndexReader reader4 = (IndexReader)readers.get(key);
                    newIndexCounts.put(key, new Long(reader4.numDocs()));
                    reader4.close();
                }
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            final HashMap<String, IndexReader> newReaders = new HashMap<String, IndexReader>();
            for (String id : invalidIndexes) {
                reader = IndexInfo.this.buildReferenceCountingIndexReader(id, (Long)newIndexCounts.get(id));
                newReaders.put(id, reader);
            }
            IndexInfo.this.getWriteLock();
            try {
                IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                    @Override
                    public Object doWork() throws Exception {
                        for (IndexEntry entry : toDelete.values()) {
                            entry.setStatus(TransactionStatus.COMMITTED);
                            entry.setType(IndexType.INDEX);
                            entry.setDeletions(0L);
                        }
                        for (String key : newIndexCounts.keySet()) {
                            Long newCount = (Long)newIndexCounts.get(key);
                            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(key);
                            entry.setDocumentCount(newCount);
                        }
                        IndexInfo.this.writeStatus();
                        for (String id : invalidIndexes) {
                            IndexReader reader = (IndexReader)IndexInfo.this.referenceCountingReadOnlyIndexReaders.remove(id);
                            if (reader == null) continue;
                            ReferenceCounting referenceCounting = (ReferenceCounting)reader;
                            referenceCounting.setInvalidForReuse();
                            if (!s_logger.isDebugEnabled()) continue;
                            s_logger.debug((Object)("... invalidating sub reader after applying deletions" + id));
                        }
                        for (String id : invalidIndexes) {
                            IndexReader newReader = (IndexReader)newReaders.get(id);
                            IndexInfo.this.registerReferenceCountingIndexReader(id, newReader);
                        }
                        if (invalidIndexes.size() > 0) {
                            if (IndexInfo.this.mainIndexReader != null) {
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)"... invalidating main index reader after applying deletions");
                                }
                                ((ReferenceCounting)IndexInfo.this.mainIndexReader).setInvalidForReuse();
                            } else if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)"... no main index reader to invalidate after applying deletions");
                            }
                            IndexInfo.this.mainIndexReader = null;
                        }
                        if (s_logger.isDebugEnabled()) {
                            for (String id : toDelete.keySet()) {
                                s_logger.debug((Object)("...applied deletion for " + id));
                            }
                            s_logger.debug((Object)"...deleting done");
                        }
                        IndexInfo.this.dumpInfo();
                        IndexInfo.this.notifyListeners("MergedDeletions", toDelete.size());
                        return null;
                    }

                    @Override
                    public boolean canRetry() {
                        return false;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            return MergeAction.APPLY_DELTA_DELETION;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MergeAction mergeIndexes() throws IOException {
            LinkedHashMap toMerge;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Merging...");
            }
            IndexInfo.this.getWriteLock();
            try {
                toMerge = (LinkedHashMap)IndexInfo.this.doWithFileLock(new LockWork<LinkedHashMap<String, IndexEntry>>(){

                    @Override
                    public LinkedHashMap<String, IndexEntry> doWork() throws Exception {
                        LinkedHashMap<String, IndexEntry> set = new LinkedHashMap<String, IndexEntry>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() == IndexType.INDEX && entry.getStatus() == TransactionStatus.MERGE) {
                                return set;
                            }
                            if (entry.getType() == IndexType.INDEX && entry.getStatus() == TransactionStatus.MERGE_TARGET) {
                                return set;
                            }
                            if (entry.getType() != IndexType.DELTA || entry.getStatus() != TransactionStatus.COMMITTED_DELETING) continue;
                            return set;
                        }
                        ArrayList<IndexEntry> mergeList = new ArrayList<IndexEntry>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() != IndexType.INDEX || entry.getStatus() != TransactionStatus.COMMITTED) continue;
                            mergeList.add(entry);
                        }
                        int position = Merger.this.findMergeIndex(1L, IndexInfo.this.mergerMaxMergeDocs, IndexInfo.this.mergerMergeFactor, mergeList);
                        String firstMergeId = ((IndexEntry)mergeList.get(position)).getName();
                        long count = 0L;
                        String guid = null;
                        if (position >= 0) {
                            guid = GUID.generate();
                            for (int i = position; i < mergeList.size(); ++i) {
                                IndexEntry entry = (IndexEntry)mergeList.get(i);
                                count += entry.getDocumentCount();
                                set.put(entry.getName(), entry);
                                entry.setStatus(TransactionStatus.MERGE);
                                entry.setMergeId(guid);
                            }
                        }
                        if (set.size() > 0) {
                            IndexEntry target = new IndexEntry(IndexType.INDEX, guid, "", TransactionStatus.MERGE_TARGET, guid, count, 0L, false);
                            set.put(guid, target);
                            LinkedHashMap<String, IndexEntry> reordered = new LinkedHashMap<String, IndexEntry>();
                            for (IndexEntry current : IndexInfo.this.indexEntries.values()) {
                                if (current.getName().equals(firstMergeId)) {
                                    reordered.put(target.getName(), target);
                                }
                                reordered.put(current.getName(), current);
                            }
                            IndexInfo.this.indexEntries = reordered;
                            IndexInfo.this.writeStatus();
                        }
                        return set;
                    }

                    @Override
                    public boolean canRetry() {
                        return false;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("....Merging..." + (toMerge.size() - 1)));
            }
            if (toMerge.size() == 0) {
                return MergeAction.NONE;
            }
            String mergeTargetId = null;
            long docCount = 0L;
            if (toMerge.size() > 0) {
                int count = 0;
                IndexReader[] readers = new IndexReader[toMerge.size() - 1];
                RAMDirectory ramDirectory = null;
                IndexWriter writer = null;
                File outputLocation = null;
                double mergeSize = 0.0;
                for (IndexEntry entry : toMerge.values()) {
                    File location = new File(IndexInfo.this.indexDirectory, entry.getName()).getCanonicalFile();
                    if (entry.getStatus() == TransactionStatus.MERGE) {
                        IndexReader reader;
                        if (IndexReader.indexExists((File)location)) {
                            reader = IndexReader.open((File)location);
                        } else {
                            s_logger.error((Object)("Index is missing " + entry.getName()));
                            reader = IndexReader.open((Directory)IndexInfo.this.emptyIndex);
                        }
                        readers[count++] = reader;
                        docCount += entry.getDocumentCount();
                        mergeSize += IndexInfo.this.getSizeInMb(location);
                        continue;
                    }
                    if (entry.getStatus() != TransactionStatus.MERGE_TARGET) continue;
                    mergeTargetId = entry.getName();
                    outputLocation = location;
                    if (docCount < (long)IndexInfo.this.maxDocsForInMemoryMerge && mergeSize < IndexInfo.this.maxRamInMbForInMemoryMerge) {
                        ramDirectory = new RAMDirectory();
                        writer = new IndexWriter((Directory)ramDirectory, (Analyzer)new AlfrescoStandardAnalyser(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                    } else {
                        writer = new IndexWriter(location, (Analyzer)new AlfrescoStandardAnalyser(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                    }
                    writer.setUseCompoundFile(IndexInfo.this.mergerUseCompoundFile);
                    writer.setMaxBufferedDocs(IndexInfo.this.mergerMaxBufferedDocs);
                    writer.setRAMBufferSizeMB(IndexInfo.this.mergerRamBufferSizeMb);
                    writer.setMergeFactor(IndexInfo.this.mergerMergeFactor);
                    writer.setMaxMergeDocs(IndexInfo.this.mergerMaxMergeDocs);
                    writer.setWriteLockTimeout(IndexInfo.this.writeLockTimeout);
                    writer.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    writer.setMergePolicy((MergePolicy)new LogDocMergePolicy());
                }
                writer.addIndexes(readers);
                writer.close();
                if (ramDirectory != null) {
                    String[] files = ramDirectory.list();
                    FSDirectory directory = FSDirectory.getDirectory(outputLocation, true);
                    for (int i = 0; i < files.length; ++i) {
                        IndexOutput os = directory.createOutput(files[i]);
                        IndexInput is = ramDirectory.openInput(files[i]);
                        int len = (int)is.length();
                        byte[] buf = new byte[len];
                        is.readBytes(buf, 0, len);
                        os.writeBytes(buf, len);
                        is.close();
                        os.close();
                    }
                    ramDirectory.close();
                    directory.close();
                }
                for (IndexReader reader : readers) {
                    reader.close();
                }
            }
            final String finalMergeTargetId = mergeTargetId;
            IndexReader newReader = null;
            IndexInfo.this.getReadLock();
            try {
                newReader = IndexInfo.this.buildReferenceCountingIndexReader(mergeTargetId, docCount);
            }
            finally {
                IndexInfo.this.releaseReadLock();
            }
            final IndexReader finalNewReader = newReader;
            IndexInfo.this.getWriteLock();
            try {
                IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                    @Override
                    public Object doWork() throws Exception {
                        HashSet<String> toDelete = new HashSet<String>();
                        for (IndexEntry entry : toMerge.values()) {
                            if (entry.getStatus() == TransactionStatus.MERGE) {
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)("... deleting as merged " + entry.getName()));
                                }
                                toDelete.add(entry.getName());
                                continue;
                            }
                            if (entry.getStatus() != TransactionStatus.MERGE_TARGET) continue;
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)("... committing merge target " + entry.getName()));
                            }
                            entry.setStatus(TransactionStatus.COMMITTED);
                        }
                        for (String id : toDelete) {
                            IndexInfo.this.indexEntries.remove(id);
                        }
                        IndexInfo.this.registerReferenceCountingIndexReader(finalMergeTargetId, finalNewReader);
                        IndexInfo.this.notifyListeners("MergedIndexes", toMerge.size());
                        IndexInfo.this.dumpInfo();
                        IndexInfo.this.writeStatus();
                        IndexInfo.this.clearOldReaders();
                        IndexInfo.this.cleaner.schedule();
                        return null;
                    }

                    @Override
                    public boolean canRetry() {
                        return false;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"..done merging");
            }
            return MergeAction.MERGE_INDEX;
        }

        private final int findMergeIndex(long min, long max, int factor, List<IndexEntry> entries) throws IOException {
            int i;
            if (entries.size() <= factor) {
                return -1;
            }
            int total = 0;
            for (i = factor; i < entries.size(); ++i) {
                total = (int)((long)total + entries.get(i).getDocumentCount());
            }
            for (i = factor - 1; i > 0; --i) {
                if ((long)(total = (int)((long)total + entries.get(i).getDocumentCount())) >= entries.get(i - 1).getDocumentCount()) continue;
                return i;
            }
            return 0;
        }
    }

    private abstract class AbstractSchedulable
    implements Schedulable,
    Runnable {
        ScheduledState scheduledState = ScheduledState.UN_SCHEDULED;
        private int scheduledCount;

        private AbstractSchedulable() {
        }

        public synchronized int getScheduledCount() {
            return this.scheduledCount;
        }

        public synchronized void schedule() {
            switch (this.scheduledState) {
                case FAILED: {
                    this.scheduledState = ScheduledState.RECOVERY_SCHEDULED;
                    IndexInfo.this.threadPoolExecutor.execute(this);
                    break;
                }
                case UN_SCHEDULED: {
                    this.scheduledState = ScheduledState.SCHEDULED;
                    ++this.scheduledCount;
                    IndexInfo.this.threadPoolExecutor.execute(this);
                    break;
                }
            }
        }

        private synchronized void done() {
            switch (this.scheduledState) {
                case SCHEDULED: {
                    --this.scheduledCount;
                    this.notifyAll();
                }
                case RECOVERY_SCHEDULED: {
                    this.scheduledState = ScheduledState.UN_SCHEDULED;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private synchronized void reschedule() {
            switch (this.scheduledState) {
                case RECOVERY_SCHEDULED: {
                    this.scheduledState = ScheduledState.SCHEDULED;
                }
                case SCHEDULED: {
                    IndexInfo.this.threadPoolExecutor.execute(this);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private synchronized void rescheduleRecovery() {
            switch (this.scheduledState) {
                case RECOVERY_SCHEDULED: {
                    IndexInfo.this.threadPoolExecutor.execute(this);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private synchronized void fail() {
            switch (this.scheduledState) {
                case SCHEDULED: {
                    --this.scheduledCount;
                    this.notifyAll();
                }
                case RECOVERY_SCHEDULED: {
                    this.scheduledState = ScheduledState.FAILED;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void run() {
            try {
                switch (this.scheduledState) {
                    case RECOVERY_SCHEDULED: {
                        ExitState reschedule = this.recoverImpl();
                        s_logger.error((Object)(this.getLogName() + " has recovered - resuming ... "));
                        if (reschedule == ExitState.RESCHEDULE) {
                            this.rescheduleRecovery();
                            break;
                        }
                    }
                    case SCHEDULED: {
                        ExitState reschedule = this.runImpl();
                        if (reschedule == ExitState.RESCHEDULE) {
                            this.reschedule();
                            break;
                        }
                        this.done();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (Throwable t) {
                try {
                    if (s_logger.isWarnEnabled()) {
                        s_logger.warn((Object)(this.getLogName() + " failed with "), t);
                    }
                    this.recoverImpl();
                    if (s_logger.isWarnEnabled()) {
                        s_logger.warn((Object)(this.getLogName() + " recovered from "), t);
                    }
                    this.done();
                }
                catch (Throwable rbt) {
                    this.fail();
                    s_logger.error((Object)(this.getLogName() + " failed to recover - suspending "), rbt);
                }
            }
        }

        abstract ExitState runImpl() throws Exception;

        abstract ExitState recoverImpl() throws Exception;

        abstract String getLogName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExitState {
        DONE,
        RESCHEDULE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScheduledState {
        UN_SCHEDULED,
        SCHEDULED,
        FAILED,
        RECOVERY_SCHEDULED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MergeAction {
        NONE,
        MERGE_INDEX,
        APPLY_DELTA_DELETION,
        MERGE_DELTA;

    }

    private class Cleaner
    extends AbstractSchedulable {
        private Cleaner() {
        }

        String getLogName() {
            return "Index cleaner";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExitState runImpl() {
            Iterator i = IndexInfo.this.deletableReaders.iterator();
            while (i.hasNext()) {
                IndexReader reader = (IndexReader)i.next();
                ReferenceCounting refCounting = (ReferenceCounting)reader;
                if (refCounting.getReferenceCount() != 0) continue;
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Deleting no longer referenced " + refCounting.getId()));
                    s_logger.debug((Object)("... queued delete for " + refCounting.getId()));
                    s_logger.debug((Object)("... " + ReferenceCountingReadOnlyIndexReaderFactory.getState(refCounting.getId())));
                }
                IndexInfo.this.getReadLock();
                try {
                    if (IndexInfo.this.indexEntries.containsKey(refCounting.getId())) {
                        s_logger.error((Object)("ERROR - deleting live reader - " + refCounting.getId()));
                    }
                }
                finally {
                    IndexInfo.this.releaseReadLock();
                }
                IndexInfo.this.deleteQueue.add(refCounting.getId());
                i.remove();
            }
            Iterator j = IndexInfo.this.deleteQueue.iterator();
            while (j.hasNext()) {
                String id = (String)j.next();
                try {
                    File location;
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Expunging " + id + " remaining " + IndexInfo.this.deleteQueue.size()));
                        s_logger.debug((Object)("... " + ReferenceCountingReadOnlyIndexReaderFactory.getState(id)));
                    }
                    if (!this.deleteDirectory(location = new File(IndexInfo.this.indexDirectory, id).getCanonicalFile())) {
                        if (!s_logger.isDebugEnabled()) continue;
                        s_logger.debug((Object)"DELETE FAILED");
                        continue;
                    }
                    j.remove();
                }
                catch (IOException ioe) {
                    s_logger.warn((Object)"Failed to delete file - invalid canonical file", (Throwable)ioe);
                }
            }
            return ExitState.DONE;
        }

        ExitState recoverImpl() {
            return ExitState.DONE;
        }

        private boolean deleteDirectory(File file) {
            File[] children = file.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    File child = children[i];
                    if (child.isDirectory()) {
                        this.deleteDirectory(child);
                        continue;
                    }
                    if (!child.exists() || child.delete() || !child.exists()) continue;
                    return false;
                }
            }
            return !file.exists() || file.delete() || !file.exists();
        }
    }

    private static class IndexInfoChannelException
    extends IOException {
        private static final long serialVersionUID = 1588898991653057286L;

        public IndexInfoChannelException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LockWork<Result> {
        public Result doWork() throws Exception;

        public boolean canRetry();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActiveTransition
    implements Transition {
        private ActiveTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry != null && entry.getStatus() != TransactionStatus.ACTIVE) {
                throw new IndexerException("TX Already active " + id);
            }
            if (!TransactionStatus.ACTIVE.follows(null)) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.ACTIVE));
            }
            IndexInfo.this.indexEntries.put(id, new IndexEntry(IndexType.DELTA, id, "", TransactionStatus.ACTIVE, "", 0L, 0L, false));
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.ACTIVE.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeletableTransition
    implements Transition {
        private DeletableTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                File location;
                if (IndexInfo.this.referenceCountingReadOnlyIndexReaders.get(id) == null && !(location = new File(IndexInfo.this.indexDirectory, id).getCanonicalFile()).exists()) {
                    throw new IndexerException("Unknown transaction " + id);
                }
                IndexInfo.this.clearOldReaders();
                IndexInfo.this.cleaner.schedule();
            }
            if (!TransactionStatus.DELETABLE.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.DELETABLE));
            }
            IndexInfo.this.indexEntries.remove(id);
            IndexInfo.this.writeStatus();
            IndexInfo.this.clearOldReaders();
            IndexInfo.this.cleaner.schedule();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.DELETABLE.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RolledBackTransition
    implements Transition {
        ThreadLocal<IndexReader> tl = new ThreadLocal();

        private RolledBackTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexInfo.this.closeDelta(id);
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            this.tl.set(IndexInfo.this.buildReferenceCountingIndexReader(id, entry.getDocumentCount()));
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                File location;
                if (IndexInfo.this.referenceCountingReadOnlyIndexReaders.get(id) == null && !(location = new File(IndexInfo.this.indexDirectory, id).getCanonicalFile()).exists()) {
                    throw new IndexerException("Unknown transaction " + id);
                }
                IndexInfo.this.clearOldReaders();
                IndexInfo.this.cleaner.schedule();
            }
            if (TransactionStatus.ROLLEDBACK.follows(entry.getStatus())) {
                entry.setStatus(TransactionStatus.ROLLEDBACK);
                IndexInfo.this.writeStatus();
                IndexInfo.this.registerReferenceCountingIndexReader(id, this.tl.get());
                IndexInfo.this.indexEntries.remove(id);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"Removed rollback");
                }
            } else {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.ROLLEDBACK));
            }
            IndexInfo.this.clearOldReaders();
            IndexInfo.this.cleaner.schedule();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.ROLLEDBACK.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RollingBackTransition
    implements Transition {
        private RollingBackTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.ROLLINGBACK.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.ROLLINGBACK));
            }
            entry.setStatus(TransactionStatus.ROLLINGBACK);
            IndexInfo.this.writeStatus();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.ROLLINGBACK.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommittedTransition
    implements Transition {
        ThreadLocal<IndexReader> tl = new ThreadLocal();

        private CommittedTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexInfo.this.closeDelta(id);
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            this.tl.set(IndexInfo.this.buildReferenceCountingIndexReader(id, entry.getDocumentCount()));
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                File location;
                if (IndexInfo.this.referenceCountingReadOnlyIndexReaders.get(id) == null && !(location = new File(IndexInfo.this.indexDirectory, id).getCanonicalFile()).exists()) {
                    throw new IndexerException("Unknown transaction " + id);
                }
                IndexInfo.this.clearOldReaders();
                IndexInfo.this.cleaner.schedule();
            }
            if (TransactionStatus.COMMITTED.follows(entry.getStatus())) {
                if (entry.getDocumentCount() + entry.getDeletions() == 0L) {
                    IndexInfo.this.registerReferenceCountingIndexReader(id, this.tl.get());
                    IndexInfo.this.indexEntries.remove(id);
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"Removed commit with no new docs and no deletions");
                    }
                    IndexInfo.this.clearOldReaders();
                    IndexInfo.this.cleaner.schedule();
                } else {
                    IndexInfo.this.registerReferenceCountingIndexReader(id, this.tl.get());
                    entry.setStatus(TransactionStatus.COMMITTED);
                    IndexInfo.this.writeStatus();
                    if (IndexInfo.this.mainIndexReader != null) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)"... invalidating main index reader");
                        }
                        ((ReferenceCounting)IndexInfo.this.mainIndexReader).setInvalidForReuse();
                        IndexInfo.this.mainIndexReader = null;
                    }
                    IndexInfo.this.merger.schedule();
                }
            } else {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.COMMITTED));
            }
            IndexInfo.this.notifyListeners("CommittedTransactions", 1);
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.COMMITTED.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommittingTransition
    implements Transition {
        private CommittingTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.COMMITTING.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.COMMITTING));
            }
            entry.setStatus(TransactionStatus.COMMITTING);
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.COMMITTING.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreparedTransition
    implements Transition {
        private PreparedTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            return IndexInfo.this.indexEntries.size() <= IndexInfo.this.mergerMergeBlockingFactor * IndexInfo.this.mergerMergeFactor + IndexInfo.this.mergerTargetOverlaysBlockingFactor * IndexInfo.this.mergerTargetOverlays;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            LinkedHashMap<String, IndexEntry> reordered;
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (TransactionStatus.PREPARED.follows(entry.getStatus())) {
                reordered = new LinkedHashMap<String, IndexEntry>();
                boolean addedPreparedEntry = false;
                for (String key : IndexInfo.this.indexEntries.keySet()) {
                    IndexEntry current = (IndexEntry)IndexInfo.this.indexEntries.get(key);
                    if (!current.getStatus().canBeReordered()) {
                        reordered.put(current.getName(), current);
                        continue;
                    }
                    if (!addedPreparedEntry) {
                        reordered.put(entry.getName(), entry);
                        reordered.put(current.getName(), current);
                        addedPreparedEntry = true;
                        continue;
                    }
                    if (current.getName().equals(entry.getName())) continue;
                    reordered.put(current.getName(), current);
                }
                if (IndexInfo.this.indexEntries.size() != reordered.size()) {
                    IndexInfo.this.indexEntries = reordered;
                    IndexInfo.this.dumpInfo();
                    throw new IndexerException("Concurrent modification error");
                }
            } else {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.PREPARED));
            }
            IndexInfo.this.indexEntries = reordered;
            entry.setStatus(TransactionStatus.PREPARED);
            IndexInfo.this.writeStatus();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.PREPARED.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreparingTransition
    implements Transition {
        private PreparingTransition() {
        }

        @Override
        public boolean beforeWithReadLock(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            return true;
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.PREPARING.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.PREPARING));
            }
            entry.setStatus(TransactionStatus.PREPARING);
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.PREPARING.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Transition {
        public boolean beforeWithReadLock(String var1, Set<Term> var2, Set<Term> var3) throws IOException;

        public void transition(String var1, Set<Term> var2, Set<Term> var3) throws IOException;

        public boolean requiresFileLock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteUnknownGuidDirectories
    implements LockWork<Object> {
        private DeleteUnknownGuidDirectories() {
        }

        @Override
        public boolean canRetry() {
            return true;
        }

        @Override
        public Object doWork() throws Exception {
            File[] files;
            IndexInfo.this.setStatusFromFile();
            if (!IndexInfo.this.indexIsShared && (files = IndexInfo.this.indexDirectory.listFiles()) != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    String id = file.getName();
                    if (IndexInfo.this.indexEntries.containsKey(id) || !IndexInfo.this.isGUID(id)) continue;
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Deleting unused index directory " + id));
                    }
                    IndexInfo.this.deleteQueue.add(id);
                }
            }
            return null;
        }
    }
}

