/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.AuthorityException;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityServiceImpl
implements AuthorityService,
InitializingBean {
    private static Set<String> DEFAULT_ZONES = new HashSet<String>();
    private PersonService personService;
    private NodeService nodeService;
    private TenantService tenantService;
    private AuthorityDAO authorityDAO;
    private UserNameMatcher userNameMatcher;
    private AuthenticationService authenticationService;
    private PermissionServiceSPI permissionServiceSPI;
    private Set<String> adminSet = Collections.singleton("ROLE_ADMINISTRATOR");
    private Set<String> guestSet = Collections.singleton("ROLE_GUEST");
    private Set<String> allSet = Collections.singleton("GROUP_EVERYONE");
    private Set<String> adminGroups = Collections.emptySet();
    private Set<String> guestGroups = Collections.emptySet();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setUserNameMatcher(UserNameMatcher userNameMatcher) {
        this.userNameMatcher = userNameMatcher;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    public void setAdminGroups(Set<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public void setGuestGroups(Set<String> guestGroups) {
        this.guestGroups = guestGroups;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.adminGroups.isEmpty()) {
            HashSet<String> adminGroups = new HashSet<String>(this.adminGroups.size());
            for (String group : this.adminGroups) {
                adminGroups.add(this.getName(AuthorityType.GROUP, group));
            }
            this.adminGroups = adminGroups;
        }
        if (!this.guestGroups.isEmpty()) {
            HashSet<String> guestGroups = new HashSet<String>(this.guestGroups.size());
            for (String group : this.guestGroups) {
                guestGroups.add(this.getName(AuthorityType.GROUP, group));
            }
            this.guestGroups = guestGroups;
        }
    }

    @Override
    public boolean hasAdminAuthority() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        return currentUserName != null && this.getAuthoritiesForUser(currentUserName).contains("ROLE_ADMINISTRATOR");
    }

    @Override
    public boolean isAdminAuthority(String authorityName) {
        String canonicalName = this.personService.getUserIdentifier(authorityName);
        if (canonicalName == null) {
            canonicalName = authorityName;
        }
        return this.getAuthoritiesForUser(canonicalName).contains("ROLE_ADMINISTRATOR");
    }

    @Override
    public boolean hasGuestAuthority() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        return currentUserName != null && this.getAuthoritiesForUser(currentUserName).contains("ROLE_GUEST");
    }

    @Override
    public boolean isGuestAuthority(String authorityName) {
        String canonicalName = this.personService.getUserIdentifier(authorityName);
        if (canonicalName == null) {
            canonicalName = authorityName;
        }
        return this.getAuthoritiesForUser(canonicalName).contains("ROLE_GUEST");
    }

    @Override
    public Set<String> getAuthorities() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        return this.getAuthoritiesForUser(currentUserName);
    }

    @Override
    public Set<String> getAuthoritiesForUser(String currentUserName) {
        HashSet<String> authorities = new HashSet<String>(64);
        authorities.addAll(this.getContainingAuthorities(null, currentUserName, false));
        Set<String> adminUsers = this.authenticationService.getDefaultAdministratorUserNames();
        Set<String> guestUsers = this.authenticationService.getDefaultGuestUserNames();
        String defaultGuestName = AuthenticationUtil.getGuestUserName();
        if (defaultGuestName != null && defaultGuestName.length() > 0) {
            guestUsers.add(defaultGuestName);
        }
        boolean isAdminUser = this.containsMatch(adminUsers, currentUserName);
        boolean isGuestUser = this.containsMatch(guestUsers, currentUserName);
        if (!isAdminUser && !this.adminGroups.isEmpty()) {
            for (String authority : authorities) {
                if (!this.adminGroups.contains(authority) && !this.adminGroups.contains(this.tenantService.getBaseNameUser(authority))) continue;
                isAdminUser = true;
                break;
            }
        }
        if (!(isAdminUser || isGuestUser || this.guestGroups.isEmpty())) {
            for (String authority : authorities) {
                if (!this.guestGroups.contains(authority) && !this.guestGroups.contains(this.tenantService.getBaseNameUser(authority))) continue;
                isGuestUser = true;
                break;
            }
        }
        if (isAdminUser) {
            authorities.addAll(this.adminSet);
        }
        if (!isGuestUser) {
            authorities.addAll(this.allSet);
        } else {
            authorities.addAll(this.guestSet);
        }
        return authorities;
    }

    @Override
    public Set<String> getAllAuthorities(AuthorityType type) {
        HashSet<String> authorities = new HashSet<String>();
        switch (type) {
            case ADMIN: {
                authorities.addAll(this.adminSet);
                break;
            }
            case EVERYONE: {
                authorities.addAll(this.allSet);
                break;
            }
            case GUEST: {
                authorities.addAll(this.guestSet);
                break;
            }
            case GROUP: {
                authorities.addAll(this.authorityDAO.getAllAuthorities(type));
                break;
            }
            case OWNER: {
                break;
            }
            case ROLE: {
                authorities.addAll(this.authorityDAO.getAllAuthorities(type));
                break;
            }
            case USER: {
                for (NodeRef personRef : this.personService.getAllPeople()) {
                    authorities.add((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME)));
                }
                break;
            }
        }
        return authorities;
    }

    @Override
    public void addAuthority(String parentName, String childName) {
        this.addAuthority(Collections.singleton(parentName), childName);
    }

    @Override
    public void addAuthority(Collection<String> parentNames, String childName) {
        this.authorityDAO.addAuthority(parentNames, childName);
    }

    private boolean containsMatch(Set<String> names, String name) {
        String baseName = this.tenantService.getBaseNameUser(name);
        if (this.tenantService.isEnabled()) {
            for (String candidate : names) {
                if (!this.userNameMatcher.matches(candidate, name) && !this.userNameMatcher.matches(this.tenantService.getBaseNameUser(candidate), baseName)) continue;
                return true;
            }
        } else {
            for (String candidate : names) {
                if (!this.userNameMatcher.matches(candidate, name) && !this.userNameMatcher.matches(candidate, baseName)) continue;
                return true;
            }
        }
        return false;
    }

    private void checkTypeIsMutable(AuthorityType type) {
        if (type == AuthorityType.GROUP || type == AuthorityType.ROLE) {
            return;
        }
        throw new AuthorityException("Trying to modify a fixed authority");
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName) {
        return this.createAuthority(type, shortName, shortName, this.getDefaultZones());
    }

    @Override
    public void deleteAuthority(String name) {
        this.deleteAuthority(name, false);
    }

    @Override
    public void deleteAuthority(String name, boolean cascade) {
        AuthorityType type = AuthorityType.getAuthorityType((String)name);
        this.checkTypeIsMutable(type);
        if (cascade) {
            for (String child : this.getContainedAuthorities(type, name, true)) {
                this.deleteAuthority(child, true);
            }
        }
        this.authorityDAO.deleteAuthority(name);
        this.permissionServiceSPI.deletePermissions(name);
    }

    @Override
    public Set<String> getAllRootAuthorities(AuthorityType type) {
        return this.authorityDAO.findAuthorities(type, null, true, null, null);
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String name, boolean immediate) {
        return this.authorityDAO.getContainedAuthorities(type, name, immediate);
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        return this.authorityDAO.getContainingAuthorities(type, name, immediate);
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
        this.authorityDAO.removeAuthority(parentName, childName);
    }

    @Override
    public boolean authorityExists(String name) {
        return this.authorityDAO.authorityExists(name);
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName, String authorityDisplayName, Set<String> authorityZones) {
        this.checkTypeIsMutable(type);
        String name = this.getName(type, shortName);
        this.authorityDAO.createAuthority(name, authorityDisplayName, authorityZones);
        return name;
    }

    @Override
    public String getAuthorityDisplayName(String name) {
        String displayName = this.authorityDAO.getAuthorityDisplayName(name);
        if (displayName == null) {
            displayName = this.getShortName(name);
        }
        return displayName;
    }

    @Override
    public void setAuthorityDisplayName(String authorityName, String authorityDisplayName) {
        AuthorityType type = AuthorityType.getAuthorityType((String)authorityName);
        this.checkTypeIsMutable(type);
        this.authorityDAO.setAuthorityDisplayName(authorityName, authorityDisplayName);
    }

    @Override
    public Set<String> getAuthorityZones(String name) {
        return this.authorityDAO.getAuthorityZones(name);
    }

    @Override
    public NodeRef getOrCreateZone(String zoneName) {
        return this.authorityDAO.getOrCreateZone(zoneName);
    }

    @Override
    public NodeRef getZone(String zoneName) {
        return this.authorityDAO.getZone(zoneName);
    }

    @Override
    public Set<String> getAllAuthoritiesInZone(String zoneName, AuthorityType type) {
        return this.authorityDAO.getAllAuthoritiesInZone(zoneName, type);
    }

    @Override
    public void addAuthorityToZones(String authorityName, Set<String> zones) {
        this.authorityDAO.addAuthorityToZones(authorityName, zones);
    }

    @Override
    public void removeAuthorityFromZones(String authorityName, Set<String> zones) {
        this.authorityDAO.removeAuthorityFromZones(authorityName, zones);
    }

    @Override
    public Set<String> getDefaultZones() {
        return DEFAULT_ZONES;
    }

    @Override
    public Set<String> getAllRootAuthoritiesInZone(String zoneName, AuthorityType type) {
        return this.authorityDAO.findAuthorities(type, null, true, null, zoneName);
    }

    @Override
    public Set<String> findAuthorities(AuthorityType type, String parentAuthority, boolean immediate, String displayNamePattern, String zoneName) {
        if (type == null || type == AuthorityType.GROUP || type == AuthorityType.USER) {
            return this.authorityDAO.findAuthorities(type, parentAuthority, immediate, displayNamePattern, zoneName);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName(AuthorityType type, String shortName) {
        return this.authorityDAO.getName(type, shortName);
    }

    @Override
    public String getShortName(String name) {
        return this.authorityDAO.getShortName(name);
    }

    static {
        DEFAULT_ZONES.add("APP.DEFAULT");
        DEFAULT_ZONES.add("AUTH.ALF");
    }
}

