/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.security.authority.script.Authority;
import org.alfresco.repo.security.authority.script.ScriptUser;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptGroup
implements Authority,
Serializable {
    private static final long serialVersionUID = 6073732221341647273L;
    private transient AuthorityService authorityService;
    private Authority.ScriptAuthorityType authorityType = Authority.ScriptAuthorityType.GROUP;
    private String shortName;
    private String fullName;
    private String displayName;
    private Set<String> childAuthorityNames;
    private Boolean isAdmin;
    private ScriptUser[] childUsers;
    private ScriptGroup[] childGroups;
    private ScriptGroup[] parentCache;

    public ScriptGroup(String fullName, AuthorityService authorityService) {
        this.authorityService = authorityService;
        this.fullName = fullName;
        this.shortName = authorityService.getShortName(fullName);
        this.displayName = authorityService.getAuthorityDisplayName(fullName);
    }

    public void deleteGroup() {
        this.authorityService.deleteAuthority(this.fullName);
    }

    public void setAuthorityType(Authority.ScriptAuthorityType authorityType) {
        this.authorityType = authorityType;
    }

    @Override
    public Authority.ScriptAuthorityType getAuthorityType() {
        return this.authorityType;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void setDisplayName(String displayName) {
        if (this.displayName != null && !this.displayName.equals(displayName)) {
            this.authorityService.setAuthorityDisplayName(this.fullName, displayName);
        }
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public ScriptUser[] getAllUsers() {
        Set<String> children = this.authorityService.getContainedAuthorities(AuthorityType.USER, this.fullName, false);
        LinkedHashSet<ScriptUser> users = new LinkedHashSet<ScriptUser>();
        for (String authority : children) {
            ScriptUser user = new ScriptUser(authority, this.authorityService);
            users.add(user);
        }
        return users.toArray(new ScriptUser[users.size()]);
    }

    public ScriptGroup[] getAllGroups() {
        Set<String> children = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, this.fullName, false);
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        for (String authority : children) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    private Set<String> getChildAuthorityNames() {
        if (this.childAuthorityNames == null) {
            this.childAuthorityNames = this.authorityService.getContainedAuthorities(null, this.fullName, true);
        }
        return this.childAuthorityNames;
    }

    private Set<String> getChildNamesOfType(AuthorityType type) {
        Set<String> authorities = this.getChildAuthorityNames();
        TreeSet<String> result = new TreeSet<String>();
        for (String authority : authorities) {
            if (AuthorityType.getAuthorityType((String)authority) != type) continue;
            result.add(authority);
        }
        return result;
    }

    public ScriptUser[] getChildUsers() {
        if (this.childUsers == null) {
            Set<String> children = this.getChildNamesOfType(AuthorityType.USER);
            LinkedHashSet<ScriptUser> users = new LinkedHashSet<ScriptUser>();
            for (String authority : children) {
                ScriptUser user = new ScriptUser(authority, this.authorityService);
                users.add(user);
            }
            this.childUsers = users.toArray(new ScriptUser[users.size()]);
        }
        return this.childUsers;
    }

    public ScriptGroup[] getChildGroups() {
        if (this.childGroups == null) {
            Set<String> children = this.getChildNamesOfType(AuthorityType.GROUP);
            LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
            for (String authority : children) {
                ScriptGroup group = new ScriptGroup(authority, this.authorityService);
                groups.add(group);
            }
            this.childGroups = groups.toArray(new ScriptGroup[groups.size()]);
        }
        return this.childGroups;
    }

    public ScriptGroup[] getParentGroups() {
        if (this.parentCache == null) {
            Set<String> parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, this.fullName, true);
            LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
            for (String authority : parents) {
                ScriptGroup group = new ScriptGroup(authority, this.authorityService);
                groups.add(group);
            }
            this.parentCache = groups.toArray(new ScriptGroup[groups.size()]);
        }
        return this.parentCache;
    }

    public ScriptGroup[] getAllParentGroups() {
        Set<String> parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, this.fullName, false);
        LinkedHashSet<ScriptGroup> groups = new LinkedHashSet<ScriptGroup>();
        for (String authority : parents) {
            ScriptGroup group = new ScriptGroup(authority, this.authorityService);
            groups.add(group);
        }
        return groups.toArray(new ScriptGroup[groups.size()]);
    }

    public Authority[] getChildAuthorities() {
        ScriptGroup[] groups = this.getChildGroups();
        ScriptUser[] users = this.getChildUsers();
        Authority[] ret = new Authority[groups.length + users.length];
        System.arraycopy(groups, 0, ret, 0, groups.length);
        System.arraycopy(users, 0, ret, groups.length, users.length);
        return ret;
    }

    public boolean isRootGroup() {
        ScriptGroup[] groups = this.getParentGroups();
        return groups.length == 0;
    }

    public boolean isAdminGroup() {
        if (this.isAdmin == null) {
            this.isAdmin = this.authorityService.isAdminAuthority(this.fullName);
        }
        return this.isAdmin;
    }

    public int getUserCount() {
        return this.getChildNamesOfType(AuthorityType.USER).size();
    }

    public int getGroupCount() {
        return this.getChildNamesOfType(AuthorityType.GROUP).size();
    }

    public ScriptGroup createGroup(String shortName, String displayName) {
        String authorityName = this.authorityService.createAuthority(AuthorityType.GROUP, shortName, displayName, this.authorityService.getDefaultZones());
        this.authorityService.addAuthority(this.fullName, authorityName);
        ScriptGroup childGroup = new ScriptGroup(authorityName, this.authorityService);
        this.clearCaches();
        return childGroup;
    }

    public void removeGroup(String shortName) {
        String fullAuthorityName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        this.authorityService.removeAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public void removeUser(String shortName) {
        String fullAuthorityName = this.authorityService.getName(AuthorityType.USER, shortName);
        this.authorityService.removeAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public void addAuthority(String fullAuthorityName) {
        this.authorityService.addAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    public void removeAuthority(String fullAuthorityName) {
        this.authorityService.removeAuthority(this.fullName, fullAuthorityName);
        this.clearCaches();
    }

    private void clearCaches() {
        this.childUsers = null;
        this.childGroups = null;
        this.childAuthorityNames = null;
    }
}

