/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.lang.reflect.Method;
import org.alfresco.repo.security.permissions.impl.AlwaysProceedMethodInterceptor;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityInterceptor;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PublicServiceAccessService;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class PublicServiceAccessServiceImpl
implements PublicServiceAccessService,
BeanFactoryAware {
    private ListableBeanFactory beanFactory;

    public AccessStatus hasAccess(String publicService, String methodName, Object ... args) {
        Object interceptor = this.beanFactory.getBean(publicService + "_security");
        if (interceptor == null) {
            throw new UnsupportedOperationException("Unknown public service security implementation " + publicService);
        }
        if (interceptor instanceof AlwaysProceedMethodInterceptor) {
            return AccessStatus.ALLOWED;
        }
        if (interceptor instanceof MethodSecurityInterceptor) {
            MethodSecurityInterceptor msi = (MethodSecurityInterceptor)((Object)interceptor);
            ReflectiveMethodInvocation methodInvocation = null;
            Object publicServiceImpl = this.beanFactory.getBean(publicService);
            for (Method method : publicServiceImpl.getClass().getMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != args.length) continue;
                methodInvocation = new ReflectiveMethodInvocation(null, null, method, args, null, null){};
            }
            if (methodInvocation == null) {
                throw new UnsupportedOperationException("Unknown public service security implementation " + publicService + "." + methodName);
            }
            return msi.pre(methodInvocation);
        }
        throw new UnsupportedOperationException("Unknown security interceptor " + interceptor.getClass());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }
}

