/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.sync.ldap;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.repo.security.sync.NodeDescription;
import org.alfresco.repo.security.sync.UserRegistry;
import org.alfresco.repo.security.sync.ldap.LDAPNameResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUserRegistry
implements UserRegistry,
LDAPNameResolver,
InitializingBean,
ActivateableBean {
    private static Log logger = LogFactory.getLog(LDAPUserRegistry.class);
    private static final Pattern PATTERN_RANGE_END = Pattern.compile(";range=[0-9]+-\\*");
    private boolean active = true;
    private boolean enableProgressEstimation = true;
    private String groupQuery = "(objectclass=groupOfNames)";
    private String groupDifferentialQuery = "(&(objectclass=groupOfNames)(!(modifyTimestamp<={0})))";
    private String personQuery = "(objectclass=inetOrgPerson)";
    private String personDifferentialQuery = "(&(objectclass=inetOrgPerson)(!(modifyTimestamp<={0})))";
    private String groupSearchBase;
    private String userSearchBase;
    private String groupIdAttributeName = "cn";
    private String userIdAttributeName = "uid";
    private String memberAttributeName = "member";
    private String modifyTimestampAttributeName = "modifyTimestamp";
    private String groupType = "groupOfNames";
    private String personType = "inetOrgPerson";
    private LDAPInitialDirContextFactory ldapInitialContextFactory;
    private NamespaceService namespaceService;
    private Map<String, String> personAttributeMapping;
    private Map<String, String> personAttributeDefaults = Collections.emptyMap();
    private Map<String, String> groupAttributeMapping;
    private Map<String, String> groupAttributeDefaults = Collections.emptyMap();
    private int queryBatchSize;
    private int attributeBatchSize;
    private boolean errorOnMissingMembers;
    private boolean errorOnDuplicateGID;
    private boolean errorOnMissingGID = false;
    private boolean errorOnMissingUID = false;
    private Pair<String[], Set<QName>> userKeys;
    private Pair<String[], Set<QName>> groupKeys;
    private DateFormat timestampFormat;

    public LDAPUserRegistry() {
        this.setTimestampFormat("yyyyMMddHHmmss'Z'");
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setEnableProgressEstimation(boolean enableProgressEstimation) {
        this.enableProgressEstimation = enableProgressEstimation;
    }

    public void setGroupIdAttributeName(String groupIdAttributeName) {
        this.groupIdAttributeName = groupIdAttributeName;
    }

    public void setGroupQuery(String groupQuery) {
        this.groupQuery = groupQuery;
    }

    public void setGroupDifferentialQuery(String groupDifferentialQuery) {
        this.groupDifferentialQuery = groupDifferentialQuery;
    }

    public void setPersonQuery(String personQuery) {
        this.personQuery = personQuery;
    }

    public void setPersonDifferentialQuery(String personDifferentialQuery) {
        this.personDifferentialQuery = personDifferentialQuery;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public void setMemberAttribute(String memberAttribute) {
        this.memberAttributeName = memberAttribute;
    }

    public void setPersonType(String personType) {
        this.personType = personType;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public void setUserIdAttributeName(String userIdAttributeName) {
        this.userIdAttributeName = userIdAttributeName;
    }

    public void setModifyTimestampAttributeName(String modifyTimestampAttributeName) {
        this.modifyTimestampAttributeName = modifyTimestampAttributeName;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = new SimpleDateFormat(timestampFormat, Locale.UK);
        this.timestampFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setErrorOnMissingMembers(boolean errorOnMissingMembers) {
        this.errorOnMissingMembers = errorOnMissingMembers;
    }

    public void setErrorOnMissingGID(boolean errorOnMissingGID) {
        this.errorOnMissingGID = errorOnMissingGID;
    }

    public void setErrorOnMissingUID(boolean errorOnMissingUID) {
        this.errorOnMissingUID = errorOnMissingUID;
    }

    public void setErrorOnDuplicateGID(boolean errorOnDuplicateGID) {
        this.errorOnDuplicateGID = errorOnDuplicateGID;
    }

    public void setLDAPInitialDirContextFactory(LDAPInitialDirContextFactory ldapInitialDirContextFactory) {
        this.ldapInitialContextFactory = ldapInitialDirContextFactory;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPersonAttributeDefaults(Map<String, String> personAttributeDefaults) {
        this.personAttributeDefaults = personAttributeDefaults;
    }

    public void setPersonAttributeMapping(Map<String, String> personAttributeMapping) {
        this.personAttributeMapping = personAttributeMapping;
    }

    public void setGroupAttributeDefaults(Map<String, String> groupAttributeDefaults) {
        this.groupAttributeDefaults = groupAttributeDefaults;
    }

    public void setGroupAttributeMapping(Map<String, String> groupAttributeMapping) {
        this.groupAttributeMapping = groupAttributeMapping;
    }

    public void setQueryBatchSize(int queryBatchSize) {
        this.queryBatchSize = queryBatchSize;
    }

    public void setAttributeBatchSize(int attributeBatchSize) {
        this.attributeBatchSize = attributeBatchSize;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.personAttributeMapping == null) {
            this.personAttributeMapping = new HashMap<String, String>(5);
        }
        this.personAttributeMapping.put(ContentModel.PROP_USERNAME.toPrefixString((NamespacePrefixResolver)this.namespaceService), this.userIdAttributeName);
        this.userKeys = this.initKeys(this.personAttributeMapping, new String[0]);
        if (this.groupAttributeMapping == null) {
            this.groupAttributeMapping = new HashMap<String, String>(5);
        }
        this.groupAttributeMapping.put(ContentModel.PROP_AUTHORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService), this.groupIdAttributeName);
        this.groupKeys = this.initKeys(this.groupAttributeMapping, this.attributeBatchSize > 0 ? this.memberAttributeName + ";range=0-" + (this.attributeBatchSize - 1) : this.memberAttributeName);
    }

    @Override
    public Set<QName> getPersonMappedProperties() {
        return (Set)this.userKeys.getSecond();
    }

    @Override
    public Collection<NodeDescription> getPersons(Date modifiedSince) {
        return new PersonCollection(modifiedSince);
    }

    @Override
    public Collection<String> getPersonNames() {
        final LinkedList<String> personNames = new LinkedList<String>();
        this.processQuery(new SearchCallback(){

            public void process(SearchResult result) throws NamingException, ParseException {
                Attribute nameAttribute = result.getAttributes().get(LDAPUserRegistry.this.userIdAttributeName);
                if (nameAttribute == null) {
                    if (LDAPUserRegistry.this.errorOnMissingUID) {
                        throw new AlfrescoRuntimeException("User missing user id attribute DN =" + result.getNameInNamespace() + "  att = " + LDAPUserRegistry.this.userIdAttributeName);
                    }
                    logger.warn((Object)("User missing user id attribute DN =" + result.getNameInNamespace() + "  att = " + LDAPUserRegistry.this.userIdAttributeName));
                } else {
                    personNames.add((String)nameAttribute.get());
                }
            }

            public void close() throws NamingException {
            }
        }, this.userSearchBase, this.personQuery, new String[]{this.userIdAttributeName});
        return personNames;
    }

    @Override
    public Collection<String> getGroupNames() {
        final LinkedList<String> groupNames = new LinkedList<String>();
        this.processQuery(new SearchCallback(){

            public void process(SearchResult result) throws NamingException, ParseException {
                Attribute nameAttribute = result.getAttributes().get(LDAPUserRegistry.this.groupIdAttributeName);
                if (nameAttribute == null) {
                    if (LDAPUserRegistry.this.errorOnMissingGID) {
                        throw new AlfrescoRuntimeException("NodeDescription returned by group search does not have mandatory group id attribute " + result.getNameInNamespace());
                    }
                    logger.warn((Object)("Missing GID on " + result.getNameInNamespace()));
                } else {
                    String authority = "GROUP_" + (String)nameAttribute.get();
                    groupNames.add(authority);
                }
            }

            public void close() throws NamingException {
            }
        }, this.groupSearchBase, this.groupQuery, new String[]{this.groupIdAttributeName});
        return groupNames;
    }

    @Override
    public Collection<NodeDescription> getGroups(Date modifiedSince) {
        LdapName userDistinguishedNamePrefix;
        LdapName groupDistinguishedNamePrefix;
        try {
            groupDistinguishedNamePrefix = LDAPUserRegistry.fixedLdapName(this.groupSearchBase.toLowerCase());
            userDistinguishedNamePrefix = LDAPUserRegistry.fixedLdapName(this.userSearchBase.toLowerCase());
        }
        catch (InvalidNameException e) {
            throw new AlfrescoRuntimeException("User and group import failed", (Throwable)e);
        }
        final boolean disjoint = !groupDistinguishedNamePrefix.startsWith(userDistinguishedNamePrefix) && !userDistinguishedNamePrefix.startsWith(groupDistinguishedNamePrefix);
        String query = modifiedSince == null ? this.groupQuery : MessageFormat.format(this.groupDifferentialQuery, this.timestampFormat.format(modifiedSince));
        final TreeMap lookup = new TreeMap();
        this.processQuery(new SearchCallback(){
            private DirContext ctx;
            {
                this.ctx = LDAPUserRegistry.this.ldapInitialContextFactory.getDefaultIntialDirContext();
            }

            public void process(SearchResult result) throws NamingException, ParseException {
                Attributes attributes = result.getAttributes();
                Attribute gidAttribute = attributes.get(LDAPUserRegistry.this.groupIdAttributeName);
                if (gidAttribute == null) {
                    if (LDAPUserRegistry.this.errorOnMissingGID) {
                        throw new AlfrescoRuntimeException("NodeDescription returned by group search does not have mandatory group id attribute " + attributes);
                    }
                    logger.warn((Object)("Missing GID on " + attributes));
                    return;
                }
                String groupShortName = gidAttribute.get(0).toString();
                String gid = "GROUP_" + groupShortName;
                NodeDescription group = (NodeDescription)lookup.get(gid);
                if (group == null) {
                    group = LDAPUserRegistry.this.mapToNode(LDAPUserRegistry.this.groupAttributeMapping, LDAPUserRegistry.this.groupAttributeDefaults, result);
                    group.getProperties().put(ContentModel.PROP_AUTHORITY_NAME, gid);
                    lookup.put(gid, group);
                } else {
                    if (LDAPUserRegistry.this.errorOnDuplicateGID) {
                        throw new AlfrescoRuntimeException("Duplicate group id found for " + gid);
                    }
                    logger.warn((Object)("Duplicate gid found for " + gid + " -> merging definitions"));
                }
                Set<String> childAssocs = group.getChildAssociations();
                Attribute memAttribute = LDAPUserRegistry.this.getRangeRestrictedAttribute(attributes, LDAPUserRegistry.this.memberAttributeName);
                int nextStart = LDAPUserRegistry.this.attributeBatchSize;
                while (memAttribute != null) {
                    for (int i = 0; i < memAttribute.size(); ++i) {
                        String attribute = (String)memAttribute.get(i);
                        if (attribute == null || attribute.length() <= 0) continue;
                        try {
                            block24: {
                                Attribute nameAttribute;
                                LdapName distinguishedNameForComparison = LDAPUserRegistry.fixedLdapName(attribute.toLowerCase());
                                if (disjoint) {
                                    LdapName distinguishedName = LDAPUserRegistry.fixedLdapName(attribute);
                                    Attributes nameAttributes = distinguishedName.getRdn(distinguishedName.size() - 1).toAttributes();
                                    if (distinguishedNameForComparison.startsWith(userDistinguishedNamePrefix) && (nameAttribute = nameAttributes.get(LDAPUserRegistry.this.userIdAttributeName)) != null) {
                                        childAssocs.add((String)nameAttribute.get());
                                        continue;
                                    }
                                    if (distinguishedNameForComparison.startsWith(groupDistinguishedNamePrefix) && (nameAttribute = nameAttributes.get(LDAPUserRegistry.this.groupIdAttributeName)) != null) {
                                        childAssocs.add("GROUP_" + nameAttribute.get());
                                        continue;
                                    }
                                }
                                if (distinguishedNameForComparison.startsWith(userDistinguishedNamePrefix) || distinguishedNameForComparison.startsWith(groupDistinguishedNamePrefix)) {
                                    try {
                                        Attributes childAttributes = this.ctx.getAttributes(LDAPUserRegistry.jndiName(attribute), new String[]{"objectclass", LDAPUserRegistry.this.groupIdAttributeName, LDAPUserRegistry.this.userIdAttributeName});
                                        Attribute objectClass = childAttributes.get("objectclass");
                                        if (LDAPUserRegistry.this.hasAttributeValue(objectClass, LDAPUserRegistry.this.personType)) {
                                            nameAttribute = childAttributes.get(LDAPUserRegistry.this.userIdAttributeName);
                                            if (nameAttribute == null) {
                                                if (LDAPUserRegistry.this.errorOnMissingUID) {
                                                    throw new AlfrescoRuntimeException("User missing user id attribute DN =" + attribute + "  att = " + LDAPUserRegistry.this.userIdAttributeName);
                                                }
                                                logger.warn((Object)("User missing user id attribute DN =" + attribute + "  att = " + LDAPUserRegistry.this.userIdAttributeName));
                                                continue;
                                            }
                                            childAssocs.add((String)nameAttribute.get());
                                            continue;
                                        }
                                        if (LDAPUserRegistry.this.hasAttributeValue(objectClass, LDAPUserRegistry.this.groupType)) {
                                            nameAttribute = childAttributes.get(LDAPUserRegistry.this.groupIdAttributeName);
                                            if (nameAttribute == null) {
                                                if (LDAPUserRegistry.this.errorOnMissingGID) {
                                                    throw new AlfrescoRuntimeException("Group returned by group search does not have mandatory group id attribute " + attributes);
                                                }
                                                logger.warn((Object)("Missing GID on " + childAttributes));
                                                continue;
                                            }
                                            childAssocs.add("GROUP_" + nameAttribute.get());
                                        }
                                        break block24;
                                    }
                                    catch (NamingException e) {
                                        if (LDAPUserRegistry.this.errorOnMissingMembers) {
                                            throw new AlfrescoRuntimeException("Failed to resolve member of group '" + groupShortName + "' with distinguished name: " + attribute, (Throwable)e);
                                        }
                                        logger.warn((Object)("Failed to resolve member of group '" + groupShortName + "' with distinguished name: " + attribute), (Throwable)e);
                                    }
                                    continue;
                                }
                            }
                            if (LDAPUserRegistry.this.errorOnMissingMembers) {
                                throw new AlfrescoRuntimeException("Failed to resolve member of group '" + groupShortName + "' with distinguished name: " + attribute);
                            }
                            logger.warn((Object)("Failed to resolve member of group '" + groupShortName + "' with distinguished name: " + attribute));
                            continue;
                        }
                        catch (InvalidNameException e) {
                            childAssocs.add(attribute);
                        }
                    }
                    if (nextStart > 0 && !PATTERN_RANGE_END.matcher(memAttribute.getID().toLowerCase()).find()) {
                        Attributes childAttributes = this.ctx.getAttributes(LDAPUserRegistry.jndiName(result.getNameInNamespace()), new String[]{LDAPUserRegistry.this.memberAttributeName + ";range=" + nextStart + '-' + (nextStart + LDAPUserRegistry.this.attributeBatchSize - 1)});
                        memAttribute = LDAPUserRegistry.this.getRangeRestrictedAttribute(childAttributes, LDAPUserRegistry.this.memberAttributeName);
                        nextStart += LDAPUserRegistry.this.attributeBatchSize;
                        continue;
                    }
                    memAttribute = null;
                }
            }

            public void close() throws NamingException {
                this.ctx.close();
            }
        }, this.groupSearchBase, query, (String[])this.groupKeys.getFirst());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + lookup.size()));
        }
        return lookup.values();
    }

    @Override
    public String resolveDistinguishedName(String userId) throws AuthenticationException {
        InitialDirContext ctx;
        block8: {
            String string;
            block9: {
                SearchControls userSearchCtls = new SearchControls();
                userSearchCtls.setSearchScope(2);
                userSearchCtls.setReturningAttributes(new String[0]);
                ctx = null;
                ctx = this.ldapInitialContextFactory.getDefaultIntialDirContext();
                NamingEnumeration<SearchResult> searchResults = ctx.search(this.userSearchBase, "(&" + this.personQuery + "(" + this.userIdAttributeName + "=" + userId + "))", userSearchCtls);
                if (!searchResults.hasMore()) break block8;
                string = searchResults.next().getNameInNamespace();
                Object var7_7 = null;
                if (ctx == null) break block9;
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
            return string;
        }
        try {
            try {
                throw new AuthenticationException("Failed to resolve user: " + userId);
            }
            catch (NamingException e) {
                throw new AlfrescoRuntimeException("Failed to resolve user ID: " + userId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            block10: {
                Object var7_8 = null;
                if (ctx == null) break block10;
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
            throw throwable;
        }
    }

    private Pair<String[], Set<QName>> initKeys(Map<String, String> attributeMapping, String ... extraAttibutes) {
        TreeSet<String> attributeSet = new TreeSet<String>();
        attributeSet.addAll(Arrays.asList(extraAttibutes));
        attributeSet.add(this.modifyTimestampAttributeName);
        for (String attribute : attributeMapping.values()) {
            if (attribute == null) continue;
            attributeSet.add(attribute);
        }
        String[] attributeNames = new String[attributeSet.size()];
        attributeSet.toArray(attributeNames);
        HashSet<QName> qnames = new HashSet<QName>(attributeMapping.size() * 2);
        for (String property : attributeMapping.keySet()) {
            qnames.add(QName.createQName((String)property, (NamespacePrefixResolver)this.namespaceService));
        }
        return new Pair((Object)attributeNames, qnames);
    }

    private NodeDescription mapToNode(Map<String, String> attributeMapping, Map<String, String> attributeDefaults, SearchResult result) throws NamingException {
        NodeDescription nodeDescription = new NodeDescription(result.getNameInNamespace());
        Attributes ldapAttributes = result.getAttributes();
        Attribute modifyTimestamp = ldapAttributes.get(this.modifyTimestampAttributeName);
        if (modifyTimestamp != null) {
            try {
                nodeDescription.setLastModified(this.timestampFormat.parse(modifyTimestamp.get().toString()));
            }
            catch (ParseException e) {
                throw new AlfrescoRuntimeException("Failed to parse timestamp.", (Throwable)e);
            }
        }
        PropertyMap properties = nodeDescription.getProperties();
        for (String key : attributeMapping.keySet()) {
            QName keyQName = QName.createQName((String)key, (NamespacePrefixResolver)this.namespaceService);
            String attributeName = attributeMapping.get(key);
            if (attributeName != null) {
                Attribute attribute = ldapAttributes.get(attributeName);
                if (attribute != null) {
                    String value = (String)attribute.get(0);
                    if (value == null) continue;
                    properties.put(keyQName, value);
                    continue;
                }
                String defaultValue = attributeDefaults.get(key);
                if (defaultValue == null) continue;
                properties.put(keyQName, defaultValue);
                continue;
            }
            String defaultValue = attributeDefaults.get(key);
            if (defaultValue == null) continue;
            properties.put(keyQName, defaultValue);
        }
        return nodeDescription;
    }

    private static Name jndiName(String dn) throws InvalidNameException {
        CompositeName n = new CompositeName();
        n.add(dn);
        return n;
    }

    private static LdapName fixedLdapName(String dn) throws InvalidNameException {
        if (dn.indexOf(92) == -1) {
            return new LdapName(dn);
        }
        StringBuilder fixed = new StringBuilder(dn.length());
        int length = dn.length();
        for (int i = 0; i < length; ++i) {
            char c = dn.charAt(i);
            if (c == '\\') {
                char c2;
                char c1;
                if (i + 2 < length && Character.isLetterOrDigit(c1 = dn.charAt(i + 1)) && Character.isLetterOrDigit(c2 = dn.charAt(i + 2))) {
                    if (c1 == '2' && c2 == '0') {
                        fixed.append("\\ ");
                    } else if (c1 == '0' && c2 == 'D') {
                        fixed.append("\\\r");
                    } else {
                        fixed.append(dn, i, i + 3);
                    }
                    i += 2;
                    continue;
                }
                if (i + 1 < length) {
                    fixed.append(dn, i, i + 2);
                    ++i;
                    continue;
                }
                fixed.append(c);
                continue;
            }
            fixed.append(c);
        }
        return new LdapName(fixed.toString());
    }

    /*
     * Loose catch block
     */
    private void processQuery(SearchCallback callback, String searchBase, String query, String[] returningAttributes) {
        block15: {
            NamingException e2;
            InitialDirContext ctx;
            block14: {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                searchControls.setReturningAttributes(returningAttributes);
                ctx = null;
                ctx = this.ldapInitialContextFactory.getDefaultIntialDirContext(this.queryBatchSize);
                do {
                    NamingEnumeration<SearchResult> searchResults = ctx.search(searchBase, query, searchControls);
                    while (searchResults.hasMore()) {
                        SearchResult result = searchResults.next();
                        callback.process(result);
                    }
                } while (this.ldapInitialContextFactory.hasNextPage(ctx, this.queryBatchSize));
                Object var10_11 = null;
                if (ctx == null) break block14;
                try {
                    ctx.close();
                }
                catch (NamingException e2) {
                    // empty catch block
                }
            }
            try {
                callback.close();
            }
            catch (NamingException e2) {}
            break block15;
            {
                catch (NamingException e3) {
                    throw new AlfrescoRuntimeException("User and group import failed", (Throwable)e3);
                }
                catch (ParseException e4) {
                    throw new AlfrescoRuntimeException("User and group import failed", (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e2) {
                        // empty catch block
                    }
                }
                try {
                    callback.close();
                }
                catch (NamingException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private boolean hasAttributeValue(Attribute attribute, String value) throws NamingException {
        if (attribute != null) {
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMore()) {
                try {
                    if (!value.equalsIgnoreCase((String)values.next())) continue;
                    return true;
                }
                catch (ClassCastException e) {
                }
            }
        }
        return false;
    }

    private Attribute getRangeRestrictedAttribute(Attributes attributes, String attributeName) throws NamingException {
        Attribute unrestricted = attributes.get(attributeName);
        if (unrestricted != null) {
            return unrestricted;
        }
        NamingEnumeration<? extends Attribute> i = attributes.getAll();
        String searchString = attributeName.toLowerCase() + ';';
        while (i.hasMore()) {
            Attribute attribute = i.next();
            if (!attribute.getID().toLowerCase().startsWith(searchString)) continue;
            return attribute;
        }
        return null;
    }

    protected static interface SearchCallback {
        public void process(SearchResult var1) throws NamingException, ParseException;

        public void close() throws NamingException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PersonCollection
    extends AbstractCollection<NodeDescription> {
        private String query;
        private int totalEstimatedSize;

        public PersonCollection(Date modifiedSince) {
            this.query = modifiedSince == null ? LDAPUserRegistry.this.personQuery : MessageFormat.format(LDAPUserRegistry.this.personDifferentialQuery, LDAPUserRegistry.this.timestampFormat.format(modifiedSince));
            if (LDAPUserRegistry.this.enableProgressEstimation) {
                class CountingCallback
                implements SearchCallback {
                    int count;

                    CountingCallback() {
                    }

                    public void process(SearchResult result) throws NamingException, ParseException {
                        ++this.count;
                    }

                    public void close() throws NamingException {
                    }
                }
                CountingCallback countingCallback = new CountingCallback();
                LDAPUserRegistry.this.processQuery(countingCallback, LDAPUserRegistry.this.userSearchBase, this.query, new String[0]);
                this.totalEstimatedSize = countingCallback.count;
            } else {
                this.totalEstimatedSize = -1;
            }
        }

        @Override
        public Iterator<NodeDescription> iterator() {
            return new PersonIterator();
        }

        @Override
        public int size() {
            return this.totalEstimatedSize;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PersonIterator
        implements Iterator<NodeDescription> {
            private InitialDirContext ctx;
            private SearchControls userSearchCtls;
            private NamingEnumeration<SearchResult> searchResults;
            private HashSet<String> uids;
            private NodeDescription next;

            /*
             * Loose catch block
             */
            public PersonIterator() {
                block8: {
                    this.uids = new HashSet();
                    this.ctx = LDAPUserRegistry.this.ldapInitialContextFactory.getDefaultIntialDirContext(LDAPUserRegistry.this.queryBatchSize);
                    this.userSearchCtls = new SearchControls();
                    this.userSearchCtls.setSearchScope(2);
                    this.userSearchCtls.setReturningAttributes((String[])LDAPUserRegistry.this.userKeys.getFirst());
                    this.next = this.fetchNext();
                    Object var4_2 = null;
                    if (this.searchResults != null) break block8;
                    try {
                        this.ctx.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.ctx = null;
                    {
                        break block8;
                        catch (NamingException e) {
                            throw new AlfrescoRuntimeException("Failed to import people.", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        if (this.searchResults == null) {
                            try {
                                this.ctx.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.ctx = null;
                        }
                        throw throwable;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public NodeDescription next() {
                if (this.next == null) {
                    throw new IllegalStateException();
                }
                NodeDescription current = this.next;
                try {
                    this.next = this.fetchNext();
                }
                catch (NamingException e) {
                    throw new AlfrescoRuntimeException("Failed to import people.", (Throwable)e);
                }
                return current;
            }

            private NodeDescription fetchNext() throws NamingException {
                boolean readyForNextPage;
                do {
                    boolean bl = readyForNextPage = this.searchResults == null;
                    while (!readyForNextPage && this.searchResults.hasMore()) {
                        SearchResult result = this.searchResults.next();
                        Attributes attributes = result.getAttributes();
                        Attribute uidAttribute = attributes.get(LDAPUserRegistry.this.userIdAttributeName);
                        if (uidAttribute == null) {
                            if (LDAPUserRegistry.this.errorOnMissingUID) {
                                throw new AlfrescoRuntimeException("User returned by user search does not have mandatory user id attribute " + attributes);
                            }
                            logger.warn((Object)("User returned by user search does not have mandatory user id attribute " + attributes));
                            continue;
                        }
                        String uid = (String)uidAttribute.get(0);
                        if (this.uids.contains(uid)) {
                            logger.warn((Object)("Duplicate uid found - there will be more than one person object for this user - " + uid));
                        }
                        this.uids.add(uid);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Adding user for " + uid));
                        }
                        return LDAPUserRegistry.this.mapToNode(LDAPUserRegistry.this.personAttributeMapping, LDAPUserRegistry.this.personAttributeDefaults, result);
                    }
                    if (!readyForNextPage) {
                        readyForNextPage = LDAPUserRegistry.this.ldapInitialContextFactory.hasNextPage(this.ctx, LDAPUserRegistry.this.queryBatchSize);
                    }
                    if (!readyForNextPage) continue;
                    this.searchResults = this.ctx.search(LDAPUserRegistry.this.userSearchBase, PersonCollection.this.query, this.userSearchCtls);
                } while (readyForNextPage);
                this.searchResults.close();
                this.searchResults = null;
                this.ctx.close();
                this.ctx = null;
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

