/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteInfoImpl;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteServiceImpl
implements SiteService,
SiteModel {
    private static Log logger = LogFactory.getLog(SiteServiceImpl.class);
    public static final StoreRef SITE_STORE = new StoreRef("workspace://SpacesStore");
    private static final String ACTIVITY_TOOL = "siteService";
    private static final String SITE_PREFIX = "site_";
    private static final String GROUP_SITE_PREFIX = "GROUP_site_";
    private static final int GROUP_PREFIX_LENGTH = "GROUP_".length();
    private static final int GROUP_SITE_PREFIX_LENGTH = "GROUP_site_".length();
    private Map<String, NodeRef> siteHomeRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private Map<String, NodeRef> siteNodeRefs = new ConcurrentHashMap<String, NodeRef>(256);
    private String sitesXPath;
    private static final String MSG_UNABLE_TO_CREATE = "site_service.unable_to_create";
    private static final String MSG_VISIBILITY_GROUP_MISSING = "site_service.visibility_group_missing";
    private static final String MSG_CAN_NOT_UPDATE = "site_service.can_not_update";
    private static final String MSG_CAN_NOT_DELETE = "site_service.can_not_delete";
    private static final String MSG_SITE_NO_EXIST = "site_service.site_no_exist";
    private static final String MSG_CAN_NOT_REMOVE_MSHIP = "site_service.can_not_reomve_memebership";
    private static final String MSG_DO_NOT_CHANGE_MGR = "site_service.do_not_change_manager";
    private static final String MSG_CAN_NOT_CHANGE_MSHIP = "site_service.can_not_change_memebership";
    private static final String MSG_SITE_CONTAINER_NOT_FOLDER = "site_service.site_container_not_folder";
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private PermissionService permissionService;
    private ActivityService activityService;
    private PersonService personService;
    private AuthenticationContext authenticationContext;
    private TaggingService taggingService;
    private AuthorityService authorityService;
    private DictionaryService dictionaryService;
    private TenantService tenantService;
    private TenantAdminService tenantAdminService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private Comparator<String> roleComparator;
    private SysAdminParams sysAdminParams;

    public void setSitesXPath(String sitesXPath) {
        this.sitesXPath = sitesXPath;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setRoleComparator(Comparator<String> roleComparator) {
        this.roleComparator = roleComparator;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public Comparator<String> getRoleComparator() {
        return this.roleComparator;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationContext", (Object)this.authenticationContext);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"activityService", (Object)this.activityService);
        PropertyCheck.mandatory((Object)this, (String)"taggingService", (Object)this.taggingService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"sitesXPath", (Object)this.sitesXPath);
    }

    @Override
    public boolean hasCreateSitePermissions() {
        NodeRef siteRoot = this.getSiteRoot();
        if (siteRoot == null) {
            throw new SiteServiceException("No root sites folder exists");
        }
        boolean result = this.permissionService.hasPermission(siteRoot, "Contributor").equals((Object)AccessStatus.ALLOWED);
        return result;
    }

    @Override
    public SiteInfo createSite(String sitePreset, String passedShortName, String title, String description, boolean isPublic) {
        SiteVisibility visibility = SiteVisibility.PRIVATE;
        if (isPublic) {
            visibility = SiteVisibility.PUBLIC;
        }
        return this.createSite(sitePreset, passedShortName, title, description, visibility);
    }

    @Override
    public SiteInfo createSite(String sitePreset, String passedShortName, String title, String description, final SiteVisibility visibility) {
        final String shortName = passedShortName.replaceAll(" ", "");
        NodeRef existingSite = this.getSiteNodeRef(shortName);
        if (existingSite != null) {
            throw new SiteServiceException(MSG_UNABLE_TO_CREATE, new Object[]{shortName});
        }
        NodeRef siteParent = this.getSiteParent(shortName);
        if (siteParent == null) {
            throw new SiteServiceException("No root sites folder exists");
        }
        PropertyMap properties = new PropertyMap(4);
        properties.put(ContentModel.PROP_NAME, shortName);
        properties.put(SiteModel.PROP_SITE_PRESET, sitePreset);
        properties.put(SiteModel.PROP_SITE_VISIBILITY, visibility.toString());
        properties.put(ContentModel.PROP_TITLE, title);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        final NodeRef siteNodeRef = this.nodeService.createNode(siteParent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)shortName), SiteModel.TYPE_SITE, (Map)properties).getChildRef();
        this.taggingService.addTagScope(siteNodeRef);
        this.permissionService.setInheritParentPermissions(siteNodeRef, false);
        final String currentUser = this.authenticationContext.getCurrentUserName();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public String doWork() throws Exception {
                HashSet<String> shareZones = new HashSet<String>(2, 1.0f);
                shareZones.add("APP.SHARE");
                shareZones.add("AUTH.ALF");
                String siteGroup = SiteServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, SiteServiceImpl.this.getSiteGroup(shortName, false), shortName, shareZones);
                Set permissions = SiteServiceImpl.this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
                for (String permission : permissions) {
                    String permissionGroup = SiteServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, SiteServiceImpl.this.getSiteRoleGroup(shortName, permission, false), shortName, shareZones);
                    SiteServiceImpl.this.authorityService.addAuthority(siteGroup, permissionGroup);
                    SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, permissionGroup, permission, true);
                }
                if (SiteVisibility.PUBLIC.equals((Object)visibility)) {
                    String sitePublicGroup = SiteServiceImpl.this.sysAdminParams.getSitePublicGroup();
                    boolean groupExists = SiteServiceImpl.this.authorityService.authorityExists(sitePublicGroup);
                    if (!"GROUP_EVERYONE".equals(sitePublicGroup) && !groupExists) {
                        throw new SiteServiceException(SiteServiceImpl.MSG_VISIBILITY_GROUP_MISSING, new Object[]{sitePublicGroup});
                    }
                    SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, sitePublicGroup, "SiteConsumer", true);
                } else if (SiteVisibility.MODERATED.equals((Object)visibility)) {
                    SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, "GROUP_EVERYONE", "SiteConsumer", true);
                }
                SiteServiceImpl.this.permissionService.setPermission(siteNodeRef, "GROUP_EVERYONE", "ReadPermissions", true);
                SiteServiceImpl.this.authorityService.addAuthority(SiteServiceImpl.this.getSiteRoleGroup(shortName, "SiteManager", true), currentUser);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        Map<QName, Serializable> customProperties = this.getSiteCustomProperties(siteNodeRef);
        SiteInfoImpl siteInfo = new SiteInfoImpl(sitePreset, shortName, title, description, visibility, customProperties, siteNodeRef);
        return siteInfo;
    }

    private Map<QName, Serializable> getSiteCustomProperties(Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> customProperties = new HashMap<QName, Serializable>(4);
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            if (!entry.getKey().getNamespaceURI().equals("http://www.alfresco.org/model/sitecustomproperty/1.0")) continue;
            customProperties.put(entry.getKey(), entry.getValue());
        }
        return customProperties;
    }

    private Map<QName, Serializable> getSiteCustomProperties(NodeRef siteNodeRef) {
        HashMap<QName, Serializable> customProperties = new HashMap<QName, Serializable>(4);
        Map properties = this.nodeService.getProperties(siteNodeRef);
        for (Map.Entry entry : properties.entrySet()) {
            if (!((QName)entry.getKey()).getNamespaceURI().equals("http://www.alfresco.org/model/sitecustomproperty/1.0")) continue;
            customProperties.put((QName)entry.getKey(), (Serializable)entry.getValue());
        }
        return customProperties;
    }

    @Override
    public String getSiteGroup(String shortName) {
        return this.getSiteGroup(shortName, true);
    }

    @Override
    public String getSiteRoleGroup(String shortName, String role) {
        return this.getSiteRoleGroup(shortName, role, true);
    }

    public String getSiteGroup(String shortName, boolean withGroupPrefix) {
        StringBuffer sb = new StringBuffer(64);
        if (withGroupPrefix) {
            sb.append("GROUP_");
        }
        sb.append(SITE_PREFIX);
        sb.append(shortName);
        return sb.toString();
    }

    public String getSiteRoleGroup(String shortName, String permission, boolean withGroupPrefix) {
        return this.getSiteGroup(shortName, withGroupPrefix) + '_' + permission;
    }

    private NodeRef getSiteParent(String shortName) {
        return this.getSiteRoot();
    }

    private NodeRef getSiteRoot() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        NodeRef siteHomeRef = this.siteHomeRefs.get(tenantDomain);
        if (siteHomeRef == null) {
            siteHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return SiteServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            NodeRef result = null;
                            NodeRef rootNodeRef = SiteServiceImpl.this.nodeService.getRootNode(SITE_STORE);
                            List results = SiteServiceImpl.this.searchService.selectNodes(rootNodeRef, SiteServiceImpl.this.sitesXPath, null, (NamespacePrefixResolver)SiteServiceImpl.this.namespaceService, false, "xpath");
                            if (results.size() != 0) {
                                result = (NodeRef)results.get(0);
                            }
                            return result;
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            this.siteHomeRefs.put(tenantDomain, siteHomeRef);
        }
        return siteHomeRef;
    }

    @Override
    public List<SiteInfo> listSites(String nameFilter, String sitePresetFilter) {
        return this.listSites(nameFilter, sitePresetFilter, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SiteInfo> listSites(String nameFilter, String sitePresetFilter, int size) {
        ArrayList<SiteInfo> result;
        block7: {
            NodeRef siteRoot = this.getSiteRoot();
            if (siteRoot == null) {
                result = new ArrayList<SiteInfo>(0);
            } else {
                if (nameFilter != null && nameFilter.length() != 0) {
                    String escNameFilter = LuceneQueryParser.escape((String)nameFilter.replace('\"', ' '));
                    QueryParameterDefinition[] params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_NAME, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, escNameFilter), new QueryParameterDefImpl(ContentModel.PROP_TITLE, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, escNameFilter), new QueryParameterDefImpl(ContentModel.PROP_DESCRIPTION, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, escNameFilter)};
                    StringBuilder query = new StringBuilder(128);
                    query.append("+PARENT:\"").append(siteRoot.toString()).append("\" +(@cm\\:name:\"*${cm:name}*\"").append(" @cm\\:title:\"${cm:title}\"").append(" @cm\\:description:\"${cm:description}\")");
                    ResultSet results = this.searchService.query(siteRoot.getStoreRef(), "lucene", query.toString(), params);
                    try {
                        result = new ArrayList(results.length());
                        for (NodeRef site : results.getNodeRefs()) {
                            QName siteClassName = this.nodeService.getType(site);
                            if (!this.dictionaryService.isSubClass(siteClassName, SiteModel.TYPE_SITE)) continue;
                            result.add(this.createSiteInfo(site));
                            if (result.size() != size) continue;
                            break;
                        }
                        Object var14_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        results.close();
                        throw throwable;
                    }
                    results.close();
                    {
                        break block7;
                    }
                }
                List assocs = this.nodeService.getChildAssocs(siteRoot, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                result = new ArrayList(assocs.size());
                for (ChildAssociationRef assoc : assocs) {
                    NodeRef site = assoc.getChildRef();
                    QName siteClassName = this.nodeService.getType(site);
                    if (!this.dictionaryService.isSubClass(siteClassName, SiteModel.TYPE_SITE)) continue;
                    result.add(this.createSiteInfo(site));
                    if (result.size() != size) continue;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public List<SiteInfo> listSites(final String userName) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantUser(userName)) {
            String tenantDomain = this.tenantService.getUserDomain(userName);
            return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<SiteInfo>>(){

                public List<SiteInfo> doWork() throws Exception {
                    return SiteServiceImpl.this.listSitesImpl(userName);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.listSitesImpl(userName);
    }

    private List<SiteInfo> listSitesImpl(String userName) {
        ArrayList<SiteInfo> result = null;
        Set<String> groups = this.authorityService.getContainingAuthorities(null, userName, false);
        HashSet<String> siteNames = new HashSet<String>(groups.size());
        for (String group : groups) {
            if (!group.startsWith(GROUP_SITE_PREFIX)) continue;
            int roleIndex = group.lastIndexOf(95);
            String siteName = roleIndex + 1 <= GROUP_SITE_PREFIX_LENGTH ? group.substring(GROUP_SITE_PREFIX_LENGTH) : group.substring(GROUP_SITE_PREFIX_LENGTH, roleIndex);
            siteNames.add(siteName);
        }
        NodeRef siteRoot = this.getSiteRoot();
        if (siteRoot == null) {
            result = new ArrayList<SiteInfo>(0);
        } else {
            List siteList = new ArrayList(siteNames);
            if (siteList.size() > 1000) {
                siteList = siteList.subList(0, 1000);
            }
            List assocs = this.nodeService.getChildrenByName(siteRoot, ContentModel.ASSOC_CONTAINS, siteList);
            result = new ArrayList(assocs.size());
            for (ChildAssociationRef assoc : assocs) {
                NodeRef site = assoc.getChildRef();
                QName siteClassName = this.nodeService.getType(site);
                if (!this.dictionaryService.isSubClass(siteClassName, SiteModel.TYPE_SITE)) continue;
                result.add(this.createSiteInfo(site));
            }
        }
        return result;
    }

    private SiteInfo createSiteInfo(NodeRef siteNodeRef) {
        SiteInfoImpl siteInfo = null;
        if (this.permissionService.hasPermission(siteNodeRef, "ReadProperties").equals((Object)AccessStatus.ALLOWED)) {
            Map properties = this.nodeService.getProperties(siteNodeRef);
            String shortName = (String)properties.get(ContentModel.PROP_NAME);
            String sitePreset = (String)properties.get(PROP_SITE_PRESET);
            String title = (String)properties.get(ContentModel.PROP_TITLE);
            String description = (String)properties.get(ContentModel.PROP_DESCRIPTION);
            SiteVisibility visibility = this.getSiteVisibility(siteNodeRef);
            Map<QName, Serializable> customProperties = this.getSiteCustomProperties(properties);
            siteInfo = new SiteInfoImpl(sitePreset, shortName, title, description, visibility, customProperties, siteNodeRef);
        }
        return siteInfo;
    }

    private SiteVisibility getSiteVisibility(NodeRef siteNodeRef) {
        SiteVisibility visibility = SiteVisibility.PRIVATE;
        String visibilityValue = (String)((Object)this.nodeService.getProperty(siteNodeRef, SiteModel.PROP_SITE_VISIBILITY));
        if (visibilityValue == null) {
            Set permissions = this.permissionService.getAllSetPermissions(siteNodeRef);
            for (AccessPermission permission : permissions) {
                if (!permission.getAuthority().equals("GROUP_EVERYONE") || !permission.getPermission().equals("SiteConsumer")) continue;
                visibility = SiteVisibility.PUBLIC;
                break;
            }
        } else {
            visibility = SiteVisibility.valueOf(visibilityValue);
        }
        return visibility;
    }

    @Override
    public SiteInfo getSite(final String shortName) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantName(shortName)) {
            String tenantDomain = this.tenantService.getDomain(shortName);
            final String sName = this.tenantService.getBaseName(shortName, true);
            return (SiteInfo)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<SiteInfo>(){

                public SiteInfo doWork() throws Exception {
                    SiteInfo site = SiteServiceImpl.this.getSiteImpl(sName);
                    return new SiteInfoImpl(site.getSitePreset(), shortName, site.getTitle(), site.getDescription(), site.getVisibility(), site.getCustomProperties(), site.getNodeRef());
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.getSiteImpl(shortName);
    }

    private SiteInfo getSiteImpl(String shortName) {
        SiteInfo result = null;
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef != null) {
            result = this.createSiteInfo(siteNodeRef);
        }
        return result;
    }

    @Override
    public SiteInfo getSite(NodeRef nodeRef) {
        SiteInfo siteInfo = null;
        NodeRef siteNodeRef = this.getSiteNodeRef(nodeRef);
        if (siteNodeRef != null) {
            siteInfo = this.createSiteInfo(siteNodeRef);
        }
        return siteInfo;
    }

    private NodeRef getSiteNodeRef(NodeRef nodeRef) {
        NodeRef siteNodeRef = null;
        QName nodeRefType = this.nodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(TYPE_SITE, nodeRefType)) {
            siteNodeRef = nodeRef;
        } else {
            ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(nodeRef);
            if (primaryParent != null && primaryParent.getParentRef() != null) {
                siteNodeRef = this.getSiteNodeRef(primaryParent.getParentRef());
            }
        }
        return siteNodeRef;
    }

    private NodeRef getSiteNodeRef(final String shortName) {
        final String cacheKey = this.tenantAdminService.getCurrentUserDomain() + '_' + shortName;
        NodeRef siteNodeRef = this.siteNodeRefs.get(cacheKey);
        if (siteNodeRef != null) {
            if (!this.nodeService.exists(siteNodeRef)) {
                this.siteNodeRefs.remove(cacheKey);
                siteNodeRef = null;
            }
        } else {
            final NodeRef siteRoot = this.getSiteParent(shortName);
            siteNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    NodeRef siteNodeRef = SiteServiceImpl.this.nodeService.getChildByName(siteRoot, ContentModel.ASSOC_CONTAINS, shortName);
                    if (siteNodeRef != null) {
                        SiteServiceImpl.this.siteNodeRefs.put(cacheKey, siteNodeRef);
                    }
                    return siteNodeRef;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
        return siteNodeRef;
    }

    @Override
    public void updateSite(SiteInfo siteInfo) {
        String shortName = siteInfo.getShortName();
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_CAN_NOT_UPDATE, new Object[]{siteInfo.getShortName()});
        }
        Map properties = this.nodeService.getProperties(siteNodeRef);
        properties.put(ContentModel.PROP_TITLE, siteInfo.getTitle());
        properties.put(ContentModel.PROP_DESCRIPTION, siteInfo.getDescription());
        SiteVisibility currentVisibility = this.getSiteVisibility(siteNodeRef);
        SiteVisibility updatedVisibility = siteInfo.getVisibility();
        if (!currentVisibility.equals((Object)updatedVisibility)) {
            NodeRef containerNodeRef;
            List<FileInfo> folders;
            logger.debug((Object)("site:" + shortName + " visibility has changed from: " + (Object)((Object)currentVisibility) + "to: " + (Object)((Object)updatedVisibility)));
            if (SiteVisibility.PUBLIC.equals((Object)currentVisibility)) {
                this.permissionService.deletePermission(siteNodeRef, "GROUP_EVERYONE", "SiteConsumer");
            } else if (SiteVisibility.MODERATED.equals((Object)currentVisibility)) {
                this.permissionService.deletePermission(siteNodeRef, "GROUP_EVERYONE", "SiteConsumer");
                folders = this.fileFolderService.listFolders(siteNodeRef);
                for (FileInfo folder : folders) {
                    containerNodeRef = folder.getNodeRef();
                    this.permissionService.setInheritParentPermissions(containerNodeRef, true);
                }
            }
            if (SiteVisibility.PUBLIC.equals((Object)updatedVisibility)) {
                this.permissionService.setPermission(siteNodeRef, "GROUP_EVERYONE", "SiteConsumer", true);
            } else if (SiteVisibility.MODERATED.equals((Object)updatedVisibility)) {
                this.permissionService.setPermission(siteNodeRef, "GROUP_EVERYONE", "SiteConsumer", true);
                folders = this.fileFolderService.listFolders(siteNodeRef);
                for (FileInfo folder : folders) {
                    containerNodeRef = folder.getNodeRef();
                    this.setModeratedPermissions(shortName, containerNodeRef);
                }
            }
            properties.put(SiteModel.PROP_SITE_VISIBILITY, siteInfo.getVisibility());
        }
        this.nodeService.setProperties(siteNodeRef, properties);
    }

    @Override
    public void deleteSite(final String shortName) {
        logger.debug((Object)("delete site :" + shortName));
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_CAN_NOT_DELETE, new Object[]{shortName});
        }
        String cacheKey = this.tenantAdminService.getCurrentUserDomain() + '_' + shortName;
        this.siteNodeRefs.remove(cacheKey);
        this.nodeService.deleteNode(siteNodeRef);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SiteServiceImpl.this.authorityService.deleteAuthority(SiteServiceImpl.this.getSiteGroup(shortName, true), false);
                Set permissions = SiteServiceImpl.this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
                for (String permission : permissions) {
                    String siteRoleGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, permission, true);
                    SiteServiceImpl.this.authorityService.deleteAuthority(siteRoleGroup);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        logger.debug((Object)("site deleted :" + shortName));
    }

    @Override
    public Map<String, String> listMembers(String shortName, String nameFilter, String roleFilter, int size) {
        return this.listMembers(shortName, nameFilter, roleFilter, size, false);
    }

    @Override
    public Map<String, String> listMembers(String shortName, final String nameFilter, final String roleFilter, final int size, final boolean collapseGroups) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantName(shortName)) {
            String tenantDomain = this.tenantService.getDomain(shortName);
            final String sName = this.tenantService.getBaseName(shortName, true);
            return (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, String>>(){

                public Map<String, String> doWork() throws Exception {
                    return SiteServiceImpl.this.listMembersImpl(sName, nameFilter, roleFilter, size, collapseGroups);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.listMembersImpl(shortName, nameFilter, roleFilter, size, collapseGroups);
    }

    private Map<String, String> listMembersImpl(String shortName, String nameFilter, String roleFilter, int size, boolean collapseGroups) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_SITE_NO_EXIST, new Object[]{shortName});
        }
        String[] nameFilters = new String[]{};
        if (nameFilter != null && nameFilter.length() != 0) {
            StringTokenizer t = new StringTokenizer(nameFilter, " ");
            nameFilters = new String[t.countTokens()];
            int i = 0;
            while (t.hasMoreTokens()) {
                nameFilters[i] = t.nextToken().toLowerCase();
                ++i;
            }
        }
        HashMap<String, String> members = new HashMap<String, String>(32);
        Set permissions = this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
        for (String permission : permissions) {
            if (roleFilter != null && roleFilter.length() != 0 && !roleFilter.equals(permission)) continue;
            String groupName = this.getSiteRoleGroup(shortName, permission, true);
            Set<String> users = this.authorityService.getContainedAuthorities(AuthorityType.USER, groupName, true);
            for (String user : users) {
                boolean addUser = true;
                if (nameFilter != null && nameFilter.length() != 0 && !nameFilter.equals(user)) {
                    addUser = this.matchPerson(nameFilters, user);
                }
                if (!addUser) continue;
                members.put(user, permission);
                if (members.size() != size) continue;
                break;
            }
            Set<String> groups = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, groupName, true);
            block3: for (String group : groups) {
                if (!collapseGroups) {
                    if (nameFilter != null && nameFilter.length() != 0) {
                        if (!group.substring(GROUP_PREFIX_LENGTH).toLowerCase().contains(nameFilter.toLowerCase())) continue;
                        members.put(group, permission);
                        continue;
                    }
                    members.put(group, permission);
                    continue;
                }
                Set<String> subUsers = this.authorityService.getContainedAuthorities(AuthorityType.USER, group, false);
                for (String subUser : subUsers) {
                    boolean addUser = true;
                    if (nameFilter != null && nameFilter.length() != 0 && !nameFilter.equals(subUser)) {
                        addUser = this.matchPerson(nameFilters, subUser);
                    }
                    if (!addUser) continue;
                    if (!members.containsKey(subUser)) {
                        members.put(subUser, permission);
                    }
                    if (members.size() != size) continue;
                    continue block3;
                }
            }
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchPerson(String[] nameFilters, String username) {
        boolean addUser = false;
        String query = "+TYPE:\"cm:person\" +@cm\\:userName:\"" + username + "\"";
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setLanguage("lucene");
        searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        searchParameters.setQuery(query);
        ResultSet resultSet = this.searchService.query(searchParameters);
        try {
            if (resultSet.length() != 0) {
                ResultSetRow row = resultSet.getRow(0);
                Map values = row.getValues();
                String firstName = (String)values.get(ContentModel.PROP_FIRSTNAME.toString());
                String lastName = (String)values.get(ContentModel.PROP_LASTNAME.toString());
                String lowFirstName = firstName != null ? firstName.toLowerCase() : "";
                String lowLastName = lastName != null ? lastName.toLowerCase() : "";
                for (int i = 0; i < nameFilters.length; ++i) {
                    if (lowFirstName.indexOf(nameFilters[i]) != -1) {
                        addUser = true;
                        break;
                    }
                    if (lowLastName.indexOf(nameFilters[i]) == -1) continue;
                    addUser = true;
                    break;
                }
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return addUser;
    }

    @Override
    public String getMembersRole(String shortName, String authorityName) {
        String result = null;
        List<String> roles = this.getMembersRoles(shortName, authorityName);
        if (roles.size() != 0) {
            if (roles.size() > 1 && this.roleComparator != null) {
                TreeSet<String> sortedRoles = new TreeSet<String>(this.roleComparator);
                for (String role : roles) {
                    sortedRoles.add(role);
                }
                result = (String)sortedRoles.first();
            } else {
                result = roles.get(0);
            }
        }
        return result;
    }

    public List<String> getMembersRoles(String shortName, String authorityName) {
        ArrayList<String> result = new ArrayList<String>(5);
        List<String> groups = this.getPermissionGroups(shortName, authorityName);
        for (String group : groups) {
            int index = group.lastIndexOf(95);
            if (index == -1) continue;
            result.add(group.substring(index + 1));
        }
        return result;
    }

    private List<String> getPermissionGroups(String siteShortName, String authorityName) {
        Set<String> authorities;
        String roleGroup;
        ArrayList<String> result = new ArrayList<String>(5);
        Set roles = this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
        for (String role : roles) {
            roleGroup = this.getSiteRoleGroup(siteShortName, role, true);
            authorities = this.authorityService.getContainedAuthorities(AuthorityType.USER, roleGroup, true);
            if (!authorities.contains(authorityName)) continue;
            result.add(roleGroup);
        }
        if (result.size() > 0) {
            return result;
        }
        for (String role : roles) {
            roleGroup = this.getSiteRoleGroup(siteShortName, role, true);
            authorities = this.authorityService.getContainedAuthorities(null, roleGroup, false);
            if (!authorities.contains(authorityName)) continue;
            result.add(roleGroup);
        }
        return result;
    }

    @Override
    public List<String> getSiteRoles() {
        Set permissions = this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
        return new ArrayList<String>(permissions);
    }

    @Override
    public boolean isMember(String shortName, String authorityName) {
        return !this.getPermissionGroups(shortName, authorityName).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeMembership(final String shortName, final String authorityName) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_SITE_NO_EXIST, new Object[]{shortName});
        }
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        final String role = this.getMembersRole(shortName, authorityName);
        if (role == null) throw new SiteServiceException(MSG_CAN_NOT_REMOVE_MSHIP, new Object[]{shortName});
        this.checkLastManagerRemoval(shortName, authorityName, role);
        if (!currentUserName.equals(authorityName) && this.permissionService.hasPermission(siteNodeRef, "ChangePermissions") != AccessStatus.ALLOWED) throw new SiteServiceException(MSG_CAN_NOT_REMOVE_MSHIP, new Object[]{shortName});
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String currentGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, role, true);
                SiteServiceImpl.this.authorityService.removeAuthority(currentGroup, authorityName);
                return null;
            }
        }, (String)"System");
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
        if (authorityType == AuthorityType.USER) {
            this.activityService.postActivity("org.alfresco.site.user-left", shortName, ACTIVITY_TOOL, this.getActivityUserData(authorityName, ""));
            return;
        } else {
            if (authorityType != AuthorityType.GROUP) return;
            this.activityService.postActivity("org.alfresco.site.group-removed", shortName, ACTIVITY_TOOL, this.getActivityGroupData(authorityName, ""));
        }
    }

    @Override
    public void setMembership(final String shortName, final String authorityName, final String role) {
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_SITE_NO_EXIST, new Object[]{shortName});
        }
        final String currentRole = this.getMembersRole(shortName, authorityName);
        if (currentRole == null || !role.equals(currentRole)) {
            SiteVisibility visibility = this.getSiteVisibility(siteNodeRef);
            String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
            if (this.permissionService.hasPermission(siteNodeRef, "ChangePermissions") == AccessStatus.ALLOWED || SiteVisibility.PUBLIC.equals((Object)visibility) && role.equals("SiteConsumer") && authorityName.equals(currentUserName) && currentRole == null) {
                this.checkLastManagerRemoval(shortName, authorityName, currentRole);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        if (currentRole != null) {
                            String currentGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, currentRole, true);
                            SiteServiceImpl.this.authorityService.removeAuthority(currentGroup, authorityName);
                        }
                        String newGroup = SiteServiceImpl.this.getSiteRoleGroup(shortName, role, true);
                        SiteServiceImpl.this.authorityService.addAuthority(newGroup, authorityName);
                        return null;
                    }
                }, (String)"System");
                if (currentRole == null) {
                    AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
                    if (authorityType == AuthorityType.USER) {
                        this.activityService.postActivity("org.alfresco.site.user-joined", shortName, ACTIVITY_TOOL, this.getActivityUserData(authorityName, role));
                    } else if (authorityType == AuthorityType.GROUP) {
                        this.activityService.postActivity("org.alfresco.site.group-added", shortName, ACTIVITY_TOOL, this.getActivityGroupData(authorityName, role));
                    }
                } else {
                    AuthorityType authorityType = AuthorityType.getAuthorityType((String)authorityName);
                    if (authorityType == AuthorityType.USER) {
                        this.activityService.postActivity("org.alfresco.site.user-role-changed", shortName, ACTIVITY_TOOL, this.getActivityUserData(authorityName, role));
                    } else if (authorityType == AuthorityType.GROUP) {
                        this.activityService.postActivity("org.alfresco.site.group-role-changed", shortName, ACTIVITY_TOOL, this.getActivityGroupData(authorityName, role));
                    }
                }
            } else {
                throw new SiteServiceException(MSG_CAN_NOT_CHANGE_MSHIP, new Object[]{shortName});
            }
        }
    }

    @Override
    public NodeRef createContainer(String shortName, String componentId, QName containerType, Map<QName, Serializable> containerProperties) {
        ParameterCheck.mandatoryString((String)"componentId", (String)componentId);
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_SITE_NO_EXIST, new Object[]{shortName});
        }
        SiteVisibility siteVisibility = this.getSiteVisibility(siteNodeRef);
        NodeRef containerNodeRef = null;
        try {
            containerNodeRef = this.findContainer(siteNodeRef, componentId);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (containerNodeRef == null) {
            if (containerType == null) {
                containerType = ContentModel.TYPE_FOLDER;
            }
            FileInfo fileInfo = this.fileFolderService.create(siteNodeRef, componentId, containerType);
            containerNodeRef = fileInfo.getNodeRef();
            if (containerProperties != null) {
                Map props = this.nodeService.getProperties(containerNodeRef);
                props.putAll(containerProperties);
                this.nodeService.setProperties(containerNodeRef, props);
            }
            HashMap<QName, String> aspectProps = new HashMap<QName, String>(1, 1.0f);
            aspectProps.put(SiteModel.PROP_COMPONENT_ID, componentId);
            this.nodeService.addAspect(containerNodeRef, ASPECT_SITE_CONTAINER, aspectProps);
            if (SiteVisibility.MODERATED.equals((Object)siteVisibility)) {
                this.setModeratedPermissions(shortName, containerNodeRef);
            }
            this.taggingService.addTagScope(containerNodeRef);
        }
        return containerNodeRef;
    }

    private void setModeratedPermissions(String shortName, NodeRef containerNodeRef) {
        this.permissionService.setInheritParentPermissions(containerNodeRef, false);
        Set permissions = this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
        for (String permission : permissions) {
            String permissionGroup = this.getSiteRoleGroup(shortName, permission, true);
            this.permissionService.setPermission(containerNodeRef, permissionGroup, permission, true);
        }
        this.permissionService.setPermission(containerNodeRef, "GROUP_EVERYONE", "ReadPermissions", true);
    }

    @Override
    public NodeRef getContainer(String shortName, String componentId) {
        ParameterCheck.mandatoryString((String)"componentId", (String)componentId);
        NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_SITE_NO_EXIST, new Object[]{shortName});
        }
        NodeRef containerNodeRef = null;
        try {
            containerNodeRef = this.findContainer(siteNodeRef, componentId);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return containerNodeRef;
    }

    @Override
    public boolean hasContainer(String shortName, final String componentId) {
        ParameterCheck.mandatoryString((String)"componentId", (String)componentId);
        final NodeRef siteNodeRef = this.getSiteNodeRef(shortName);
        if (siteNodeRef == null) {
            throw new SiteServiceException(MSG_SITE_NO_EXIST, new Object[]{shortName});
        }
        boolean hasContainer = false;
        NodeRef containerRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImpl.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() throws Exception {
                        try {
                            return SiteServiceImpl.this.findContainer(siteNodeRef, componentId);
                        }
                        catch (FileNotFoundException e) {
                            return null;
                        }
                    }
                }, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (containerRef != null) {
            hasContainer = true;
        }
        return hasContainer;
    }

    private NodeRef findContainer(NodeRef siteNodeRef, String componentId) throws FileNotFoundException {
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(componentId);
        FileInfo fileInfo = this.fileFolderService.resolveNamePath(siteNodeRef, paths);
        if (!fileInfo.isFolder()) {
            throw new SiteServiceException(MSG_SITE_CONTAINER_NOT_FOLDER, new Object[]{fileInfo.getName()});
        }
        return fileInfo.getNodeRef();
    }

    private String getActivityUserData(String userName, String role) {
        String memberFN = "";
        String memberLN = "";
        NodeRef person = this.personService.getPerson(userName);
        if (person != null) {
            memberFN = (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_FIRSTNAME));
            memberLN = (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_LASTNAME));
        }
        try {
            JSONObject activityData = new JSONObject();
            activityData.put("role", (Object)role);
            activityData.put("memberUserName", (Object)userName);
            activityData.put("memberFirstName", (Object)memberFN);
            activityData.put("memberLastName", (Object)memberLN);
            activityData.put("title", (Object)(memberFN + " " + memberLN + " (" + userName + ")").trim());
            return activityData.toString();
        }
        catch (JSONException je) {
            logger.error((Object)("Failed to get activity data: " + (Object)((Object)je)));
            return "";
        }
    }

    private String getActivityGroupData(String groupName, String role) {
        try {
            JSONObject activityData = new JSONObject();
            activityData.put("role", (Object)role);
            activityData.put("groupName", (Object)groupName);
            return activityData.toString();
        }
        catch (JSONException je) {
            logger.error((Object)("Failed to get activity data: " + (Object)((Object)je)));
            return "";
        }
    }

    private void checkLastManagerRemoval(String shortName, String authorityName, String role) {
        String mgrGroup;
        Set<String> siteUserMangers;
        if ("SiteManager".equals(role) && (siteUserMangers = this.authorityService.getContainedAuthorities(AuthorityType.USER, mgrGroup = this.getSiteRoleGroup(shortName, "SiteManager", true), true)).size() <= 1) {
            Set<String> siteGroupManagers = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, mgrGroup, true);
            if (siteUserMangers.size() + siteGroupManagers.size() == 1) {
                throw new SiteServiceException(MSG_DO_NOT_CHANGE_MGR, new Object[]{authorityName});
            }
        }
    }
}

