/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;

public class TaggingServiceImplTest
extends BaseAlfrescoSpringTest
implements AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute {
    private TaggingService taggingService;
    private CopyService copyService;
    private CheckOutCheckInService checkOutCheckInService;
    private ScriptService scriptService;
    private PolicyComponent policyComponent;
    private static StoreRef storeRef;
    private static NodeRef rootNode;
    private NodeRef folder;
    private NodeRef subFolder;
    private NodeRef document;
    private NodeRef subDocument;
    private static final String TAG_1 = "tag one";
    private static final String TAG_2 = "tag two";
    private static final String TAG_3 = "Tag Three";
    private static final String TAG_4 = "tag four";
    private static final String TAG_5 = "tag five";
    private static final String TAG_I18N = "\u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1";
    private static final String UPPER_TAG = "House";
    private static final String LOWER_TAG = "house";
    private static boolean init;
    private static Object mutex;

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.taggingService = (TaggingService)this.applicationContext.getBean("TaggingService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("CheckoutCheckinService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.scriptService = (ScriptService)this.applicationContext.getBean("scriptService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        if (!init) {
            UserTransaction tx = this.transactionService.getUserTransaction();
            tx.begin();
            AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
            authenticationComponent.setSystemUserAsCurrentUser();
            storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
            rootNode = this.nodeService.getRootNode(storeRef);
            NodeRef catContainer = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
            NodeRef catRoot = this.nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
            this.nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
            this.policyComponent.bindClassBehaviour(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.QNAME, this, (Behaviour)new JavaBehaviour(this, "onAsyncActionExecute", Behaviour.NotificationFrequency.EVERY_EVENT));
            init = true;
            tx.commit();
        }
    }

    protected void onSetUpInTransaction() throws Exception {
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        String guid = GUID.generate();
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder" + guid);
        this.folder = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        HashMap<QName, String> docProps = new HashMap<QName, String>(1);
        docProps.put(ContentModel.PROP_NAME, "testDocument" + guid + ".txt");
        this.document = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "subFolder" + guid);
        this.subFolder = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subFolder" + guid)), ContentModel.TYPE_FOLDER, props).getChildRef();
        props = new HashMap(1);
        props.put(ContentModel.PROP_NAME, "subDocument" + guid + ".txt");
        this.subDocument = this.nodeService.createNode(this.subFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, props).getChildRef();
        this.setComplete();
        this.endTransaction();
    }

    public void testTagCRUD() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        List<String> tags = this.taggingService.getTags(storeRef);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)0, (int)tags.size());
        this.taggingService.createTag(storeRef, TAG_1);
        this.taggingService.createTag(storeRef, UPPER_TAG);
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        tags = this.taggingService.getTags(storeRef);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(LOWER_TAG));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, UPPER_TAG));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, LOWER_TAG));
        this.taggingService.deleteTag(storeRef, UPPER_TAG);
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        tags = this.taggingService.getTags(storeRef);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)tags.contains(LOWER_TAG));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, UPPER_TAG));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, LOWER_TAG));
        tx.commit();
    }

    public void testAddRemoveTag() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        List<String> tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertTrue((boolean)tags.isEmpty());
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_1));
        this.taggingService.addTag(this.document, TAG_1);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, TAG_2));
        this.taggingService.addTag(this.document, TAG_2);
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_2));
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_2));
        this.taggingService.removeTag(this.document, TAG_1);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertFalse((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_2));
        ArrayList<String> setTags = new ArrayList<String>(2);
        setTags.add(TAG_3);
        setTags.add(TAG_1);
        this.taggingService.setTags(this.document, setTags);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)tags.contains(TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_3.toLowerCase()));
        this.taggingService.clearTags(this.document);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertTrue((boolean)tags.isEmpty());
        tx.commit();
    }

    public void testTagScopeFindAddRemove() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        TagScope tagScope = this.taggingService.findTagScope(this.subDocument);
        TaggingServiceImplTest.assertNull((Object)tagScope);
        List<TagScope> tagScopes = this.taggingService.findAllTagScopes(this.subDocument);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)0, (int)tagScopes.size());
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        tagScope = this.taggingService.findTagScope(this.subDocument);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subDocument);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)2, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subFolder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)2, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.folder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
        this.taggingService.removeTagScope(this.folder);
        tagScope = this.taggingService.findTagScope(this.subDocument);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subDocument);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subFolder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.folder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)0, (int)tagScopes.size());
        tx.commit();
    }

    public void testTagScope() throws Exception {
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        this.taggingService.addTag(this.subDocument, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_3);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.folder, TAG_2);
        this.waitForActionExecution();
        TagScope ts1 = this.taggingService.findTagScope(this.subDocument);
        TagScope ts2 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTags().get(0).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTags().get(1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTags().get(2).getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)ts2.getTags().get(0).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_2, (String)ts2.getTags().get(0).getName());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTags().get(1).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_1, (String)ts2.getTags().get(1).getName());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts2.getTags().get(2).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_3.toLowerCase(), (String)ts2.getTags().get(2).getName());
        this.taggingService.removeTag(this.folder, TAG_2);
        this.waitForActionExecution();
        this.taggingService.removeTag(this.subFolder, TAG_2);
        this.waitForActionExecution();
        this.taggingService.removeTag(this.subFolder, TAG_1);
        this.waitForActionExecution();
        this.taggingService.removeTag(this.subDocument, TAG_1);
        this.waitForActionExecution();
        ts1 = this.taggingService.findTagScope(this.subDocument);
        ts2 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTags().size());
    }

    public void testTagScopeRefresh() throws Exception {
        this.taggingService.addTag(this.subDocument, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_3);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.folder, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTagScope(this.folder);
        TagScope tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        TaggingServiceImplTest.assertEquals((int)3, (int)tagScope.getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)tagScope.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)tagScope.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScope.getTag(TAG_3.toLowerCase()).getCount());
    }

    public void testTagScopeSetUpdate() throws Exception {
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTag(this.folder, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.document, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.document, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_3);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_1);
        this.waitForActionExecution();
        TagScope ts1 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((int)4, (int)ts1.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_3.toLowerCase()).getCount());
        ArrayList<String> tags = new ArrayList<String>(3);
        tags.add(TAG_2);
        tags.add(TAG_3);
        tags.add(TAG_4);
        this.taggingService.setTags(this.subDocument, tags);
        this.waitForActionExecution();
        ts1 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((int)3, (int)ts1.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_3.toLowerCase()).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_4).getCount());
    }

    public void testETHREEOH_220() throws Exception {
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTag(this.folder, TAG_I18N);
        this.waitForActionExecution();
        List<String> tags = this.taggingService.getTags(this.folder);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertEquals((String)TAG_I18N, (String)tags.get(0));
        TagScope tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScope.getTags().size());
        TagDetails tagDetails = tagScope.getTag(TAG_I18N);
        TaggingServiceImplTest.assertNotNull((Object)tagDetails);
        TaggingServiceImplTest.assertEquals((String)TAG_I18N, (String)tagDetails.getName());
        TaggingServiceImplTest.assertEquals((int)1, (int)tagDetails.getCount());
    }

    public void testTagScopeUpdateViaNodePolicies() throws Exception {
        NodeRef tagFoo1 = this.taggingService.createTag(this.folder.getStoreRef(), "Foo1");
        NodeRef tagFoo2 = this.taggingService.createTag(this.folder.getStoreRef(), "Foo2");
        NodeRef tagFoo3 = this.taggingService.createTag(this.folder.getStoreRef(), "Foo3");
        NodeRef tagBar = this.taggingService.createTag(this.folder.getStoreRef(), "Bar");
        ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
        HashMap<QName, String> container1Props = new HashMap<QName, String>(1);
        container1Props.put(ContentModel.PROP_NAME, "Container1");
        NodeRef container1 = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container1Props).getChildRef();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container1).size());
        HashMap container2Props = new HashMap(1);
        container1Props.put(ContentModel.PROP_NAME, "Container2");
        NodeRef container2 = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container2Props).getChildRef();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container2).size());
        this.taggingService.addTagScope(container1);
        this.taggingService.addTagScope(container2);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container2));
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        HashMap<QName, Object> taggedFolderProps = new HashMap<QName, Object>(1);
        taggedFolderProps.put(ContentModel.PROP_NAME, "Folder");
        NodeRef taggedFolder = this.nodeService.createNode(container1, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, taggedFolderProps).getChildRef();
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        taggedFolderProps.clear();
        tagsList.clear();
        tagsList.add(tagFoo1);
        tagsList.add(tagFoo3);
        taggedFolderProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
        this.nodeService.addProperties(taggedFolder, taggedFolderProps);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        tagsList.clear();
        tagsList.add(tagFoo1);
        tagsList.add(tagFoo2);
        HashMap<QName, Object> taggedDocProps = new HashMap<QName, Object>(1);
        taggedDocProps.put(ContentModel.PROP_NAME, "Document");
        taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
        NodeRef taggedDoc = this.nodeService.createNode(taggedFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(taggedFolder).size());
        NodeRef checkedOutDoc = this.checkOutCheckInService.checkout(taggedDoc);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(taggedFolder).size());
        this.checkOutCheckInService.checkin(checkedOutDoc, null);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(taggedFolder).size());
        taggedDocProps.clear();
        taggedDocProps.put(ContentModel.PROP_NAME, "CopyDoc");
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container2).size());
        NodeRef taggedDoc2 = this.nodeService.createNode(container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        this.copyService.copy(taggedDoc, taggedDoc2);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.nodeService.getPrimaryParent(taggedDoc2).getParentRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.taggingService.findTagScope(taggedDoc2).getNodeRef());
        NodeRef taggedFolder2 = this.copyService.copy(taggedFolder, container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, true);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(taggedFolder2).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        tagsList.clear();
        tagsList.add(tagBar);
        taggedDocProps.clear();
        taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
        taggedDocProps.put(ContentModel.PROP_NAME, "UpdatedDocument");
        this.nodeService.addProperties(taggedDoc, taggedDocProps);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("bar").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        taggedDoc = this.nodeService.moveNode(taggedDoc, container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE).getChildRef();
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)4, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("bar").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.nodeService.getPrimaryParent(taggedDoc).getParentRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.taggingService.findTagScope(taggedDoc).getNodeRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.nodeService.getPrimaryParent(taggedDoc2).getParentRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.taggingService.findTagScope(taggedDoc2).getNodeRef());
        this.nodeService.deleteNode(taggedDoc);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals(null, (Object)this.taggingService.findTagScope(container2).getTag("bar"));
        this.nodeService.deleteNode(taggedDoc2);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals(null, (Object)this.taggingService.findTagScope(container2).getTag("bar"));
        this.nodeService.deleteNode(taggedFolder);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        this.nodeService.deleteNode(taggedFolder2);
        this.waitForActionExecution();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container2).size());
    }

    public void testJSAPI() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        HashMap<String, Object> model = new HashMap<String, Object>(0);
        model.put("folder", this.folder);
        model.put("subFolder", this.subFolder);
        model.put("document", this.document);
        model.put("subDocument", this.subDocument);
        model.put("tagScopeTest", false);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
        this.scriptService.executeScript(location, model);
        tx.commit();
    }

    public void testJSTagScope() throws Exception {
        this.taggingService.createTag(storeRef, "alpha");
        this.taggingService.createTag(storeRef, "alpha double");
        this.taggingService.createTag(storeRef, "beta");
        this.taggingService.createTag(storeRef, "gamma");
        this.taggingService.createTag(storeRef, "delta");
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        this.taggingService.addTag(this.subDocument, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subDocument, TAG_3);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.subFolder, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.document, TAG_1);
        this.waitForActionExecution();
        this.taggingService.addTag(this.document, TAG_2);
        this.waitForActionExecution();
        this.taggingService.addTag(this.folder, TAG_1);
        this.waitForActionExecution();
        HashMap<String, Object> model = new HashMap<String, Object>(0);
        model.put("folder", this.folder);
        model.put("subFolder", this.subFolder);
        model.put("document", this.document);
        model.put("subDocument", this.subDocument);
        model.put("tagScopeTest", true);
        model.put("store", storeRef.toString());
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
        this.scriptService.executeScript(location, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForActionExecution() throws Exception {
        Object object = mutex;
        synchronized (object) {
            mutex.wait(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAsyncActionExecute(Action action, NodeRef actionedUponNodeRef) {
        Object object = mutex;
        synchronized (object) {
            mutex.notifyAll();
        }
    }

    static {
        init = false;
        mutex = new Object();
    }
}

