/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.TagDetailsImpl;
import org.alfresco.repo.tagging.TaggingServiceImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.tagging.TaggingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTagScopesActionExecuter
extends ActionExecuterAbstractBase {
    private NodeService nodeService;
    private ContentService contentService;
    private TaggingService taggingService;
    public static final String NAME = "update-tagscope";
    public static final String PARAM_TAG_UPDATES = "tag_updates";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    @Override
    protected void executeImpl(final Action action, final NodeRef actionedUponNodeRef) {
        try {
            if (this.nodeService.exists(actionedUponNodeRef)) {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        Map tagUpdates = (Map)((Object)action.getParameterValue(UpdateTagScopesActionExecuter.PARAM_TAG_UPDATES));
                        List<TagScope> tagScopes = UpdateTagScopesActionExecuter.this.taggingService.findAllTagScopes(actionedUponNodeRef);
                        for (TagScope tagScope : tagScopes) {
                            NodeRef tagScopeNodeRef = tagScope.getNodeRef();
                            List<TagDetails> tags = null;
                            ContentReader contentReader = UpdateTagScopesActionExecuter.this.contentService.getReader(tagScopeNodeRef, ContentModel.PROP_TAGSCOPE_CACHE);
                            tags = contentReader == null ? new ArrayList<TagDetails>(1) : TaggingServiceImpl.readTagDetails(contentReader.getContentInputStream());
                            for (String tagName : tagUpdates.keySet()) {
                                boolean isAdd = (Boolean)tagUpdates.get(tagName);
                                TagDetails currentTag = null;
                                for (TagDetails tag : tags) {
                                    if (!tag.getName().equals(tagName)) continue;
                                    currentTag = tag;
                                    break;
                                }
                                if (isAdd) {
                                    if (currentTag == null) {
                                        tags.add(new TagDetailsImpl(tagName, 1));
                                        continue;
                                    }
                                    ((TagDetailsImpl)currentTag).incrementCount();
                                    continue;
                                }
                                if (currentTag == null) continue;
                                int currentTagCount = currentTag.getCount();
                                if (currentTagCount == 1) {
                                    tags.remove(currentTag);
                                    continue;
                                }
                                ((TagDetailsImpl)currentTag).decrementCount();
                            }
                            Collections.sort(tags);
                            String tagContent = TaggingServiceImpl.tagDetailsToString(tags);
                            ContentWriter contentWriter = UpdateTagScopesActionExecuter.this.contentService.getWriter(tagScopeNodeRef, ContentModel.PROP_TAGSCOPE_CACHE, true);
                            contentWriter.setEncoding("UTF-8");
                            contentWriter.setMimetype("text/plain");
                            contentWriter.putContent(tagContent);
                        }
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to update the tag scopes.", exception);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TAG_UPDATES, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_TAG_UPDATES)));
    }
}

