/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.alfresco.repo.transfer.ContentDataPart;
import org.alfresco.repo.transfer.HttpMethodFactory;
import org.alfresco.repo.transfer.StandardHttpMethodFactoryImpl;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferTransmitter;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.util.json.ExceptionJsonSerializer;
import org.alfresco.util.json.JsonSerializer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientTransmitterImpl
implements TransferTransmitter {
    private static final Log log = LogFactory.getLog(HttpClientTransmitterImpl.class);
    private static final String MSG_UNSUPPORTED_PROTOCOL = "transfer_service.comms.unsupported_protocol";
    private static final String MSG_UNSUCCESSFUL_RESPONSE = "transfer_service.comms.unsuccessful_response";
    private static final String MSG_HTTP_REQUEST_FAILED = "transfer_service.comms.http_request_failed";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String HTTP_SCHEME_NAME = "http";
    private static final String HTTPS_SCHEME_NAME = "https";
    private HttpClient httpClient = null;
    private Protocol httpProtocol = new Protocol("http", (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), 80);
    private Protocol httpsProtocol = new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(), 443);
    private Map<String, Protocol> protocolMap = new TreeMap<String, Protocol>();
    private HttpMethodFactory httpMethodFactory = null;
    private JsonSerializer<Throwable, JSONObject> jsonErrorSerializer;
    private ContentService contentService;

    public HttpClientTransmitterImpl() {
        this.protocolMap.put(HTTP_SCHEME_NAME, this.httpProtocol);
        this.protocolMap.put(HTTPS_SCHEME_NAME, this.httpsProtocol);
        this.httpClient = new HttpClient();
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpMethodFactory = new StandardHttpMethodFactoryImpl();
        this.jsonErrorSerializer = new ExceptionJsonSerializer();
    }

    public void init() {
    }

    public void setHttpsSocketFactory(ProtocolSocketFactory socketFactory) {
        this.protocolMap.put(HTTPS_SCHEME_NAME, new Protocol(HTTPS_SCHEME_NAME, socketFactory, 443));
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyTarget(TransferTarget target) throws TransferException {
        PostMethod verifyRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            verifyRequest.setPath(target.getEndpointPath() + "/test");
            try {
                int response = this.httpClient.executeMethod(hostConfig, (HttpMethod)verifyRequest, httpState);
                this.checkResponseStatus("verifyTarget", response, (HttpMethod)verifyRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"verifyTraget", target.toString(), e.toString()}, e);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            verifyRequest.releaseConnection();
            throw throwable;
        }
        verifyRequest.releaseConnection();
    }

    private void checkResponseStatus(String methodName, int response, HttpMethod method) {
        if (response != 200) {
            Throwable error = null;
            try {
                log.error((Object)("Received \"unsuccessful\" response code from target server: " + response));
                String errorPayload = method.getResponseBodyAsString();
                JSONObject errorObj = new JSONObject(errorPayload);
                error = this.rehydrateError(errorObj);
            }
            catch (Exception ex) {
                throw new TransferException(MSG_UNSUCCESSFUL_RESPONSE, new Object[]{methodName, response});
            }
            if (error != null && TransferException.class.isAssignableFrom(error.getClass())) {
                throw (TransferException)((Object)error);
            }
            throw new TransferException(MSG_UNSUCCESSFUL_RESPONSE, error);
        }
    }

    protected HttpState getHttpState(TransferTarget target) {
        HttpState httpState = new HttpState();
        httpState.setCredentials(new AuthScope(target.getEndpointHost(), target.getEndpointPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(target.getUsername(), new String(target.getPassword())));
        return httpState;
    }

    private HostConfiguration getHostConfig(TransferTarget target) {
        String requiredProtocol = target.getEndpointProtocol();
        if (requiredProtocol == null) {
            throw new TransferException(MSG_UNSUPPORTED_PROTOCOL, new Object[]{target.getEndpointProtocol()});
        }
        Protocol protocol = this.protocolMap.get(requiredProtocol.toLowerCase().trim());
        if (protocol == null) {
            log.error((Object)("Unsupported protocol: " + target.getEndpointProtocol()));
            throw new TransferException(MSG_UNSUPPORTED_PROTOCOL, new Object[]{target.getEndpointProtocol()});
        }
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(target.getEndpointHost(), target.getEndpointPort(), protocol);
        return hostConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Transfer begin(TransferTarget target) throws TransferException {
        Transfer transfer;
        PostMethod beginRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            beginRequest.setPath(target.getEndpointPath() + "/begin");
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)beginRequest, httpState);
                this.checkResponseStatus("begin", responseStatus, (HttpMethod)beginRequest);
                JSONObject response = new JSONObject(beginRequest.getResponseBodyAsString());
                String transferId = response.getString("transferId");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("begin transfer transferId:" + transferId + ", target:" + target));
                }
                Transfer transfer2 = new Transfer();
                transfer2.setTransferId(transferId);
                transfer2.setTransferTarget(target);
                transfer = transfer2;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"begin", target.toString(), e.toString()}, e);
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            beginRequest.releaseConnection();
            throw throwable;
        }
        beginRequest.releaseConnection();
        return transfer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendManifest(Transfer transfer, File manifest, OutputStream result) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod postSnapshotRequest = this.getPostMethod();
        if (log.isDebugEnabled()) {
            log.debug((Object)("does manifest exist? " + manifest.exists()));
            log.debug((Object)("sendManifest file : " + manifest.getAbsoluteFile()));
        }
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            try {
                postSnapshotRequest.setPath(target.getEndpointPath() + "/post-snapshot");
                postSnapshotRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
                FilePart file = new FilePart("manifest", manifest);
                MultipartRequestEntity requestEntity = new MultipartRequestEntity(new Part[]{file}, postSnapshotRequest.getParams());
                postSnapshotRequest.setRequestEntity((RequestEntity)requestEntity);
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)postSnapshotRequest, httpState);
                this.checkResponseStatus("sendManifest", responseStatus, (HttpMethod)postSnapshotRequest);
                InputStream is = postSnapshotRequest.getResponseBodyAsStream();
                InputStreamReader reader = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(reader);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(result));
                String s = br.readLine();
                while (s != null) {
                    bw.write(s);
                    s = br.readLine();
                }
                bw.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"sendManifest", target.toString(), e.toString()}, e);
            }
            Object var17_19 = null;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            postSnapshotRequest.releaseConnection();
            throw throwable;
        }
        postSnapshotRequest.releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Transfer transfer) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod abortRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            abortRequest.setPath(target.getEndpointPath() + "/abort");
            abortRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)abortRequest, httpState);
                this.checkResponseStatus("abort", responseStatus, (HttpMethod)abortRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"abort", target.toString(), e.toString()}, e);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            abortRequest.releaseConnection();
            throw throwable;
        }
        abortRequest.releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Transfer transfer) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod commitRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            commitRequest.setPath(target.getEndpointPath() + "/commit");
            commitRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)commitRequest, httpState);
                this.checkResponseStatus("commit", responseStatus, (HttpMethod)commitRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.error((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"commit", target.toString(), e.toString()}, e);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            commitRequest.releaseConnection();
            throw throwable;
        }
        commitRequest.releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(Transfer transfer) throws TransferException {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod prepareRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            prepareRequest.setPath(target.getEndpointPath() + "/prepare");
            prepareRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)prepareRequest, httpState);
                this.checkResponseStatus("prepare", responseStatus, (HttpMethod)prepareRequest);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"prepare", target.toString(), e.toString()}, e);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            prepareRequest.releaseConnection();
            throw throwable;
        }
        prepareRequest.releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendContent(Transfer transfer, Set<ContentData> data) throws TransferException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("send content to transfer:" + transfer));
        }
        TransferTarget target = transfer.getTransferTarget();
        PostMethod postContentRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            try {
                postContentRequest.setPath(target.getEndpointPath() + "/post-content");
                postContentRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
                postContentRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
                Part[] parts = new Part[data.size()];
                int index = 0;
                for (ContentData content : data) {
                    String contentUrl = content.getContentUrl();
                    String fileName = TransferCommons.URLToPartName(contentUrl);
                    log.debug((Object)("content partName: " + fileName));
                    parts[index++] = new ContentDataPart(this.getContentService(), fileName, content);
                }
                MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts, postContentRequest.getParams());
                postContentRequest.setRequestEntity((RequestEntity)requestEntity);
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)postContentRequest, httpState);
                this.checkResponseStatus("sendContent", responseStatus, (HttpMethod)postContentRequest);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sent content");
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"sendContent", target.toString(), e.toString()}, e);
            }
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            postContentRequest.releaseConnection();
            throw throwable;
        }
        postContentRequest.releaseConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransferProgress getStatus(Transfer transfer) throws TransferException {
        TransferProgress transferProgress;
        TransferTarget target = transfer.getTransferTarget();
        PostMethod statusRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            statusRequest.setPath(target.getEndpointPath() + "/status");
            statusRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
            try {
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)statusRequest, httpState);
                this.checkResponseStatus("status", responseStatus, (HttpMethod)statusRequest);
                String statusPayload = statusRequest.getResponseBodyAsString();
                JSONObject statusObj = new JSONObject(statusPayload);
                int currentPosition = statusObj.getInt("currentPosition");
                int endPosition = statusObj.getInt("endPosition");
                String statusStr = statusObj.getString("status");
                TransferProgress p = new TransferProgress();
                if (statusObj.has("error")) {
                    JSONObject errorJSON = statusObj.getJSONObject("error");
                    Throwable throwable = this.rehydrateError(errorJSON);
                    p.setError(throwable);
                }
                p.setStatus(TransferProgress.Status.valueOf(statusStr));
                p.setCurrentPosition(currentPosition);
                p.setEndPosition(endPosition);
                transferProgress = p;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"status", target.toString(), e.toString()}, e);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            statusRequest.releaseConnection();
            throw throwable;
        }
        statusRequest.releaseConnection();
        return transferProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getTransferReport(Transfer transfer, OutputStream result) {
        TransferTarget target = transfer.getTransferTarget();
        PostMethod getReportRequest = this.getPostMethod();
        try {
            HostConfiguration hostConfig = this.getHostConfig(target);
            HttpState httpState = this.getHttpState(target);
            try {
                getReportRequest.setPath(target.getEndpointPath() + "/report");
                getReportRequest.setQueryString(new NameValuePair[]{new NameValuePair("transferId", transfer.getTransferId())});
                int responseStatus = this.httpClient.executeMethod(hostConfig, (HttpMethod)getReportRequest, httpState);
                this.checkResponseStatus("getReport", responseStatus, (HttpMethod)getReportRequest);
                InputStream is = getReportRequest.getResponseBodyAsStream();
                ReadableByteChannel inputChannel = Channels.newChannel(is);
                WritableByteChannel outputChannel = Channels.newChannel(result);
                try {
                    HttpClientTransmitterImpl.channelCopy(inputChannel, outputChannel);
                    Object var12_14 = null;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    inputChannel.close();
                    outputChannel.close();
                    throw throwable;
                }
                inputChannel.close();
                outputChannel.close();
                Object var14_17 = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String error = "Failed to execute HTTP request to target";
                log.debug((Object)error, (Throwable)e);
                throw new TransferException(MSG_HTTP_REQUEST_FAILED, new Object[]{"getTransferReport", target.toString(), e.toString()}, e);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            getReportRequest.releaseConnection();
            throw throwable;
        }
        getReportRequest.releaseConnection();
    }

    private static void channelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(2048);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    protected PostMethod getPostMethod() {
        return this.httpMethodFactory.createPostMethod();
    }

    private Throwable rehydrateError(JSONObject errorJSON) {
        return this.jsonErrorSerializer.deserialize(errorJSON);
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setHttpMethodFactory(HttpMethodFactory httpMethodFactory) {
        this.httpMethodFactory = httpMethodFactory;
    }

    public void setJsonErrorSerializer(JsonSerializer<Throwable, JSONObject> jsonErrorSerializer) {
        this.jsonErrorSerializer = jsonErrorSerializer;
    }
}

