/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerAssociatedNodeFinder
extends AbstractNodeFinder {
    private Set<QName> suppliedAssociationTypes = new HashSet<QName>();
    private boolean exclude = false;
    private boolean initialised = false;
    private List<QName> peerAssociationTypes = new ArrayList<QName>();

    public PeerAssociatedNodeFinder() {
    }

    public PeerAssociatedNodeFinder(Collection<QName> associationTypeNames) {
        this.setAssociationTypes(associationTypeNames);
    }

    public PeerAssociatedNodeFinder(QName ... associationTypeNames) {
        this.setAssociationTypes(associationTypeNames);
    }

    public PeerAssociatedNodeFinder(Collection<QName> associationTypeNames, boolean exclude) {
        this.setAssociationTypes(associationTypeNames);
        this.exclude = exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public void setAssociationTypes(QName ... associationTypes) {
        this.setAssociationTypes(Arrays.asList(associationTypes));
    }

    public void setAssociationTypes(Collection<QName> associationTypes) {
        this.suppliedAssociationTypes = new HashSet<QName>(associationTypes);
        this.initialised = false;
    }

    @Override
    public Set<NodeRef> findFrom(NodeRef thisNode) {
        if (!this.initialised) {
            this.init();
        }
        if (this.exclude) {
            return this.processExcludedSet(thisNode);
        }
        return this.processIncludedSet(thisNode);
    }

    private Set<NodeRef> processExcludedSet(NodeRef thisNode) {
        HashSet<NodeRef> results = new HashSet<NodeRef>(89);
        NodeService nodeService = this.serviceRegistry.getNodeService();
        List targets = nodeService.getTargetAssocs(thisNode, RegexQNamePattern.MATCH_ALL);
        boolean filterPeers = !this.peerAssociationTypes.isEmpty();
        for (AssociationRef target : targets) {
            if (filterPeers && this.peerAssociationTypes.contains(target.getTypeQName())) continue;
            results.add(target.getTargetRef());
        }
        return results;
    }

    private Set<NodeRef> processIncludedSet(NodeRef startingNode) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        HashSet<NodeRef> foundNodes = new HashSet<NodeRef>(89);
        for (QName assocType : this.peerAssociationTypes) {
            List targets = nodeService.getTargetAssocs(startingNode, (QNamePattern)assocType);
            for (AssociationRef target : targets) {
                foundNodes.add(target.getTargetRef());
            }
        }
        return foundNodes;
    }

    @Override
    public void init() {
        super.init();
        DictionaryService dictionaryService = this.serviceRegistry.getDictionaryService();
        this.peerAssociationTypes.clear();
        for (QName associationType : this.suppliedAssociationTypes) {
            AssociationDefinition assocDef = dictionaryService.getAssociation(associationType);
            if (assocDef == null || assocDef.isChild()) continue;
            this.peerAssociationTypes.add(associationType);
        }
        this.initialised = true;
    }
}

