/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProcessingException;
import org.alfresco.repo.transfer.manifest.ManifestAccessControl;
import org.alfresco.repo.transfer.manifest.ManifestPermission;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoPrimaryManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private static final Log log = LogFactory.getLog(RepoPrimaryManifestProcessorImpl.class);
    private static final String MSG_NO_PRIMARY_PARENT_SUPPLIED = "transfer_service.receiver.no_primary_parent_supplied";
    private static final String MSG_ORPHANS_EXIST = "transfer_service.receiver.orphans_exist";
    private static final String MSG_REFERENCED_CONTENT_FILE_MISSING = "transfer_service.receiver.content_file_missing";
    protected static final Set<QName> DEFAULT_LOCAL_PROPERTIES = new HashSet<QName>();
    private NodeService nodeService;
    private PermissionService permissionService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private CorrespondingNodeResolver nodeResolver;
    private AlienProcessor alienProcessor;
    TransferManifestHeader header;
    private Map<NodeRef, List<ChildAssociationRef>> orphans = new HashMap<NodeRef, List<ChildAssociationRef>>(89);

    public RepoPrimaryManifestProcessorImpl(TransferReceiver receiver, String transferId) {
        super(receiver, transferId);
    }

    @Override
    protected void endManifest() {
        if (!this.orphans.isEmpty()) {
            this.error(MSG_ORPHANS_EXIST);
        }
    }

    @Override
    protected void processNode(TransferManifestDeletedNode node) {
        this.logComment("Primary Processing incoming deleted node: " + node.getNodeRef());
        ChildAssociationRef origPrimaryParent = node.getPrimaryParentAssoc();
        NodeRef origNodeRef = new NodeRef(origPrimaryParent.getParentRef().getStoreRef(), node.getNodeRef().getId());
        CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes = this.nodeResolver.resolveCorrespondingNode(origNodeRef, origPrimaryParent, node.getParentPath());
        if (resolvedNodes.resolvedChild != null) {
            NodeRef exNode = resolvedNodes.resolvedChild;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming deleted noderef " + node.getNodeRef() + " has been resolved to existing local noderef " + exNode + "  - deleting"));
            }
            this.logDeleted(node.getNodeRef(), exNode, this.nodeService.getPath(exNode));
            this.delete(node, exNode);
        } else {
            this.logComment("Unable to find corresponding node for incoming deleted node: " + node.getNodeRef());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming deleted noderef has no corresponding local noderef: " + node.getNodeRef() + "  - ignoring"));
            }
        }
    }

    @Override
    protected void processNode(TransferManifestNormalNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing node with incoming noderef of " + node.getNodeRef()));
        }
        this.logComment("Primary Processing incoming node: " + node.getNodeRef() + " --  Source path = " + node.getParentPath() + "/" + node.getPrimaryParentAssoc().getQName());
        ChildAssociationRef primaryParentAssoc = node.getPrimaryParentAssoc();
        if (primaryParentAssoc == null) {
            this.error(node, MSG_NO_PRIMARY_PARENT_SUPPLIED);
        }
        CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes = this.nodeResolver.resolveCorrespondingNode(node.getNodeRef(), primaryParentAssoc, node.getParentPath());
        if (resolvedNodes.resolvedChild != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming noderef " + node.getNodeRef() + " has been resolved to existing local noderef " + resolvedNodes.resolvedChild));
            }
            this.update(node, resolvedNodes, primaryParentAssoc);
        } else {
            NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, node.getNodeRef().getId());
            if (this.nodeService.exists(archiveNodeRef)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Located an archived node with UUID matching transferred node: " + archiveNodeRef));
                    log.info((Object)("Attempting to restore " + archiveNodeRef));
                }
                this.logComment("Delete node from archive: " + archiveNodeRef);
                this.nodeService.deleteNode(archiveNodeRef);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incoming noderef has no corresponding local noderef: " + node.getNodeRef()));
            }
            this.create(node, resolvedNodes, primaryParentAssoc);
        }
    }

    private void create(TransferManifestNormalNode node, CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes, ChildAssociationRef primaryParentAssoc) {
        log.info((Object)("Creating new node with noderef " + node.getNodeRef()));
        QName parentAssocType = primaryParentAssoc.getTypeQName();
        QName parentAssocName = primaryParentAssoc.getQName();
        NodeRef parentNodeRef = resolvedNodes.resolvedParent;
        if (parentNodeRef == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to resolve parent for inbound noderef " + node.getNodeRef() + ".\n  Supplied parent noderef is " + primaryParentAssoc.getParentRef() + ".\n  Supplied parent path is " + node.getParentPath().toString()));
            }
            ChildAssociationRef tempLocation = this.getTemporaryLocation(node.getNodeRef());
            parentNodeRef = tempLocation.getParentRef();
            parentAssocType = tempLocation.getTypeQName();
            parentAssocName = tempLocation.getQName();
            log.info((Object)("Recording orphaned transfer node: " + node.getNodeRef()));
            this.logComment("Unable to resolve parent for new incoming node. Storing it in temp folder: " + node.getNodeRef());
            this.storeOrphanNode(primaryParentAssoc);
        }
        log.info((Object)("Resolved parent node to " + parentNodeRef));
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(node.getProperties());
        Map<QName, Serializable> contentProps = this.processProperties(null, props, null);
        this.injectTransferred(props);
        props.remove(TransferModel.PROP_INVADED_BY);
        if (this.header.isReadOnly()) {
            log.debug((Object)"new node needs to be locked");
            props.put(ContentModel.PROP_LOCK_OWNER, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
            props.put(ContentModel.PROP_LOCK_TYPE, (Serializable)((Object)LockType.NODE_LOCK.toString()));
            props.put(ContentModel.PROP_EXPIRY_DATE, null);
        }
        ChildAssociationRef newNode = this.nodeService.createNode(parentNodeRef, parentAssocType, parentAssocName, node.getType(), props);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new node (" + newNode.getChildRef() + ") parented by node " + newNode.getParentRef()));
        }
        this.logCreated(node.getNodeRef(), newNode.getChildRef(), newNode.getParentRef(), this.nodeService.getPath(newNode.getChildRef()), false);
        this.writeContent(newNode.getChildRef(), contentProps);
        HashSet<QName> aspects = new HashSet<QName>(node.getAspects());
        aspects.removeAll(this.nodeService.getAspects(newNode.getChildRef()));
        for (QName aspect : aspects) {
            this.nodeService.addAspect(newNode.getChildRef(), aspect, null);
        }
        ManifestAccessControl acl = node.getAccessControl();
        if (acl != null) {
            this.permissionService.setInheritParentPermissions(newNode.getChildRef(), acl.isInherited());
            if (acl.getPermissions() != null) {
                for (ManifestPermission permission : acl.getPermissions()) {
                    log.debug((Object)"setting permission on node");
                    AccessStatus status = AccessStatus.valueOf((String)permission.getStatus());
                    this.permissionService.setPermission(newNode.getChildRef(), permission.getAuthority(), permission.getPermission(), status == AccessStatus.ALLOWED);
                }
            }
        }
        if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) || this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
            this.alienProcessor.onCreateChild(newNode, this.header.getRepositoryId(), true);
        }
        this.checkOrphans(newNode.getChildRef());
    }

    protected void delete(TransferManifestDeletedNode node, NodeRef nodeToDelete) {
        if (this.alienProcessor.isAlien(nodeToDelete)) {
            this.logComment("Node contains alien content and can't be deleted: " + nodeToDelete);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node to be deleted is alien prune rather than delete: " + nodeToDelete));
            }
            this.alienProcessor.pruneNode(nodeToDelete, this.header.getRepositoryId());
        } else {
            if (this.nodeService.hasAspect(nodeToDelete, TransferModel.ASPECT_TRANSFERRED)) {
                String fromRepository = (String)((Object)this.nodeService.getProperty(nodeToDelete, TransferModel.PROP_FROM_REPOSITORY_ID));
                String transferringRepo = this.header.getRepositoryId();
                if (fromRepository != null && transferringRepo != null && !fromRepository.equalsIgnoreCase(transferringRepo)) {
                    this.logComment("Not deleting local node (not from the transferring repository): " + nodeToDelete);
                    return;
                }
            }
            this.logDeleted(node.getNodeRef(), nodeToDelete, this.nodeService.getPath(nodeToDelete));
            this.nodeService.deleteNode(nodeToDelete);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted local node: " + nodeToDelete));
            }
        }
    }

    private void checkOrphans(NodeRef parentNode) {
        List<ChildAssociationRef> orphansToClaim = this.orphans.get(parentNode);
        if (orphansToClaim != null) {
            for (ChildAssociationRef orphan : orphansToClaim) {
                this.logComment("Re-parenting previously orphaned node (" + orphan.getChildRef() + ") with found parent " + orphan.getParentRef());
                ChildAssociationRef newRef = this.nodeService.moveNode(orphan.getChildRef(), orphan.getParentRef(), orphan.getTypeQName(), orphan.getQName());
                if (!this.nodeService.hasAspect(newRef.getParentRef(), TransferModel.ASPECT_TRANSFERRED)) continue;
                this.alienProcessor.onCreateChild(newRef, this.header.getRepositoryId(), true);
            }
            this.orphans.remove(parentNode);
        }
    }

    private void update(TransferManifestNormalNode node, CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes, ChildAssociationRef primaryParentAssoc) {
        ChildAssociationRef currentParent;
        NodeRef nodeToUpdate = resolvedNodes.resolvedChild;
        if (this.nodeService.hasAspect(nodeToUpdate, TransferModel.ASPECT_TRANSFERRED)) {
            String fromRepository = (String)((Object)this.nodeService.getProperty(nodeToUpdate, TransferModel.PROP_FROM_REPOSITORY_ID));
            String transferringRepo = this.header.getRepositoryId();
            if (fromRepository != null && transferringRepo != null && !fromRepository.equalsIgnoreCase(transferringRepo)) {
                this.logComment("Not updating local node (not from the transferring repository): " + node.getNodeRef());
                return;
            }
        }
        QName parentAssocType = primaryParentAssoc.getTypeQName();
        QName parentAssocName = primaryParentAssoc.getQName();
        NodeRef parentNodeRef = resolvedNodes.resolvedParent;
        if (parentNodeRef == null) {
            ChildAssociationRef tempLocation = this.getTemporaryLocation(node.getNodeRef());
            parentNodeRef = tempLocation.getParentRef();
            parentAssocType = tempLocation.getTypeQName();
            parentAssocName = tempLocation.getQName();
            this.storeOrphanNode(primaryParentAssoc);
        }
        if (!((currentParent = this.nodeService.getPrimaryParent(nodeToUpdate)).getParentRef().equals((Object)parentNodeRef) && currentParent.getTypeQName().equals((Object)parentAssocType) && currentParent.getQName().equals((Object)parentAssocName))) {
            if (this.nodeService.hasAspect(currentParent.getParentRef(), TransferModel.ASPECT_ALIEN)) {
                this.alienProcessor.beforeDeleteAlien(currentParent.getChildRef(), null);
            }
            ChildAssociationRef newNode = this.nodeService.moveNode(nodeToUpdate, parentNodeRef, parentAssocType, parentAssocName);
            this.logMoved(node.getNodeRef(), nodeToUpdate, node.getParentPath(), newNode.getParentRef(), this.nodeService.getPath(newNode.getChildRef()));
            if (this.nodeService.hasAspect(newNode.getChildRef(), TransferModel.ASPECT_ALIEN)) {
                this.alienProcessor.afterMoveAlien(newNode);
            } else if (this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_TRANSFERRED) || this.nodeService.hasAspect(parentNodeRef, TransferModel.ASPECT_ALIEN)) {
                this.alienProcessor.onCreateChild(newNode, this.header.getRepositoryId(), true);
            }
        }
        log.info((Object)("Resolved parent node to " + parentNodeRef));
        if (this.updateNeeded(node, nodeToUpdate)) {
            this.logUpdated(node.getNodeRef(), nodeToUpdate, this.nodeService.getPath(nodeToUpdate));
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(node.getProperties());
            Map existingProps = this.nodeService.getProperties(nodeToUpdate);
            this.injectTransferred(props);
            props.remove(TransferModel.PROP_INVADED_BY);
            if (this.header.isReadOnly()) {
                props.put(ContentModel.PROP_LOCK_OWNER, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
                props.put(ContentModel.PROP_LOCK_TYPE, (Serializable)((Object)LockType.NODE_LOCK.toString()));
                props.put(ContentModel.PROP_EXPIRY_DATE, null);
                log.debug((Object)"updated node needs to be locked");
            }
            Map<QName, Serializable> contentProps = this.processProperties(nodeToUpdate, props, existingProps);
            if (existingProps.containsKey(TransferModel.PROP_INVADED_BY)) {
                props.put(TransferModel.PROP_INVADED_BY, (Serializable)existingProps.get(TransferModel.PROP_INVADED_BY));
            }
            this.nodeService.setProperties(nodeToUpdate, props);
            this.writeContent(nodeToUpdate, contentProps);
            HashSet<QName> suppliedAspects = new HashSet<QName>(node.getAspects());
            Set existingAspects = this.nodeService.getAspects(nodeToUpdate);
            HashSet aspectsToRemove = new HashSet(existingAspects);
            List aspectDefs = this.dictionaryService.getType(this.nodeService.getType(nodeToUpdate)).getDefaultAspects(true);
            for (AspectDefinition aspectDef : aspectDefs) {
                suppliedAspects.add(aspectDef.getName());
            }
            if (this.header.isReadOnly()) {
                suppliedAspects.add(ContentModel.ASPECT_LOCKABLE);
            }
            aspectsToRemove.removeAll(suppliedAspects);
            aspectsToRemove.remove(TransferModel.ASPECT_TRANSFERRED);
            aspectsToRemove.remove(TransferModel.ASPECT_ALIEN);
            suppliedAspects.removeAll(existingAspects);
            for (QName aspect : suppliedAspects) {
                this.nodeService.addAspect(nodeToUpdate, aspect, null);
            }
            for (QName aspect : aspectsToRemove) {
                this.nodeService.removeAspect(nodeToUpdate, aspect);
            }
            ManifestAccessControl acl = node.getAccessControl();
            if (acl != null) {
                boolean existInherit = this.permissionService.getInheritParentPermissions(nodeToUpdate);
                if (existInherit != acl.isInherited()) {
                    log.debug((Object)"changed inherit permissions flag");
                    this.permissionService.setInheritParentPermissions(nodeToUpdate, acl.isInherited());
                }
                Set existingPermissions = this.permissionService.getAllSetPermissions(nodeToUpdate);
                List<ManifestPermission> newPermissions = acl.getPermissions();
                if (existingPermissions.size() > 0 || newPermissions != null) {
                    log.debug((Object)"have to check permissions");
                    HashSet<ManifestPermission> work = new HashSet<ManifestPermission>();
                    for (AccessPermission accessPermission : existingPermissions) {
                        if (!accessPermission.isSetDirectly()) continue;
                        ManifestPermission p = new ManifestPermission();
                        p.setAuthority(accessPermission.getAuthority());
                        p.setPermission(accessPermission.getPermission());
                        p.setStatus(accessPermission.getAccessStatus().toString());
                        work.add(p);
                    }
                    if (newPermissions != null) {
                        for (ManifestPermission manifestPermission : acl.getPermissions()) {
                            if (work.contains(manifestPermission)) continue;
                            log.debug((Object)("setting permission on node:" + manifestPermission));
                            AccessStatus status = AccessStatus.valueOf((String)manifestPermission.getStatus());
                            this.permissionService.setPermission(nodeToUpdate, manifestPermission.getAuthority(), manifestPermission.getPermission(), status == AccessStatus.ALLOWED);
                        }
                        work.removeAll(newPermissions);
                    }
                    for (ManifestPermission manifestPermission : work) {
                        log.debug((Object)("removing permission on node:" + manifestPermission));
                        this.permissionService.deletePermission(nodeToUpdate, manifestPermission.getAuthority(), manifestPermission.getPermission());
                    }
                }
            }
        }
    }

    private Map<QName, Serializable> processProperties(NodeRef nodeToUpdate, Map<QName, Serializable> props, Map<QName, Serializable> existingProps) {
        HashMap<QName, Serializable> contentProps = new HashMap<QName, Serializable>();
        for (Map.Entry<QName, Serializable> propEntry : props.entrySet()) {
            Serializable value = propEntry.getValue();
            QName key = propEntry.getKey();
            if (log.isDebugEnabled() && value == null) {
                log.debug((Object)("Received a null value for property " + propEntry.getKey()));
            }
            if (value == null || !ContentData.class.isAssignableFrom(value.getClass())) continue;
            if (existingProps != null) {
                ContentData contentData;
                String contentUrl;
                String fileName;
                File stagingDir = this.getStagingFolder();
                File stagedFile = new File(stagingDir, fileName = TransferCommons.URLToPartName(contentUrl = (contentData = (ContentData)propEntry.getValue()).getContentUrl()));
                if (stagedFile.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("replace content for node:" + nodeToUpdate + ", " + key));
                    }
                    contentProps.put(propEntry.getKey(), propEntry.getValue());
                    continue;
                }
                if (!props.containsKey(key)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("keep existing content for node:" + nodeToUpdate + ", " + key));
                }
                props.put(propEntry.getKey(), existingProps.get(key));
                continue;
            }
            contentProps.put(propEntry.getKey(), propEntry.getValue());
        }
        for (QName contentPropertyName : contentProps.keySet()) {
            props.remove(contentPropertyName);
        }
        if (existingProps != null) {
            for (QName localProperty : this.getLocalProperties()) {
                Serializable existingValue = existingProps.get(localProperty);
                if (existingValue != null) {
                    props.put(localProperty, existingValue);
                    continue;
                }
                props.remove(localProperty);
            }
        }
        return contentProps;
    }

    private void writeContent(NodeRef nodeToUpdate, Map<QName, Serializable> contentProps) {
        File stagingDir = this.getStagingFolder();
        for (Map.Entry<QName, Serializable> contentEntry : contentProps.entrySet()) {
            ContentData contentData = (ContentData)contentEntry.getValue();
            String contentUrl = contentData.getContentUrl();
            String fileName = TransferCommons.URLToPartName(contentUrl);
            File stagedFile = new File(stagingDir, fileName);
            if (!stagedFile.exists()) {
                this.error(MSG_REFERENCED_CONTENT_FILE_MISSING);
            }
            ContentWriter writer = this.contentService.getWriter(nodeToUpdate, contentEntry.getKey(), true);
            writer.setEncoding(contentData.getEncoding());
            writer.setMimetype(contentData.getMimetype());
            writer.setLocale(contentData.getLocale());
            writer.putContent(stagedFile);
        }
    }

    protected boolean updateNeeded(TransferManifestNormalNode node, NodeRef nodeToUpdate) {
        boolean updateNeeded = true;
        return updateNeeded;
    }

    protected Set<QName> getLocalProperties() {
        return DEFAULT_LOCAL_PROPERTIES;
    }

    private void storeOrphanNode(ChildAssociationRef primaryParentAssoc) {
        List<ChildAssociationRef> orphansOfParent = this.orphans.get(primaryParentAssoc.getParentRef());
        if (orphansOfParent == null) {
            orphansOfParent = new ArrayList<ChildAssociationRef>();
            this.orphans.put(primaryParentAssoc.getParentRef(), orphansOfParent);
        }
        orphansOfParent.add(primaryParentAssoc);
    }

    private void error(TransferManifestNode node, String msgId) {
        TransferProcessingException ex = new TransferProcessingException(msgId);
        log.error((Object)ex.getMessage(), (Throwable)((Object)ex));
        throw ex;
    }

    private void error(String msgId) {
        TransferProcessingException ex = new TransferProcessingException(msgId);
        log.error((Object)ex.getMessage(), (Throwable)((Object)ex));
        throw ex;
    }

    @Override
    protected void processHeader(TransferManifestHeader header) {
        this.header = header;
    }

    @Override
    protected void startManifest() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    private void injectTransferred(Map<QName, Serializable> props) {
        if (!props.containsKey(TransferModel.PROP_REPOSITORY_ID)) {
            log.debug((Object)"injecting repositoryId property");
            props.put(TransferModel.PROP_REPOSITORY_ID, (Serializable)((Object)this.header.getRepositoryId()));
        }
        props.put(TransferModel.PROP_FROM_REPOSITORY_ID, (Serializable)((Object)this.header.getRepositoryId()));
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }

    static {
        DEFAULT_LOCAL_PROPERTIES.add(ContentModel.PROP_STORE_IDENTIFIER);
        DEFAULT_LOCAL_PROPERTIES.add(ContentModel.PROP_STORE_NAME);
        DEFAULT_LOCAL_PROPERTIES.add(ContentModel.PROP_STORE_PROTOCOL);
        DEFAULT_LOCAL_PROPERTIES.add(ContentModel.PROP_NODE_DBID);
        DEFAULT_LOCAL_PROPERTIES.add(ContentModel.PROP_NODE_REF);
        DEFAULT_LOCAL_PROPERTIES.add(ContentModel.PROP_NODE_UUID);
    }
}

