/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.TransferCommons;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.requisite.TransferRequsiteWriter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoRequisiteManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private NodeService nodeService;
    private CorrespondingNodeResolver nodeResolver;
    private TransferRequsiteWriter out;
    private static final Log log = LogFactory.getLog(RepoRequisiteManifestProcessorImpl.class);

    public RepoRequisiteManifestProcessorImpl(TransferReceiver receiver, String transferId, TransferRequsiteWriter out) {
        super(receiver, transferId);
        this.out = out;
    }

    protected void endManifest() {
        log.debug((Object)"End Requsite");
        this.out.endTransferRequsite();
    }

    protected void processNode(TransferManifestDeletedNode node) {
    }

    protected void processNode(TransferManifestNormalNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing node with incoming noderef of " + node.getNodeRef()));
        }
        this.logComment("Primary Processing incoming node: " + node.getNodeRef() + " --  Source path = " + node.getParentPath() + "/" + node.getPrimaryParentAssoc().getQName());
        ChildAssociationRef primaryParentAssoc = node.getPrimaryParentAssoc();
        CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes = this.nodeResolver.resolveCorrespondingNode(node.getNodeRef(), primaryParentAssoc, node.getParentPath());
        if (resolvedNodes.resolvedChild != null) {
            NodeRef destinationNode = resolvedNodes.resolvedChild;
            Map destProps = this.nodeService.getProperties(destinationNode);
            for (Map.Entry<QName, Serializable> propEntry : node.getProperties().entrySet()) {
                Serializable value = propEntry.getValue();
                if (log.isDebugEnabled() && value == null) {
                    log.debug((Object)("Received a null value for property " + propEntry.getKey()));
                }
                if (value == null || !ContentData.class.isAssignableFrom(value.getClass())) continue;
                ContentData srcContent = (ContentData)value;
                Serializable destSer = (Serializable)destProps.get(propEntry.getKey());
                if (destSer != null && ContentData.class.isAssignableFrom(destSer.getClass())) {
                    ContentData destContent = (ContentData)destProps.get(propEntry.getKey());
                    Serializable srcModified = node.getProperties().get(ContentModel.PROP_MODIFIED);
                    Serializable destModified = (Serializable)destProps.get(ContentModel.PROP_MODIFIED);
                    log.debug((Object)("srcModified :" + srcModified + "destModified :" + destModified));
                    if (srcModified != null && destModified != null && srcModified instanceof Date && destModified instanceof Date && ((Date)srcModified).getTime() <= ((Date)destModified).getTime()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("the modified date is the same - no need to send it:" + destContent.getContentUrl()));
                        continue;
                    }
                    this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(srcContent.getContentUrl()));
                    continue;
                }
                this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(srcContent.getContentUrl()));
            }
        } else {
            for (Map.Entry<QName, Serializable> propEntry : node.getProperties().entrySet()) {
                Serializable value = propEntry.getValue();
                if (log.isDebugEnabled() && value == null) {
                    log.debug((Object)("Received a null value for property " + propEntry.getKey()));
                }
                if (value == null || !ContentData.class.isAssignableFrom(value.getClass())) continue;
                ContentData content = (ContentData)value;
                this.out.missingContent(node.getNodeRef(), propEntry.getKey(), TransferCommons.URLToPartName(content.getContentUrl()));
            }
        }
    }

    protected void processHeader(TransferManifestHeader header) {
    }

    protected void startManifest() {
        log.debug((Object)"Start Requsite");
        this.out.startTransferRequsite();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }
}

