/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.Transfer;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.report.TransferReporter;
import org.alfresco.repo.transfer.report.XMLTransferReportWriter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferReporterImpl
implements TransferReporter {
    private NodeService nodeService;
    private ContentService contentService;
    private static Log logger = LogFactory.getLog(TransferReporterImpl.class);
    private static String DEFAULT_ENCODING = "UTF-8";

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
    }

    public NodeRef createDestinationTransferReport(TransferTarget target) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeRef createTransferReport(String transferName, Exception e, TransferTarget target, TransferDefinition definition, List<TransferEvent> events, File snapshotFile) {
        NodeRef nodeRef;
        HashMap<QName, String> properties = new HashMap<QName, String>();
        String title = transferName;
        String description = "Transfer Report - target: " + target.getName();
        String name = transferName;
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_TITLE, title);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        ChildAssociationRef ref = this.nodeService.createNode(target.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), TransferModel.TYPE_TRANSFER_REPORT, properties);
        ContentWriter writer = this.contentService.getWriter(ref.getChildRef(), ContentModel.PROP_CONTENT, true);
        writer.setLocale(Locale.getDefault());
        writer.setMimetype("text/xml");
        writer.setEncoding(DEFAULT_ENCODING);
        XMLTransferReportWriter reportWriter = new XMLTransferReportWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(writer.getContentOutputStream()));
        try {
            try {
                reportWriter.startTransferReport(DEFAULT_ENCODING, bufferedWriter);
                reportWriter.writeTarget(target);
                reportWriter.writeDefinition(definition);
                reportWriter.writeException(e);
                reportWriter.writeTransferEvents(events);
                reportWriter.endTransferReport();
                nodeRef = ref.getChildRef();
                Object var18_17 = null;
            }
            catch (SAXException se) {
                NodeRef nodeRef2 = null;
                Object var18_18 = null;
                try {
                    bufferedWriter.close();
                    return nodeRef2;
                }
                catch (IOException error) {
                    error.printStackTrace();
                }
                return nodeRef2;
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            try {}
            catch (IOException error) {
                error.printStackTrace();
                throw throwable;
            }
            bufferedWriter.close();
            throw throwable;
        }
        try {}
        catch (IOException error) {
            error.printStackTrace();
            return nodeRef;
        }
        bufferedWriter.close();
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public NodeRef createTransferReport(String transferName, Transfer transfer, TransferTarget target, TransferDefinition definition, List<TransferEvent> events, File snapshotFile) {
        NodeRef nodeRef;
        HashMap<QName, String> properties = new HashMap<QName, String>();
        String title = transferName;
        String description = "Transfer Report - target: " + target.getName();
        String name = transferName;
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_TITLE, title);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        ChildAssociationRef ref = this.nodeService.createNode(target.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), TransferModel.TYPE_TRANSFER_REPORT, properties);
        ContentWriter writer = this.contentService.getWriter(ref.getChildRef(), ContentModel.PROP_CONTENT, true);
        writer.setLocale(Locale.getDefault());
        writer.setMimetype("text/xml");
        writer.setEncoding(DEFAULT_ENCODING);
        final XMLTransferReportWriter reportWriter = new XMLTransferReportWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(writer.getContentOutputStream()));
        reportWriter.startTransferReport(DEFAULT_ENCODING, bufferedWriter);
        reportWriter.writeTarget(target);
        reportWriter.writeDefinition(definition);
        TransferManifestProcessor processor = new TransferManifestProcessor(){

            public void processTransferManifestNode(TransferManifestNormalNode node) {
                try {
                    reportWriter.writeNodeSummary(node);
                }
                catch (SAXException error) {
                    error.printStackTrace();
                }
            }

            public void processTransferManifestNode(TransferManifestDeletedNode node) {
                try {
                    reportWriter.writeNodeSummary(node);
                }
                catch (SAXException error) {
                    error.printStackTrace();
                }
            }

            public void processTransferManifiestHeader(TransferManifestHeader header) {
            }

            public void startTransferManifest() {
            }

            public void endTransferManifest() {
            }
        };
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser parser = saxParserFactory.newSAXParser();
        XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
        try {
            parser.parse(snapshotFile, (DefaultHandler)reader);
        }
        catch (IOException error) {
            error.printStackTrace();
            NodeRef nodeRef2 = null;
            Object var22_24 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException error2) {
                error2.printStackTrace();
            }
            return nodeRef2;
        }
        reportWriter.writeTransferEvents(events);
        reportWriter.endTransferReport();
        NodeRef nodeRef3 = ref.getChildRef();
        Object var22_25 = null;
        try {
            bufferedWriter.close();
        }
        catch (IOException error2) {
            error2.printStackTrace();
        }
        return nodeRef3;
        catch (SAXException se) {
            nodeRef = null;
            Object var22_26 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException error2) {
                error2.printStackTrace();
            }
            return nodeRef;
        }
        catch (ParserConfigurationException error) {
            error.printStackTrace();
            nodeRef = null;
            Object var22_27 = null;
            {
                catch (Throwable throwable) {
                    Object var22_28 = null;
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException error2) {
                        error2.printStackTrace();
                    }
                    throw throwable;
                }
            }
            try {
                bufferedWriter.close();
            }
            catch (IOException error2) {
                error2.printStackTrace();
            }
            return nodeRef;
        }
    }

    @Override
    public NodeRef writeDestinationReport(String transferName, TransferTarget target, File tempFile) {
        String title = transferName + "_destination";
        String description = "Transfer Destination Report - target: " + target.getName();
        String name = title;
        logger.debug((Object)("writing destination transfer report " + title));
        logger.debug((Object)("parent node ref " + target.getNodeRef()));
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, name);
        properties.put(ContentModel.PROP_TITLE, title);
        properties.put(ContentModel.PROP_DESCRIPTION, description);
        ChildAssociationRef ref = this.nodeService.createNode(target.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), TransferModel.TYPE_TRANSFER_REPORT_DEST, properties);
        ContentWriter writer = this.contentService.getWriter(ref.getChildRef(), ContentModel.PROP_CONTENT, true);
        writer.setLocale(Locale.getDefault());
        writer.setMimetype("text/xml");
        writer.setEncoding(DEFAULT_ENCODING);
        writer.putContent(tempFile);
        logger.debug((Object)("written " + name + ", " + ref.getChildRef()));
        return ref.getChildRef();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }
}

