/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionableAspect
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
VersionServicePolicies.AfterCreateVersionPolicy,
CopyServicePolicies.OnCopyNodePolicy {
    private static final String MSG_INITIAL_VERSION = "create_version.initial_version";
    private static final String MSG_AUTO_VERSION = "create_version.auto_version";
    private static final String MSG_AUTO_VERSION_PROPS = "create_version.auto_version_props";
    private static final String KEY_VERSIONED_NODEREFS = "versioned_noderefs";
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private VersionService versionService;
    JavaBehaviour onUpdatePropertiesBehaviour;
    private List<String> excludedOnUpdateProps = Collections.emptyList();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setExcludedOnUpdateProps(List<String> excludedOnUpdateProps) {
        this.excludedOnUpdateProps = excludedOnUpdateProps;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onRemoveAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onDeleteNode", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"afterCreateVersion"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "afterCreateVersion", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onContentUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.onUpdatePropertiesBehaviour = new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)this.onUpdatePropertiesBehaviour);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        if (!isNodeArchived) {
            this.versionService.deleteVersionHistory(childAssocRef.getChildRef());
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return VersionableAspectCopyBehaviourCallback.INSTANCE;
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.nodeService.exists(nodeRef) && aspectTypeQName.equals((Object)ContentModel.ASPECT_VERSIONABLE)) {
            Map versionedNodeRefs;
            boolean initialVersion = true;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_INITIAL_VERSION);
            if (value != null) {
                initialVersion = value;
            }
            if (initialVersion && ((versionedNodeRefs = (Map)AlfrescoTransactionSupport.getResource(KEY_VERSIONED_NODEREFS)) == null || !versionedNodeRefs.containsKey(nodeRef))) {
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
                versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_INITIAL_VERSION)));
                this.createVersionImpl(nodeRef, versionProperties);
            }
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.versionService.deleteVersionHistory(nodeRef);
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        Map versionedNodeRefs;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY) && ((versionedNodeRefs = (Map)AlfrescoTransactionSupport.getResource(KEY_VERSIONED_NODEREFS)) == null || !versionedNodeRefs.containsKey(nodeRef))) {
            boolean autoVersion = false;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION);
            if (value != null) {
                autoVersion = value;
            }
            if (autoVersion) {
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
                versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_AUTO_VERSION)));
                this.createVersionImpl(nodeRef, versionProperties);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        block9: {
            block10: {
                if (!this.nodeService.exists(nodeRef)) return;
                if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) return;
                if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY)) return;
                if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) return;
                this.onUpdatePropertiesBehaviour.disable();
                try {
                    Map versionedNodeRefs = (Map)AlfrescoTransactionSupport.getResource(KEY_VERSIONED_NODEREFS);
                    if (versionedNodeRefs != null && versionedNodeRefs.containsKey(nodeRef)) break block9;
                    boolean autoVersion = false;
                    Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION);
                    if (value != null) {
                        autoVersion = value;
                    }
                    boolean autoVersionProps = false;
                    value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION_PROPS);
                    if (value != null) {
                        autoVersionProps = value;
                    }
                    if (!autoVersion || !autoVersionProps) break block9;
                    if (this.excludedOnUpdateProps.size() > 0) {
                        HashMap<String, QName> propNames = new HashMap<String, QName>(after.size());
                        for (QName afterProp : after.keySet()) {
                            if (!this.excludedOnUpdateProps.contains(afterProp.getPrefixString())) continue;
                            propNames.put(afterProp.getPrefixString(), afterProp);
                        }
                        for (QName beforeProp : before.keySet()) {
                            if (!this.excludedOnUpdateProps.contains(beforeProp.getPrefixString())) continue;
                            propNames.put(beforeProp.getPrefixString(), beforeProp);
                        }
                        if (propNames.size() > 0) {
                            for (QName prop : propNames.values()) {
                                Serializable afterValue;
                                Serializable beforeValue = before.get(prop);
                                if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)(afterValue = after.get(prop)))) continue;
                                Object var14_13 = null;
                                break block10;
                            }
                        }
                    }
                    HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
                    versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_AUTO_VERSION_PROPS)));
                    this.createVersionImpl(nodeRef, versionProperties);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    this.onUpdatePropertiesBehaviour.enable();
                    throw throwable;
                }
            }
            this.onUpdatePropertiesBehaviour.enable();
            return;
        }
        Object var14_14 = null;
        this.onUpdatePropertiesBehaviour.enable();
    }

    private void createVersionImpl(NodeRef nodeRef, Map<String, Serializable> versionProperties) {
        this.recordCreateVersion(nodeRef, null);
        this.versionService.createVersion(nodeRef, versionProperties);
    }

    @Override
    public void afterCreateVersion(NodeRef versionableNode, Version version) {
        this.recordCreateVersion(versionableNode, version);
    }

    private void recordCreateVersion(NodeRef versionableNode, Version version) {
        HashMap<NodeRef, NodeRef> versionedNodeRefs = (HashMap<NodeRef, NodeRef>)AlfrescoTransactionSupport.getResource(KEY_VERSIONED_NODEREFS);
        if (versionedNodeRefs == null) {
            versionedNodeRefs = new HashMap<NodeRef, NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_VERSIONED_NODEREFS, versionedNodeRefs);
        }
        versionedNodeRefs.put(versionableNode, versionableNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionableAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new VersionableAspectCopyBehaviourCallback();

        private VersionableAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            Serializable value1 = properties.get(ContentModel.PROP_AUTO_VERSION);
            Serializable value2 = properties.get(ContentModel.PROP_AUTO_VERSION_PROPS);
            if (value1 != null || value2 != null) {
                HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(2);
                if (value1 != null) {
                    newProperties.put(ContentModel.PROP_AUTO_VERSION, value1);
                }
                if (value2 != null) {
                    newProperties.put(ContentModel.PROP_AUTO_VERSION_PROPS, value2);
                }
                return newProperties;
            }
            return Collections.emptyMap();
        }
    }
}

