/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartWorkflowActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "start-workflow";
    public static final String PARAM_WORKFLOW_NAME = "workflowName";
    public static final String PARAM_END_START_TASK = "endStartTask";
    public static final String PARAM_START_TASK_TRANSITION = "startTaskTransition";
    private NamespaceService namespaceService;
    private WorkflowService workflowService;
    private NodeService nodeService;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    protected boolean getAdhocPropertiesAllowed() {
        return true;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_WORKFLOW_NAME, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_WORKFLOW_NAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_END_START_TASK, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_END_START_TASK)));
        paramList.add(new ParameterDefinitionImpl(PARAM_START_TASK_TRANSITION, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_START_TASK_TRANSITION)));
    }

    @Override
    protected void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        String workflowName = (String)((Object)ruleAction.getParameterValue(PARAM_WORKFLOW_NAME));
        WorkflowDefinition def = this.workflowService.getDefinitionByName(workflowName);
        NodeRef workflowPackage = (NodeRef)ruleAction.getParameterValue(WorkflowModel.ASSOC_PACKAGE.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        workflowPackage = this.workflowService.createPackage(workflowPackage);
        ChildAssociationRef childAssoc = this.nodeService.getPrimaryParent(actionedUponNodeRef);
        this.nodeService.addChild(workflowPackage, actionedUponNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, childAssoc.getQName());
        Map<String, Serializable> paramValues = ruleAction.getParameterValues();
        HashMap<QName, Serializable> workflowParameters = new HashMap<QName, Serializable>();
        workflowParameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)workflowPackage);
        for (Map.Entry<String, Serializable> entry : paramValues.entrySet()) {
            if (entry.getKey().equals(PARAM_WORKFLOW_NAME)) continue;
            QName qname = QName.createQName((String)entry.getKey(), (NamespacePrefixResolver)this.namespaceService);
            Serializable value = entry.getValue();
            workflowParameters.put(qname, value);
        }
        Serializable context = (Serializable)workflowParameters.get(WorkflowModel.PROP_CONTEXT);
        if (context == null) {
            workflowParameters.put(WorkflowModel.PROP_CONTEXT, (Serializable)childAssoc.getParentRef());
        }
        WorkflowPath path = this.workflowService.startWorkflow(def.id, workflowParameters);
        Boolean endStartTask = (Boolean)ruleAction.getParameterValue(PARAM_END_START_TASK);
        String startTaskTransition = (String)((Object)ruleAction.getParameterValue(PARAM_START_TASK_TRANSITION));
        if ((endStartTask = Boolean.valueOf(endStartTask == null)).booleanValue()) {
            List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.id);
            for (WorkflowTask task : tasks) {
                this.workflowService.endTask(task.id, startTaskTransition);
            }
        }
    }
}

