/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.jbpm.AlfrescoJavaScript;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AlfrescoJavaScriptIntegrationTest
extends BaseAlfrescoSpringTest {
    private static final QName fooName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"Foo");
    private static final QName barName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"Bar");
    private static final QName docName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"Doc");
    private static final String BASIC_USER = "basic" + GUID.generate();
    private static String systemUser = AuthenticationUtil.getSystemUserName();
    private ServiceRegistry services;
    private ExecutionContext context;
    private HashMap<String, Object> variables;
    private PersonService personService;

    public void testRunsWithoutAuthentication() throws Exception {
        NodeRef systemNode = this.personService.getPerson(systemUser);
        NodeRef baseUserNode = this.personService.getPerson(BASIC_USER);
        TestUserStore userStore = new TestUserStore();
        this.variables.put("userStore", userStore);
        Element script = this.buildScript("userStore.storeUsers(person)");
        AuthenticationUtil.clearCurrentSecurityContext();
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        AlfrescoJavaScript scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)systemUser, (String)userStore.runAsUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)systemUser, (String)userStore.fullUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)systemNode, (Object)userStore.person.getNodeRef());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
        TaskInstance taskInstance = (TaskInstance)Mockito.mock(TaskInstance.class);
        Mockito.when((Object)taskInstance.getActorId()).thenReturn((Object)BASIC_USER);
        Mockito.when((Object)this.context.getTaskInstance()).thenReturn((Object)taskInstance);
        scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)BASIC_USER, (String)userStore.runAsUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((String)BASIC_USER, (String)userStore.fullUser);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)baseUserNode, (Object)userStore.person.getNodeRef());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getFullyAuthenticatedUser());
        AlfrescoJavaScriptIntegrationTest.assertNull((Object)AuthenticationUtil.getRunAsUser());
    }

    public void testRunAsAdminMoveContent() throws Exception {
        AlfrescoJavaScript scriptHandler;
        NodeRef fooFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, fooName, ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef barFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, barName, ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef doc = this.nodeService.createNode(fooFolder, ContentModel.ASSOC_CONTAINS, docName, ContentModel.TYPE_CONTENT).getChildRef();
        PermissionService permissions = this.services.getPermissionService();
        permissions.setPermission(doc, BASIC_USER, "All", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)BASIC_USER);
        Element script = this.buildScript("doc.move(bar)");
        this.variables.put("doc", new JBPMNode(doc, this.services));
        this.variables.put("bar", new JBPMNode(barFolder, this.services));
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)fooFolder, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
        try {
            scriptHandler = new AlfrescoJavaScript();
            scriptHandler.setScript(script);
            scriptHandler.execute(this.context);
            AlfrescoJavaScriptIntegrationTest.fail((String)"The user should not have permission to write to bar!");
        }
        catch (ScriptException e) {
            // empty catch block
        }
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)fooFolder, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
        scriptHandler = new AlfrescoJavaScript();
        scriptHandler.setScript(script);
        scriptHandler.setRunas(AuthenticationUtil.getAdminUserName());
        scriptHandler.execute(this.context);
        AlfrescoJavaScriptIntegrationTest.assertEquals((Object)barFolder, (Object)this.nodeService.getPrimaryParent(doc).getParentRef());
    }

    private Element buildScript(String expression) {
        Element script = DocumentHelper.createElement((String)"script");
        script.setText(expression);
        return script;
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        this.services = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.personService = this.services.getPersonService();
        this.createUser(BASIC_USER);
        this.context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        ContextInstance contextInstance = (ContextInstance)Mockito.mock(ContextInstance.class);
        Mockito.when((Object)this.context.getContextInstance()).thenReturn((Object)contextInstance);
        this.variables = new HashMap();
        Mockito.when((Object)contextInstance.getVariables()).thenReturn(this.variables);
        Mockito.when((Object)contextInstance.getVariables((Token)Matchers.any())).thenReturn(this.variables);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    public static class TestUserStore {
        private String runAsUser;
        private String fullUser;
        private JBPMNode person = null;

        public void storeUsers(JBPMNode person) {
            this.fullUser = AuthenticationUtil.getFullyAuthenticatedUser();
            this.runAsUser = AuthenticationUtil.getRunAsUser();
            this.person = person;
        }
    }
}

