/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowPackageComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBPMEngineTest
extends BaseSpringTest {
    AuthenticationComponent authenticationComponent;
    NodeService nodeService;
    WorkflowComponent workflowComponent;
    TaskComponent taskComponent;
    WorkflowPackageComponent packageComponent;
    WorkflowDefinition testWorkflowDef;
    NodeRef testNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        BPMEngineRegistry registry = (BPMEngineRegistry)this.applicationContext.getBean("bpm_engineRegistry");
        this.workflowComponent = registry.getWorkflowComponent("jbpm");
        this.taskComponent = registry.getTaskComponent("jbpm");
        this.packageComponent = (WorkflowPackageComponent)this.applicationContext.getBean("workflowPackageImpl");
        I18NUtil.registerResourceBundle((String)"jbpmresources/test-messages");
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_processdefinition.xml");
        JBPMEngineTest.assertFalse((boolean)this.workflowComponent.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        this.testWorkflowDef = deployment.definition;
        JBPMEngineTest.assertNotNull((Object)this.testWorkflowDef);
        JBPMEngineTest.assertEquals((String)"jbpm$test", (String)this.testWorkflowDef.name);
        JBPMEngineTest.assertEquals((String)"1", (String)this.testWorkflowDef.version);
        JBPMEngineTest.assertTrue((boolean)this.workflowComponent.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.testNodeRef = this.nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        this.nodeService.setProperty(this.testNodeRef, ContentModel.PROP_CREATED, (Serializable)new Date());
    }

    protected void onTearDownInTransaction() {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testGetWorkflowDefinitions() {
        List<WorkflowDefinition> workflowDefs = this.workflowComponent.getDefinitions();
        JBPMEngineTest.assertNotNull(workflowDefs);
        JBPMEngineTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
    }

    public void testDeployWorkflow() throws Exception {
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_processdefinition.xml");
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        this.testWorkflowDef = deployment.definition;
        JBPMEngineTest.assertNotNull((Object)this.testWorkflowDef);
        JBPMEngineTest.assertEquals((String)"jbpm$test", (String)this.testWorkflowDef.name);
        JBPMEngineTest.assertEquals((String)"2", (String)this.testWorkflowDef.version);
    }

    public void testStartWorkflow() {
        try {
            WorkflowPath path = this.workflowComponent.startWorkflow("norfolknchance", null);
            JBPMEngineTest.fail((String)"Failed to catch invalid definition id");
        }
        catch (WorkflowException e) {
            // empty catch block
        }
        WorkflowDefinition workflowDef = this.getTestDefinition();
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, null);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.id.endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.node);
        JBPMEngineTest.assertNotNull((Object)path.instance);
        JBPMEngineTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
    }

    public void testGetWorkflowById() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, null);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.id.endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.node);
        JBPMEngineTest.assertNotNull((Object)path.instance);
        JBPMEngineTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
        WorkflowInstance instance = this.workflowComponent.getWorkflowById(path.instance.id);
        JBPMEngineTest.assertNotNull((Object)instance);
        JBPMEngineTest.assertEquals((String)path.instance.id, (String)instance.id);
        this.workflowComponent.cancelWorkflow(instance.id);
        WorkflowInstance result = this.workflowComponent.getWorkflowById(instance.id);
        JBPMEngineTest.assertNull((String)"The workflow isntance should be null!", (Object)result);
    }

    public void testStartWorkflowParameters() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_TASK_ID, Integer.valueOf(3));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(10));
        params.put(QName.createQName((String)"", (String)"Message"), (Serializable)((Object)"Hello World"));
        params.put(QName.createQName((String)"", (String)"Array"), (Serializable)new String[]{"one", "two"});
        params.put(QName.createQName((String)"", (String)"NodeRef"), (Serializable)new NodeRef("workspace://1/1001"));
        params.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, params);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.id.endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.node);
        JBPMEngineTest.assertNotNull((Object)path.instance);
        JBPMEngineTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_TASK_ID));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_DUE_DATE));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PRIORITY));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PERCENT_COMPLETE));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(ContentModel.PROP_OWNER));
        NodeRef initiator = path.instance.initiator;
        String initiatorUsername = (String)((Object)this.nodeService.getProperty(initiator, ContentModel.PROP_USERNAME));
        JBPMEngineTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)initiatorUsername);
    }

    public void testUpdateTask() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.PROP_TASK_ID, Integer.valueOf(3));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(1));
        params.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(10));
        params.put(QName.createQName((String)"", (String)"Message"), (Serializable)((Object)"Hello World"));
        params.put(QName.createQName((String)"", (String)"Array"), (Serializable)new String[]{"one", "two"});
        params.put(QName.createQName((String)"", (String)"NodeRef"), (Serializable)new NodeRef("workspace://1/1001"));
        params.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, params);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertTrue((boolean)path.id.endsWith("-@"));
        JBPMEngineTest.assertNotNull((Object)path.node);
        JBPMEngineTest.assertNotNull((Object)path.instance);
        JBPMEngineTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_TASK_ID));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_DUE_DATE));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PRIORITY));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(WorkflowModel.PROP_PERCENT_COMPLETE));
        JBPMEngineTest.assertTrue((boolean)task.properties.containsKey(ContentModel.PROP_OWNER));
        try {
            WorkflowTask taskU1 = this.taskComponent.updateTask(task.id, null, null, null);
            JBPMEngineTest.assertNotNull((Object)taskU1);
        }
        catch (Throwable e) {
            JBPMEngineTest.fail((String)"Task update failed with null parameters");
        }
        HashMap<QName, Serializable> updateProperties2 = new HashMap<QName, Serializable>();
        updateProperties2.put(WorkflowModel.PROP_PERCENT_COMPLETE, Integer.valueOf(100));
        WorkflowTask taskU2 = this.taskComponent.updateTask(task.id, updateProperties2, null, null);
        JBPMEngineTest.assertEquals((Object)100, (Object)taskU2.properties.get(WorkflowModel.PROP_PERCENT_COMPLETE));
        QName assocName = QName.createQName((String)"", (String)"TestAssoc");
        ArrayList<NodeRef> toAdd = new ArrayList<NodeRef>();
        toAdd.add(new NodeRef("workspace://1/1001"));
        toAdd.add(new NodeRef("workspace://1/1002"));
        toAdd.add(new NodeRef("workspace://1/1003"));
        HashMap<QName, List<NodeRef>> addAssocs = new HashMap<QName, List<NodeRef>>();
        addAssocs.put(assocName, toAdd);
        WorkflowTask taskU3 = this.taskComponent.updateTask(task.id, null, addAssocs, null);
        JBPMEngineTest.assertNotNull((Object)taskU3.properties.get(assocName));
        JBPMEngineTest.assertEquals((int)3, (int)((List)((Object)taskU3.properties.get(assocName))).size());
        ArrayList<NodeRef> toAddAgain = new ArrayList<NodeRef>();
        toAddAgain.add(new NodeRef("workspace://1/1004"));
        toAddAgain.add(new NodeRef("workspace://1/1005"));
        HashMap<QName, List<NodeRef>> addAssocsAgain = new HashMap<QName, List<NodeRef>>();
        addAssocsAgain.put(assocName, toAddAgain);
        WorkflowTask taskU4 = this.taskComponent.updateTask(task.id, null, addAssocsAgain, null);
        JBPMEngineTest.assertNotNull((Object)taskU4.properties.get(assocName));
        JBPMEngineTest.assertEquals((int)5, (int)((List)((Object)taskU4.properties.get(assocName))).size());
        ArrayList<NodeRef> toRemove = new ArrayList<NodeRef>();
        toRemove.add(new NodeRef("workspace://1/1002"));
        toRemove.add(new NodeRef("workspace://1/1003"));
        HashMap<QName, List<NodeRef>> removeAssocs = new HashMap<QName, List<NodeRef>>();
        removeAssocs.put(assocName, toRemove);
        WorkflowTask taskU5 = this.taskComponent.updateTask(task.id, null, null, removeAssocs);
        JBPMEngineTest.assertNotNull((Object)taskU5.properties.get(assocName));
        JBPMEngineTest.assertEquals((int)3, (int)((List)((Object)taskU5.properties.get(assocName))).size());
    }

    public void testGetWorkflowInstances() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        this.workflowComponent.startWorkflow(workflowDef.id, null);
        this.workflowComponent.startWorkflow(workflowDef.id, null);
        List<WorkflowInstance> instances = this.workflowComponent.getActiveWorkflows(workflowDef.id);
        JBPMEngineTest.assertNotNull(instances);
        JBPMEngineTest.assertEquals((int)2, (int)instances.size());
        for (WorkflowInstance instance : instances) {
            JBPMEngineTest.assertEquals((String)workflowDef.id, (String)instance.definition.id);
        }
    }

    public void testGetPositions() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        this.workflowComponent.startWorkflow(workflowDef.id, null);
        List<WorkflowInstance> instances = this.workflowComponent.getActiveWorkflows(workflowDef.id);
        JBPMEngineTest.assertNotNull(instances);
        JBPMEngineTest.assertEquals((int)1, (int)instances.size());
        List<WorkflowPath> paths = this.workflowComponent.getWorkflowPaths(instances.get((int)0).id);
        JBPMEngineTest.assertNotNull(paths);
        JBPMEngineTest.assertEquals((int)1, (int)paths.size());
        JBPMEngineTest.assertEquals((String)instances.get((int)0).id, (String)paths.get((int)0).instance.id);
        JBPMEngineTest.assertTrue((boolean)paths.get((int)0).id.endsWith("-@"));
    }

    public void testCancelWorkflowInstance() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        this.workflowComponent.startWorkflow(workflowDef.id, null);
        List<WorkflowInstance> instances1 = this.workflowComponent.getActiveWorkflows(workflowDef.id);
        JBPMEngineTest.assertNotNull(instances1);
        JBPMEngineTest.assertEquals((int)1, (int)instances1.size());
        List<WorkflowTask> tasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertNotNull(tasks);
        JBPMEngineTest.assertTrue((tasks.size() > 0 ? 1 : 0) != 0);
        WorkflowInstance cancelledInstance = this.workflowComponent.cancelWorkflow(instances1.get((int)0).id);
        JBPMEngineTest.assertNotNull((Object)cancelledInstance);
        JBPMEngineTest.assertFalse((boolean)cancelledInstance.active);
        List<WorkflowInstance> instances2 = this.workflowComponent.getActiveWorkflows(workflowDef.id);
        JBPMEngineTest.assertNotNull(instances2);
        JBPMEngineTest.assertEquals((int)0, (int)instances2.size());
        List<WorkflowTask> tasks1 = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertNotNull(tasks1);
        tasks1 = this.filterTasksByWorkflowInstance(tasks1, cancelledInstance.id);
        JBPMEngineTest.assertEquals((int)0, (int)tasks1.size());
    }

    public void testSignal() {
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        WorkflowDefinition workflowDef = this.getTestDefinition();
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        WorkflowPath updatedPath = this.workflowComponent.signal(path.id, path.node.transitions[1].id);
        JBPMEngineTest.assertNotNull((Object)updatedPath);
    }

    public void testGetAssignedTasks() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks);
        JBPMEngineTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks.get((int)0).id, path.node.transitions[0].id);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
        List<WorkflowTask> completedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.COMPLETED);
        JBPMEngineTest.assertNotNull(completedTasks);
        completedTasks = this.filterTasksByWorkflowInstance(completedTasks, path.instance.id);
        JBPMEngineTest.assertEquals((int)1, (int)completedTasks.size());
        List<WorkflowTask> assignedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        JBPMEngineTest.assertNotNull(assignedTasks);
        assignedTasks = this.filterTasksByWorkflowInstance(assignedTasks, path.instance.id);
        JBPMEngineTest.assertEquals((int)1, (int)assignedTasks.size());
        JBPMEngineTest.assertEquals((String)"review", (String)assignedTasks.get((int)0).name);
    }

    public void xtestMultiAssign() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        ArrayList<String> bpm_assignees = new ArrayList<String>();
        bpm_assignees.add(AuthenticationUtil.getAdminUserName());
        bpm_assignees.add("bob");
        bpm_assignees.add("fred");
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"assignees"), bpm_assignees);
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks);
        JBPMEngineTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks.get((int)0).id, "multi");
        JBPMEngineTest.assertNotNull((Object)updatedTask);
    }

    public void testEndTask() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)tasks1.get((int)0).state));
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks1.get((int)0).id, null);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)updatedTask.state));
        List<WorkflowTask> completedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.COMPLETED);
        JBPMEngineTest.assertNotNull(completedTasks);
        completedTasks = this.filterTasksByWorkflowInstance(completedTasks, path.instance.id);
        JBPMEngineTest.assertEquals((int)1, (int)completedTasks.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)completedTasks.get((int)0).state));
    }

    public void testGetTask() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask getTask = this.taskComponent.getTaskById(tasks1.get((int)0).id);
        JBPMEngineTest.assertNotNull((Object)getTask);
        JBPMEngineTest.assertEquals((String)getTask.id, (String)tasks1.get((int)0).id);
    }

    public void testNodeRef() {
        WorkflowDefinition workflowDef = this.getTestDefinition();
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"reviewer"), (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)tasks1.get((int)0).state));
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks1.get((int)0).id, null);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
    }

    public void testScript() throws IOException {
        ClassPathResource processDef = new ClassPathResource("jbpmresources/test_script.xml");
        JBPMEngineTest.assertFalse((boolean)this.workflowComponent.isDefinitionDeployed(processDef.getInputStream(), "text/xml"));
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        JBPMEngineTest.assertNotNull((Object)deployment);
        WorkflowDefinition workflowDef = deployment.definition;
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(QName.createQName((String)"", (String)"testNode"), (Serializable)this.testNodeRef);
        parameters.put(QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package"), (Serializable)this.packageComponent.createPackage(null));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.id, parameters);
        JBPMEngineTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.id);
        JBPMEngineTest.assertNotNull(tasks1);
        JBPMEngineTest.assertEquals((int)1, (int)tasks1.size());
        JBPMEngineTest.assertEquals((Object)((Object)WorkflowTaskState.IN_PROGRESS), (Object)((Object)tasks1.get((int)0).state));
        WorkflowTask updatedTask = this.taskComponent.endTask(tasks1.get((int)0).id, null);
        JBPMEngineTest.assertNotNull((Object)updatedTask);
    }

    private WorkflowDefinition getTestDefinition() {
        return this.testWorkflowDef;
    }

    private List<WorkflowTask> filterTasksByWorkflowInstance(List<WorkflowTask> tasks, String workflowInstanceId) {
        ArrayList<WorkflowTask> filteredTasks = new ArrayList<WorkflowTask>();
        for (WorkflowTask task : tasks) {
            if (!task.path.instance.id.equals(workflowInstanceId)) continue;
            filteredTasks.add(task);
        }
        return filteredTasks;
    }
}

