/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.avm;

import java.io.Serializable;
import org.alfresco.service.cmr.avm.AVMException;

public class AVMNodeDescriptor
implements Serializable {
    private static final long serialVersionUID = -7959606980486852184L;
    private String fPath;
    private String fName;
    private int fType;
    private String fOwner;
    private String fCreator;
    private String fLastModifier;
    private long fCreateDate;
    private long fModDate;
    private long fAccessDate;
    private long fID;
    private int fVersionID;
    private String fIndirection;
    private int fIndirectionVersion;
    private boolean fIsPrimary;
    private long fLayerID;
    private long fLength;
    private boolean fOpacity;
    private int fDeletedType;
    private String fGuid;

    public AVMNodeDescriptor(String path, String name, int type, String creator, String owner, String lastModifier, long createDate, long modDate, long accessDate, long id, String guid, int versionID, String indirection, int indirectionVersion, boolean isPrimary, long layerID, boolean opacity, long length, int deletedType) {
        this.fPath = path;
        this.fName = name;
        this.fType = type;
        this.fCreator = creator;
        this.fOwner = owner;
        this.fLastModifier = lastModifier;
        this.fCreateDate = createDate;
        this.fModDate = modDate;
        this.fAccessDate = accessDate;
        this.fID = id;
        this.fGuid = guid;
        this.fVersionID = versionID;
        this.fIndirection = indirection;
        this.fIndirectionVersion = indirectionVersion;
        this.fIsPrimary = isPrimary;
        this.fLayerID = layerID;
        this.fLength = length;
        this.fOpacity = opacity;
        this.fDeletedType = deletedType;
    }

    public long getAccessDate() {
        return this.fAccessDate;
    }

    public long getCreateDate() {
        return this.fCreateDate;
    }

    public String getCreator() {
        return this.fCreator;
    }

    public String getIndirection() {
        return this.fIndirection;
    }

    public int getIndirectionVersion() {
        return this.fIndirectionVersion;
    }

    public boolean isPrimary() {
        return this.fIsPrimary;
    }

    public boolean isFile() {
        return this.fType == 0 || this.fType == 1;
    }

    public boolean isPlainFile() {
        return this.fType == 0;
    }

    public boolean isLayeredFile() {
        return this.fType == 1;
    }

    public boolean isDirectory() {
        return this.fType == 2 || this.fType == 3;
    }

    public boolean isPlainDirectory() {
        return this.fType == 2;
    }

    public boolean isLayeredDirectory() {
        return this.fType == 3;
    }

    public boolean isDeleted() {
        return this.fType == 4;
    }

    public String getLastModifier() {
        return this.fLastModifier;
    }

    public long getLayerID() {
        return this.fLayerID;
    }

    public long getModDate() {
        return this.fModDate;
    }

    public String getOwner() {
        return this.fOwner;
    }

    public String getPath() {
        return this.fPath;
    }

    public int getType() {
        return this.fType;
    }

    public int getVersionID() {
        return this.fVersionID;
    }

    public long getId() {
        return this.fID;
    }

    public long getLength() {
        return this.fLength;
    }

    public String getName() {
        return this.fName;
    }

    public boolean getOpacity() {
        return this.fOpacity;
    }

    public String toString() {
        switch (this.fType) {
            case 0: {
                return "[PF:" + this.fID + ":" + this.fName + ", " + this.fVersionID + "]";
            }
            case 2: {
                return "[PD:" + this.fID + ":" + this.fName + ", " + this.fVersionID + "]";
            }
            case 1: {
                return "[LF:" + this.fID + ":" + this.fIndirection + ", " + this.fVersionID + "]";
            }
            case 3: {
                return "[LD:" + this.fID + ":" + this.fIndirection + ", " + this.fVersionID + "]";
            }
            case 4: {
                return "[DN:" + this.fID + ", " + this.fVersionID + "]";
            }
        }
        throw new AVMException("Internal Error.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AVMNodeDescriptor)) {
            return false;
        }
        return this.fID == ((AVMNodeDescriptor)obj).fID;
    }

    public int hashCode() {
        return (int)this.fID;
    }

    public int getDeletedType() {
        return this.fDeletedType;
    }

    public boolean isDeletedDirectory() {
        return this.fType == 4 && (this.fDeletedType == 3 || this.fDeletedType == 2);
    }

    public boolean isDeletedFile() {
        return this.fType == 4 && (this.fDeletedType == 1 || this.fDeletedType == 0);
    }

    public String getGuid() {
        return this.fGuid;
    }
}

