/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server.socket;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public class HostConfigurableSocketFactory
implements RMIServerSocketFactory,
RMIClientSocketFactory,
InitializingBean,
Serializable {
    private static final long serialVersionUID = 4115227360496369889L;
    private static final String SERVER_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    private InetAddress host;

    public void setHost(String host) {
        try {
            this.host = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void setHost(InetAddress host) {
        this.host = host;
    }

    public String getHost() {
        if (null != this.host.getHostName()) {
            return this.host.getHostName();
        }
        return this.host.getHostAddress();
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(this.host, port);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port, 0, this.host);
    }

    public void afterPropertiesSet() throws Exception {
        Properties properties = System.getProperties();
        if (properties.containsKey(SERVER_HOSTNAME_PROPERTY)) {
            this.setHost(properties.getProperty(SERVER_HOSTNAME_PROPERTY));
        }
    }
}

