/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.catalina.Context;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.log.SystemLogHandler;

final class StandardWrapperValve
extends ValveBase {
    private volatile long processingTime;
    private volatile long maxTime;
    private volatile long minTime = Long.MAX_VALUE;
    private volatile int requestCount;
    private volatile int errorCount;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block49: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block48: {
                block47: {
                    boolean unavailable = false;
                    throwable = null;
                    t1 = System.currentTimeMillis();
                    ++this.requestCount;
                    wrapper = (StandardWrapper)this.getContainer();
                    servlet = null;
                    Context context = (Context)wrapper.getParent();
                    if (!context.getAvailable()) {
                        response.sendError(503, sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.container.getLogger().info((Object)sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), (Throwable)e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    try {
                        response.sendAcknowledgement();
                    }
                    catch (IOException e) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                        this.container.getLogger().warn((Object)sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), (Throwable)e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    MessageBytes requestPathMB = null;
                    if (request != null) {
                        requestPathMB = request.getRequestPathMB();
                    }
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.REQUEST_INTEGER);
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                    ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)request, wrapper, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            request.setAttribute("org.apache.catalina.jsp_file", jspFile);
                        } else {
                            request.removeAttribute("org.apache.catalina.jsp_file");
                        }
                        if (servlet != null && filterChain != null) {
                            if (context.getSwallowOutput()) {
                                try {
                                    SystemLogHandler.startCapture();
                                    filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                                }
                                finally {
                                    String log = SystemLogHandler.stopCapture();
                                    if (log != null && log.length() > 0) {
                                        context.getLogger().info((Object)log);
                                    }
                                }
                            } else {
                                filterChain.doFilter((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                            }
                        }
                        request.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    catch (ClientAbortException e) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), (Throwable)e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), (Throwable)e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        request.removeAttribute("org.apache.catalina.jsp_file");
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.releaseFilters", wrapper.getName()), e);
                        if (throwable != null) break block47;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block48;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block49;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        request.setAttribute("javax.servlet.error.exception", exception);
        response.setStatus(500);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

