/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.catalina.host;

import java.io.File;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.alfresco.catalina.host.AVMHostConfig;
import org.alfresco.catalina.host.AVMHostMatch;
import org.alfresco.catalina.host.AVMResourceBinding;
import org.alfresco.filter.CacheControlFilter;
import org.alfresco.filter.CacheControlFilterInfoBean;
import org.alfresco.jndi.AVMFileDirContext;
import org.alfresco.jndi.JndiInfoBean;
import org.alfresco.mbeans.VirtServerRegistrationThread;
import org.alfresco.mbeans.VirtWebappRegistryMBean;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class AVMHost
extends StandardHost {
    static AVMRemote Service_;
    static FileSystemXmlApplicationContext Context_;
    private static Log log;
    static String AVMFileDirMountPoint_;
    protected VirtServerRegistrationThread registrationThread_ = null;
    private boolean initialized = false;
    private ObjectName errorReportValveObjectName = null;
    private static final String info = "org.alfresco.jndi.AVMHost/1.0";
    String reverse_proxy_binding_;
    String resource_binding_classname_ = "org.alfresco.catalina.host.DefaultAVMResourceBinding";
    AVMResourceBinding resource_binding_;
    static ArrayList<ReverseProxyBinding> ReverseProxies_;

    public String getReverseProxyBinding() {
        return this.reverse_proxy_binding_;
    }

    public void setReverseProxyBinding(String binding) {
        this.reverse_proxy_binding_ = binding;
    }

    public String getResourceBindingClassName() {
        return this.resource_binding_classname_;
    }

    public void setResourceBindingClassName(String binding) {
        this.resource_binding_classname_ = binding;
    }

    public AVMResourceBinding getResourceBinding() {
        return this.resource_binding_;
    }

    public static AVMHostMatch getAVMHostMatch(String forwardProxyName) {
        for (ReverseProxyBinding binding : ReverseProxies_) {
            Matcher match = binding.pattern.matcher(forwardProxyName);
            if (!match.find()) continue;
            return new AVMHostMatch(binding.host, match);
        }
        return null;
    }

    public String getInfo() {
        return info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("AVMHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public String getAppBase() {
        return AVMFileDirMountPoint_;
    }

    public String getHostAppBase() {
        return super.getAppBase();
    }

    public static ApplicationContext GetSpringApplicationContext() {
        return Context_;
    }

    public void init() {
        File absWorkDir;
        ServerStatus alfrescoStatus = ServerStatus.AVAILABLE;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String catalina_base = System.getProperty("catalina.base");
        if (catalina_base == null) {
            catalina_base = System.getProperty("catalina.home");
        }
        if (catalina_base != null) {
            if (!catalina_base.endsWith("/")) {
                catalina_base = catalina_base + "/";
            }
        } else {
            catalina_base = "";
        }
        boolean done_trying = false;
        int retry_count = 0;
        while (!done_trying) {
            try {
                Context_ = new FileSystemXmlApplicationContext("file:" + catalina_base + "conf/alfresco-virtserver-context.xml");
                Service_ = (AVMRemote)Context_.getBean("avmRemote");
                AuthenticationService authService = (AuthenticationService)Context_.getBean("authenticationService");
                JndiInfoBean info = (JndiInfoBean)Context_.getBean("jndiInfoBean");
                authService.authenticate(info.getAlfrescoServerUser(), info.getAlfrescoServerPassword().toCharArray());
                ((ClientTicketHolder)Context_.getBean("clientTicketHolder")).setTicket(authService.getCurrentTicket());
                done_trying = true;
                alfrescoStatus = ServerStatus.AVAILABLE;
            }
            catch (BeanCreationException e) {
                ++retry_count;
                boolean retry_op = false;
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof IOException) && !(cause instanceof NotBoundException)) continue;
                    retry_op = true;
                    break;
                }
                if (!retry_op) {
                    if (alfrescoStatus == ServerStatus.AVAILABLE) {
                        alfrescoStatus = ServerStatus.NOT_AVAILABLE;
                        log.error((Object)("Bean creation error: " + ((Object)((Object)e)).getClass().getName()));
                    }
                    throw e;
                }
                this.sleepBeforeRetryingConnection();
            }
            catch (AuthenticationException auth_ex) {
                ++retry_count;
                if (alfrescoStatus == ServerStatus.AVAILABLE) {
                    alfrescoStatus = ServerStatus.NOT_AVAILABLE;
                    log.error((Object)("Authentication error (may be transient): " + auth_ex.getMessage()));
                }
                this.sleepBeforeRetryingConnection();
            }
        }
        log.debug((Object)"Succeeded connecting to authentication service");
        AVMFileDirContext.InitAVMRemote((AVMRemote)Service_);
        CacheControlFilter.InitInfo((CacheControlFilterInfoBean)((CacheControlFilterInfoBean)Context_.getBean("cacheControlInfo")));
        String workDir = this.getWorkDir();
        if (workDir == null) {
            workDir = "work" + File.separator + ((StandardEngine)this.parent).getName() + File.separator + this.getName();
        }
        if (!(absWorkDir = new File(workDir)).isAbsolute()) {
            absWorkDir = new File(catalina_base, workDir);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting: " + absWorkDir.getAbsolutePath()));
        }
        AVMHostConfig.CleanDir(absWorkDir, true);
        this.registrationThread_ = new VirtServerRegistrationThread();
        AVMFileDirMountPoint_ = AVMFileDirContext.getAVMFileDirMountPoint();
        try {
            this.resource_binding_ = (AVMResourceBinding)Class.forName(this.resource_binding_classname_).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LifecycleListener[] listen = this.findLifecycleListeners();
        try {
            ObjectName serviceName = new ObjectName(this.domain + ":type=Engine");
            for (int i = 0; i < listen.length; ++i) {
                if (!(listen[i] instanceof HostConfig)) continue;
                this.removeLifecycleListener(listen[i]);
            }
            AVMHostConfig deployer = new AVMHostConfig(super.getAppBase());
            if (this.reverse_proxy_binding_ == null) {
                this.reverse_proxy_binding_ = "^(.+)\\.www--sandbox\\.(?:version--v(-?[\\d]+)\\.)?.*$";
            }
            log.debug((Object)("Reverse proxy binding: " + this.reverse_proxy_binding_));
            ReverseProxies_.add(new ReverseProxyBinding(this, this.reverse_proxy_binding_));
            VirtWebappRegistryMBean virtWebappRegistry = (VirtWebappRegistryMBean)Context_.getBean("virtWebappRegistry");
            virtWebappRegistry.setDeployer(deployer);
            this.registrationThread_.start();
            this.addLifecycleListener((LifecycleListener)deployer);
        }
        catch (Exception ex) {
            log.error((Object)"Host registering failed!", (Throwable)ex);
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register host " + this.getName() + " with domain " + this.domain));
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.error((Object)"Host registering failed!", t);
            }
        }
    }

    void sleepBeforeRetryingConnection() {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception te) {
            // empty catch block
        }
        if (Context_ != null) {
            try {
                Context_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.registrationThread_ == null) {
            this.registrationThread_ = new VirtServerRegistrationThread();
            this.registrationThread_.start();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Realm,host=" + this.getName());
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                }
            }
            catch (Throwable t) {
                log.debug((Object)("No realm for this host " + realmName));
            }
        }
        if (this.getErrorReportValveClass() != null && !this.getErrorReportValveClass().equals("")) {
            try {
                boolean found = false;
                if (this.errorReportValveObjectName != null) {
                    ObjectName[] names = ((StandardPipeline)this.pipeline).getValveObjectNames();
                    for (int i = 0; !found && i < names.length; ++i) {
                        if (!this.errorReportValveObjectName.equals(names[i])) continue;
                        found = true;
                    }
                }
                if (!found) {
                    Valve valve = (Valve)Class.forName(this.getErrorReportValveClass()).newInstance();
                    this.addValve(valve);
                    this.errorReportValveObjectName = ((ValveBase)valve).getObjectName();
                }
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardHost.invalidErrorReportValveClass", (Object)this.getErrorReportValveClass()));
            }
        }
        if (log.isInfoEnabled()) {
            if (this.getXmlValidation()) {
                log.info((Object)sm.getString("standardHost.validationEnabled"));
            } else {
                log.info((Object)sm.getString("standardHost.validationDisabled"));
            }
        }
        super.start();
    }

    public synchronized void stop() throws LifecycleException {
        if (this.registrationThread_ != null) {
            this.registrationThread_.setDone();
            this.registrationThread_ = null;
        }
        Context_.close();
        AVMFileDirContext.ReleaseAVMRemote();
        super.stop();
    }

    static {
        Context_ = null;
        log = LogFactory.getLog(AVMHost.class);
        ReverseProxies_ = new ArrayList();
    }

    static class ReverseProxyBinding {
        AVMHost host;
        String regex;
        Pattern pattern;

        public ReverseProxyBinding(AVMHost avmHost, String reverseProxyBinding) {
            this.host = avmHost;
            this.regex = reverseProxyBinding;
            this.pattern = Pattern.compile(this.regex, 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ServerStatus {
        NOT_AVAILABLE,
        AVAILABLE;

    }
}

