/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.catalina.host;

import java.util.Map;
import java.util.regex.Matcher;
import org.alfresco.catalina.host.AVMResourceBinding;
import org.alfresco.jndi.AVMFileDirContext;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.namespace.QName;

public class DefaultAVMResourceBinding
implements AVMResourceBinding {
    protected static AVMRemote AVMRemote_;

    public String getRepositoryName(Matcher match) {
        String host_info = match.group(1);
        if (host_info == null) {
            host_info = "";
        }
        String repo = DefaultAVMResourceBinding.getRepoNameFromHostInfo(host_info);
        return repo;
    }

    public String getVersion(Matcher match) {
        String version = match.group(2);
        if (version == null) {
            version = "-1";
        }
        return version;
    }

    static String getRepoNameFromHostInfo(String host_info) {
        String repo_name;
        if (AVMRemote_ == null) {
            AVMRemote_ = AVMFileDirContext.getAVMRemote();
        }
        try {
            Map repo_dns_entries = AVMRemote_.queryStoresPropertyKey(QName.createQName(null, (String)(".dns." + host_info)));
            repo_name = (String)repo_dns_entries.keySet().iterator().next();
        }
        catch (Exception e) {
            repo_name = "";
        }
        return repo_name;
    }
}

