/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.catalina.host;

import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

public class ReauthenticatingAdvice
implements MethodInterceptor {
    private AuthenticationService fAuthService;
    private ClientTicketHolder fTicketHolder;
    private String fUser;
    private String fPassword;
    private long fRetryInterval;

    public void setAuthenticationService(AuthenticationService service) {
        this.fAuthService = service;
    }

    public void setClientTicketHolder(ClientTicketHolder ticketHolder) {
        this.fTicketHolder = ticketHolder;
    }

    public void setUser(String user) {
        this.fUser = user;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public void setRetryInterval(long retryInterval) {
        this.fRetryInterval = retryInterval;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        while (true) {
            try {
                MethodInvocation clone = ((ReflectiveMethodInvocation)mi).invocableClone();
                return clone.proceed();
            }
            catch (AuthenticationException ae) {
                try {
                    Thread.sleep(this.fRetryInterval);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                try {
                    this.fAuthService.authenticate(this.fUser, this.fPassword.toCharArray());
                    String ticket = this.fAuthService.getCurrentTicket();
                    this.fTicketHolder.setTicket(ticket);
                    mi.getArguments()[0] = ticket;
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }
}

