/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.catalina.valve;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.alfresco.catalina.host.AVMHost;
import org.alfresco.catalina.host.AVMHostMatch;
import org.alfresco.catalina.host.AVMResourceBinding;
import org.alfresco.filter.CacheControlFilter;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.Adapter;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.MessageBytes;

public class AVMUrlValve
extends ValveBase
implements Lifecycle {
    static Pattern first_seg_pattern_ = Pattern.compile("^/([^/]*)");
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected static ThreadLocal AVMUrlValve_invoked_ = new ThreadLocal();

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public static String GetContextNameFromStoreName(int version, String storeName, String webappName) {
        return "/$" + version + "$" + storeName + "$" + webappName;
    }

    public static String GetContextNameFromStorePath(int version, String storePath) {
        int store_tail = storePath.indexOf(58);
        int webapp_head = storePath.lastIndexOf(47) + 1;
        if (store_tail < 0 || webapp_head <= 0 || webapp_head >= storePath.length()) {
            return null;
        }
        String store_name = storePath.substring(0, store_tail);
        String webapp_name = storePath.substring(webapp_head, storePath.length());
        return "/$" + version + "$" + store_name + "$" + webapp_name;
    }

    void sendErrorPageResponse(org.apache.catalina.connector.Response response, String html_error_msg) {
        try {
            response.setStatus(404);
            response.setContentType("text/html");
            response.setCharacterEncoding("utf-8");
            PrintWriter writer = response.getReporter();
            if (writer != null) {
                ((Writer)writer).write(html_error_msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        if (AVMUrlValve_invoked_.get() == Boolean.TRUE) {
            org.apache.coyote.Request req = request.getCoyoteRequest();
            MessageBytes decoded_uri_MB = req.decodedURI();
            MessageBytes request_uri_MB = req.requestURI();
            String decoded_uri = req.decodedURI().toString();
            String request_uri = req.requestURI().toString();
            decoded_uri_MB.recycle();
            request_uri_MB.recycle();
            decoded_uri = AVMUrlValve.unMangleAVMuri(decoded_uri);
            request_uri = AVMUrlValve.unMangleAVMuri(request_uri);
            decoded_uri_MB.setString(decoded_uri);
            request_uri_MB.setString(request_uri);
            MessageBytes context_path_MB = request.getContextPathMB();
            String context_path = request.getContextPath();
            context_path_MB.recycle();
            try {
                context_path = AVMUrlValve.unMangleAVMuri(context_path);
            }
            catch (Exception bad_context) {
                AVMUrlValve_invoked_.set(null);
                this.sendErrorPageResponse(response, "<html>\n  <head><title>Virtual website not found</title></head>\n  <body>\n     <p>\n     <h2>Virtual website not found</h2>\n     <br>\n     &nbsp;&nbsp;&nbsp;&nbsp;No such webapp  </body>\n</html>");
                return;
            }
            context_path_MB.setString(context_path);
            String reverse_proxy = request.getHeader("Host");
            MessageBytes server_MB = req.serverName();
            int port_colon_offset = reverse_proxy.indexOf(58);
            if (port_colon_offset >= 0) {
                reverse_proxy = reverse_proxy.substring(0, port_colon_offset);
            }
            server_MB.recycle();
            server_MB.setString(reverse_proxy);
            try {
                this.getNext().invoke(request, response);
            }
            catch (Exception e) {
            }
            finally {
                AVMUrlValve_invoked_.set(null);
            }
            return;
        }
        AVMUrlValve_invoked_.set(Boolean.TRUE);
        boolean in_lookup_dependency = false;
        if (null != request.getHeader("X-Alfresco-Lookup")) {
            CacheControlFilter.StartLookupDependency();
            in_lookup_dependency = true;
        }
        org.apache.coyote.Request req = request.getCoyoteRequest();
        MessageBytes server_MB = req.serverName();
        String server_name = server_MB.toString();
        Object host = request.getHost();
        int avm_port = req.getServerPort();
        AVMHostMatch hostmatch = AVMHost.getAVMHostMatch(server_name);
        if (hostmatch == null) {
            this.getNext().invoke(request, response);
            AVMUrlValve_invoked_.set(null);
            if (in_lookup_dependency) {
                CacheControlFilter.StopLookupDependency();
            }
            return;
        }
        Matcher rproxy_match = hostmatch.getMatch();
        AVMHost avm_host = hostmatch.getHost();
        AVMResourceBinding binding = avm_host.getResourceBinding();
        String store_name = binding.getRepositoryName(rproxy_match);
        String version_str = binding.getVersion(rproxy_match);
        int version = 0;
        try {
            version = Integer.parseInt(version_str);
        }
        catch (Exception num_ex) {
            if (version_str == null) {
                version_str = "";
            }
            AVMUrlValve_invoked_.set(null);
            if (in_lookup_dependency) {
                CacheControlFilter.StopLookupDependency();
            }
            this.sendErrorPageResponse(response, "<html>\n  <head><title>Virtual website not found</title></head>\n  <body>\n     <p>\n     <h2>Virtual website not found</h2>\n     <br>\n     &nbsp;&nbsp;&nbsp;&nbsp;Bad version:&nbsp;&nbsp;     &nbsp;&nbsp;<tt>" + version_str + "</tt>\n" + "  </body>\n" + "</html>");
            return;
        }
        if (store_name == null || store_name.equals("")) {
            AVMUrlValve_invoked_.set(null);
            if (in_lookup_dependency) {
                CacheControlFilter.StopLookupDependency();
            }
            this.sendErrorPageResponse(response, "<html>\n  <head><title>Virtual website not found</title></head>\n  <body>\n     <p>\n     <h2>Virtual website not found</h2>\n     <br>\n     &nbsp;&nbsp;&nbsp;&nbsp;Bad host name:&nbsp;&nbsp;     &nbsp;&nbsp;<tt>" + server_name + "</tt>\n" + "  </body>\n" + "</html>");
            return;
        }
        host = avm_host;
        String avm_hostname = host.getName();
        server_MB.recycle();
        server_MB.setString(avm_hostname);
        MessageBytes decoded_uri_MB = req.decodedURI();
        MessageBytes request_uri_MB = req.requestURI();
        String decoded_uri = req.decodedURI().toString();
        String request_uri = req.requestURI().toString();
        decoded_uri_MB.recycle();
        request_uri_MB.recycle();
        String uri_prefix = AVMUrlValve.GetContextNameFromStoreName(version, store_name, "");
        Matcher first_segment_match = first_seg_pattern_.matcher(decoded_uri);
        String first_segment = "";
        if (first_segment_match.find() && (first_segment = first_segment_match.group(1)) == null) {
            first_segment = "";
        }
        if (host.findChild(uri_prefix + first_segment) != null) {
            decoded_uri = uri_prefix + decoded_uri.substring(1);
            request_uri = uri_prefix + request_uri.substring(1);
        } else {
            decoded_uri = uri_prefix + "ROOT" + decoded_uri;
            request_uri = uri_prefix + "ROOT" + request_uri;
        }
        byte[] uri_bytes = decoded_uri.getBytes();
        decoded_uri_MB.setBytes(uri_bytes, 0, uri_bytes.length);
        uri_bytes = request_uri.getBytes();
        request_uri_MB.setBytes(uri_bytes, 0, uri_bytes.length);
        Adapter adapter = request.getConnector().getProtocolHandler().getAdapter();
        request.recycle();
        try {
            Response resp = response.getCoyoteResponse();
            adapter.service(req, resp);
            String redirection = response.getHeader("Location");
            if (redirection != null) {
                String avm_hostport = avm_hostname;
                String proxy_hostport = server_name;
                if (!(avm_port == 80 && redirection.substring(0, 5).equalsIgnoreCase("http:") || avm_port == 443 && redirection.substring(0, 6).equalsIgnoreCase("https:"))) {
                    avm_hostport = avm_hostport + ":" + avm_port;
                    proxy_hostport = proxy_hostport + ":" + avm_port;
                }
                redirection = this.reverseProxyRedirect(redirection, avm_hostport, proxy_hostport, uri_prefix);
                response.setHeader("Location", redirection);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AVMUrlValve_invoked_.set(null);
        if (in_lookup_dependency) {
            CacheControlFilter.StopLookupDependency();
        }
    }

    public static String unMangleAVMuri(String uri) {
        String unmangled_uri;
        if (!uri.startsWith("/$")) {
            return uri;
        }
        int offset = uri.indexOf(36, 2);
        if (offset < 0) {
            return uri;
        }
        if ((offset = uri.indexOf(36, offset + 1)) < 0) {
            return uri;
        }
        if (uri.startsWith("ROOT/", ++offset)) {
            offset += "ROOT/".length();
        }
        return (unmangled_uri = "/" + uri.substring(offset, uri.length())).equals("/ROOT") ? "" : unmangled_uri;
    }

    String reverseProxyRedirect(String avm_location, String avm_hostport, String reverse_proxy, String uri_prefix) {
        int host_start = avm_location.indexOf(58);
        if (host_start < 0) {
            return avm_location;
        }
        if (!avm_location.startsWith("//", host_start + 1)) {
            return avm_location;
        }
        if (!avm_location.startsWith(avm_hostport, host_start += 3)) {
            return avm_location;
        }
        int host_end = host_start + avm_hostport.length();
        if (!avm_location.startsWith(uri_prefix, host_end)) {
            return avm_location;
        }
        int prefix_end = host_end + uri_prefix.length();
        if (avm_location.startsWith("ROOT/", prefix_end)) {
            prefix_end += "ROOT/".length();
        }
        return avm_location.substring(0, host_start) + reverse_proxy + "/" + avm_location.substring(prefix_end, avm_location.length());
    }
}

