/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXAdaptorLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog((Class)JMXAdaptorLifecycleListener.class);
    private static final String info = "org.apache.catalina.mbeans.JMXAdaptorLifecycleListener/1.0";
    private boolean enabled = true;
    private int namingPort = 0;
    private int port = 0;
    private String host = null;
    private String jmxUrl = null;
    private JMXConnectorServer connectorServer = null;
    private Properties managementProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMXAdaptorLifecycleListener() {
        String configProperty = "com.sun.management.config.file";
        String configFileName = System.getProperty("com.sun.management.config.file");
        if (configFileName != null) {
            try {
                FileInputStream configFile = new FileInputStream(configFileName);
                try {
                    this.managementProperties = new Properties();
                    this.managementProperties.load(configFile);
                }
                finally {
                    configFile.close();
                }
            }
            catch (FileNotFoundException ex) {
                log.error((Object)("Cannot open " + configFileName), (Throwable)ex);
            }
            catch (IOException ex) {
                log.error((Object)("Error while reading " + configFileName), (Throwable)ex);
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < 1 || 65535 < port) {
            log.warn((Object)("Illegal port value " + port));
            port = 0;
        }
        this.port = port;
    }

    public int getNamingPort() {
        return this.namingPort;
    }

    public void setNamingPort(int namingPort) {
        this.namingPort = namingPort;
        if (namingPort < 1 || 65535 < namingPort) {
            log.warn((Object)("Illegal namingPort value " + namingPort));
            namingPort = 0;
        }
        this.namingPort = namingPort;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public String getInfo() {
        return info;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Object source = event.getSource();
        if (!(source instanceof StandardServer)) {
            return;
        }
        if ("after_start".equals(event.getType())) {
            this.start();
        }
        if ("before_stop".equals(event.getType())) {
            this.stop();
        }
    }

    protected void stop() {
        if (this.connectorServer != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("JMXConnectorServer stopping on " + this.jmxUrl));
            }
            try {
                this.connectorServer.stop();
                this.jmxUrl = null;
            }
            catch (IOException ex) {
                log.error((Object)"Error while stopping remote JMX connector", (Throwable)ex);
            }
            this.connectorServer = null;
        }
    }

    protected String getConfigProperty(String name) {
        String result = null;
        if (this.managementProperties != null) {
            result = this.managementProperties.getProperty(name);
        }
        if (result == null) {
            result = System.getProperty(name);
        }
        return result;
    }

    public void start() {
        if (this.enabled) {
            if (this.namingPort == 0 || this.port == 0) {
                return;
            }
            try {
                if (this.host == null || "".equals(this.host)) {
                    InetAddress address = InetAddress.getLocalHost();
                    this.host = address.getHostName();
                }
                LocateRegistry.createRegistry(this.namingPort);
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                HashMap<String, Object> env = new HashMap<String, Object>();
                String sslProperty = "com.sun.management.jmxremote.ssl";
                String value = this.getConfigProperty("com.sun.management.jmxremote.ssl");
                if (Boolean.valueOf(value).booleanValue()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Activated SSL communication");
                    }
                    SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                    SslRMIServerSocketFactory ssf = new SslRMIServerSocketFactory();
                    env.put("jmx.remote.rmi.client.socket.factory", csf);
                    env.put("jmx.remote.rmi.server.socket.factory", ssf);
                }
                String authenticateProperty = "com.sun.management.jmxremote.authenticate";
                value = this.getConfigProperty("com.sun.management.jmxremote.authenticate");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("com.sun.management.jmxremote.authenticate is " + value));
                }
                if (Boolean.valueOf(value).booleanValue()) {
                    String accessFileProperty = "com.sun.management.jmxremote.access.file";
                    value = this.getConfigProperty("com.sun.management.jmxremote.access.file");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("com.sun.management.jmxremote.access.file is " + value));
                    }
                    if (value != null) {
                        env.put("jmx.remote.x.access.file", value);
                    }
                    String passwordFileProperty = "com.sun.management.jmxremote.password.file";
                    value = this.getConfigProperty("com.sun.management.jmxremote.password.file");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("com.sun.management.jmxremote.password.file is " + value));
                    }
                    if (value != null) {
                        env.put("jmx.remote.x.password.file", value);
                    }
                } else {
                    log.warn((Object)"Unsafe JMX remote access!");
                }
                this.jmxUrl = "service:jmx:rmi://" + this.host + ":" + this.port + "/jndi/rmi://" + this.host + ":" + this.namingPort + "/server";
                JMXServiceURL url = new JMXServiceURL(this.jmxUrl);
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
                try {
                    this.connectorServer.start();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("JMXConnectorServer started on " + this.jmxUrl));
                    }
                }
                catch (IOException ex) {
                    log.warn((Object)("Cannot start JMXConnectorServer on " + this.jmxUrl), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error while setting up remote JMX connector", (Throwable)ex);
            }
        }
    }
}

