/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;

public abstract class AbstractTriggerBean
implements InitializingBean,
JobDetailAwareTrigger,
BeanNameAware,
DisposableBean {
    private static Log s_logger = LogFactory.getLog(AbstractTriggerBean.class);
    private JobDetail jobDetail;
    private Scheduler scheduler;
    private String beanName;
    private Trigger trigger;

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jobDetail == null) {
            throw new AlfrescoRuntimeException("Job detail has not been set");
        }
        if (this.scheduler == null) {
            s_logger.warn((Object)("Job " + this.getBeanName() + " is not active"));
        } else {
            s_logger.info((Object)("Job " + this.getBeanName() + " is active"));
            this.trigger = this.getTrigger();
            this.scheduler.scheduleJob(this.jobDetail, this.trigger);
        }
    }

    public void destroy() throws Exception {
        if (this.trigger != null) {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.unscheduleJob(this.trigger.getName(), this.trigger.getGroup());
            }
            this.trigger = null;
        }
    }

    public abstract Trigger getTrigger() throws Exception;

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }
}

