/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.TempFileProvider;

public class EqualsHelperTest
extends TestCase {
    private File fileOne;
    private File fileTwo;

    public void setUp() throws Exception {
        this.fileOne = TempFileProvider.createTempFile(this.getName(), "-one.txt");
        this.fileTwo = TempFileProvider.createTempFile(this.getName(), "-two.txt");
        FileOutputStream osOne = new FileOutputStream(this.fileOne);
        ((OutputStream)osOne).write("1234567890 - ONE".getBytes("UTF-8"));
        ((OutputStream)osOne).close();
        FileOutputStream osTwo = new FileOutputStream(this.fileTwo);
        ((OutputStream)osTwo).write("1234567890 - TWO".getBytes("UTF-8"));
        ((OutputStream)osTwo).close();
    }

    public void testStreamsNotEqual() throws Exception {
        FileInputStream isLeft = new FileInputStream(this.fileOne);
        FileInputStream isRight = new FileInputStream(this.fileTwo);
        boolean equal = EqualsHelper.binaryStreamEquals(isLeft, isRight);
        EqualsHelperTest.assertFalse((String)"Should not be the same", (boolean)equal);
    }

    public void testStreamsEqual() throws Exception {
        FileInputStream isLeft = new FileInputStream(this.fileOne);
        FileInputStream isRight = new FileInputStream(this.fileOne);
        boolean equal = EqualsHelper.binaryStreamEquals(isLeft, isRight);
        EqualsHelperTest.assertTrue((String)"Should be the same", (boolean)equal);
    }

    public void testMapComparison() throws Exception {
        HashMap<Integer, String> left = new HashMap<Integer, String>();
        HashMap<Integer, String> right = new HashMap<Integer, String>();
        left.put(0, "A");
        right.put(0, "A");
        left.put(1, "A");
        right.put(1, "B");
        left.put(2, null);
        right.put(2, null);
        left.put(3, null);
        right.put(3, "B");
        left.put(4, "A");
        right.put(4, null);
        right.put(5, "B");
        left.put(6, "A");
        Map diff = EqualsHelper.getMapComparison(left, right);
        EqualsHelperTest.assertEquals((String)"'EQUAL' check failed", (Object)((Object)EqualsHelper.MapValueComparison.EQUAL), (Object)((Object)diff.get(0)));
        EqualsHelperTest.assertEquals((String)"'NOT_EQUAL' check failed", (Object)((Object)EqualsHelper.MapValueComparison.NOT_EQUAL), (Object)((Object)diff.get(1)));
        EqualsHelperTest.assertEquals((String)"'EQUAL' check failed", (Object)((Object)EqualsHelper.MapValueComparison.EQUAL), (Object)((Object)diff.get(2)));
        EqualsHelperTest.assertEquals((String)"'NOT_EQUAL' check failed", (Object)((Object)EqualsHelper.MapValueComparison.NOT_EQUAL), (Object)((Object)diff.get(3)));
        EqualsHelperTest.assertEquals((String)"'NOT_EQUAL' check failed", (Object)((Object)EqualsHelper.MapValueComparison.NOT_EQUAL), (Object)((Object)diff.get(4)));
        EqualsHelperTest.assertEquals((String)"'RIGHT_ONLY' check failed", (Object)((Object)EqualsHelper.MapValueComparison.RIGHT_ONLY), (Object)((Object)diff.get(5)));
        EqualsHelperTest.assertEquals((String)"'LEFT_ONLY' check failed", (Object)((Object)EqualsHelper.MapValueComparison.LEFT_ONLY), (Object)((Object)diff.get(6)));
    }
}

