/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigLookupAlgorithm;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.evaluator.Evaluator;

public class DefaultLookupAlgorithm
implements ConfigLookupAlgorithm {
    private static final Log logger = LogFactory.getLog(DefaultLookupAlgorithm.class);

    public void process(ConfigSection section, Evaluator evaluator, Object object, Config results) {
        if (evaluator.applies(object, section.getCondition())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(section + " matches"));
            }
            List<ConfigElement> sectionConfigElements = section.getConfigElements();
            for (ConfigElement newConfigElement : sectionConfigElements) {
                String name = newConfigElement.getName();
                ConfigElement existingConfigElement = results.getConfigElements().get(name);
                if (existingConfigElement != null) {
                    if (section.isReplace()) {
                        results.getConfigElements().put(name, newConfigElement);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Replaced " + existingConfigElement + " with " + newConfigElement));
                        continue;
                    }
                    ConfigElement combinedConfigElement = existingConfigElement.combine(newConfigElement);
                    results.getConfigElements().put(name, combinedConfigElement);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Combined " + newConfigElement + " with " + existingConfigElement + " to create " + combinedConfigElement));
                    continue;
                }
                results.getConfigElements().put(name, newConfigElement);
            }
        }
    }
}

