/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.xml.elementreader;

import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class GenericElementReader
implements ConfigElementReader {
    private XMLConfigService.PropertyConfigurer propertyConfigurer;

    public GenericElementReader(XMLConfigService.PropertyConfigurer propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
    }

    public ConfigElement parse(Element element) {
        GenericConfigElement configElement = null;
        if (element != null) {
            configElement = this.createConfigElement(element);
            this.processChildren(element, configElement);
        }
        return configElement;
    }

    protected void processChildren(Element element, GenericConfigElement parentConfig) {
        Iterator children = element.elementIterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            GenericConfigElement childConfigElement = this.createConfigElement(child);
            parentConfig.addChild(childConfigElement);
            this.processChildren(child, childConfigElement);
        }
    }

    protected GenericConfigElement createConfigElement(Element element) {
        String value;
        String name = element.getName();
        GenericConfigElement configElement = new GenericConfigElement(name);
        if (element.hasContent() && !element.hasMixedContent() && (value = element.getTextTrim()) != null && value.length() > 0) {
            if (this.propertyConfigurer != null) {
                value = this.propertyConfigurer.resolveValue(value);
            }
            configElement.setValue(value);
        }
        Iterator attrs = element.attributeIterator();
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (this.propertyConfigurer != null) {
                attrValue = this.propertyConfigurer.resolveValue(attrValue);
            }
            configElement.addAttribute(attrName, attrValue);
        }
        return configElement;
    }
}

