/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.AnalysisException;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class VerbatimMLAnalayser
extends Analyzer {
    private static Log s_logger = LogFactory.getLog(VerbatimMLAnalayser.class);
    private MLAnalysisMode mlAnalaysisMode;

    public VerbatimMLAnalayser(MLAnalysisMode mlAnalaysisMode) {
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (!(reader instanceof BufferedReader)) {
            BufferedReader breader = new BufferedReader(reader);
            try {
                if (!breader.markSupported()) {
                    throw new AnalysisException("Multilingual tokenisation requires a reader that supports marks and reset");
                }
                breader.mark(100);
                StringBuilder builder = new StringBuilder();
                if (breader.read() == 0) {
                    char c;
                    String language = "";
                    String country = "";
                    String varient = "";
                    int count = 0;
                    while ((c = (char)breader.read()) != '\u0000') {
                        if (count++ > 99) {
                            breader.reset();
                            return this.getAnalyser().tokenStream(fieldName, (Reader)breader);
                        }
                        if (c == '_') {
                            if (language.length() == 0) {
                                language = builder.toString();
                            } else if (country.length() == 0) {
                                country = builder.toString();
                            } else if (varient.length() == 0) {
                                varient = builder.toString();
                            } else {
                                breader.reset();
                                return this.getAnalyser().tokenStream(fieldName, (Reader)breader);
                            }
                            builder = new StringBuilder();
                            continue;
                        }
                        builder.append(c);
                    }
                    if (builder.length() > 0) {
                        if (language.length() == 0) {
                            language = builder.toString();
                        } else if (country.length() == 0) {
                            country = builder.toString();
                        } else if (varient.length() == 0) {
                            varient = builder.toString();
                        } else {
                            breader.reset();
                            return this.getAnalyser().tokenStream(fieldName, (Reader)breader);
                        }
                    }
                    Locale locale = new Locale(language, country, varient);
                    return new MLTokenDuplicator(this.getAnalyser().tokenStream(fieldName, (Reader)breader), locale, breader, this.mlAnalaysisMode);
                }
                breader.reset();
                return this.getAnalyser().tokenStream(fieldName, (Reader)breader);
            }
            catch (IOException io) {
                try {
                    breader.reset();
                }
                catch (IOException e) {
                    throw new AnalysisException("Failed to reset buffered reader - token stream will be invalid", e);
                }
                return this.getAnalyser().tokenStream(fieldName, (Reader)breader);
            }
        }
        throw new AnalysisException("Multilingual tokenisation requires a buffered reader");
    }

    private Analyzer getAnalyser() {
        return new VerbatimAnalyser(false);
    }
}

