/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class VerbatimTokenFilter
extends Tokenizer {
    boolean readInput = true;
    boolean lowerCase;

    VerbatimTokenFilter(Reader in, boolean lowerCase) {
        super(in);
        this.lowerCase = lowerCase;
    }

    public Token next() throws IOException {
        if (this.readInput) {
            int current;
            this.readInput = false;
            StringBuilder buffer = new StringBuilder();
            while ((current = this.input.read()) != -1) {
                char c = (char)current;
                buffer.append(c);
            }
            String token = buffer.toString();
            if (this.lowerCase) {
                token = token.toLowerCase();
            }
            return new Token(token, 0, token.length() - 1, "VERBATIM");
        }
        return null;
    }
}

