/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;

public class CMISFolderTypeDefinition
extends CMISAbstractTypeDefinition {
    private static final long serialVersionUID = 7526155195125799106L;

    public CMISFolderTypeDefinition(CMISMapping cmisMapping, CMISTypeId typeId, ClassDefinition cmisClassDef) {
        this.isPublic = true;
        this.cmisClassDef = cmisClassDef;
        this.objectTypeId = typeId;
        this.displayName = cmisClassDef.getTitle() != null ? cmisClassDef.getTitle() : typeId.getId();
        this.description = cmisClassDef.getDescription();
        QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
        if (typeId == CMISDictionaryModel.FOLDER_TYPE_ID) {
            this.objectTypeQueryName = typeId.getId();
            if (parentQName != null) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.OBJECT, parentQName);
            }
        } else {
            this.objectTypeQueryName = cmisMapping.buildPrefixEncodedString(typeId.getQName());
            if (cmisMapping.isValidCmisFolder(parentQName)) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.FOLDER, parentQName);
            }
        }
        this.actionEvaluators = cmisMapping.getActionEvaluators(this.objectTypeId.getScope());
        this.creatable = !typeId.getQName().equals((Object)ContentModel.TYPE_SYSTEM_FOLDER);
        this.queryable = true;
        this.fullTextIndexed = true;
        this.controllablePolicy = false;
        this.controllableACL = true;
        this.includedInSuperTypeQuery = cmisClassDef.getIncludedInSuperTypeQuery();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CMISFolderTypeDefinition[");
        builder.append("Id=").append(this.getTypeId().getId()).append(", ");
        builder.append("Namespace=").append(this.getTypeId().getLocalNamespace()).append(", ");
        builder.append("LocalName=").append(this.getTypeId().getLocalName()).append(", ");
        builder.append("QueryName=").append(this.getQueryName()).append(", ");
        builder.append("DisplayName=").append(this.getDisplayName()).append(", ");
        builder.append("ParentId=").append(this.getParentType() == null ? "<none>" : this.getParentType().getTypeId()).append(", ");
        builder.append("Description=").append(this.getDescription()).append(", ");
        builder.append("Creatable=").append(this.isCreatable()).append(", ");
        builder.append("Queryable=").append(this.isQueryable()).append(", ");
        builder.append("FullTextIndexed=").append(this.isFullTextIndexed()).append(", ");
        builder.append("IncludedInSuperTypeQuery=").append(this.isIncludedInSuperTypeQuery()).append(", ");
        builder.append("ControllablePolicy=").append(this.isControllablePolicy()).append(", ");
        builder.append("ControllableACL=").append(this.isControllableACL()).append(", ");
        builder.append("SubTypes=").append(this.getSubTypes(false).size()).append(", ");
        builder.append("Properties=").append(this.getPropertyDefinitions().size());
        builder.append("]");
        return builder.toString();
    }
}

