/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;

public class CMISPolicyTypeDefinition
extends CMISAbstractTypeDefinition {
    private static final long serialVersionUID = 1621538303752395828L;

    public CMISPolicyTypeDefinition(CMISMapping cmisMapping, CMISTypeId typeId, ClassDefinition cmisClassDef) {
        this.isPublic = true;
        this.cmisClassDef = cmisClassDef;
        this.objectTypeId = typeId;
        String string = this.displayName = cmisClassDef.getTitle() != null ? cmisClassDef.getTitle() : typeId.getId();
        if (typeId == CMISDictionaryModel.POLICY_TYPE_ID) {
            this.objectTypeQueryName = typeId.getId();
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (parentQName != null) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.OBJECT, parentQName);
            }
        } else {
            this.objectTypeQueryName = cmisMapping.buildPrefixEncodedString(typeId.getQName());
            this.parentTypeId = CMISDictionaryModel.POLICY_TYPE_ID;
        }
        this.description = cmisClassDef.getDescription();
        this.actionEvaluators = cmisMapping.getActionEvaluators(this.objectTypeId.getScope());
        this.creatable = false;
        this.queryable = true;
        this.includedInSuperTypeQuery = cmisClassDef.getIncludedInSuperTypeQuery();
        this.fullTextIndexed = true;
        this.controllablePolicy = false;
        this.controllableACL = false;
    }

    void createSubTypes(CMISMapping cmisMapping, DictionaryService dictionaryService) {
        this.subTypeIds = new ArrayList();
        if (this.objectTypeId.equals(CMISDictionaryModel.POLICY_TYPE_ID)) {
            Collection aspects = dictionaryService.getAllAspects();
            for (QName aspect : aspects) {
                if (!cmisMapping.isValidCmisPolicy(aspect)) continue;
                this.subTypeIds.add(cmisMapping.getCmisTypeId(CMISScope.POLICY, aspect));
            }
        }
    }

    void resolveInheritance(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        this.inheritedProperties = new HashMap();
        this.ownedProperties = new HashMap();
        this.inheritedProperties.putAll(this.properties);
        this.ownedProperties.putAll(this.properties);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Type " + this.objectTypeId + " properties: " + this.inheritedProperties.size() + ", owned: " + this.ownedProperties.size()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CMISPolicyTypeDefinition[");
        builder.append("Id=").append(this.getTypeId().getId()).append(", ");
        builder.append("Namespace=").append(this.getTypeId().getLocalNamespace()).append(", ");
        builder.append("LocalName=").append(this.getTypeId().getLocalName()).append(", ");
        builder.append("QueryName=").append(this.getQueryName()).append(", ");
        builder.append("DisplayName=").append(this.getDisplayName()).append(", ");
        builder.append("ParentId=").append(this.getParentType() == null ? "<none>" : this.getParentType().getTypeId()).append(", ");
        builder.append("Description=").append(this.getDescription()).append(", ");
        builder.append("Creatable=").append(this.isCreatable()).append(", ");
        builder.append("Queryable=").append(this.isQueryable()).append(", ");
        builder.append("Controllable=").append(this.isControllablePolicy()).append(", ");
        builder.append("IncludedInSuperTypeQuery=").append(this.isIncludedInSuperTypeQuery()).append(", ");
        builder.append("SubTypes=").append(this.getSubTypes(false).size()).append(", ");
        builder.append("Properties=").append(this.getPropertyDefinitions().size());
        builder.append("]");
        return builder.toString();
    }
}

