/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISJoinEnum;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISQueryException;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.search.CMISFTSQueryParser;
import org.alfresco.cmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.search.impl.parsers.CMISLexer;
import org.alfresco.repo.search.impl.parsers.CMISParser;
import org.alfresco.repo.search.impl.parsers.FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.ArgumentDefinition;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Join;
import org.alfresco.repo.search.impl.querymodel.JoinType;
import org.alfresco.repo.search.impl.querymodel.ListArgument;
import org.alfresco.repo.search.impl.querymodel.LiteralArgument;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.ParameterArgument;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.repo.search.impl.querymodel.SelectorArgument;
import org.alfresco.repo.search.impl.querymodel.Source;
import org.alfresco.repo.search.impl.querymodel.impl.BaseComparison;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISQueryParser {
    private CMISQueryOptions options;
    private CMISDictionaryService cmisDictionaryService;
    private CMISJoinEnum joinSupport;
    private CMISScope[] validScopes;
    private boolean hasScore = false;
    private boolean hasContains = false;

    public CMISQueryParser(CMISQueryOptions options, CMISDictionaryService cmisDictionaryService, CMISJoinEnum joinSupport) {
        this.options = options;
        this.cmisDictionaryService = cmisDictionaryService;
        this.joinSupport = joinSupport;
        this.validScopes = options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
    }

    public Query parse(QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext) {
        CMISParser parser = null;
        try {
            ANTLRStringStream cs = new ANTLRStringStream(this.options.getQuery());
            CMISLexer lexer = new CMISLexer((CharStream)cs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new CMISParser((TokenStream)tokens);
            parser.setStrict(this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT);
            CommonTree queryNode = (CommonTree)parser.query().getTree();
            CommonTree sourceNode = (CommonTree)queryNode.getFirstChildWithType(11);
            Source source = this.buildSource(sourceNode, this.joinSupport, factory);
            Map selectors = source.getSelectors();
            ArrayList<Column> columns = this.buildColumns(queryNode, factory, selectors, this.options.getQuery());
            HashMap<String, Column> columnMap = new HashMap<String, Column>();
            for (Column column : columns) {
                if (columnMap.containsKey(column.getAlias())) {
                    throw new CMISQueryException("Duplicate column alias for " + column.getAlias());
                }
                columnMap.put(column.getAlias(), column);
            }
            ArrayList<Ordering> orderings = this.buildOrderings(queryNode, factory, selectors, columns);
            Constraint constraint = null;
            CommonTree orNode = (CommonTree)queryNode.getFirstChildWithType(16);
            if (orNode != null) {
                constraint = this.buildDisjunction(orNode, factory, functionEvaluationContext, selectors, columnMap);
            }
            Query query = factory.createQuery(columns, source, constraint, orderings);
            if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT && this.hasScore && !this.hasContains) {
                throw new CMISQueryException("Function SCORE() used without matching CONTAINS() function");
            }
            return query;
        }
        catch (RecognitionException e) {
            if (parser != null) {
                String[] tokenNames = parser.getTokenNames();
                String hdr = parser.getErrorHeader(e);
                String msg = parser.getErrorMessage(e, tokenNames);
                throw new CMISQueryException(hdr + "\n" + msg, e);
            }
            throw new CMISQueryException("Failed to parse");
        }
    }

    private Constraint buildDisjunction(CommonTree orNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Map<String, Selector> selectors, HashMap<String, Column> columnMap) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(orNode.getChildCount());
        for (int i = 0; i < orNode.getChildCount(); ++i) {
            CommonTree andNode = (CommonTree)orNode.getChild(i);
            Constraint constraint = this.buildConjunction(andNode, factory, functionEvaluationContext, selectors, columnMap);
            constraints.add(constraint);
        }
        if (constraints.size() == 1) {
            return (Constraint)constraints.get(0);
        }
        return factory.createDisjunction(constraints);
    }

    private Constraint buildConjunction(CommonTree andNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Map<String, Selector> selectors, HashMap<String, Column> columnMap) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(andNode.getChildCount());
        for (int i = 0; i < andNode.getChildCount(); ++i) {
            CommonTree notNode = (CommonTree)andNode.getChild(i);
            Constraint constraint = this.buildNegation(notNode, factory, functionEvaluationContext, selectors, columnMap);
            constraints.add(constraint);
        }
        if (constraints.size() == 1) {
            return (Constraint)constraints.get(0);
        }
        return factory.createConjunction(constraints);
    }

    private Constraint buildNegation(CommonTree notNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Map<String, Selector> selectors, HashMap<String, Column> columnMap) {
        if (notNode.getType() == 17) {
            Constraint constraint = this.buildTest((CommonTree)notNode.getChild(0), factory, functionEvaluationContext, selectors, columnMap);
            constraint.setOccur(Constraint.Occur.EXCLUDE);
            return constraint;
        }
        return this.buildTest(notNode, factory, functionEvaluationContext, selectors, columnMap);
    }

    private Constraint buildTest(CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Map<String, Selector> selectors, HashMap<String, Column> columnMap) {
        if (testNode.getType() == 16) {
            return this.buildDisjunction(testNode, factory, functionEvaluationContext, selectors, columnMap);
        }
        return this.buildPredicate(testNode, factory, functionEvaluationContext, selectors, columnMap);
    }

    private Constraint buildPredicate(CommonTree predicateNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Map<String, Selector> selectors, Map<String, Column> columnMap) {
        switch (predicateNode.getType()) {
            case 24: {
                String functionName = "Child";
                Function function = factory.getFunction(functionName);
                LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
                CommonTree argNode = (CommonTree)predicateNode.getChild(0);
                Argument arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Parent"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                if (predicateNode.getChildCount() > 1) {
                    argNode = (CommonTree)predicateNode.getChild(1);
                    arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Selector"), factory, selectors, columnMap, false);
                    if (!arg.isQueryable()) {
                        throw new CMISQueryException("The property is not queryable: " + argNode.getText());
                    }
                    functionArguments.put(arg.getName(), arg);
                }
                return factory.createFunctionalConstraint(function, functionArguments);
            }
            case 18: {
                Function function;
                switch (predicateNode.getChild(2).getType()) {
                    case 46: {
                        String functionName = "Equals";
                        function = factory.getFunction(functionName);
                        break;
                    }
                    case 51: {
                        String functionName = "NotEquals";
                        function = factory.getFunction(functionName);
                        break;
                    }
                    case 53: {
                        String functionName = "GreaterThan";
                        function = factory.getFunction(functionName);
                        break;
                    }
                    case 55: {
                        String functionName = "GreaterThanOrEquals";
                        function = factory.getFunction(functionName);
                        break;
                    }
                    case 52: {
                        String functionName = "LessThan";
                        function = factory.getFunction(functionName);
                        break;
                    }
                    case 54: {
                        String functionName = "LessThanOrEquals";
                        function = factory.getFunction(functionName);
                        break;
                    }
                    default: {
                        throw new CMISQueryException("Unknown comparison function " + predicateNode.getChild(2).getText());
                    }
                }
                LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
                CommonTree argNode = (CommonTree)predicateNode.getChild(0);
                Argument arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Mode"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                argNode = (CommonTree)predicateNode.getChild(1);
                arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("LHS"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                argNode = (CommonTree)predicateNode.getChild(3);
                arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("RHS"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                this.checkPredicateConditionsForComparisons(function, functionArguments, functionEvaluationContext, columnMap);
                return factory.createFunctionalConstraint(function, functionArguments);
            }
            case 25: {
                String functionName = "Descendant";
                Function function = factory.getFunction(functionName);
                CommonTree argNode = (CommonTree)predicateNode.getChild(0);
                LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
                Argument arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Ancestor"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                if (predicateNode.getChildCount() > 1) {
                    argNode = (CommonTree)predicateNode.getChild(1);
                    arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Selector"), factory, selectors, columnMap, false);
                    functionArguments.put(arg.getName(), arg);
                }
                return factory.createFunctionalConstraint(function, functionArguments);
            }
            case 20: {
                String functionName = "Exists";
                Function function = factory.getFunction(functionName);
                CommonTree argNode = (CommonTree)predicateNode.getChild(0);
                LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
                Argument arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Property"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                arg = factory.createLiteralArgument("Not", DataTypeDefinition.BOOLEAN, (Serializable)Boolean.valueOf(predicateNode.getChildCount() > 1));
                functionArguments.put(arg.getName(), arg);
                return factory.createFunctionalConstraint(function, functionArguments);
            }
            case 22: {
                QueryOptions.Connective defaultFieldConnective;
                QueryOptions.Connective defaultConnective;
                Selector selector;
                if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT && this.hasContains) {
                    throw new CMISQueryException("Only one CONTAINS() function can be included in a single query statement.");
                }
                String ftsExpression = predicateNode.getChild(0).getText();
                ftsExpression = ftsExpression.substring(1, ftsExpression.length() - 1);
                ftsExpression = this.unescape(ftsExpression, EscapeMode.CONTAINS);
                if (predicateNode.getChildCount() > 1) {
                    String qualifier = predicateNode.getChild(1).getText();
                    selector = selectors.get(qualifier);
                    if (selector == null) {
                        throw new CMISQueryException("No selector for " + qualifier);
                    }
                } else if (selectors.size() == 1) {
                    selector = selectors.get(selectors.keySet().iterator().next());
                } else {
                    throw new CMISQueryException("A selector must be specified when there are two or more selectors");
                }
                if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
                    defaultConnective = QueryOptions.Connective.AND;
                    defaultFieldConnective = QueryOptions.Connective.AND;
                } else {
                    defaultConnective = this.options.getDefaultFTSConnective();
                    defaultFieldConnective = this.options.getDefaultFTSFieldConnective();
                }
                FTSParser.Mode mode = this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? FTSParser.Mode.CMIS : (defaultConnective == QueryOptions.Connective.AND ? FTSParser.Mode.DEFAULT_CONJUNCTION : FTSParser.Mode.DEFAULT_DISJUNCTION);
                Constraint ftsConstraint = this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CMISFTSQueryParser.buildFTS(ftsExpression, factory, functionEvaluationContext, selector, columnMap, this.options.getDefaultFieldName()) : FTSQueryParser.buildFTS((String)ftsExpression, (QueryModelFactory)factory, (FunctionEvaluationContext)functionEvaluationContext, (Selector)selector, columnMap, (FTSParser.Mode)mode, (QueryOptions.Connective)defaultFieldConnective, null, (String)this.options.getDefaultFieldName());
                ftsConstraint.setBoost(1000.0f);
                this.hasContains = true;
                return ftsConstraint;
            }
            case 19: {
                String functionName = "In";
                Function function = factory.getFunction(functionName);
                LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
                CommonTree argNode = (CommonTree)predicateNode.getChild(0);
                Argument arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Mode"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                argNode = (CommonTree)predicateNode.getChild(1);
                arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Property"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                argNode = (CommonTree)predicateNode.getChild(2);
                arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("List"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                arg = factory.createLiteralArgument("Not", DataTypeDefinition.BOOLEAN, (Serializable)Boolean.valueOf(predicateNode.getChildCount() > 3));
                functionArguments.put(arg.getName(), arg);
                this.checkPredicateConditionsForIn(functionArguments, functionEvaluationContext, columnMap);
                return factory.createFunctionalConstraint(function, functionArguments);
            }
            case 21: {
                String functionName = "Like";
                Function function = factory.getFunction(functionName);
                LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
                CommonTree argNode = (CommonTree)predicateNode.getChild(0);
                Argument arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Property"), factory, selectors, columnMap, false);
                functionArguments.put(arg.getName(), arg);
                argNode = (CommonTree)predicateNode.getChild(1);
                arg = this.getFunctionArgument(argNode, function.getArgumentDefinition("Exp"), factory, selectors, columnMap, true);
                functionArguments.put(arg.getName(), arg);
                arg = factory.createLiteralArgument("Not", DataTypeDefinition.BOOLEAN, (Serializable)Boolean.valueOf(predicateNode.getChildCount() > 2));
                functionArguments.put(arg.getName(), arg);
                this.checkPredicateConditionsForLike(functionArguments, functionEvaluationContext, columnMap);
                return factory.createFunctionalConstraint(function, functionArguments);
            }
        }
        return null;
    }

    private void checkPredicateConditionsForIn(Map<String, Argument> functionArguments, FunctionEvaluationContext functionEvaluationContext, Map<String, Column> columnMap) {
        if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
            PropertyArgument propertyArgument = (PropertyArgument)functionArguments.get("Property");
            LiteralArgument modeArgument = (LiteralArgument)functionArguments.get("Mode");
            String modeString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)modeArgument.getValue(functionEvaluationContext));
            PredicateMode mode = PredicateMode.valueOf((String)modeString);
            String propertyName = propertyArgument.getPropertyName();
            Column column = columnMap.get(propertyName);
            if (column != null) {
                if (column.getFunction().getName().equals("PropertyAccessor")) {
                    PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                    propertyName = arg.getPropertyName();
                } else {
                    throw new CMISQueryException("Complex column reference not supoprted in LIKE " + propertyName);
                }
            }
            boolean isMultiValued = functionEvaluationContext.isMultiValued(propertyName);
            switch (mode) {
                case ANY: {
                    if (isMultiValued) break;
                    throw new QueryModelException("Predicate mode " + PredicateMode.ANY + " is not supported for IN and single valued properties");
                }
                case SINGLE_VALUED_PROPERTY: {
                    if (!isMultiValued) break;
                    throw new QueryModelException("Predicate mode " + PredicateMode.SINGLE_VALUED_PROPERTY + " is not supported for IN and multi-valued properties");
                }
                default: {
                    throw new QueryModelException("Unsupported predicate mode " + mode);
                }
            }
            CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(propertyName);
            if (propDef.getDataType() == CMISDataTypeEnum.BOOLEAN) {
                throw new QueryModelException("In is not supported for properties of type Boolean");
            }
        }
    }

    private void checkPredicateConditionsForComparisons(Function function, Map<String, Argument> functionArguments, FunctionEvaluationContext functionEvaluationContext, Map<String, Column> columnMap) {
        if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
            ((BaseComparison)function).setPropertyAndStaticArguments(functionArguments);
            String propertyName = ((BaseComparison)function).getPropertyName();
            LiteralArgument modeArgument = (LiteralArgument)functionArguments.get("Mode");
            String modeString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)modeArgument.getValue(functionEvaluationContext));
            PredicateMode mode = PredicateMode.valueOf((String)modeString);
            Column column = columnMap.get(propertyName);
            if (column != null) {
                if (column.getFunction().getName().equals("PropertyAccessor")) {
                    PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                    propertyName = arg.getPropertyName();
                } else {
                    throw new CMISQueryException("Complex column reference not supoprted in LIKE " + propertyName);
                }
            }
            boolean isMultiValued = functionEvaluationContext.isMultiValued(propertyName);
            switch (mode) {
                case ANY: {
                    if (isMultiValued) {
                        if (function.getName().equals("Equals")) break;
                        throw new QueryModelException("Predicate mode " + PredicateMode.ANY + " is only supported for " + "Equals" + " (and multi-valued properties).");
                    }
                    throw new QueryModelException("Predicate mode " + PredicateMode.ANY + " is not supported for " + function.getName() + " and single valued properties");
                }
                case SINGLE_VALUED_PROPERTY: {
                    if (!isMultiValued) break;
                    throw new QueryModelException("Predicate mode " + PredicateMode.SINGLE_VALUED_PROPERTY + " is not supported for " + function.getName() + " and multi-valued properties");
                }
                default: {
                    throw new QueryModelException("Unsupported predicate mode " + mode);
                }
            }
            CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(propertyName);
            if (propDef.getDataType() == CMISDataTypeEnum.ID) {
                if (function.getName().equals("Equals") || function.getName().equals("NotEquals")) {
                    return;
                }
                throw new QueryModelException("Comparison " + function.getName() + " is not supported for properties of type ID");
            }
            if (propDef.getDataType() == CMISDataTypeEnum.BOOLEAN) {
                if (function.getName().equals("Equals")) {
                    return;
                }
                throw new QueryModelException("Comparison " + function.getName() + " is not supported for properties of type Boolean");
            }
        }
    }

    private void checkPredicateConditionsForLike(Map<String, Argument> functionArguments, FunctionEvaluationContext functionEvaluationContext, Map<String, Column> columnMap) {
        if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
            CMISPropertyDefinition propDef;
            PropertyArgument propertyArgument = (PropertyArgument)functionArguments.get("Property");
            boolean isMultiValued = functionEvaluationContext.isMultiValued(propertyArgument.getPropertyName());
            if (isMultiValued) {
                throw new QueryModelException("Like is not supported for multi-valued properties");
            }
            String cmisPropertyName = propertyArgument.getPropertyName();
            Column column = columnMap.get(cmisPropertyName);
            if (column != null) {
                if (column.getFunction().getName().equals("PropertyAccessor")) {
                    PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                    cmisPropertyName = arg.getPropertyName();
                } else {
                    throw new CMISQueryException("Complex column reference not supoprted in LIKE " + cmisPropertyName);
                }
            }
            if ((propDef = this.cmisDictionaryService.findPropertyByQueryName(cmisPropertyName)).getDataType() != CMISDataTypeEnum.STRING) {
                throw new CMISQueryException("LIKE is only supported against String types" + cmisPropertyName);
            }
        }
    }

    private ArrayList<Ordering> buildOrderings(CommonTree queryNode, QueryModelFactory factory, Map<String, Selector> selectors, List<Column> columns) {
        ArrayList<Ordering> orderings = new ArrayList<Ordering>();
        CommonTree orderNode = (CommonTree)queryNode.getFirstChildWithType(64);
        if (orderNode != null) {
            for (int i = 0; i < orderNode.getChildCount(); ++i) {
                CommonTree current = (CommonTree)orderNode.getChild(i);
                CommonTree columnRefNode = (CommonTree)current.getFirstChildWithType(8);
                if (columnRefNode == null) continue;
                String columnName = columnRefNode.getChild(0).getText();
                String qualifier = "";
                if (columnRefNode.getChildCount() > 1) {
                    qualifier = columnRefNode.getChild(1).getText();
                }
                Order order = Order.ASCENDING;
                if (current.getChild(1).getType() == 67) {
                    order = Order.DESCENDING;
                }
                Column orderColumn = null;
                if (qualifier.length() == 0) {
                    Column match = null;
                    for (Column column : columns) {
                        PropertyArgument arg;
                        String propertyName;
                        if (column.getAlias().equals(columnName)) {
                            match = column;
                            break;
                        }
                        if (!column.getFunction().getName().equals("PropertyAccessor") || !(propertyName = (arg = (PropertyArgument)column.getFunctionArguments().get("Property")).getPropertyName()).equals(columnName)) continue;
                        match = column;
                        break;
                    }
                    if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT && match == null) {
                        throw new CMISQueryException("Ordered column is not selected: " + qualifier + "." + columnName);
                    }
                    if (match == null) {
                        CMISTypeDefinition typeDef;
                        Selector selector = selectors.get(qualifier);
                        if (selector == null) {
                            if (qualifier.equals("") && selectors.size() == 1) {
                                selector = selectors.get(selectors.keySet().iterator().next());
                            } else {
                                throw new CMISQueryException("No selector for " + qualifier);
                            }
                        }
                        if ((typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), CMISScope.DOCUMENT, CMISScope.FOLDER)) == null) {
                            throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
                        }
                        CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(columnName);
                        if (propDef == null) {
                            throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + "." + columnName);
                        }
                        if (!typeDef.getPropertyDefinitions().containsKey(propDef.getPropertyId().getId())) {
                            throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + "." + columnName);
                        }
                        if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
                            boolean found = false;
                            for (Column column : columns) {
                                PropertyArgument pa;
                                if (!column.getFunction().getName().equals("PropertyAccessor") || !(pa = (PropertyArgument)column.getFunctionArguments().get("Property")).getPropertyName().equals(propDef.getPropertyId().getId())) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                throw new CMISQueryException("Ordered column is not selected: " + qualifier + "." + columnName);
                            }
                        }
                        Function function = factory.getFunction("PropertyAccessor");
                        PropertyArgument arg = factory.createPropertyArgument("Property", propDef.isQueryable(), propDef.isOrderable(), selector.getAlias(), propDef.getPropertyId().getId());
                        LinkedHashMap<String, PropertyArgument> functionArguments = new LinkedHashMap<String, PropertyArgument>();
                        functionArguments.put(arg.getName(), arg);
                        String alias = selector.getAlias().length() > 0 ? selector.getAlias() + "." + propDef.getPropertyId().getId() : propDef.getPropertyId().getId();
                        match = factory.createColumn(function, functionArguments, alias);
                    }
                    orderColumn = match;
                } else {
                    CMISTypeDefinition typeDef;
                    Selector selector = selectors.get(qualifier);
                    if (selector == null) {
                        if (qualifier.equals("") && selectors.size() == 1) {
                            selector = selectors.get(selectors.keySet().iterator().next());
                        } else {
                            throw new CMISQueryException("No selector for " + qualifier);
                        }
                    }
                    if ((typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), CMISScope.DOCUMENT, CMISScope.FOLDER)) == null) {
                        throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
                    }
                    CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(columnName);
                    if (propDef == null) {
                        throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + "." + columnName + " selector alias " + selector.getAlias());
                    }
                    if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
                        boolean found = false;
                        for (Column column : columns) {
                            PropertyArgument pa;
                            if (!column.getFunction().getName().equals("PropertyAccessor") || !(pa = (PropertyArgument)column.getFunctionArguments().get("Property")).getPropertyName().equals(propDef.getPropertyId().getId())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            throw new CMISQueryException("Ordered column is not selected: " + qualifier + "." + columnName);
                        }
                    }
                    Function function = factory.getFunction("PropertyAccessor");
                    PropertyArgument arg = factory.createPropertyArgument("Property", propDef.isQueryable(), propDef.isOrderable(), selector.getAlias(), propDef.getPropertyId().getId());
                    LinkedHashMap<String, PropertyArgument> functionArguments = new LinkedHashMap<String, PropertyArgument>();
                    functionArguments.put(arg.getName(), arg);
                    String alias = selector.getAlias().length() > 0 ? selector.getAlias() + "." + propDef.getPropertyId().getId() : propDef.getPropertyId().getId();
                    orderColumn = factory.createColumn(function, functionArguments, alias);
                }
                if (!orderColumn.isOrderable() || !orderColumn.isQueryable()) {
                    throw new CMISQueryException("Ordering is not support for " + orderColumn.getAlias());
                }
                Ordering ordering = factory.createOrdering(orderColumn, order);
                orderings.add(ordering);
            }
        }
        return orderings;
    }

    private ArrayList<Column> buildColumns(CommonTree queryNode, QueryModelFactory factory, Map<String, Selector> selectors, String query) {
        CommonTree columnsNode;
        LinkedHashMap<String, Object> functionArguments;
        Function function;
        ArrayList<Column> columns = new ArrayList<Column>();
        CommonTree starNode = (CommonTree)queryNode.getFirstChildWithType(5);
        if (starNode != null) {
            for (Selector selector : selectors.values()) {
                CMISTypeDefinition typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), this.validScopes);
                if (typeDef == null) {
                    throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
                }
                Map<String, CMISPropertyDefinition> propDefs = typeDef.getPropertyDefinitions();
                for (CMISPropertyDefinition definition : propDefs.values()) {
                    function = factory.getFunction("PropertyAccessor");
                    PropertyArgument arg = factory.createPropertyArgument("Property", definition.isQueryable(), definition.isOrderable(), selector.getAlias(), definition.getPropertyId().getId());
                    functionArguments = new LinkedHashMap<String, Object>();
                    functionArguments.put(arg.getName(), arg);
                    String alias = selector.getAlias().length() > 0 ? selector.getAlias() + "." + definition.getPropertyId().getId() : definition.getPropertyId().getId();
                    Column column = factory.createColumn(function, functionArguments, alias);
                    columns.add(column);
                }
            }
        }
        if ((columnsNode = (CommonTree)queryNode.getFirstChildWithType(7)) != null) {
            for (CommonTree columnNode : columnsNode.getChildren()) {
                String alias;
                CommonTree functionNode;
                Column column;
                String alias2;
                LinkedHashMap<String, PropertyArgument> functionArguments2;
                PropertyArgument arg;
                if (columnNode.getType() == 5) {
                    CMISTypeDefinition typeDef;
                    String qualifier = columnNode.getChild(0).getText();
                    Selector selector = selectors.get(qualifier);
                    if (selector == null) {
                        if (qualifier.equals("") && selectors.size() == 1) {
                            selector = selectors.get(selectors.keySet().iterator().next());
                        } else {
                            throw new CMISQueryException("No selector for " + qualifier + " in " + qualifier + ".*");
                        }
                    }
                    if ((typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), this.validScopes)) == null) {
                        throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
                    }
                    Map<String, CMISPropertyDefinition> propDefs = typeDef.getPropertyDefinitions();
                    for (CMISPropertyDefinition definition : propDefs.values()) {
                        Function function2 = factory.getFunction("PropertyAccessor");
                        arg = factory.createPropertyArgument("Property", definition.isQueryable(), definition.isOrderable(), selector.getAlias(), definition.getPropertyId().getId());
                        functionArguments2 = new LinkedHashMap<String, PropertyArgument>();
                        functionArguments2.put(arg.getName(), arg);
                        alias2 = selector.getAlias().length() > 0 ? selector.getAlias() + "." + definition.getPropertyId().getId() : definition.getPropertyId().getId();
                        column = factory.createColumn(function2, functionArguments2, alias2);
                        columns.add(column);
                    }
                }
                if (columnNode.getType() != 6) continue;
                CommonTree columnRefNode = (CommonTree)columnNode.getFirstChildWithType(8);
                if (columnRefNode != null) {
                    CMISTypeDefinition typeDef;
                    Selector selector;
                    String columnName = columnRefNode.getChild(0).getText();
                    String qualifier = "";
                    if (columnRefNode.getChildCount() > 1) {
                        qualifier = columnRefNode.getChild(1).getText();
                    }
                    if ((selector = selectors.get(qualifier)) == null) {
                        if (qualifier.equals("") && selectors.size() == 1) {
                            selector = selectors.get(selectors.keySet().iterator().next());
                        } else {
                            throw new CMISQueryException("No selector for " + qualifier);
                        }
                    }
                    if ((typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), this.validScopes)) == null) {
                        throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
                    }
                    CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(columnName);
                    if (propDef == null) {
                        throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + " " + columnName);
                    }
                    if (!typeDef.getPropertyDefinitions().containsKey(propDef.getPropertyId().getId())) {
                        throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + "." + columnName);
                    }
                    Function function3 = factory.getFunction("PropertyAccessor");
                    arg = factory.createPropertyArgument("Property", propDef.isQueryable(), propDef.isOrderable(), selector.getAlias(), propDef.getPropertyId().getId());
                    functionArguments2 = new LinkedHashMap();
                    functionArguments2.put(arg.getName(), arg);
                    String string = alias2 = selector.getAlias().length() > 0 ? selector.getAlias() + "." + propDef.getPropertyId().getId() : propDef.getPropertyId().getId();
                    if (columnNode.getChildCount() > 1) {
                        alias2 = columnNode.getChild(1).getText();
                    }
                    column = factory.createColumn(function3, functionArguments2, alias2);
                    columns.add(column);
                }
                if ((functionNode = (CommonTree)columnNode.getFirstChildWithType(10)) == null) continue;
                CommonTree functionNameNode = (CommonTree)functionNode.getChild(0);
                function = factory.getFunction(functionNameNode.getText());
                if (function == null) {
                    throw new CMISQueryException("Unknown function: " + functionNameNode.getText());
                }
                Collection definitions = function.getArgumentDefinitions().values();
                functionArguments = new LinkedHashMap();
                int childIndex = 2;
                for (ArgumentDefinition definition : definitions) {
                    if (functionNode.getChildCount() > childIndex + 1) {
                        CommonTree argNode = (CommonTree)functionNode.getChild(childIndex++);
                        Argument arg2 = this.getFunctionArgument(argNode, definition, factory, selectors, null, function.getName().equals("Like"));
                        functionArguments.put(arg2.getName(), arg2);
                        continue;
                    }
                    if (!definition.isMandatory()) continue;
                    break;
                }
                CommonTree rparenNode = (CommonTree)functionNode.getChild(functionNode.getChildCount() - 1);
                int start = this.getStringPosition(query, functionNode.getLine(), functionNode.getCharPositionInLine());
                int end = this.getStringPosition(query, rparenNode.getLine(), rparenNode.getCharPositionInLine());
                if (function.getName().equals("Score")) {
                    this.hasScore = true;
                }
                if (function.getName().equals("Score")) {
                    alias = "SEARCH_SCORE";
                    if (functionNode.getChildCount() > 3) {
                        throw new CMISQueryException("The function SCORE() is not allowed any arguments");
                    }
                } else {
                    alias = query.substring(start, end + 1);
                }
                if (columnNode.getChildCount() > 1) {
                    alias = columnNode.getChild(1).getText();
                }
                Column column2 = factory.createColumn(function, functionArguments, alias);
                columns.add(column2);
            }
        }
        return columns;
    }

    private int getStringPosition(String query, int line, int charPositionInLine) {
        StringTokenizer tokenizer = new StringTokenizer(query, "\n\r\f");
        String[] lines = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            lines[i++] = tokenizer.nextToken();
        }
        int position = 0;
        for (i = 0; i < line - 1; ++i) {
            position += lines[i].length();
            ++position;
        }
        return position + charPositionInLine;
    }

    private Argument getFunctionArgument(CommonTree argNode, ArgumentDefinition definition, QueryModelFactory factory, Map<String, Selector> selectors, Map<String, Column> columnMap, boolean inLike) {
        if (argNode.getType() == 8) {
            PropertyArgument arg = this.buildColumnReference(definition.getName(), argNode, factory, selectors, columnMap);
            if (!arg.isQueryable()) {
                throw new CMISQueryException("Column refers to unqueryable property " + arg.getPropertyName());
            }
            if (!selectors.containsKey(arg.getSelector())) {
                throw new CMISQueryException("No table with alias " + arg.getSelector());
            }
            return arg;
        }
        if (argNode.getType() == 70) {
            String id = argNode.getText();
            if (selectors.containsKey(id)) {
                SelectorArgument arg = factory.createSelectorArgument(definition.getName(), id);
                if (!arg.isQueryable()) {
                    throw new CMISQueryException("Selector is not queryable " + arg.getSelector());
                }
                return arg;
            }
            CMISPropertyDefinition propDef = this.cmisDictionaryService.findPropertyByQueryName(id);
            if (propDef == null || !propDef.isQueryable()) {
                throw new CMISQueryException("Column refers to unqueryable property " + definition.getName());
            }
            PropertyArgument arg = factory.createPropertyArgument(definition.getName(), propDef.isQueryable(), propDef.isOrderable(), "", propDef.getPropertyId().getId());
            return arg;
        }
        if (argNode.getType() == 14) {
            ParameterArgument arg = factory.createParameterArgument(definition.getName(), argNode.getText());
            if (!arg.isQueryable()) {
                throw new CMISQueryException("Parameter is not queryable " + arg.getParameterName());
            }
            return arg;
        }
        if (argNode.getType() == 27) {
            CommonTree literalNode = (CommonTree)argNode.getChild(0);
            if (literalNode.getType() == 72) {
                QName type = DataTypeDefinition.DOUBLE;
                Number value = Double.parseDouble(literalNode.getText());
                if ((double)((Number)value).floatValue() == value) {
                    type = DataTypeDefinition.FLOAT;
                    value = Float.valueOf(((Number)value).floatValue());
                }
                LiteralArgument arg = factory.createLiteralArgument(definition.getName(), type, (Serializable)value);
                return arg;
            }
            if (literalNode.getType() == 73) {
                QName type = DataTypeDefinition.LONG;
                Number value = Long.parseLong(literalNode.getText());
                if ((long)((Number)value).intValue() == value) {
                    type = DataTypeDefinition.INT;
                    value = ((Number)value).intValue();
                }
                LiteralArgument arg = factory.createLiteralArgument(definition.getName(), type, (Serializable)value);
                return arg;
            }
            throw new CMISQueryException("Invalid numeric literal " + literalNode.getText());
        }
        if (argNode.getType() == 28) {
            String text = argNode.getChild(0).getText();
            text = text.substring(1, text.length() - 1);
            text = this.unescape(text, inLike ? EscapeMode.LIKE : EscapeMode.LITERAL);
            LiteralArgument arg = factory.createLiteralArgument(definition.getName(), DataTypeDefinition.TEXT, (Serializable)((Object)text));
            return arg;
        }
        if (argNode.getType() == 29) {
            Date date;
            String text = argNode.getChild(0).getText();
            text = text.substring(1, text.length() - 1);
            StringBuilder builder = new StringBuilder();
            if (text.endsWith("Z")) {
                builder.append(text.substring(0, text.length() - 1));
                builder.append("+0000");
            } else {
                if (text.charAt(text.length() - 3) != ':') {
                    throw new CMISQueryException("Invalid datetime literal " + text);
                }
                builder.append(text.substring(0, text.length() - 3));
                builder.append(text.substring(text.length() - 2, text.length()));
            }
            text = builder.toString();
            SimpleDateFormat df = CachingDateFormat.getCmisSqlDatetimeFormat();
            try {
                date = df.parse(text);
            }
            catch (ParseException e) {
                throw new CMISQueryException("Invalid datetime literal " + text);
            }
            String alfrescoDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
            LiteralArgument arg = factory.createLiteralArgument(definition.getName(), DataTypeDefinition.TEXT, (Serializable)((Object)alfrescoDate));
            return arg;
        }
        if (argNode.getType() == 30) {
            String text = argNode.getChild(0).getText();
            if (text.equalsIgnoreCase("TRUE") || text.equalsIgnoreCase("FALSE")) {
                LiteralArgument arg = factory.createLiteralArgument(definition.getName(), DataTypeDefinition.TEXT, (Serializable)((Object)text));
                return arg;
            }
            throw new CMISQueryException("Invalid boolean literal " + text);
        }
        if (argNode.getType() == 23) {
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            for (int i = 0; i < argNode.getChildCount(); ++i) {
                CommonTree arg = (CommonTree)argNode.getChild(i);
                arguments.add(this.getFunctionArgument(arg, definition, factory, selectors, columnMap, inLike));
            }
            ListArgument arg = factory.createListArgument(definition.getName(), arguments);
            if (!arg.isQueryable()) {
                throw new CMISQueryException("Not all members of the list are queryable");
            }
            return arg;
        }
        if (argNode.getType() == 60) {
            LiteralArgument arg = factory.createLiteralArgument(definition.getName(), DataTypeDefinition.TEXT, (Serializable)((Object)argNode.getText()));
            return arg;
        }
        if (argNode.getType() == 31) {
            LiteralArgument arg = factory.createLiteralArgument(definition.getName(), DataTypeDefinition.TEXT, (Serializable)((Object)argNode.getText()));
            return arg;
        }
        if (argNode.getType() == 50) {
            LiteralArgument arg = factory.createLiteralArgument(definition.getName(), DataTypeDefinition.TEXT, (Serializable)((Object)argNode.getText()));
            return arg;
        }
        if (argNode.getType() == 10) {
            FunctionArgument arg;
            CommonTree functionNameNode = (CommonTree)argNode.getChild(0);
            Function function = factory.getFunction(functionNameNode.getText());
            if (function == null) {
                throw new CMISQueryException("Unknown function: " + functionNameNode.getText());
            }
            Collection definitions = function.getArgumentDefinitions().values();
            LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
            int childIndex = 2;
            for (ArgumentDefinition currentDefinition : definitions) {
                if (argNode.getChildCount() > childIndex + 1) {
                    CommonTree currentArgNode = (CommonTree)argNode.getChild(childIndex++);
                    Argument arg2 = this.getFunctionArgument(currentArgNode, currentDefinition, factory, selectors, columnMap, inLike);
                    functionArguments.put(arg2.getName(), arg2);
                    continue;
                }
                if (!definition.isMandatory()) continue;
                break;
            }
            if (!(arg = factory.createFunctionArgument(definition.getName(), function, functionArguments)).isQueryable()) {
                throw new CMISQueryException("Not all function arguments refer to orderable arguments: " + arg.getFunction().getName());
            }
            return arg;
        }
        throw new CMISQueryException("Invalid function argument " + argNode.getText());
    }

    private Source buildSource(CommonTree source, CMISJoinEnum joinSupport, QueryModelFactory factory) {
        CMISTypeDefinition typeDef;
        if (source.getChildCount() == 1) {
            CMISTypeDefinition typeDef2;
            CommonTree singleTableNode = (CommonTree)source.getChild(0);
            if (singleTableNode.getType() == 12) {
                if (joinSupport == CMISJoinEnum.NO_JOIN_SUPPORT) {
                    throw new UnsupportedOperationException("Joins are not supported");
                }
                CommonTree tableSourceNode = (CommonTree)singleTableNode.getFirstChildWithType(11);
                return this.buildSource(tableSourceNode, joinSupport, factory);
            }
            if (singleTableNode.getType() != 13) {
                throw new CMISQueryException("Expecting TABLE_REF token but found " + singleTableNode.getText());
            }
            String tableName = singleTableNode.getChild(0).getText();
            String alias = "";
            if (singleTableNode.getChildCount() > 1) {
                alias = singleTableNode.getChild(1).getText();
            }
            if ((typeDef2 = this.cmisDictionaryService.findTypeByQueryName(tableName)) == null) {
                throw new CMISQueryException("Type is unsupported in query: " + tableName);
            }
            if (typeDef2.getTypeId().getScope() != CMISScope.POLICY && !typeDef2.isQueryable()) {
                throw new CMISQueryException("Type is not queryable " + tableName + " -> " + typeDef2.getTypeId());
            }
            return factory.createSelector(typeDef2.getTypeId().getQName(), alias);
        }
        if (joinSupport == CMISJoinEnum.NO_JOIN_SUPPORT) {
            throw new UnsupportedOperationException("Joins are not supported");
        }
        CommonTree singleTableNode = (CommonTree)source.getChild(0);
        if (singleTableNode.getType() != 13) {
            throw new CMISQueryException("Expecting TABLE_REF token but found " + singleTableNode.getText());
        }
        String tableName = singleTableNode.getChild(0).getText();
        String alias = "";
        if (singleTableNode.getChildCount() == 2) {
            alias = singleTableNode.getChild(1).getText();
        }
        if ((typeDef = this.cmisDictionaryService.findTypeByQueryName(tableName)) == null) {
            throw new CMISQueryException("Type is unsupported in query " + tableName);
        }
        if (typeDef.getTypeId().getScope() != CMISScope.POLICY && !typeDef.isQueryable()) {
            throw new CMISQueryException("Type is not queryable " + tableName + " -> " + typeDef.getTypeId());
        }
        Selector lhs = factory.createSelector(typeDef.getTypeId().getQName(), alias);
        List list = source.getChildren();
        for (CommonTree joinNode : list) {
            if (joinNode.getType() != 41) continue;
            CommonTree rhsSource = (CommonTree)joinNode.getFirstChildWithType(11);
            Source rhs = this.buildSource(rhsSource, joinSupport, factory);
            JoinType joinType = JoinType.INNER;
            CommonTree joinTypeNode = (CommonTree)joinNode.getFirstChildWithType(43);
            if (joinTypeNode != null) {
                joinType = JoinType.LEFT;
            }
            if (joinType == JoinType.LEFT && joinSupport == CMISJoinEnum.INNER_JOIN_SUPPORT) {
                throw new UnsupportedOperationException("Outer joins are not supported");
            }
            Constraint joinCondition = null;
            CommonTree joinConditionNode = (CommonTree)joinNode.getFirstChildWithType(45);
            if (joinConditionNode != null) {
                PropertyArgument arg1 = this.buildColumnReference("LHS", (CommonTree)joinConditionNode.getChild(0), factory, null, null);
                if (!lhs.getSelectors().containsKey(arg1.getSelector()) && !rhs.getSelectors().containsKey(arg1.getSelector())) {
                    throw new CMISQueryException("No table with alias " + arg1.getSelector());
                }
                CommonTree functionNameNode = (CommonTree)joinConditionNode.getChild(1);
                if (functionNameNode.getType() != 46) {
                    throw new CMISQueryException("Only Equi-join is supported " + functionNameNode.getText());
                }
                Function function = factory.getFunction("Equals");
                if (function == null) {
                    throw new CMISQueryException("Unknown function: " + functionNameNode.getText());
                }
                PropertyArgument arg2 = this.buildColumnReference("RHS", (CommonTree)joinConditionNode.getChild(2), factory, null, null);
                if (!lhs.getSelectors().containsKey(arg2.getSelector()) && !rhs.getSelectors().containsKey(arg2.getSelector())) {
                    throw new CMISQueryException("No table with alias " + arg2.getSelector());
                }
                LinkedHashMap<String, PropertyArgument> functionArguments = new LinkedHashMap<String, PropertyArgument>();
                functionArguments.put(arg1.getName(), arg1);
                functionArguments.put(arg2.getName(), arg2);
                joinCondition = factory.createFunctionalConstraint(function, functionArguments);
            }
            Join join = factory.createJoin((Source)lhs, rhs, joinType, joinCondition);
            lhs = join;
        }
        return lhs;
    }

    public PropertyArgument buildColumnReference(String argumentName, CommonTree columnReferenceNode, QueryModelFactory factory, Map<String, Selector> selectors, Map<String, Column> columnMap) {
        CMISPropertyDefinition propDef;
        Column column;
        String cmisPropertyName = columnReferenceNode.getChild(0).getText();
        String qualifier = "";
        if (columnReferenceNode.getChildCount() > 1) {
            qualifier = columnReferenceNode.getChild(1).getText();
        }
        if (qualifier == "" && columnMap != null && (column = columnMap.get(cmisPropertyName)) != null) {
            if (column.getFunction().getName().equals("PropertyAccessor")) {
                PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                cmisPropertyName = arg.getPropertyName();
                qualifier = arg.getSelector();
            } else {
                throw new CMISQueryException("Complex column reference unsupported (only direct column references are currently supported) " + cmisPropertyName);
            }
        }
        if ((propDef = this.cmisDictionaryService.findPropertyByQueryName(cmisPropertyName)) == null) {
            throw new CMISQueryException("Unknown column/property " + cmisPropertyName);
        }
        if (selectors != null) {
            CMISTypeDefinition typeDef;
            Selector selector = selectors.get(qualifier);
            if (selector == null) {
                if (qualifier.equals("") && selectors.size() == 1) {
                    selector = selectors.get(selectors.keySet().iterator().next());
                } else {
                    throw new CMISQueryException("No selector for " + qualifier);
                }
            }
            if ((typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), this.validScopes)) == null) {
                throw new CMISQueryException("Type unsupported in CMIS queries: " + selector.getAlias());
            }
            if (!typeDef.getPropertyDefinitions().containsKey(propDef.getPropertyId().getId())) {
                throw new CMISQueryException("Invalid column for " + typeDef.getQueryName() + "." + cmisPropertyName);
            }
        }
        if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT && !propDef.isQueryable()) {
            throw new CMISQueryException("Column is not queryable " + qualifier + "." + cmisPropertyName);
        }
        return factory.createPropertyArgument(argumentName, propDef.isQueryable(), propDef.isOrderable(), qualifier, propDef.getPropertyId().getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String unescape(String string, EscapeMode mode) {
        StringBuilder builder = new StringBuilder(string.length());
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                if (mode == EscapeMode.LIKE) {
                    if (c == '\'') {
                        builder.append(c);
                    } else if (c == '%') {
                        builder.append('\\');
                        builder.append(c);
                    } else if (c == '_') {
                        builder.append('\\');
                        builder.append(c);
                    } else {
                        if (c != '\\') throw new UnsupportedOperationException("Unsupported escape pattern in <" + string + "> at position " + i);
                        builder.append('\\');
                        builder.append(c);
                    }
                } else if (mode == EscapeMode.CONTAINS) {
                    if (this.options.getQueryMode() == CMISQueryOptions.CMISQueryMode.CMS_STRICT) {
                        if (c == '\'') {
                            builder.append(c);
                        } else {
                            if (c != '\\') throw new UnsupportedOperationException("Unsupported escape pattern in <" + string + "> at position " + i);
                            builder.append('\\');
                            builder.append(c);
                        }
                    } else if (c == '\'') {
                        builder.append(c);
                    } else {
                        builder.append(c);
                    }
                } else {
                    if (mode != EscapeMode.LITERAL) throw new UnsupportedOperationException("Unsupported escape pattern in <" + string + "> at position " + i);
                    if (c == '\'') {
                        builder.append(c);
                    } else {
                        if (c != '\\') throw new UnsupportedOperationException("Unsupported escape pattern in <" + string + "> at position " + i);
                        builder.append(c);
                    }
                }
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            builder.append(c);
        }
        if (!lastWasEscape) return builder.toString();
        throw new FTSQueryException("Escape character at end of string " + string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EscapeMode {
        LITERAL,
        LIKE,
        CONTAINS;

    }
}

